/*
	By IQ_132 for neo-pcm2
	Some code taken from MAME (Code has comments)
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#define BUFSIZE 50000
#define WORDSIZE 4

void usage()
{
	printf("Usage: snkpcm2 infile outfile [-w n]\n\n");
	printf("  -w  Specify the size of a word as n bytes (default is 4)\n\n");
	printf("This program encrypts and decrypts Neo-PCM2 (SNK, 1999) Sample (V) roms\n");
	printf("It byte swaps and line swaps the roms.  n can be 2, 4, or 8 \n");
	printf("Pochi and Nyaa uses 2, Metal Slug 4 uses 4, and Rage of the Dragons uses 8\n");
	printf("Note: the output file will be overwritten if it already exists!\n");
}

int main(int argc, char **argv)
{
	FILE *infid, *outfid;
	int nread, wsize=4, b, errornum=0, i, j;
	struct stat infileinfo;
	unsigned char databuf[BUFSIZE];

	/* Check for valid command-line arguments */
	if (argc < 2)
	{
		usage(); return(1);
	}
	if (argc > 3)
	{
		if (!strcmp(argv[3],"-w"))
		{
			if (argc < 5)
			{
				usage(); return(1);
			}

			sscanf(argv[4],"%d",&wsize);

			if (wsize!=2 && wsize!=4 && wsize!=8 && wsize!=16 && wsize!=32 && wsize!=64 && wsize!=128)
			{
				fprintf(stderr,"Error: bad word size!\n"); return(1);
			}
		} else {
			usage(); return(1);
		}
	}
	if ((infid=fopen(argv[1],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read '%s'\n",argv[1]); return(1);
	}
	if ((outfid=fopen(argv[2],"wb"))==NULL)
	{
		fclose(infid); fprintf(stderr,"Error: cannot write to '%s'\n",argv[2]);
		return(1);
	}

	/* The file size must be a multiple of the word size */
	if (stat(argv[1],&infileinfo)!=0)
	{
		fprintf(stderr,"Error: cannot read the input file size!\n");
		fclose(infid); fclose(outfid); return(1);
	}
	if (infileinfo.st_size%wsize > 0)
	{
		fprintf(stderr,"Error: input file size is not a multiple of the word size!\n");
		fclose(infid); fclose(outfid); return(1);
	}

	/* Byteswap all the words in the file */
	while ((nread=fread((void *)databuf,1,BUFSIZE,infid)) > 0)
	{
		/* thanks to Elsemi for the NEO-PCM2 info */
		unsigned short *rom = (unsigned short*)(databuf);
		/* swap address lines on the whole ROMs */
		for(i = 0; i < nread / 2; i += wsize)
		{
			unsigned short buffer[wsize];
			memcpy( buffer, &rom[i], (wsize*2) );
			for(j = 0; j < wsize; j++)
			{
				rom[i + j] = buffer[j ^ (wsize/2)];
			}
		}
		if (fwrite((void *)databuf,1,nread,outfid)!=nread) break;
	}
	if (ferror(infid))
	{
		fprintf(stderr,"Error: problem reading from the input file!\n");
		errornum=1;
	}
	if (ferror(outfid))
	{
		fprintf(stderr,"Error: problem reading from the input file!\n");
		errornum=1;
	}

	/* Done */
	fclose(infid); fclose(outfid); return(errornum);
  }
