
#include <stdio.h>

 /*--------------------------------------------------*\
|   Thanks to Aquasync, El Semi, Fataku, and Halrin    |
 \*--------------------------------------------------*/

void playmore_pcm2(unsigned char *src, int nLen, int nCom, int a)
{
	unsigned int addrs[7][2] = {
		{ 0x000000, 0xA5000 }, // 0 kof2002
		{ 0xFFCE20, 0x01000 }, // 1 matrimelee
		{ 0xFE2CF6, 0x4E001 }, // 2 mslug5
		{ 0xFEB2C0, 0x0A000 }, // 3 samsho5
		{ 0xFFAC28, 0xC2000 }, // 4 svcchaos
		{ 0xFF14EA, 0xA7001 }, // 5 kof2003
		{ 0xFFB440, 0x02000 }, // 6 samsh5sp
	};

	unsigned int xordata[7][8] = {
		{ 0xF9, 0xE0, 0x5D, 0xF3, 0xEA, 0x92, 0xBE, 0xEF }, // 0 kof2002
		{ 0xC4, 0x83, 0xA8, 0x5F, 0x21, 0x27, 0x64, 0xAF }, // 1 matrimelee
		{ 0xC3, 0xFD, 0x81, 0xAC, 0x6D, 0xE7, 0xBF, 0x9E }, // 2 mslug5
		{ 0xCB, 0x29, 0x7D, 0x43, 0xD2, 0x3A, 0xC2, 0xB4 }, // 3 samsho5
		{ 0xC3, 0xFD, 0x81, 0xAC, 0x6D, 0xE7, 0xBF, 0x9E }, // 4 svcchaos
		{ 0x4B, 0xA4, 0x63, 0x46, 0xF0, 0x91, 0xEA, 0x62 }, // 5 kof2003
		{ 0x4B, 0xA4, 0x63, 0x46, 0xF0, 0x91, 0xEA, 0x62 }, // 6 samsh5sp
	};

	int i, j, k;
	unsigned char *buf = (unsigned char*)malloc(nLen);

	if (!buf) return;

	memcpy (buf, src, nLen);

	for (i = 0; i < nLen; i++)
	{
		j  = (i & 0xfefffe) | ((i >> 16) & 1) | ((i & 1) << 16);
		j ^= addrs[a][1];
		k  = (i + addrs[a][0]) & (nLen-1);

		if (nCom)	// decrypt
		{
			src[j] = buf[k] ^ xordata[a][j & 7];
		}
		else		// encrypt
		{
			src[k] = buf[j] ^ xordata[a][j & 7];
		}
	}
			
	free (buf);
}

void snk_pcm2(unsigned char *src, int nLen, int nCom, int a) // 4 = pnyaa, 8 = mslug4, 16 = rotd 
{
	int i,j,t;
	for (i = 0; i < nLen; i += a)
	{
		for (j = 0; j < a / 2; j++)
		{
			t = src[i + j + 0];
			src[i + j + 0] = src[i + j + (a / 2)];
			src[i + j + (a / 2)] = t;
		}
	}
}

void usage()
{
	char string[2];

	printf("Converts between encrypted and decrypted V (sample) roms\n\n");
	printf("Usage: neoconv [type] [command] [select] [rom-name] [rom-number] < [separator] [extension] < [endchar] > >\n\n");
	printf("[type]:        0 for pcm2 (1999) | 1 for pcm2 (2002)\n");
	printf("[command]:      e (for encryption) | d (for decryption)\n");
	printf("[select]:       Game select (one or two digit value)\n");
	printf("                ( e.g. 0 for kof2002 )\n");
	printf("[rom-name]:     the first part of the rom name\n");
	printf("                ( e.g. for 265-vX.bin you type '265' )\n");
	printf("[rom-number]:   number of roms, it can be 1, 2, or 4\n");
	printf("                ( e.g. 2 for kof2002 )\n");
	printf("[separator]:    the separating char between the rom-name and vX\n");
	printf("                (e.g. for 265-vX.bin you type '-' )\n");
	printf("[extension]:    the extension of the roms\n");
	printf("                (e.g. for 265-vX.bin you type 'bin' )\n");
	printf("[endchar]:      the char after vX in the name of the roms (if it exists)\n");
	printf("                (e.g. for 265-vXd.bin you type d)\n");

	printf ("\nPress i and ENTER for extra info, a and ENTER for the about screen,\nor ENTER alone to continue\n");
	gets (string);

	if (!strcmp(string, "i") | !strcmp(string, "I"))
	{
		printf("\n");
		printf ("PCM2, 1999, SNK Encryption (type 0) is used by the following games:\n\n");
		printf ("\tROM NAME\tNGID#\tSelect\n");
		printf ("\tPNYAA\t\t267\t4\n");
		printf ("\tMSLUG4\t\t263\t8\n");
		printf ("\tROTD\t\t264\t16\n");
		printf("\n");
		printf ("PCM2, 2002, Playmore Encryption (type 1) is used by the following games:\n\n");
		printf ("\tROM NAME\tNGID#\tSelect\n");
		printf ("\tKOF2002\t\t265\t0\n");
		printf ("\tMATRIM\t\t266\t1\n");
		printf ("\tMSLUG5\t\t268\t2\n");
		printf ("\tSAMSHO5\t\t270\t3\n");
		printf ("\tSVC\t\t269\t4\n");
		printf ("\tKOF2003\t\t271\t5\n");
		printf ("\tSAMSH5SP\t272\t6\n");
	}

	if (!strcmp(string, "a") | !strcmp(string, "A"))
	{
		printf ("\n");
		printf ("Thanks to Aquasync, El Semi, Fataku, and Halrin for the original decrypt code!\n");
		printf ("version 2 - IQ_132 http://neosource.1emulation.com\n");
	}
}

int main(int argc, char **argv)
{
	int i,j;
	FILE *fp;
	char Name[32];			// Temporary name storage
	unsigned char *src;		// Source
	unsigned char *tmp;

	int nType = 0;			// Encryption type (SNK [0] or Playmore [1])
	int nCom  = 0;			// Command (encrypt [e] or decrypted [d])
	int nSel  = 0;			// Game select (see usage)
	int nNum  = 0;			// Number of source files (limit to 4 later)
	int nLen  = 0;			// Total length of source files
	int fLen[4];			// Lengths of source files

	if (argc < 8)
	{
		usage();
		exit(1);
	}

	sscanf (argv[1], "%x", &nType);
	sscanf (argv[2], "%x", &nCom);
	sscanf (argv[3], "%d", &nSel);
	sscanf (argv[5], "%d", &nNum);

	nType &= 1;			// Type can be 0 or 1
	nCom &= 1;			// Command: d = 1, e = 0
	nNum = ((nNum-1) & 3) + 1;	// Limit of 4 roms

	const char Playmore[7][16] = {
		{ "KOF2002"  },
		{ "MATRIM"   }, 
		{ "MSLUG5"   },
		{ "SAMSHO5"  },
		{ "SVC"	     },
		{ "KOF2003"  },
		{ "SAMSH5SP" }
	};

	const char SNK[3][16] = {
		{ "PNYAA"  },
		{ "MSLUG4" },
		{ "ROTD"   }
	};

	printf ("%s using %s type encryption\n", nCom ? "Decrypting" : "Encrypting", nType ? "Playmore (2002)" : "SNK (1999)");
	printf ("%s selected\n\n", nType ? Playmore[nSel] : SNK[nSel >> 3]);

	for (i = 0; i < nNum; i++)
	{
		sprintf(Name, "%s%sv%d%s.%s", argv[4], argv[6], i+1, argv[8] ? argv[8] : "", argv[7]);
		printf ("Verifying %s\n", Name);

		fp = fopen(Name, "rb");

		if (fp == NULL) {
			printf ("There was an error opening %s.\n", Name);
			exit(1);
		}

		fseek (fp, 0, SEEK_END);
		fLen[i] = ftell (fp);
		nLen += fLen[i];
		fclose (fp);
	}

	if (nLen != 0x1000000 && nType) {
		printf ("These roms cannot be protected by PCM2 2002, Playmore.  The\n");
		printf ("roms must have a combined size of 16mb!\n");
		exit(1);
	}

	src = (unsigned char*)malloc(nLen);
	if (!src) exit(1);

	tmp = src;

	for (i = 0; i < nNum; i++)
	{
		sprintf(Name, "%s%sv%d%s.%s", argv[4], argv[6], i+1, argv[8] ? argv[8] : "", argv[7]);

		printf ("Reading %s\n", Name);

		fp = fopen(Name, "rb");
		fread (tmp, 1, fLen[i], fp);
		fclose (fp);
		tmp += fLen[i];
	}

	printf ("%scrypting\n", nCom ? "De" : "En");

	if (nType)	// Playmore-Type encryption
	{
		playmore_pcm2(src, nLen, nCom, nSel);
	}
	else		// SNK-Type encryption
	{
		snk_pcm2(src, nLen, nCom, nSel);
	}

	tmp = src;

	for (i = 0; i < nNum; i++)
	{
		sprintf(Name, "%s%sv%d%s.%s", argv[4], argv[6], i+1, nCom ? "d" : "e", argv[7]);

		printf ("Writing %s\n", Name);

		fp = fopen(Name, "wb");
		fwrite (tmp, 1, fLen[i], fp);
		fclose (fp);
		tmp += fLen[i];
	}

	free (src);

	printf ("Finished\n");
}
