#include <stdio.h>

int main(int argc, char **argv)
{
	int i;
	FILE *c1, *c2;
	int ROMSize = 0;
	unsigned char *src = NULL;

	if (argc != 3)
	{
		printf("USAGE:\n");
		printf("\tgfxcnv.exe c1_file c2_file\n");
		return(1);
	}

	printf("Checking input\n");

	if ((c1 = fopen(argv[1],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.",argv[1]);
		return(1);
	}
	fseek (c1, 0, SEEK_END); ROMSize = ftell (c1); rewind (c1);

	if ((c2 = fopen(argv[2],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.",argv[2]);
		return(1);
	}
	fseek (c2, 0, SEEK_END);
	if (ROMSize != (ftell (c2)))
	{
		printf("Input sizes must match!");
		return(1);
	}
	rewind (c2);

	// Make sure Graphics rom does not exceed 4mb
	ROMSize <<= 1;
	if (ROMSize > 0x400000) ROMSize = 0x400000;

	src = (unsigned char*)malloc(ROMSize);

	printf("Read and process input file\n");

	for (i = 0; i < ROMSize; i+=4) {
		fread (src + i + 1, 1, 1, c1);
		fread (src + i + 0, 1, 1, c1);
		fread (src + i + 3, 1, 1, c2);
		fread (src + i + 2, 1, 1, c2);
	}
	fclose(c1);
	fclose(c2);

	while (1) // Trim dummy data, decrease load time
	{
		if ((src[ROMSize-1] == 0xff) || (src[ROMSize-1] == 0))
			ROMSize--;
		else {
			if (ROMSize & 0x7f) ROMSize = (ROMSize & ~0x7f) + 0x80;
			break;
		}
	}

	printf("Write output file\n");

	c1 = fopen("SPR.SPR","wb");
	fwrite (src, 1, ROMSize, c1);
	fclose(c1);

	free(src);

	printf("Finished\n");
}
