#include <stdio.h>

int main(int argc, char **argv)
{
	int i;
	int ROMSize = 0;
	FILE *fp;
	unsigned char *src = NULL;

	if (argc != 2) {
		printf("USAGE:\n\tprogcnv.exe filename\n");
		return(1);
	}

	if ((fp=fopen(argv[1],"rb"))==NULL) {
		printf("Error: cannot read %s.", argv[1]);
		return(1);
	}

	fseek (fp, 0, SEEK_END);
	ROMSize = ftell (fp); rewind (fp);

	src = (unsigned char*)malloc(ROMSize);

	printf("Reading input file\n");
	fread (src, 1, ROMSize, fp);
	fclose(fp);

	printf("Byteswapping \n");

	for (i = 0; i < ROMSize; i += 2) {
		int n = src[i + 0];
		src[i + 0] = src[i + 1];
		src[i + 1] = n;
	}

	printf("Swap VBlank and HBlank (0x64 & 0x68)\n");

	for (i = 0; i < 4; i++) {
		int n = src[i + 0x64];
		src[i + 0x64] = src[i + 0x68];
		src[i + 0x68] = n;
	}

	printf("Applying patches\n");

	unsigned char data[0x24] = {
		0x00, 0xC0, 0x05, 0x22, 0x00, 0xC0, 0x05, 0x28, 0x00, 0xC0, 0x05, 0x2E, 0x00, 0xC0, 0x05, 0x34, 
		0x00, 0xC0, 0x05, 0x3A, 0x00, 0xC0, 0x04, 0xF2, 0x00, 0xC0, 0x04, 0xEC, 0x00, 0xC0, 0x04, 0xE6,
		0x00, 0xC0, 0x04, 0xE0
	};

	memcpy (src + 0x40, data, 0x24);


	if (ROMSize > 0x100000) {
		printf ("Program rom size exceeds 1MB. Trimming it. (this will cause problems!)\n");
		ROMSize = 0x100000;
	}

	while (1) // Trim dummy data, file loading is faster on real neocd
	{
		if ((src[ROMSize-1] == 0xff) || (src[ROMSize-1] == 0))
			ROMSize--;
		else
			break;
	}

	printf ("Write output file\n");

	fp = fopen("PRG.PRG","wb");
	fwrite (src, 1, ROMSize, fp);
	fclose(fp);

	free(src);

	printf("Finished\n");
}
