

function create(form)
{
	form.chxbxp1.checked = true;
	form.chxbxm1d.checked = true;

getRomInfo(form);
errorchk(form);

var continuecreation = "TRUE";
var output = "";

if (stop_alertonstart == 0)
{
	if (form.errors.value) {
		if (!confirm(l_cnferr))
			continuecreation = "FALSE";
	} else {
		alert(l_cnfcrt);
	}
}

if (continuecreation == "TRUE")
{
	var USE_SMA = 0;
	for (i = 0; i < 5; i++){
		var SMA_TMP = PxInfo[i][0];
		for (j = 0; j < SMA_TMP.length; j++) {
			if ((SMA_TMP.slice(j, j+3).toLowerCase() == "sma")&&(form["chxbxp" + (i+1)].checked)) {
				USE_SMA = i+1;
			}
		}
	}


if (form.picker.value == "fba")
{
	var fba_version = form.fba_version.value;

	var prg_num  = "0x10";
	var srm_num  = "1";
	var gfx_num  = "1";
	var mdrm_num = "0x10";
	var snd_num  = "2";
	var sma_num  = "0x10";
	var mrm_num  = "0x10";

	if (fba_version == "new")
	{
		prg_num  = "1 | BRF_ESS | BRF_PRG ";
		srm_num  = "2 | BRF_GRA ";
		gfx_num  = "3 | BRF_GRA ";
		mdrm_num = "4 | BRF_ESS | BRF_PRG ";
		snd_num  = "5 | BRF_SND ";
		sma_num  = "9 | BRF_ESS | BRF_PRG ";
		mrm_num  = "0 | BRF_PRG | BRF_OPT ";
	}

	var beginning_space = "";
	var size_brf_space = "   ";
	if (fba_version == "new"){
		beginning_space = " ";
		size_brf_space = "";
	}

	var n1 = 0;

	var additional = "";
	if (form.bootleg.checked) additional += " (Bootleg)";
	if (form.proto.checked) additional += " (Prototype)";

	output ="// " + form.realname.value + additional + "\n\n";
	output +="static struct BurnRomInfo " + form.setname.value + "RomDesc[] = {\n";

// SMA Output

	if (USE_SMA) {
		if (form["chxbxp"+USE_SMA].checked)
		{
			output += "	{" + beginning_space + "\"" + PxInfo[USE_SMA-1][0] + "\", 0x" + PxInfo[USE_SMA-1][1] + ", " + fba_hash(PxInfo[USE_SMA-1][2]) + ", " + sma_num + "}, // " + n1 + " 68k Code\n";
			n1++;
		}
	}

// Px Output

	for (i = 1; i < 6; i++)	{
		if (form["chxbxp" + i].checked)
		{
			if ((i == USE_SMA) && (USE_SMA != 0)){} else {
				output +="	{" + beginning_space + "\"" + PxInfo[i-1][0] + "\", 0x" + PxInfo[i-1][1] + ", " + fba_hash(PxInfo[i-1][2]) + ", " + prg_num + "}, //  " + n1;
				if (n1==0) output += " 68K Code";
				output += "\n";

				n1++;
			}
		}
	}

// S1 Output

	if (form.chxbxs1.checked)
	{
		output +="\n	{" + beginning_space + "\"" +  S1Info[0] + "\", 0x" + S1Info[1] + ", " + fba_hash(S1Info[2]) +  ", " + size_brf_space  + srm_num + "},";

		if (fba_version == "new")
			output += "	     ";
	
		output += " //  " + n1 + " Text data\n";

		n1++;
	}

// Cx Output

	var c1_label = 0;
	if (getlen("c", 1, 8, 1) > 0) output += "\n";

	for (var i = 1; i < 9; i++) {
		if (form["chxbxc" + i].checked)
		{
			output +="	{" + beginning_space + "\"" +  CxInfo[i-1][0] + "\", 0x" + CxInfo[i-1][1] + ", " + fba_hash(CxInfo[i-1][2]) +  ", " + size_brf_space  + gfx_num + "},";

			if (fba_version == "new")
				output += "	     ";

			output += " //  " + n1;

			if (c1_label == 0) output += " Sprite data";

			output += "\n";

			n1++;
			c1_label = 1;
		}
	}

// M1/M1D Output

	if (form.chxbxm1d.checked) {
		output +="\n	{" + beginning_space + "\"" + M1dInfo[0] + "\", 0x" + M1dInfo[1] + ", " + fba_hash(M1dInfo[2]) +  ", " + mdrm_num + "}, //  " + n1 + " Z80 code";

		if (form.chxbxm1.checked)
			output += " (decrypted)";

		output += "\n";

		n1++;
	}

	if (form.chxbxm1.checked)
	{
		output +="	{" + beginning_space + "\"" + M1Info[0] + "\",  0x" + M1Info[1] + ", " + fba_hash(M1Info[2]) +  ", " + mrm_num + "}, //  " + n1 + " Z80 code\n";
		n1++;
	}

// Vx Output

	var vx_label = 0;
	if (getlen("v", 1, 5, 0) > 0) output += "\n";

	for (var i = 1; i < 7; i++)
	{
		if (form["chxbxv" + i].checked)
		{
			var name = VxInfo[i-1][0];
			output +="	{" + beginning_space + "\"" + name + "\", 0x" + VxInfo[i-1][1] + ", " + fba_hash(VxInfo[i-1][2]) +  ", " + size_brf_space;

			if (fba_version == "new")
			{
				if ((name.slice(4,7) == "v21")||(name.slice(4,7) == "v22")||(name.slice(4,7) == "v23")||(name.slice(4,7) == "v24"))
				{
					output += "6 | BRF_SND ";
				} else {
					output += snd_num;
				}

				output += "},	      //  " + n1;
			}
			else
				output += snd_num + "}, //  " + n1;

				if (vx_label == 0) output += " Sound data";
				output += "\n";

			n1++;
			vx_label = 1;
		}
	}

// End Rom Output

	output +="}; \n\nSTDROMPICKEXT(" + form.setname.value + ", " + form.setname.value + ", neogeo); \nSTD_ROM_FN(" + form.setname.value + ");\n";

// Init Output

	var show_fba_init = 0;

	var enable_textromfix = 0;
	if ((form.textromfix.checked) && (form.chxbxs1.checked == "")) enable_textromfix = 1;

	var pulstar_fix = 0;
	if (form.setname.value.toLowerCase() == "pulstar") pulstar_fix = 1;

	if ((pulstar_fix)||((form.GfxKey.value)&&(form.criptsel.value))||(form.pcm2.value!=00)||(enable_textromfix))
	{
		show_fba_init = 1;
	}

	if (show_fba_init)
	{
		output +="\nstatic int " + form.setname.value + "Init()\n{\n";

		if (form.pcm2.value != "00")
		{
			output += "	int nRet;\n\n"
		}

		if (pulstar_fix) output +="	nNeoSRAMProtection = 0x035A;\n"

		if (enable_textromfix)	output +="	nNeoTextROMSize = 0x080000;\n";

		if ((form.criptsel.value) && (form.GfxKey.value))
		{
			output +="	nNeoProtectionXor = 0x" + form.GfxKey.value + ";\n";
		}

		if (form.pcm2.value == "00")
		{
			output +="\n	return NeoInit();\n}\n";
		} else {

			output += "\n	nRet = NeoInit();\n\n	if (nRet == 0) {\n";

			var pcm2x = new Array(
				new Array( "0x0A5000, 0x000000", "0xF9, 0xE0, 0x5D, 0xF3, 0xEA, 0x92, 0xBE, 0xEF" ),
				new Array( "0x001000, 0xFFCE20", "0xC4, 0x83, 0xA8, 0x5F, 0x21, 0x27, 0x64, 0xAF" ),
				new Array( "0x04E001, 0xFE2CF6", "0xC3, 0xFD, 0x81, 0xAC, 0x6D, 0xE7, 0xBF, 0x9E" ),
				new Array( "0x0C2000, 0xFFAC28", "0xC3, 0xFD, 0x81, 0xAC, 0x6D, 0xE7, 0xBF, 0x9E" ),
				new Array( "0x00A000, 0xFEB2C0", "0xCB, 0x29, 0x7D, 0x43, 0xD2, 0x3A, 0xC2, 0xB4" ),
				new Array( "0x0A7001, 0xFF14EA", "0x4B, 0xA4, 0x63, 0x46, 0xF0, 0x91, 0xEA, 0x62" ),
				new Array( "0x002000, 0xFFB440", "0x4B, 0xA4, 0x63, 0x46, 0xF0, 0x91, 0xEA, 0x62" )
			);

			if (form.pcm2.value >= 11) {
				output += "		PCM2DecryptVInfo Info = { " + pcm2x[form.pcm2.value-11][0] + ", { " + pcm2x[form.pcm2.value-11][1] + "} };\n\n";
			}

			if (eval(form.pcm2.value) >= 10) output += "		PCM2DecryptV(&Info);\n"

			if (eval(form.pcm2.value) < 10)
			{
				var pcm2vtot = 0;
				for (i = 1; i < 6; i++)
					if (form["chxbxv" + i].checked) pcm2vtot += eval(form["v" + i + "size"].value);

				var pcm2v1t = (form.pcm2.value<<3);
				if (form.pcm2.value == "03") pcm2v1t = 4;

				output += "		for (int i = 0; i < 0x" + toHex(pcm2vtot) + " / 2; i += " + pcm2v1t + " / 2) {\n";
				output += "			unsigned short buffer[" + pcm2v1t + " / 2];\n";
				output += "			memcpy(buffer, ((unsigned short*)YM2610ADPCMAROM) + i, " + pcm2v1t + ")\n";
				output += "			for (int j = 0; j < " + pcm2v1t + " / 2; j++) {\n";
				output += "				((unsigned short*)YM2610ADPCMAROM)[i + j] = buffer[j ^ " + (pcm2v1t/4) + "];\n";
				output += "			}\n		}\n";
			}

			output +="	}\n\n	return nRet;\n}\n";
		}
	}

// Driver info Output

	output +="\nstruct BurnDriver BurnDrv" + form.setname.value + " = {\n";

	var parentname = "NULL";
	if ((form.parentname.value) && (form.bdfclone.value)) parentname = "\"" + form.parentname.value + "\"";

	var year = "NULL";
	if ((form.yearname.value) && (form.yearname.value != "NULL")) year = "\"" + form.yearname.value + "\"";

	var notes = "NULL";
	if ((form.notesname.value)&&(form.notesname.value != l_noneop))
		notes ="\"" + form.notesname.value + "\"";

	var developer = "NULL";
	if (form.devname.value) developer = "\"" + form.devname.value + "\"";

	if (fba_version == "old")
	{
		output +="\n	{\"" + form.setname.value + "\", \"" + form.realname.value + "\", ";
		output += notes + ", " + developer + ", \"Neo Geo\", " + year + ", ";
		output +=parentname + ", \"neogeo\"},\n";
	}

	if (fba_version == "new")
	{
		output += "	\"" + form.setname.value + "\", " + parentname + ", \"neogeo\", " + year + ",\n";
		output += "	\"" + form.realname.value + "\\0\", " + notes + ", " + developer + ", \"Neo Geo\",\n";

		var unicode_name = "NULL";
		if ((form.non_latin_text.value)&&(form.non_latin_text.value != "null")) {
			var unicode_name = "L\"" + form.non_latin_text.value + "\\0\"";
		}

		output += "	" + unicode_name + ", NULL, NULL, NULL,\n";
	}

	var BDF_INFO = 0;

	if (form.works.checked)	BDF_INFO = "BDF_GAME_WORKING";

	if (form.proto.checked)	{
		if (BDF_INFO) {
			BDF_INFO += " | BDF_PROTOTYPE";
		} else {
			BDF_INFO =  "BDF_PROTOTYPE";
		}
	}

	if (form.bootleg.checked) {
		if (BDF_INFO) {
			BDF_INFO += " | BDF_BOOTLEG";
		} else { 
			BDF_INFO = "BDF_BOOTLEG";
		}
	}

	if ((form.parentname.value) && (form.bdfclone.value)) {
		if (BDF_INFO) {
			BDF_INFO += " | BDF_CLONE";
		} else {
			BDF_INFO = "BDF_CLONE";
		}
	}

	output += "	" + BDF_INFO;

	output+=", 2, HARDWARE_SNK_NEOGEO"; // number of players & system

	if ((form.GfxKey.value) && (form.criptsel.value)) {
		output += " | HARDWARE_SNK_ENCRYPTED_";
		if (form.criptsel.value == 1) output += "A";
		if (form.criptsel.value == 2) output += "B";
	}

	if (form.swapc.checked)  output += " | HARDWARE_SNK_SWAPC";
	if (form.swapp.checked)  output += " | HARDWARE_SNK_SWAPP";
	if (form.sram.checked)   output += " | HARDWARE_SNK_SRAM";
	if (form.alttxt.checked) output += " | HARDWARE_SNK_ALTERNATE_TEXT";
	if (USE_SMA)		 output += " | HARDWARE_SNK_SMA_PROTECTION";

	if (form.controls.value != "neogeo")
		output += " | HARDWARE_SNK_" + form.controls.value.slice(3, form.controls.value.length).toUpperCase();

	if (form.gambling.checked) output +=" | HARDWARE_SNK_GAMBLING";

	output +=",\n	NULL, " + form.setname.value + "RomInfo, " + form.setname.value + "RomName, " + form.controls.value + "InputInfo, " + form.controls.value + "DIPInfo,\n";

	if (show_fba_init) {
		output += "	" + form.setname.value + "Init";
	} else {
		output += "	NeoInit";
	}

	output +=", NeoExit, NeoFrame, NeoRender, NeoScan, &NeoRecalcPalette,\n";

	var screenwidth  = "nNeoScreenWidth";
	var screenheight = "224";
	var screenratio  = "4, 3";

	output +="	" + screenwidth + ", " + screenheight + ", " + screenratio + "\n};\n";
}














if (form.picker.value == "nebula")
{

	output ="%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n";

// Header Output

	output +="System: NEO\n";			// The system being emulated-  Always "NEO" (Neo-Geo)
	output +="RomName: " + form.setname.value;	// The rom's name (ZIP) (Example: kof2000)
	output +="\nGame: " + form.realname.value;	// The game's name (Example: King of Fighters)

	if (form.bootleg.checked)	output += " (Bootleg)"

	if (form.proto.checked)		output += " (Prototype)"

	output +="\n"

	if ((form.bdfclone.value) && (form.parentname.value))
		output +="Parent: " + form.parentname.value + "\n"; // The parent rom (if there is one)

// Px Output

	output +="\n[Program]\n";

	for (i = 1; i < 6; i++)
	{
		var offset = 0;
		if (form["chxbxp" + i].checked)
		{
			if (((form.swapp.checked)&&(i == 1))||(USE_SMA)) offset += 1048576;
			if (i >= 2) offset += getlen("p", 1, i-1, 0);
			offset = toHex(offset);

			var pxcrc = PxInfo[i-1][2];
			if (pxcrc.length < 7) pxcrc = "0";

			output += PxInfo[i-1][0] + "," + offset + "," + PxInfo[i-1][1] + "," + pxcrc + ",";
			if ((form.swapp.checked)&&(i == 1))
				output += 1;
			else 
				output += 0;

			output += "\n";
		}
	}

// S1 Output

	output +="\n[Text]\n"

	if (form.chxbxs1.checked)
	{
		var s1crc = S1Info[2];
		if (s1crc.length < 7) s1crc = "0";

		output += S1Info[0] + "," + 0 + "," + S1Info[1] + "," + s1crc + ",0\n";
	}

// M1/M1D Output

	output +="\n[Z80]\n"

	if (form.chxbxm1.checked)
	{
		var m1crc = M1Info[2];
		if (m1crc.length < 7) m1crc = "0";

		output += M1Info[0] + ",0," + M1Info[1] + "," + m1crc +  ",0\n";
	}

	if (form.chxbxm1d.checked)
	{
		var m1dcrc = M1dInfo[2];
		if (m1dcrc.length < 7) m1dcrc = "0";

		output += M1dInfo[0] + ",0," + M1dInfo[1] + "," + m1dcrc +  ",0\n";
	}

// Vx Output

	output +="\n[Samples]\n"

	for (var i = 1; i < 7; i++)
	{
		if (form["chxbxv" + i].checked)
		{
			var v_crc = VxInfo[i-1][2];
			if (v_crc.length < 7) v_crc = "0";
			var offset = getlen("v", 1, i-1, 1);

			output += VxInfo[i-1][0] + "," + offset + "," + VxInfo[i-1][1] + "," + v_crc +  ",0\n";
		}
	}

// Cx Output

	var c1swap = 0;
	var c2swap = 0;
	var swpval1 = "";
	var swpval2 = "";

	if (form.swapc.checked)
	{
		C2total = getlen("c", 1, 1, 1);
		c3total = getlen("c", 1, 1, 3);

		if ((CxInfo[0][1] == "200000") && (CxInfo[1][1] == "200000")) c1swap = "2";
		if ((CxInfo[2][1] == "200000") && (CxInfo[3][1] == "200000")) c2swap = "2";
		
		if ((CxInfo[2][1] == "80000") && (form.chxbxc3.checked)) swpval1 = ",400000,200000,0,0\n"; // type 1

		if ((!c2swap)&&(c1swap)) swpval1 = ",400000,100000,0,0\n"; // type 2

		if (c2swap) { // type 3
			swpval2 = ",400000,200000,0,0\n";
			if (form.setname.value.toLowerCase() == "3countb") {
				swpval1 = swpval2;
				swpval2 = ",600000,200000,0,0\n";
			}
		}
	}

	output +="\n[Graphics]\n";

	for (var i = 1; i < 9; i++)
	{
		if (form["chxbxc" + i].checked)
		{
			var swap = 0;
			if (i<3) swap = c1swap;
			if ((i>2)&&(i<5)) swap = c2swap;
			var c_crc = CxInfo[i-1][2];
			if (c_crc.length < 7) c_crc = "0";

			var offset = getlen("c", 1, ((i-1)&14), (3^((i&1)<<1)));
			if (offset.length <= 2) offset &= 1;
			if ((i == 2) && (form.c1size.value == "33554432")) offset = CxInfo[0][1]; // SVCCHAOS Cx Fix

			output += CxInfo[i-1][0] + "," + offset + "," + CxInfo[i-1][1] + "," + c_crc +  "," + swap + "\n";
		}

		if ((swpval1) && (i == 2)) output += swpval1;
		if ((swpval2) && (i == 8)) output += swpval2;
	}

// Footer Output

	var criptsel = "0";
	var gfxkey = "0";

	if ((form.GfxKey.value) && (form.criptsel.value)) {
		criptsel = form.criptsel.value;
		gfxkey = form.GfxKey.value;
	}

	output +="\n[System]\n"

 	// This is the Unique Id. number for each game. You can find it at offset 0x108 of most P roms.
	output +="CartridgeID: ";
	output +=form.cartidn.value;

	output +="\nGfxCrypt: " + criptsel + "\n";
	output +="GfxKey: " + gfxkey + "\n";

	if ((form.pcm2.value != "00") && (form.pcm2.value != "03")) {
		var nebpcm2val = 0;
		if (form.pcm2.value < 3) nebpcm2val = form.pcm2.value;
		if (form.pcm2.value > 2) nebpcm2val = "0" + eval(form.pcm2.value-8);
		if ((nebpcm2val&14)==6) nebpcm2val = "0" + (nebpcm2val^1); // swap samsho5 & svc
		output += "PCM2: " + nebpcm2val + "\n";
	}

	//  This section is to deal with JockeyGP and Vliner's butlayout numbers.
	//  While all other neogeo games are 9, Jockeygp is 7 and Vliner is 8

	var butlayout = "9";
	if (form.gambling.checked) {
		var find_name_letter = form.setname.value.slice(0,1);
		if (find_name_letter.toLowerCase() == "j") butlayout = 7; // jockeygp
		if (find_name_letter.toLowerCase() == "v") butlayout = 8; // vliner
	}

	output +="ButLayout: " + butlayout + "\n"; 
	output +="Fix: ";

	if (form.nebfixn.value)
	{
		output +=form.nebfixn.value;
	} else {
		output +="0";
	}

	output +="\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%";
}










if (form.picker.value == "mame")
{
	var mamebios="neogeo,";
	var gameb="B";
	var criptsel = "";

	if (form.GfxKey.value) {
		if (form.chxbxs1.checked) {
			if (form.criptsel.value == 1) criptsel = "	cmc42";
			if (form.criptsel.value == 2) criptsel = "	cmc50";
		} else {
			if (form.criptsel.value == 1) criptsel = "	kof99"
			if (form.criptsel.value == 2) criptsel = "	kof2000";
		}

		if (criptsel) criptsel += "_neogeo_gfx_decrypt(0x" + form.GfxKey.value + ");\n";
	}

	output = l_mmtxt5 + "\n\n";
	output +="ROM_START( " + form.setname.value + " )\n";

	var crc1val="CRC(";
	var crc2val=")";

// Px Output

	var ptotal=getlen("p", 1, 5, 1);

	if ((form.gambling.checked) && (!form.chxbxp2.checked) && (PxInfo[0][1] == "100000"))
		ptotal = "200000";

	if (USE_SMA) ptotal="900000";

	output +="	ROM_REGION( 0x" + ptotal + ", REGION_CPU1, 0 )\n";

	// SMA
	if (USE_SMA) {
		if (form["chxbxp"+USE_SMA].checked) {
			output += "	ROM_LOAD16_WORD_SWAP( \"" + PxInfo[USE_SMA-1][0] + "\", 0x0c0000, 0x" + PxInfo[USE_SMA-1][1] + ", ";
			output += mame_crc(PxInfo[USE_SMA-1][2], crc1val, crc2val, 7) + PxInfo[USE_SMA-1][3] + " ) /* stored in the custom chip */\n";
		}
	}

	for (i = 1; i < 6; i++)
	{
		if (form["chxbxp" + i].checked)
		{
			if ((USE_SMA) && (i == USE_SMA)){}else{
				var px_crc =  mame_crc(PxInfo[i-1][2], crc1val, crc2val, 7);
				var px_size = PxInfo[i-1][1];
				var offset = mame_offset(ptotal, getlen("p", 1, i-1, 0));
				if ((form.swapp.checked) && (i==1)) { // Swap P
					offset = 1048576;
					px_size = offset;
				}
				if (USE_SMA) offset += 1048576;
				offset = toHex(offset);

				output +="	ROM_LOAD16_WORD_SWAP( \"" + PxInfo[i-1][0] + "\", 0x" + offset + ", 0x" + PxInfo[i-1][1] + ", " + px_crc + PxInfo[i-1][3] + " )\n";
			}
		}
	}

	if ((form.gambling.checked) && (!form.chxbxp2.checked) && (PxInfo[0][1] == "100000"))
		output += "	ROM_FILL( 				     0x100000, 0x100000, 0xFF )\n";

	if (form.swapp.checked)
		output +="	ROM_CONTINUE(					   0x000000, 0x100000 )\n"

	output +="\n";

// S1 Output

	var s_rom_written = 0;
	var s1crc = mame_crc(S1Info[2], crc1val, crc2val, 7);

	if ((form.chxbxs1.checked) && (eval(form.s1size.value / 1024) < 256))
	{
		var ssize = eval(form.s1size.value / 1024);

		if (form.s1size.value <= 131072)
		{
			output +="	NEO_SFIX_" + ssize + "K( \"" + S1Info[0] + "\", " + s1crc + S1Info[3] + " )\n\n";
			s_rom_written = 1;
		}
	}

	if (s_rom_written != 1)
	{
		var s1esha1 = "";
		var s1size4mame = S1Info[1];
		var snotesmame = "";
		if (!form.chxbxs1.checked) s1size4mame = "20000";
		if (form.textromfix.checked) s1size4mame = "80000";
		if ((form.textromfix.checked)||((form.chxbxs1.checked)&&(form.s1size.value < 262144))) snotesmame = " /* larger char set */ "

		if (!form.chxbxs1.checked)
			output +="	/* The Encrypted Boards do _not_ have an s1 rom, data for it comes from the Cx ROMs */\n"

		output +="	ROM_REGION( 0x" + s1size4mame + ", REGION_GFX1, 0 )" + snotesmame + "\n"

		if (form.chxbxs1.checked)
			output += "	ROM_LOAD( \"" + S1Info[0] + "\",		0x000000, 0x" + S1Info[1] + ", " + s1crc + S1Info[3] + " )\n";
		else
			output +="	ROM_FILL(                 0x000000, 0x" + s1size4mame + ", 0 )\n"

		output +="	ROM_REGION( 0x20000, REGION_GFX2, 0 )\n"

		if (form.usesha.value == 1) s1esha1 = " SHA1(" + sfixsha + ")";

		output +="	ROM_LOAD( \"sfix.sfx\",  0x000000, 0x20000, " + crc1val + sfixcrc + crc2val + s1esha1 + " )\n\n"
	}

// M1/M1D Output

	if (form.chxbxm1.checked)
	{
		var m1crc = mame_crc(M1Info[2],    crc1val, crc2val, 7);
		output += "	ROM_REGION( 0x" + M1Info[1] + ", REGION_USER4, 0 )\n";
		output += "	\/* The M1 ROM is encrypted, we load it here for reference and replace it with a decrypted version *\/\n";
		output += "	ROM_LOAD( \"" + M1Info[0] + "\", 0x00000, 0x" + M1Info[1] + ", " + m1crc + M1Info[3] + " )\n";
		output += "	/* Decrypted */\n";
	}

	if (form.chxbxm1d.checked)
	{
		var m1dcrc = mame_crc(M1dInfo[2],  crc1val, crc2val, 7);
		output +="	NEO_BIOS_SOUND_" + eval(form.m1dsize.value / 1024) + "K( \"" + M1dInfo[0] + "\", " + m1dcrc + M1dInfo[3] + " )\n\n";
	}

// Vx Output

	var b_reg2 = 5;
	var vx1total = 0;
	var vx2total = 0;

	for (i = 1; i < 6; i++) { // find sound region 2
		if (form["chxbxv" + i].checked)	{
			var tmp = VxInfo[i-1][0];
			for (var j = 0; j < 16; j++) {
				var tmp2 = tmp.slice(j, j+3);
				if ((tmp2.toLowerCase() == "v21")||(tmp2.toLowerCase() == "v22")||(tmp2.toLowerCase() == "v23")||(tmp2.toLowerCase() == "v24")) {
					b_reg2 = i-1;
					i = 6;
				}
			}
		}
	}

	if (getlen("v", 1, b_reg2, 1) == 0)
		vx1total = "200000";
	else
		vx1total = getlen("v", 1, b_reg2, 1);

	if (b_reg2) vx2total = getlen("v", b_reg2+1, 5, 1);

	output +="	ROM_REGION( 0x" + vx1total + ", REGION_SOUND1, 0 )\n";

	if (form.pcm2.value != "00") output += "\t/* Encrypted */\n";

	for (i = 1; i < 7; i++)
	{
		if (form["chxbxv" + i].checked)
		{
			var vx_crc = mame_crc(VxInfo[i-1][2], crc1val, crc2val, 7);
			var offset = mame_offset(vx1total, getlen("v", 1, i-1, 1));
			if (i > b_reg2) offset = mame_offset(vx2total, getlen("v", b_reg2+1, i-1, 1));
			if (i == b_reg2+1) output +="\n	ROM_REGION( 0x" + vx2total + ", REGION_SOUND2, 0 )\n";
			output +="	ROM_LOAD( \"" + VxInfo[i-1][0] + "\", 0x" + offset + ", 0x" + VxInfo[i-1][1] + ", " + vx_crc + VxInfo[i-1][3] + " )\n";
		}
	}

	if (b_reg2 == 5) output +="	\n	NO_DELTAT_REGION\n";

// Cx Output

	var C2total = getlen("c", 1, 2, 1);
	var C3total = getlen("c", 1, 2, 3);
	var Ctotal  = getlen("c", 1, 8, 1);
	var enswapc = 0;

	if ((!form.chxbxc5.checked) && (CxInfo[0][1] == "200000") && (form.swapc.checked))
	{
		CxInfo[0][1] = "100000";
		CxInfo[1][1] = "100000";

		if (CxInfo[2][1] == "200000") CxInfo[2][1] = "100000";
		if (CxInfo[3][1] == "200000") CxInfo[3][1] = "100000";

		if ((form.chxbxc3.checked) && (form.chxbxc4.checked)) Ctotal="600000";

		C2total = "200000";
		C3total = "200001";

		enswapc = "1";
	}

	output +="\n	ROM_REGION( 0x" + Ctotal + ", REGION_GFX3, 0 )\n";

	if (criptsel) output += "\t/* Encrypted */\n";

	for (i = 1; i < 9; i++)
	{
		if (form["chxbxc" + i].checked)
		{
			var cx_crc = mame_crc(CxInfo[i-1][2], crc1val, crc2val, 7);
			var offset = mame_offset(Ctotal, getlen("c", 1, ((i-1)&14), (3^((i&1)<<1))));
			if ((i == 2) && (form.c1size.value&0x2000000)&&(form.criptsel.value == 2)) offset = CxInfo[0][1]; // svcpcb
			if (i == 3) offset = C2total;
			if (i == 4) offset = C3total;

			if ((CxInfo[i-1][1] == "1000000")&&(form.criptsel.value == 2)) { // ms5pcb, svcpcba, kf2k3pcb
				if (offset.slice(offset.length-1, offset.length) == 1) offset = offset.slice(0, offset.length-1) + "2";
				output += "	ROM_LOAD32_WORD( \"" + CxInfo[i-1][0] + "\", 0x" + offset + ", 0x" + CxInfo[i-1][1] + ", " + cx_crc + CxInfo[i-1][3] + " ) ";
			} else {
				output += "	ROM_LOAD16_BYTE( \"" + CxInfo[i-1][0] + "\", 0x" + offset + ", 0x" + CxInfo[i-1][1] + ", " + cx_crc + CxInfo[i-1][3] + " ) ";
			}

			output += "/* Plane " + (((i&1)^1)<<1) + "," + ((((i&1)^1)<<1)+1) + " */\n";

			if ((form["c" + i + "size"].value == "2097152") && (enswapc))
				output += "	ROM_CONTINUE(      			   0x" + (4+((i-1)&2)) + "0000" + (~i&1) + ", 0x100000 )\n"
		}
	}

// Init Output

	output += "ROM_END";

	var show_mame_init = 0;
	var encryption_stuff = "";
	var fix_bank = "";
	var extract_sdata = "";
	var pcm2_stuff = "";

	if (form.pcm2.value != "00") {

		show_mame_init = 1;

		if (form.pcm2.value > 10) pcm2_stuff = "\n	neo_pcm2_swap(" + (form.pcm2.value-11) + ");\n";
		if (form.pcm2.value < 10)
		{
			var outval = form.pcm2.value<<3;
			if (form.pcm2.value == 3) outval = 4;

			pcm2_stuff = "\n	/* Thanks to Elsemi for the NEO-PCM2 info */\n	neo_pcm2_snk_1999(" + outval + ");\n";
		}
	}

	if (criptsel) {
		show_mame_init = 1;
		fix_bank = "	neogeo_fix_bank_type = 1;\n"
		encryption_stuff = criptsel;
	}

	if (form.alttxt.checked) {
		show_mame_init = 1;
		fix_bank = "	neogeo_fix_bank_type = 2;\n"
	}

	if ((!form.criptsel.value) && (!form.chxbxs1.checked))
	{
		show_mame_init = 1;

		extract_sdata =  "	/* the S data comes from the end fo the C data */\n";
		extract_sdata += "	int i;\n	UINT8 *src = memory_region(REGION_GFX3) + memory_region_length(REGION_GFX3) - 0x" + s1size4mame + ";\n";
		extract_sdata += "	UINT8 *dst = memory_region(REGION_GFX1);\n\n	for (i = 0; i < 0x" + s1size4mame + "; i++)\n";
		extract_sdata += "		dst[i] = src[(i & 0x1ffe0) + ((i & 7) << 2) + ((~i & 8) >> 2) + ((i & 0x10) >> 4)];\n\n";
	}

	if (show_mame_init)
	{
  		output +="\n\n\n" + l_mmtxt2 + " \n\n";

		output +="DRIVER_INIT( " + form.setname.value + " )\n{\n";

		output += extract_sdata;
		output += fix_bank;
		output += encryption_stuff;

		output +="	init_neogeo();\n";

		output += pcm2_stuff;

		output += "}";
	}

// End Output

	output +="\n\n\n" + l_mmtxt1 + " NEOGEO.C (src/drivers/)\n\n";

	var parentname ="neogeo";

	if ((form.bdfclone.value) && (form.parentname.value))
	{
		var parentname = form.parentname.value;
	}

	var initname = "neogeo";

	if (show_mame_init) var initname = form.setname.value;

	// mjneogeo irrmaze -->trackball

	var controls = "neogeo";
	if (form.controls.value == "neotrackball")
		controls = "irrmaze";
	if (form.controls.value == "neomahjong")
		controls = "mjneogeo";
	if (form.controls.value == "neopaddle")
		controls = "neogeo";

	var working = "X";
	var working2 = ", GAME_NOT_WORKING";
	if (form.works.checked) {
		working = "";
		working2 = ", 0";
	}

	var prototype = "";
	if (form.proto.checked)
		prototype = " (Prototype)";

	var bootleg = "";
	if (form.bootleg.checked)
		bootleg = " (Bootleg)";

	output +="GAME" + gameb + working + "( " + form.yearname.value + ", " + form.setname.value + ", " + parentname + ", " + mamebios + " neogeo, " + controls + ",  " + initname + ",   ROT0, \"" + form.devname.value + "\", \"" + form.realname.value + prototype + bootleg + "\"" + working2 + " )";

	if ((form.criptsel.value) && (form.GfxKey.value))
	{
		output += "	/* Encrypted GFX */";
	}


	output +="\n\n\n" + l_mmtxt1 + " DRIVER.C (src/)\n\n";

	var cartidmame = ""
	if (form.cartidn.value)
		var cartidmame = form.cartidn.value + " ";

	output +="	DRIVER( " + form.setname.value + " )	/* " + cartidmame + "(c) " + form.yearname.value + " " + form.devname.value + " */";

}






if (form.picker.value == "clrmamepro")
{
	output = "game (\n"; // begin

	// Header
	output += "	name " + form.setname.value + "\n";
	if (form.notesname.value) output += "	description \"" + form.realname.value + "\"\n";
	if (form.yearname.value)  output += "	year " + form.yearname.value + "\n";
	if (form.devname.value)   output += "	manufacturer \"" + form.devname.value + "\"\n";
	if (form.bdfclone.value)  output += "	cloneof " + form.parentname.value + "\n";
	output += "	romof neogeo\n";

	for (i = 1; i < 6; i++) // Px roms
		if (form["chxbxp" + i].checked)
			output += clrmamepro_write(PxInfo[i-1]);

	if (form.chxbxs1.checked) // S1 rom
		output += clrmamepro_write(S1Info);

	for (i = 1; i < 9; i++) // Cx roms
		if (form["chxbxc" + i].checked)
			output += clrmamepro_write(CxInfo[i-1]);

	if (form.chxbxm1.checked) // m1 rom
		output += clrmamepro_write(M1Info);

	if (form.chxbxm1d.checked) // m1d rom
		output += clrmamepro_write(M1dInfo);

	for (i = 1; i < 6; i++) // Vx roms
		if (form["chxbxv" + i].checked)
			output += clrmamepro_write(VxInfo[i-1]);

	for (i = 0; i < 25; i++) // bios roms
		if (dat_bios_files[i] != 0)
		output += clrmamepro_write(dat_bios_files[i]);

	output += ")\n"; // end
}




if (form.picker.value == "romcenter")
{
	output = "";

	if ((form.ptitle.value == "") && (form.bdfclone.value)) {
		if (form.parentname.value != "") {
			form.ptitle.value = prompt(l_plsgtl, form.ptitle.value);
			if (form.ptitle.value == "null") form.ptitle.value = form.realname.value;
		}
	}

	for (i = 1; i < 6; i++) // Px roms
		if (form["chxbxp" + i].checked)
			output += romcenter_write(form, PxInfo[i-1]);

	for (i = 0; i < 25; i++) // bios roms
		if (dat_bios_files[i])
			output += romcenter_write(form, dat_bios_files[i]);

	if (form.chxbxs1.checked) // S1 rom
		output += romcenter_write(form, S1Info);

	if (form.chxbxm1.checked) // m1 rom
		output += romcenter_write(form, M1Info);

	if (form.chxbxm1d.checked) // m1d rom
		output += romcenter_write(form, M1dInfo);

	for (i = 1; i < 6; i++) // Vx roms
		if (form["chxbxv" + i].checked)
			output += romcenter_write(form, VxInfo[i-1]);

	for (i = 1; i < 9; i++) // Cx roms
		if (form["chxbxc" + i].checked)
			output += romcenter_write(form, CxInfo[i-1]);
}


// Leave these alone!!!!!
	form.fbagen.value = output;
   }
}