/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import java.util.concurrent.atomic.AtomicBoolean;
import uk101.hardware.ALU6502;
import uk101.hardware.bus.DataBus;
import uk101.machine.Computer;
import uk101.machine.Data;
import uk101.machine.Trace;

public class CPU6502 {
    static final byte FLAG_N = -128;
    static final byte FLAG_V = 64;
    static final byte FLAG_x = 32;
    static final byte FLAG_B = 16;
    static final byte FLAG_D = 8;
    static final byte FLAG_I = 4;
    static final byte FLAG_Z = 2;
    static final byte FLAG_C = 1;
    static final int MODE_IMPLIED = 0;
    static final int MODE_ACCUM = 1;
    static final int MODE_IMMEDIATE = 2;
    static final int MODE_ABSOLUTE = 3;
    static final int MODE_INDIRECT = 4;
    static final int MODE_ZEROPAGE = 5;
    static final int MODE_RELATIVE = 6;
    static final int MODE_ABS_X = 7;
    static final int MODE_ABS_Y = 8;
    static final int MODE_PRE_X = 9;
    static final int MODE_POST_Y = 10;
    static final int MODE_0PAGE_X = 11;
    static final int MODE_0PAGE_Y = 12;
    static final int STACK_BASE = 256;
    static final byte STACK_TOP = -1;
    static final int NMI_VECTOR = 65530;
    static final int RESET_VECTOR = 65532;
    static final int IRQ_VECTOR = 65534;
    private byte A;
    private byte X;
    private byte Y;
    private byte S;
    private byte P;
    private short PC;
    private ALU6502 alu = new ALU6502();
    private DataBus bus;
    private AtomicBoolean running;
    private boolean sigRESET;
    private boolean sigNMI;
    private boolean sigIRQ;
    private boolean useAuto;
    private boolean useYield;
    private boolean useSleep;
    private int speed;
    private long spinPause;
    private long yieldPause;
    private long sleepPause;
    private long now;
    private long end;
    private long cpuStart;
    private long cpuCycles;
    private Trace trace;
    private Trace.Entry traceEntry;

    public CPU6502(int mhz, String control, DataBus bus) {
        this.bus = bus;
        this.running = new AtomicBoolean();
        this.sigRESET = true;
        this.setMHz(mhz);
        this.useAuto = control.equals("auto");
        if (!this.useAuto) {
            this.useSleep = control.equals("sleep");
            this.useYield = control.equals("yield");
        }
    }

    public synchronized void setMHz(int mhz) {
        this.speed = mhz == 0 ? 0 : 1000 / mhz;
        this.now = this.end = System.nanoTime();
    }

    public int getMHz() {
        return this.speed == 0 ? 0 : 1000 / this.speed;
    }

    public synchronized float getSpeed() {
        float cpuTime = System.currentTimeMillis() - this.cpuStart;
        float mhz = (float)this.cpuCycles / (cpuTime * 1000.0f);
        this.cpuStart = System.currentTimeMillis();
        this.cpuCycles = 0L;
        return mhz;
    }

    private void calibrate() {
        long nt = 0L;
        long yt = 0L;
        long st = 0L;
        int i = 0;
        while (i < 3) {
            long t1 = System.nanoTime();
            long t2 = System.nanoTime();
            Thread.yield();
            long t3 = System.nanoTime();
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long t4 = System.nanoTime();
            nt += t2 - t1;
            yt += t3 - t2;
            st += t4 - t3;
            ++i;
        }
        this.spinPause = nt / 3L;
        this.yieldPause = yt / 3L;
        this.sleepPause = st / 3L;
        if (this.useAuto) {
            this.useSleep = this.sleepPause <= (long)(10000 * this.speed);
            boolean bl = this.useYield = this.yieldPause <= (long)(10000 * this.speed);
        }
        if (Computer.debug) {
            System.out.println("CPU:");
            System.out.println("  sleep time:   " + this.sleepPause);
            System.out.println("  yield time:   " + this.yieldPause);
            System.out.println("  spin time:    " + this.spinPause);
            System.out.println("  pause method: " + (this.speed == 0 ? "none" : (this.useSleep ? "sleep" : (this.useYield ? "yield" : "spin"))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        this.getSpeed();
        this.now = this.end = System.nanoTime();
        this.running.set(true);
lbl5:
        // 5 sources

        while (this.running.get()) {
            var1_1 = this;
            synchronized (var1_1) {
                block9: {
                    this.checkSignals();
                    cycles = this.execute();
                    this.cpuCycles += (long)cycles;
                    if (this.speed <= 0) ** GOTO lbl5
                    this.end += (long)(cycles * this.speed);
                    if (!this.useSleep) break block9;
                    while (this.end - this.now > this.sleepPause) {
                        try {
                            pause = this.end - this.now;
                            Thread.sleep(pause / 1000000L, (int)pause % 1000000);
                        }
                        catch (InterruptedException var3_4) {
                            // empty catch block
                        }
                        this.now = System.nanoTime();
                    }
                    ** GOTO lbl5
                }
                if (!this.useYield) ** GOTO lbl33
                while (this.end - this.now > this.yieldPause) {
                    Thread.yield();
                    this.now = System.nanoTime();
                }
                ** GOTO lbl5
lbl-1000:
                // 1 sources

                {
                    this.now = System.nanoTime();
lbl33:
                    // 2 sources

                    ** while (this.end - this.now > this.spinPause)
                }
lbl34:
                // 1 sources

            }
        }
    }

    public void stop() {
        this.running.set(false);
    }

    public synchronized void signalReset() {
        this.sigRESET = true;
        this.notify();
    }

    public synchronized void signalNMI() {
        this.sigNMI = true;
        this.notify();
    }

    public synchronized void signalIRQ() {
        if (!this.testFlag((byte)4)) {
            this.sigIRQ = true;
            this.notify();
        }
    }

    private void reset() {
        this.calibrate();
        this.Y = 0;
        this.X = 0;
        this.A = 0;
        this.S = (byte)-1;
        this.P = (byte)32;
        this.PC = 0;
    }

    private int execute() {
        if (this.trace != null) {
            this.traceEntry = this.trace.trace(this.PC, this.A, this.X, this.Y, this.S, this.P);
        }
        int op = Data.asBits(this.fetchByte());
        int cycles = 0;
        int bc = 0;
        switch (op) {
            default: {
                cycles = 6;
                break;
            }
            case 109: {
                this.adc(3);
                cycles = 4;
                break;
            }
            case 101: {
                this.adc(5);
                cycles = 3;
                break;
            }
            case 105: {
                this.adc(2);
                cycles = 2;
                break;
            }
            case 125: {
                this.adc(7);
                cycles = 4;
                break;
            }
            case 121: {
                this.adc(8);
                cycles = 4;
                break;
            }
            case 97: {
                this.adc(9);
                cycles = 6;
                break;
            }
            case 113: {
                this.adc(10);
                cycles = 5;
                break;
            }
            case 117: {
                this.adc(11);
                cycles = 4;
                break;
            }
            case 45: {
                this.and(3);
                cycles = 4;
                break;
            }
            case 37: {
                this.and(5);
                cycles = 3;
                break;
            }
            case 41: {
                this.and(2);
                cycles = 2;
                break;
            }
            case 61: {
                this.and(7);
                cycles = 4;
                break;
            }
            case 57: {
                this.and(8);
                cycles = 4;
                break;
            }
            case 33: {
                this.and(9);
                cycles = 6;
                break;
            }
            case 49: {
                this.and(10);
                cycles = 5;
                break;
            }
            case 53: {
                this.and(11);
                cycles = 4;
                break;
            }
            case 205: {
                this.cmp(3);
                cycles = 4;
                break;
            }
            case 197: {
                this.cmp(5);
                cycles = 3;
                break;
            }
            case 201: {
                this.cmp(2);
                cycles = 2;
                break;
            }
            case 221: {
                this.cmp(7);
                cycles = 4;
                break;
            }
            case 217: {
                this.cmp(8);
                cycles = 4;
                break;
            }
            case 193: {
                this.cmp(9);
                cycles = 6;
                break;
            }
            case 209: {
                this.cmp(10);
                cycles = 5;
                break;
            }
            case 213: {
                this.cmp(11);
                cycles = 4;
                break;
            }
            case 77: {
                this.eor(3);
                cycles = 4;
                break;
            }
            case 69: {
                this.eor(5);
                cycles = 3;
                break;
            }
            case 73: {
                this.eor(2);
                cycles = 2;
                break;
            }
            case 93: {
                this.eor(7);
                cycles = 4;
                break;
            }
            case 89: {
                this.eor(8);
                cycles = 4;
                break;
            }
            case 65: {
                this.eor(9);
                cycles = 6;
                break;
            }
            case 81: {
                this.eor(10);
                cycles = 5;
                break;
            }
            case 85: {
                this.eor(11);
                cycles = 4;
                break;
            }
            case 173: {
                this.lda(3);
                cycles = 4;
                break;
            }
            case 165: {
                this.lda(5);
                cycles = 3;
                break;
            }
            case 169: {
                this.lda(2);
                cycles = 2;
                break;
            }
            case 189: {
                this.lda(7);
                cycles = 4;
                break;
            }
            case 185: {
                this.lda(8);
                cycles = 4;
                break;
            }
            case 161: {
                this.lda(9);
                cycles = 6;
                break;
            }
            case 177: {
                this.lda(10);
                cycles = 5;
                break;
            }
            case 181: {
                this.lda(11);
                cycles = 4;
                break;
            }
            case 13: {
                this.ora(3);
                cycles = 4;
                break;
            }
            case 5: {
                this.ora(5);
                cycles = 3;
                break;
            }
            case 9: {
                this.ora(2);
                cycles = 2;
                break;
            }
            case 29: {
                this.ora(7);
                cycles = 4;
                break;
            }
            case 25: {
                this.ora(8);
                cycles = 4;
                break;
            }
            case 1: {
                this.ora(9);
                cycles = 6;
                break;
            }
            case 17: {
                this.ora(10);
                cycles = 5;
                break;
            }
            case 21: {
                this.ora(11);
                cycles = 4;
                break;
            }
            case 237: {
                this.sbc(3);
                cycles = 4;
                break;
            }
            case 229: {
                this.sbc(5);
                cycles = 3;
                break;
            }
            case 233: {
                this.sbc(2);
                cycles = 2;
                break;
            }
            case 253: {
                this.sbc(7);
                cycles = 4;
                break;
            }
            case 249: {
                this.sbc(8);
                cycles = 4;
                break;
            }
            case 225: {
                this.sbc(9);
                cycles = 6;
                break;
            }
            case 241: {
                this.sbc(10);
                cycles = 5;
                break;
            }
            case 245: {
                this.sbc(11);
                cycles = 4;
                break;
            }
            case 141: {
                this.sta(3);
                cycles = 4;
                break;
            }
            case 133: {
                this.sta(5);
                cycles = 3;
                break;
            }
            case 157: {
                this.sta(7);
                cycles = 5;
                break;
            }
            case 153: {
                this.sta(8);
                cycles = 5;
                break;
            }
            case 129: {
                this.sta(9);
                cycles = 6;
                break;
            }
            case 145: {
                this.sta(10);
                cycles = 6;
                break;
            }
            case 149: {
                this.sta(11);
                cycles = 4;
                break;
            }
            case 236: {
                this.cpx(3);
                cycles = 4;
                break;
            }
            case 228: {
                this.cpx(5);
                cycles = 3;
                break;
            }
            case 224: {
                this.cpx(2);
                cycles = 2;
                break;
            }
            case 204: {
                this.cpy(3);
                cycles = 4;
                break;
            }
            case 196: {
                this.cpy(5);
                cycles = 3;
                break;
            }
            case 192: {
                this.cpy(2);
                cycles = 2;
                break;
            }
            case 174: {
                this.ldx(3);
                cycles = 4;
                break;
            }
            case 166: {
                this.ldx(5);
                cycles = 3;
                break;
            }
            case 162: {
                this.ldx(2);
                cycles = 2;
                break;
            }
            case 190: {
                this.ldx(8);
                cycles = 4;
                break;
            }
            case 182: {
                this.ldx(12);
                cycles = 4;
                break;
            }
            case 172: {
                this.ldy(3);
                cycles = 4;
                break;
            }
            case 164: {
                this.ldy(5);
                cycles = 3;
                break;
            }
            case 160: {
                this.ldy(2);
                cycles = 2;
                break;
            }
            case 188: {
                this.ldy(7);
                cycles = 4;
                break;
            }
            case 180: {
                this.ldy(11);
                cycles = 4;
                break;
            }
            case 142: {
                this.stx(3);
                cycles = 4;
                break;
            }
            case 134: {
                this.stx(5);
                cycles = 3;
                break;
            }
            case 150: {
                this.stx(12);
                cycles = 4;
                break;
            }
            case 140: {
                this.sty(3);
                cycles = 4;
                break;
            }
            case 132: {
                this.sty(5);
                cycles = 3;
                break;
            }
            case 148: {
                this.sty(11);
                cycles = 4;
                break;
            }
            case 10: {
                this.asl(1);
                cycles = 2;
                break;
            }
            case 14: {
                this.asl(3);
                cycles = 6;
                break;
            }
            case 6: {
                this.asl(5);
                cycles = 5;
                break;
            }
            case 30: {
                this.asl(7);
                cycles = 7;
                break;
            }
            case 22: {
                this.asl(11);
                cycles = 6;
                break;
            }
            case 74: {
                this.lsr(1);
                cycles = 2;
                break;
            }
            case 78: {
                this.lsr(3);
                cycles = 6;
                break;
            }
            case 70: {
                this.lsr(5);
                cycles = 5;
                break;
            }
            case 94: {
                this.lsr(7);
                cycles = 7;
                break;
            }
            case 86: {
                this.lsr(11);
                cycles = 6;
                break;
            }
            case 42: {
                this.rol(1);
                cycles = 2;
                break;
            }
            case 46: {
                this.rol(3);
                cycles = 6;
                break;
            }
            case 38: {
                this.rol(5);
                cycles = 5;
                break;
            }
            case 62: {
                this.rol(7);
                cycles = 7;
                break;
            }
            case 54: {
                this.rol(11);
                cycles = 6;
                break;
            }
            case 106: {
                this.ror(1);
                cycles = 2;
                break;
            }
            case 110: {
                this.ror(3);
                cycles = 6;
                break;
            }
            case 102: {
                this.ror(5);
                cycles = 5;
                break;
            }
            case 126: {
                this.ror(7);
                cycles = 7;
                break;
            }
            case 118: {
                this.ror(11);
                cycles = 6;
                break;
            }
            case 44: {
                this.bit(3);
                cycles = 4;
                break;
            }
            case 36: {
                this.bit(5);
                cycles = 3;
                break;
            }
            case 206: {
                this.dec(3);
                cycles = 6;
                break;
            }
            case 198: {
                this.dec(5);
                cycles = 5;
                break;
            }
            case 222: {
                this.dec(7);
                cycles = 7;
                break;
            }
            case 214: {
                this.dec(11);
                cycles = 6;
                break;
            }
            case 238: {
                this.inc(3);
                cycles = 6;
                break;
            }
            case 230: {
                this.inc(5);
                cycles = 5;
                break;
            }
            case 254: {
                this.inc(7);
                cycles = 7;
                break;
            }
            case 246: {
                this.inc(11);
                cycles = 6;
                break;
            }
            case 202: {
                this.dex();
                cycles = 2;
                break;
            }
            case 136: {
                this.dey();
                cycles = 2;
                break;
            }
            case 232: {
                this.inx();
                cycles = 2;
                break;
            }
            case 200: {
                this.iny();
                cycles = 2;
                break;
            }
            case 170: {
                this.tax();
                cycles = 2;
                break;
            }
            case 168: {
                this.tay();
                cycles = 2;
                break;
            }
            case 186: {
                this.tsx();
                cycles = 2;
                break;
            }
            case 138: {
                this.txa();
                cycles = 2;
                break;
            }
            case 154: {
                this.txs();
                cycles = 2;
                break;
            }
            case 152: {
                this.tya();
                cycles = 2;
                break;
            }
            case 144: {
                bc = this.branch((byte)1, false);
                cycles = 2;
                break;
            }
            case 176: {
                bc = this.branch((byte)1, true);
                cycles = 2;
                break;
            }
            case 208: {
                bc = this.branch((byte)2, false);
                cycles = 2;
                break;
            }
            case 240: {
                bc = this.branch((byte)2, true);
                cycles = 2;
                break;
            }
            case 16: {
                bc = this.branch((byte)-128, false);
                cycles = 2;
                break;
            }
            case 48: {
                bc = this.branch((byte)-128, true);
                cycles = 2;
                break;
            }
            case 80: {
                bc = this.branch((byte)64, false);
                cycles = 2;
                break;
            }
            case 112: {
                bc = this.branch((byte)64, true);
                cycles = 2;
                break;
            }
            case 24: {
                this.flag((byte)1, false);
                cycles = 2;
                break;
            }
            case 216: {
                this.flag((byte)8, false);
                cycles = 2;
                break;
            }
            case 88: {
                this.flag((byte)4, false);
                cycles = 2;
                break;
            }
            case 184: {
                this.flag((byte)64, false);
                cycles = 2;
                break;
            }
            case 56: {
                this.flag((byte)1, true);
                cycles = 2;
                break;
            }
            case 248: {
                this.flag((byte)8, true);
                cycles = 2;
                break;
            }
            case 120: {
                this.flag((byte)4, true);
                cycles = 2;
                break;
            }
            case 234: {
                this.nop();
                cycles = 2;
                break;
            }
            case 72: {
                this.pha();
                cycles = 3;
                break;
            }
            case 8: {
                this.php();
                cycles = 3;
                break;
            }
            case 104: {
                this.pla();
                cycles = 4;
                break;
            }
            case 40: {
                this.plp();
                cycles = 4;
                break;
            }
            case 0: {
                this.brk();
                cycles = 7;
                break;
            }
            case 76: {
                this.jmp(3);
                cycles = 3;
                break;
            }
            case 108: {
                this.jmp(4);
                cycles = 5;
                break;
            }
            case 32: {
                this.jsr(3);
                cycles = 6;
                break;
            }
            case 64: {
                this.rti();
                cycles = 6;
                break;
            }
            case 96: {
                this.rts();
                cycles = 6;
                break;
            }
            case 2: {
                this.halt();
                break;
            }
            case 34: {
                this.debug();
            }
        }
        this.traceEntry = null;
        return cycles + bc;
    }

    private void checkSignals() {
        if (this.sigRESET) {
            this.sigIRQ = false;
            this.sigNMI = false;
            this.sigRESET = false;
            this.reset();
            this.PC = this.readWord(65532);
        } else if (this.sigNMI) {
            this.sigNMI = false;
            this.pushWord(this.PC);
            this.pushByte(this.P);
            this.setFlag((byte)4, true);
            this.PC = this.readWord(65530);
        } else if (this.sigIRQ) {
            this.sigIRQ = false;
            this.pushWord(this.PC);
            this.pushByte((byte)(this.P & 0xFFFFFFEF));
            this.setFlag((byte)4, true);
            this.PC = this.readWord(65534);
        }
    }

    private void nop() {
    }

    private void brk() {
        this.pushWord((short)(this.PC + 1));
        this.pushByte((byte)(this.P | 0x10));
        this.PC = this.readWord(65534);
    }

    private void sta(int mode) {
        this.setResult(this.A, mode);
    }

    private void stx(int mode) {
        this.setResult(this.X, mode);
    }

    private void sty(int mode) {
        this.setResult(this.Y, mode);
    }

    private void lda(int mode) {
        this.A = this.getOperand(mode);
        this.setNZ(this.A);
    }

    private void ldx(int mode) {
        this.X = this.getOperand(mode);
        this.setNZ(this.X);
    }

    private void ldy(int mode) {
        this.Y = this.getOperand(mode);
        this.setNZ(this.Y);
    }

    private void tax() {
        this.X = this.A;
        this.setNZ(this.X);
    }

    private void txa() {
        this.A = this.X;
        this.setNZ(this.A);
    }

    private void tay() {
        this.Y = this.A;
        this.setNZ(this.Y);
    }

    private void tya() {
        this.A = this.Y;
        this.setNZ(this.A);
    }

    private void tsx() {
        this.X = this.S;
        this.setNZ(this.X);
    }

    private void txs() {
        this.S = this.X;
    }

    private void ora(int mode) {
        this.A = this.alu.or(this.A, this.getOperand(mode));
        this.setNZ(this.A);
    }

    private void and(int mode) {
        this.A = this.alu.and(this.A, this.getOperand(mode));
        this.setNZ(this.A);
    }

    private void eor(int mode) {
        this.A = this.alu.xor(this.A, this.getOperand(mode));
        this.setNZ(this.A);
    }

    private void adc(int mode) {
        this.A = this.alu.add(this.A, this.getOperand(mode), this.testFlag((byte)1));
        this.setNZCV(this.A);
    }

    private void sbc(int mode) {
        this.A = this.alu.sub(this.A, this.getOperand(mode), this.testFlag((byte)1));
        this.setNZCV(this.A);
    }

    private void cmp(int mode) {
        byte b = this.alu.cmp(this.A, this.getOperand(mode));
        this.setNZC(b);
    }

    private void cpx(int mode) {
        byte b = this.alu.cmp(this.X, this.getOperand(mode));
        this.setNZC(b);
    }

    private void cpy(int mode) {
        byte b = this.alu.cmp(this.Y, this.getOperand(mode));
        this.setNZC(b);
    }

    private void asl(int mode) {
        byte b;
        if (mode == 1) {
            b = this.A = this.alu.shl(this.A);
        } else {
            int addr = this.getAddress(mode);
            b = this.alu.shl(this.getOperand(addr, mode));
            this.setResult(addr, b);
        }
        this.setNZC(b);
    }

    private void rol(int mode) {
        byte b;
        if (mode == 1) {
            b = this.A = this.alu.rol(this.A, this.testFlag((byte)1));
        } else {
            int addr = this.getAddress(mode);
            b = this.alu.rol(this.getOperand(addr, mode), this.testFlag((byte)1));
            this.setResult(addr, b);
        }
        this.setNZC(b);
    }

    private void ror(int mode) {
        byte b;
        if (mode == 1) {
            b = this.A = this.alu.ror(this.A, this.testFlag((byte)1));
        } else {
            int addr = this.getAddress(mode);
            b = this.alu.ror(this.getOperand(addr, mode), this.testFlag((byte)1));
            this.setResult(addr, b);
        }
        this.setNZC(b);
    }

    private void lsr(int mode) {
        byte b;
        if (mode == 1) {
            b = this.A = this.alu.shr(this.A);
        } else {
            int addr = this.getAddress(mode);
            b = this.alu.shr(this.getOperand(addr, mode));
            this.setResult(addr, b);
        }
        this.setNZC(b);
    }

    private void dec(int mode) {
        int addr = this.getAddress(mode);
        byte b = (byte)(this.getOperand(addr, mode) - 1);
        this.setResult(addr, b);
        this.setNZ(b);
    }

    private void inc(int mode) {
        int addr = this.getAddress(mode);
        byte b = (byte)(this.getOperand(addr, mode) + 1);
        this.setResult(addr, b);
        this.setNZ(b);
    }

    private void dex() {
        this.X = (byte)(this.X - 1);
        this.setNZ(this.X);
    }

    private void inx() {
        this.X = (byte)(this.X + 1);
        this.setNZ(this.X);
    }

    private void dey() {
        this.Y = (byte)(this.Y - 1);
        this.setNZ(this.Y);
    }

    private void iny() {
        this.Y = (byte)(this.Y + 1);
        this.setNZ(this.Y);
    }

    private void bit(int mode) {
        byte b = this.getOperand(mode);
        this.setFlag((byte)2, (b & this.A) == 0);
        this.setFlag((byte)-128, (b & 0x80) != 0);
        this.setFlag((byte)64, (b & 0x40) != 0);
    }

    private void jmp(int mode) {
        this.PC = (short)this.getAddress(mode);
    }

    private void jsr(int mode) {
        this.pushWord((short)(this.PC + 1));
        this.PC = (short)this.getAddress(mode);
    }

    private void rts() {
        this.PC = this.pullWord();
        this.PC = (short)(this.PC + 1);
    }

    private void rti() {
        this.P = this.pullByte();
        this.PC = this.pullWord();
    }

    private void php() {
        this.pushByte(this.P);
    }

    private void pha() {
        this.pushByte(this.A);
    }

    private void plp() {
        this.P = this.pullByte();
    }

    private void pla() {
        this.A = this.pullByte();
        this.setNZ(this.A);
    }

    private void flag(byte flag, boolean value) {
        this.setFlag(flag, value);
        if (flag == 8) {
            this.alu.setDecimal(value);
        }
    }

    private int branch(byte flag, boolean value) {
        int extraCycles = 0;
        int addr = this.getAddress(6);
        if (this.testFlag(flag) == value) {
            this.PC = (short)addr;
            extraCycles = 1;
        }
        return extraCycles;
    }

    private void pushByte(byte b) {
        this.bus.writeByte(256 + Data.asAddr(this.S), b);
        this.S = (byte)(this.S - 1);
    }

    private void pushWord(short w) {
        this.pushByte(Data.getHiByte(w));
        this.pushByte(Data.getLoByte(w));
    }

    private byte pullByte() {
        this.S = (byte)(this.S + 1);
        return this.bus.readByte(256 + Data.asAddr(this.S));
    }

    private short pullWord() {
        byte bl = this.pullByte();
        byte bh = this.pullByte();
        return Data.getWord(bh, bl);
    }

    private void halt() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.now = this.end = System.nanoTime();
    }

    private void debug() {
        byte action = this.getOperand(2);
        switch (action) {
            case 255: {
                if (!(this.bus instanceof Computer)) break;
                ((Computer)this.bus).dump();
                break;
            }
            case 1: 
            case 2: {
                if (!(this.bus instanceof Computer)) break;
                ((Computer)this.bus).trace(action == 1);
                break;
            }
            default: {
                this.PC = (short)(this.PC - 1);
            }
        }
    }

    private void setFlag(byte flag, boolean set) {
        this.P = set ? (byte)(this.P | flag) : (byte)(this.P & ~flag);
    }

    private boolean testFlag(byte flag) {
        return (this.P & flag) != 0;
    }

    private void setNZ(byte value) {
        this.setFlag((byte)-128, value < 0);
        this.setFlag((byte)2, value == 0);
    }

    private void setNZC(byte value) {
        this.setFlag((byte)-128, value < 0);
        this.setFlag((byte)2, value == 0);
        this.setFlag((byte)1, this.alu.isCarry);
    }

    private void setNZCV(byte value) {
        this.setFlag((byte)-128, value < 0);
        this.setFlag((byte)2, value == 0);
        this.setFlag((byte)1, this.alu.isCarry);
        this.setFlag((byte)64, this.alu.isOverflow);
    }

    private short readWord(int addr) {
        byte bl = this.bus.readByte(addr++);
        byte bh = this.bus.readByte(addr & 0xFFFF);
        return Data.getWord(bh, bl);
    }

    private short readWord0(int addr) {
        byte bl = this.bus.readByte(addr++);
        byte bh = this.bus.readByte(addr & 0xFF);
        return Data.getWord(bh, bl);
    }

    private byte fetchByte() {
        short s = this.PC;
        this.PC = (short)(s + 1);
        byte b = this.bus.readByte(Data.asAddr(s));
        if (this.traceEntry != null) {
            this.traceEntry.addByte(b);
        }
        return b;
    }

    private short fetchWord() {
        short s = this.PC;
        this.PC = (short)(s + 1);
        byte bl = this.bus.readByte(Data.asAddr(s));
        short s2 = this.PC;
        this.PC = (short)(s2 + 1);
        byte bh = this.bus.readByte(Data.asAddr(s2));
        short w = Data.getWord(bh, bl);
        if (this.traceEntry != null) {
            this.traceEntry.addWord(w);
        }
        return w;
    }

    private int getAddress(int mode) {
        int addr = 0;
        switch (mode) {
            default: {
                break;
            }
            case 2: {
                addr = Data.asBits(this.fetchByte());
                break;
            }
            case 3: {
                addr = Data.asAddr(this.fetchWord());
                break;
            }
            case 4: {
                addr = Data.asAddr(this.readWord(Data.asAddr(this.fetchWord())));
                break;
            }
            case 5: {
                addr = Data.asAddr(this.fetchByte());
                break;
            }
            case 6: {
                addr = Data.asInt(this.fetchByte()) + Data.asAddr(this.PC);
                break;
            }
            case 7: {
                addr = Data.asAddr(this.fetchWord()) + Data.asAddr(this.X);
                break;
            }
            case 8: {
                addr = Data.asAddr(this.fetchWord()) + Data.asAddr(this.Y);
                break;
            }
            case 9: {
                addr = Data.asAddr(this.readWord0(Data.asAddr(this.fetchByte()) + Data.asAddr(this.X) & 0xFF));
                break;
            }
            case 10: {
                addr = Data.asAddr(this.readWord0(Data.asAddr(this.fetchByte()))) + Data.asAddr(this.Y);
                break;
            }
            case 11: {
                addr = Data.asAddr(this.fetchByte()) + Data.asAddr(this.X) & 0xFF;
                break;
            }
            case 12: {
                addr = Data.asAddr(this.fetchByte()) + Data.asAddr(this.Y) & 0xFF;
            }
        }
        addr &= 0xFFFF;
        if (this.traceEntry != null) {
            this.traceEntry.addAddr(addr, this.bus.traceByte(addr));
        }
        return addr;
    }

    private byte getOperand(int mode) {
        return this.getOperand(this.getAddress(mode), mode);
    }

    private byte getOperand(int addr, int mode) {
        return mode == 2 ? (byte)addr : this.bus.readByte(addr);
    }

    private void setResult(byte b, int mode) {
        this.setResult(this.getAddress(mode), b);
    }

    private void setResult(int addr, byte b) {
        this.bus.writeByte(addr, b);
    }

    public synchronized void trace(Trace trace) {
        this.trace = trace;
    }

    public int getPC() {
        return Data.asAddr(this.PC);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("CPU: ");
        s.append("PC=").append(Data.toHexString(this.PC));
        s.append(" A=").append(Data.toHexString(this.A));
        s.append(" X=").append(Data.toHexString(this.X));
        s.append(" Y=").append(Data.toHexString(this.Y));
        s.append(" S=").append(Data.toHexString(this.S));
        s.append(" P=").append(CPU6502.toFlagString(this.P));
        return s.toString();
    }

    public static String toFlagString(byte b) {
        StringBuilder s = new StringBuilder();
        s.append((b & 0xFFFFFF80) != 0 ? "N" : "n");
        s.append((b & 0x40) != 0 ? "V" : "v");
        s.append("-");
        s.append((b & 0x10) != 0 ? "B" : "b");
        s.append((b & 8) != 0 ? "D" : "d");
        s.append((b & 4) != 0 ? "I" : "i");
        s.append((b & 2) != 0 ? "Z" : "z");
        s.append((b & 1) != 0 ? "C" : "c");
        return s.toString();
    }
}

