/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk101.hardware.ROM;

public class EPROM
extends ROM {
    private RandomAccessFile file;

    public EPROM(String id) throws IOException {
        super(EPROM.validate(id), false);
        this.file = new RandomAccessFile(this.name, "rwd");
        this.file.setLength(this.bytes());
    }

    public void writeByte(int offset, byte b) {
        super.writeByte(offset, b);
        try {
            this.file.seek(offset);
            this.file.writeByte(b);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private static String validate(String id) throws IOException {
        File f = new File(id);
        if (!(f.exists() && f.isFile() && f.canWrite())) {
            throw new FileNotFoundException(id);
        }
        return f.getCanonicalPath();
    }

    public String toString() {
        return "EPROM" + super.toString() + ": " + this.bytes() + " " + this.name;
    }
}

