/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import uk101.machine.Data;

public abstract class Memory {
    public static final int BLKSIZE = 256;
    public static final int K1 = 1024;
    public static final int K64 = 65536;
    public int base;
    public int blocks;
    public byte[] store;
    private boolean readOnly;

    public Memory(int bytes) {
        this.blocks = Memory.toBlocks(bytes);
    }

    public Memory(byte[] sb, boolean ro) {
        this.store = sb;
        this.readOnly = ro;
        this.blocks = Memory.toBlocks(sb.length);
    }

    public byte readByte(int offset) {
        return this.store[offset];
    }

    public void writeByte(int offset, byte b) {
        if (!this.readOnly) {
            this.store[offset] = b;
        }
    }

    public byte traceByte(int offset) {
        return this.readByte(offset);
    }

    public int bytes() {
        return this.blocks * 256;
    }

    public int kBytes() {
        return Memory.toK(this.bytes());
    }

    public static final int toK(int bytes) {
        return (bytes + 1024 - 1) / 1024;
    }

    public static final int toBlocks(int bytes) {
        return (bytes + 256 - 1) / 256;
    }

    public static final int asBlock(int addr) {
        return addr / 256;
    }

    public String toString() {
        return "@" + Data.toHexString(this.base) + "-" + Data.toHexString(this.base + this.blocks * 256);
    }
}

