/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public abstract class AudioDecoder {
    protected AudioFormat audioFormat = new AudioFormat(48000.0f, 16, 1, true, true);
    protected InputStream inputStream;
    private int bytesPerFrame;
    private int bytesPerChannel;
    private int channels;
    private boolean phaseShift;
    private boolean phaseInvert;
    private boolean hasNextSample;
    private int nextSample;

    protected AudioDecoder(int phase) {
        phase = phase % 360 / 90;
        this.phaseShift = phase == 1 || phase == 3;
        this.phaseInvert = phase == 2 || phase == 3;
    }

    public void setInputStream(InputStream in, AudioFormat format) {
        this.inputStream = in;
        this.audioFormat = format;
        this.channels = this.audioFormat.getChannels();
        this.bytesPerFrame = this.audioFormat.getFrameSize();
        this.bytesPerChannel = this.bytesPerFrame / this.channels;
    }

    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    protected int peekSample(boolean invert) throws IOException {
        if (!this.hasNextSample) {
            this.nextSample = this.nextSample();
            this.hasNextSample = true;
        }
        return invert ? -this.nextSample : this.nextSample;
    }

    protected int readSample(boolean invert) throws IOException {
        int sample = this.peekSample(invert);
        this.hasNextSample = false;
        return sample;
    }

    private int nextSample() throws IOException {
        byte[] frame = new byte[this.bytesPerFrame];
        if (this.inputStream.read(frame) != this.bytesPerFrame) {
            throw new EOFException();
        }
        int total = 0;
        int count = 0;
        int i = 0;
        int k = 0;
        while (i < this.channels) {
            int a = frame[k++];
            int j = 1;
            while (j < this.bytesPerChannel) {
                a = a << 8 | frame[k++] & 0xFF;
                ++j;
            }
            if (a != 0) {
                total += a;
                ++count;
            }
            ++i;
        }
        return count == 0 ? 0 : total / count;
    }

    protected int readCycle() throws IOException {
        int count = 0;
        int last = 0;
        while (this.peekSample(this.phaseInvert) >= 0) {
            last = this.readSample(this.phaseInvert);
            ++count;
        }
        while (this.peekSample(this.phaseInvert) < 0) {
            last = this.readSample(this.phaseInvert);
            ++count;
        }
        if (this.phaseShift) {
            while (this.peekSample(this.phaseInvert) > last) {
                last = this.readSample(this.phaseInvert);
                ++count;
            }
        }
        return count;
    }

    public abstract void decodeStart() throws IOException;

    public abstract void decodeEnd() throws IOException;

    public abstract int decodeByte() throws IOException;
}

