/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import uk101.io.AudioDecoder;

public class WaveInputStream
extends InputStream {
    private InputStream inputStream;
    private AudioDecoder audioDecoder;

    public WaveInputStream(InputStream in, AudioDecoder decoder) throws UnsupportedAudioFileException, IOException {
        this.audioDecoder = decoder;
        AudioInputStream audio = AudioSystem.getAudioInputStream(new BufferedInputStream(in));
        AudioFormat af1 = audio.getFormat();
        AudioFormat af2 = new AudioFormat(af1.getSampleRate(), af1.getSampleSizeInBits(), af1.getChannels(), true, true);
        this.inputStream = AudioSystem.getAudioInputStream(af2, audio);
        this.audioDecoder.setInputStream(this.inputStream, af2);
        this.audioDecoder.decodeStart();
    }

    public int read() throws IOException {
        return this.audioDecoder.decodeByte();
    }

    public void close() throws IOException {
        this.audioDecoder.decodeEnd();
        this.inputStream.close();
    }
}

