/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import uk101.machine.Computer;
import uk101.machine.Data;

public class Trace
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int BUFFER_SIZE = 8192;
    public String name;
    public String version;
    public Date timestamp;
    private transient Entry[] traceLog;
    private transient int maximum;
    private transient int position;
    private transient ObjectOutputStream out;
    private transient ObjectInputStream in;

    public Trace(Computer computer) {
        this.name = computer.name;
        this.version = computer.version;
        this.timestamp = new Date();
        this.maximum = 8192;
        this.position = 0;
        this.traceLog = new Entry[this.maximum];
    }

    public Entry trace(short pc, byte a, byte x, byte y, byte s, byte p) {
        if (this.position == this.maximum) {
            this.flush(false);
            this.position = 0;
        }
        Entry entry = new Entry(pc, a, x, y, s, p);
        this.traceLog[this.position++] = entry;
        return entry;
    }

    public void write() {
        this.flush(true);
    }

    synchronized void flush(boolean close) {
        if (this.out == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
            String filename = "uk101-" + df.format(this.timestamp) + ".trace";
            try {
                FileOutputStream fout = new FileOutputStream(filename);
                DeflaterOutputStream zout = new DeflaterOutputStream(fout);
                this.out = new ObjectOutputStream(zout);
                this.out.writeObject(this);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        if (this.out != null) {
            try {
                int i = 0;
                while (i < this.position) {
                    this.out.writeObject(this.traceLog[i]);
                    ++i;
                }
                if (close) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public Entry nextEntry() {
        Entry entry = null;
        if (this.in != null) {
            try {
                entry = (Entry)this.in.readObject();
            }
            catch (EOFException e) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (IOException e1) {
                    System.err.println(e1);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return entry;
    }

    public static Trace readTrace(File file) {
        Trace trace = null;
        try {
            InflaterInputStream stream = new InflaterInputStream(new FileInputStream(file));
            ObjectInputStream in = new ObjectInputStream(stream);
            trace = (Trace)in.readObject();
            trace.in = in;
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return trace;
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public short PC;
        public byte A;
        public byte X;
        public byte Y;
        public byte S;
        public byte P;
        public byte[] instruction;
        public int length;
        public int addr;
        public byte data;

        public Entry(short pc, byte a, byte x, byte y, byte s, byte p) {
            this.PC = pc;
            this.A = a;
            this.X = x;
            this.Y = y;
            this.S = s;
            this.P = p;
            this.instruction = new byte[3];
            this.length = 0;
        }

        public void addByte(byte b) {
            this.instruction[this.length++] = b;
        }

        public void addWord(short w) {
            this.instruction[this.length++] = Data.getLoByte(w);
            this.instruction[this.length++] = Data.getHiByte(w);
        }

        public void addAddr(int i, byte b) {
            this.addr = i;
            this.data = b;
        }
    }
}

