/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import uk101.io.KansasCityDecoder;
import uk101.io.Tape;
import uk101.io.UK101OutputStream;
import uk101.utils.Args;

public class TapeRead {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("binary");
        options.put("adaptive");
        options.put("baud", "baudrate (300, 600 or 1200)");
        options.put("phase", "phaseangle (0, 90, 180 or 270)");
        Args parms = new Args(TapeRead.class, "inputtape [outputfile]", args, options);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile(2);
        int inputFormat = parms.getFlag("binary") ? 2 : 0;
        int baudRate = parms.getInteger("baud", 300);
        int phaseAngle = parms.getInteger("phase", 90);
        boolean adaptive = parms.getFlag("adaptive");
        if (inputFile == null || baudRate != 300 && baudRate != 600 && baudRate != 1200 || phaseAngle % 90 != 0) {
            parms.usage();
        }
        KansasCityDecoder decoder = new KansasCityDecoder(baudRate, phaseAngle);
        InputStream input = Tape.getInputStream(inputFile, inputFormat, decoder);
        OutputStream output = null;
        output = outputFile != null ? Tape.getOutputStream(outputFile, 1, null) : new UK101OutputStream(System.out);
        decoder.setAdaptive(adaptive);
        Tape.copy(input, output);
        output.close();
        input.close();
    }
}

