/*
 * Decompiled with CFR 0.152.
 */
package uk101.view.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class KeyboardKey
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final int KEY_STD = 2;
    public static final int KEY_BIG = 3;
    public static final int KEY_HALF = 1;
    public static final int KEY_BAR = 16;
    static Font KEY_FONT = Font.decode("Dialog-bold-9");
    static Border KEY_BORDER_UP = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(3, 0, 3, 0));
    static Border KEY_BORDER_DOWN = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(3, 0, 3, 0));
    static Dimension KEY_SIZE;
    private int code;

    static {
        int kw = new JLabel().getFontMetrics(KEY_FONT).stringWidth(" RESET ");
        KEY_SIZE = new Dimension(kw, kw);
    }

    public static Component getOffset(int size) {
        return Box.createHorizontalStrut(KeyboardKey.KEY_SIZE.width * size / 2);
    }

    public KeyboardKey(String text, int keycode, MouseListener handler) {
        this(text, 2, keycode, handler);
    }

    public KeyboardKey(String text, int size, int keycode, MouseListener handler) {
        this.setLayout(new BorderLayout());
        this.setBorder(KEY_BORDER_UP);
        this.setAlignmentY(1.0f);
        this.addMouseListener(handler);
        this.addMouseListener(this);
        Dimension d = KEY_SIZE;
        if (size != 2) {
            d = new Dimension(d.width * size / 2, d.height);
        }
        this.setMaximumSize(d);
        this.setPreferredSize(d);
        char code2 = '\u0000';
        int i = text.indexOf(32);
        if (i == -1) {
            JLabel l1 = new JLabel(text, 0);
            l1.setFont(KEY_FONT);
            this.add((Component)l1, "Center");
            if (text.length() > 0) {
                code2 = text.charAt(0);
            }
        } else {
            String t1 = text.substring(0, i);
            String t2 = text.substring(i + 1);
            JLabel l1 = new JLabel(t1, 0);
            l1.setFont(KEY_FONT);
            JLabel l2 = new JLabel(t2, 0);
            l2.setFont(KEY_FONT);
            if (t2.equals("^")) {
                this.add((Component)l1, "Center");
            } else {
                this.add((Component)l1, "North");
                this.add((Component)l2, "South");
            }
            code2 = t2.charAt(0);
        }
        this.code = keycode != 0 ? keycode : (int)code2;
    }

    public int getCode() {
        return this.code;
    }

    public void mousePressed(MouseEvent e) {
        this.setBorder(KEY_BORDER_DOWN);
    }

    public void mouseReleased(MouseEvent e) {
        this.setBorder(KEY_BORDER_UP);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

