/*
 * Decompiled with CFR 0.152.
 */
package uk101.view.component;

import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TapeFormat
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String MODE_AUTO = "Automatic";
    public static final String MODE_ASCII = "ASCII";
    public static final String MODE_BINARY = "Binary";
    public static final String MODE_AUDIO = "Audio";
    public static final String MODE_UNSET = " ";
    private JRadioButton iAuto;
    private JRadioButton oAscii;
    private ButtonGroup inputGroup;
    private ButtonGroup outputGroup;

    public TapeFormat() {
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.setBorder(BorderFactory.createTitledBorder("Tape Format"));
        this.add(buttons);
        this.iAuto = new JRadioButton(null, true);
        JRadioButton ia = new JRadioButton();
        JRadioButton ib = new JRadioButton();
        JRadioButton iw = new JRadioButton();
        this.iAuto.setActionCommand(Integer.toString(0));
        ia.setActionCommand(Integer.toString(1));
        ib.setActionCommand(Integer.toString(2));
        iw.setActionCommand(Integer.toString(3));
        this.inputGroup = new ButtonGroup();
        this.inputGroup.add(this.iAuto);
        this.inputGroup.add(ia);
        this.inputGroup.add(ib);
        this.inputGroup.add(iw);
        this.oAscii = new JRadioButton(null, true);
        JRadioButton ob = new JRadioButton();
        JRadioButton ow = new JRadioButton();
        this.oAscii.setActionCommand(Integer.toString(1));
        ob.setActionCommand(Integer.toString(2));
        ow.setActionCommand(Integer.toString(3));
        this.outputGroup = new ButtonGroup();
        this.outputGroup.add(this.oAscii);
        this.outputGroup.add(ob);
        this.outputGroup.add(ow);
        JPanel heads = new JPanel();
        heads.setLayout(new BoxLayout(heads, 0));
        heads.setBorder(BorderFactory.createEmptyBorder(2, 1, 5, 1));
        heads.add(new JLabel("Read"));
        heads.add(Box.createHorizontalGlue());
        heads.add(new JLabel("Write"));
        buttons.add(heads);
        buttons.add(this.buttonPair(MODE_AUTO, this.iAuto, null));
        buttons.add(this.buttonPair(MODE_ASCII, ia, this.oAscii));
        buttons.add(this.buttonPair(MODE_BINARY, ib, ob));
        buttons.add(this.buttonPair(MODE_AUDIO, iw, ow));
    }

    private JPanel buttonPair(String bt, JRadioButton bl, JRadioButton br) {
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 0));
        bl.setMargin(new Insets(2, 0, 0, 2));
        bp.add(bl);
        bp.add(Box.createHorizontalGlue());
        bp.add(new JLabel(bt));
        bp.add(Box.createHorizontalGlue());
        if (br != null) {
            br.setMargin(new Insets(2, 2, 0, 0));
            bp.add(br);
        } else {
            bp.add(Box.createRigidArea(bl.getPreferredSize()));
        }
        return bp;
    }

    public void reset() {
        this.iAuto.setSelected(true);
        this.oAscii.setSelected(true);
    }

    public int getInputFormat() {
        return Integer.parseInt(this.inputGroup.getSelection().getActionCommand());
    }

    public int getOutputFormat() {
        return Integer.parseInt(this.outputGroup.getSelection().getActionCommand());
    }
}

