/*
  HI65 - a high-level Commodore 65 emulator
  Copyright (C) 2013-2023  Simone Gremmo
  Contact: devilmaster@email.com

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see
  http://www.gnu.org/licenses/gpl.txt
*/

// gdef.h

#define uchar unsigned char
#define uint unsigned int
#define ulong unsigned long

#define YEAR 2023
#define VERSION 9

#define PROGRAMSIZE 8388608
// #define PROGRAMSIZE 1048576

#define BACKSPACE 0x08
#define ENTER     0x0D
#define ESC       0x1B
#define SPACE     0x20
#define PLUS      0xBF
#define TAB       0x09

#define MAXLOOPS 33

// Reserved variables
#define DS 140 // DOS errors
#define EL 170 // BASIC error line
#define ER 176 // BASIC error number
#define TI 722 // 60ths of a second since switch-on (instead, TI$ contains the system hours, minutes and seconds)

                    
// #define DEBUG_INSTRUCTIONS // if this is defined, the debug instructions
                           // will be executed
// #define DEBUG_SCREEN // if this is defined, the program will log any failed
                     // attempt to open a screen

#define COLON_TEST

// BASIC 10 tokens, 1 byte
#define C65ADD      0xAA        // + (addition)
#define C65SUB      0xAB        // - (subtraction)
#define C65MUL      0xAC        // * (multiplication)
#define C65DIV      0xAD        // / (division)
#define C65PWR      0xAE        // ^ (exponentiation (power))
#define C65GT       0xB1        // > (greater-than)
#define C65EQU      0xB2        // = (equal)
#define C65LT       0xB3        // < (less-than)
#define C65PI       0xFF        // return value of PI

#define ABSC65      0xB6        // absolute function
#define AND         0xAF        // logical AND operator
#define ASC         0xC6        // string to PETSCII function
#define ATN         0xC1        // trigonometric arctangent function
#define AUTO        0xDC        // auto line numbering
#define BACKUP      0xF6        // backup diskette
#define BOX         0xE1        // draw graphic box
#define CHAR        0xE0        // display characters on screen
#define CHR$        0xC7        // PETSCII to string function
#define CIRCLE      0xE2        // draw graphic circle
#define CLOSE       0xA0        // close channel or file
#define CLR         0x9C        // clear BASIC variables, etc.
#define CMD         0x9D        // set output channel
#define COLLECT     0xF3        // validate diskette (chkdsk)
#define COLOR       0xE7        // set screen colors
#define CONT        0x9A        // continue BASIC program execution
#define COPY        0xF4        // copy a disk file
#define COS         0xBE        // trigonometric cosine function
#define CUT         0xE4        // cut graphic area
#define DATA        0x83        // pre-define BASIC program data
#define DEC         0xD1        // decimal function
#define DEF         0x96        // define user function
#define DELETE      0xF7        // delete BASIC lines or disk file
#define DIM         0x86        // dimension BASIC array
#define DIR         0xEE        // disk directory
#define DLOAD       0xF0        // load BASIC program from disk
#define DO          0xEB        // start BASIC loop
#define DSAVE       0xEF        // save BASIC program to disk
#define ELSE        0xD5        // if/then/else clause
#define END         0x80        // end of BASIC program
#define ERRS        0xD3        // BASIC error function
#define EXIT        0xED        // exit BASIC loop
#define EXP         0xBD        // exponentiation function
#define FN          0xA5        // define user function
#define FOR         0x81        // start BASIC for/next loop
#define FRE         0xB8        // available memory function
#define GET         0xA1        // receive a byte of input
#define GO          0xCB        // program branch when used as GO TO, switch from C65 mode to C64 mode when used as GO 64
#define GOSUB       0x8D        // program subroutine call
#define GOTO        0x89        // program branch
#define GRAPHIC     0xDE        // set graphic mode
#define HEADER      0xF1        // format a diskette
#define HELP        0xEA        // display BASIC line causing error
#define HEX$        0xD2        // return hexadecimal string function
#define IF          0x8B        // if/then/else conditional
#define INPUT       0x85        // receive input data from keyboard
#define INPUTSHARP  0x84        // receive input data from channel (file)
#define INSTR       0xD4        // locate a string within a string
#define INT         0xB5        // integer function
#define JOY         0xCF        // joystick position function
#define KEY         0xF9        // define or display function key
#define LEFT$       0xC8        // leftmost substring function
#define LEN         0xC3        // length of string function
#define LET         0x88        // variable assignment
#define LINE        0xE5        // draw graphic line, input line
#define LIST        0x9B        // list BASIC program
#define LOAD        0x93        // load program from disk
#define LOCATE      0xE6        // position the cursor on the text screen
#define LOG         0xBC        // natural log function
#define LOOP        0xEC        // end of do/loop
#define MID$        0xCA        // substring function
#define MONITOR     0xFA        // enter ML Monitor mode
#define NEW         0xA2        // clear BASIC program area
#define NEXT        0x82        // end of for-next loop
#define NOT         0xA8        // logical complement function
#define ON          0x91        // multiple branch or subcommand
#define OPEN        0x9F        // open I/O channel
#define OR          0xB0        // logical or function
#define PAINT       0xDF        // graphic flood-fill
#define PASTE       0xE3        // draw graphic area from cut buffer
#define PEEK        0xC2        // return memory byte function
#define POKE        0x97        // change memory byte
#define POS         0xB9        // text cursor position function
#define PRINT       0x99        // display data on text screen
#define PRINTSHARP  0x98        // send data to channel (file)
#define PUDEF       0xDD        // define print-using symbols
#define RCLR        0xCD        // (currently unimplemented)
#define RDOT        0xD0        // (currently unimplemented)
#define READ        0x87        // read program pre-defined program data
#define REM         0x8F        // BASIC program comment
#define RENAME      0xF5        // rename disk file
#define RENUMBER    0xF8        // renumber BASIC program lines
#define RESTORE     0x8C        // set DATA pointer, subcommand
#define RESUME      0xD6        // resume BASIC program after trap
#define RETURN      0x8E        // end of subroutine call
#define RGR         0xCC        // (currently unimplemented)
#define RIGHT$      0xC9        // rightmost substring function
#define RND         0xBB        // pseudo random number function
#define RUN         0x8A        // run BASIC program from memory or disk
#define SAVE        0x94        // save BASIC program to disk
#define SCALE       0xE9        // (currently unimplemented)
#define SCNCLR      0xE8        // erase text or graphic display
#define SCRATCH     0xF2        // delete disk file
#define SGNC65      0xB4        // return sign of number function
#define SIN         0xBF        // trigonometric sine function
#define SOUND       0xDA        // perform sound effects
#define SPC         0xA6        // skip spaces in printed output
#define SQR         0xBA        // Square root function
#define STEP        0xA9        // for-next step increment
#define STOP        0x90        // halt BASIC program
#define STRS        0xC4        // string representation of number function
#define SYS         0x9E        // call ML routine
#define TABC65      0xA3        // tab position in printed output
#define TAN         0xC0        // trigonometric tangent function
#define THEN        0xA7        // if/then/else clause
#define TO          0xA4        // (subcommand)
#define TRAP        0xD7        // define BASIC error handler
#define TROFF       0xD9        // BASIC trace mode disable
#define TRON        0xD8        // BASIC trace mode enable
#define UNTIL       0xFC        // do/loop conditional
#define USING       0xFB        // define print output format
#define USR         0xB7        // call user ML function
#define VAL         0xC5        // numeric value of a string function
#define VERIFY      0x95        // compare memory to disk file
#define VOL         0xDB        // set audio volume
#define WAIT        0x92        // pause program pending memory condition
#define WHILE       0xFD        // do/loop conditional
// NOTE: The C65 manual states that the token for EXIT is 0xFD and the
// token for WHILE is 0xED, while Petcat tokenizes them the other way
// around. Here, I followed the convention of Petcat.

// BASIC 10 tokens, 2 bytes
#define APPEND      0xFE0E     // append file
#define BACKGROUND  0xFE3B     // background color
#define BANK        0xFE02     // memory bank selection
#define BEGIN       0xFE18     // start logical program block
#define BEND        0xFE19     // end logical program block
#define BLOAD       0xFE11     // binary load file from diskette
#define BOOT        0xFE1B     // load & run ML, or BASIC autoboot
#define BORDER      0xFE3C     // border color
#define BSAVE       0xFE10     // binary save to disk file
#define BUMP        0xCE03     // sprite collision function
#define BVERIFY     0xFE28     // verify memory to binary file
#define CATALOG     0xFE0C     // disk directory
#define CHANGE      0xFE2C     // edit program
#define COLLISION   0xFE17     // enable BASIC event
#define CONCAT      0xFE13     // concatenate two disk files
#define DCLEAR      0xFE15     // mild reset of disk drive
#define DCLOSE      0xFE0F     // close disk channel or file
#define DISK        0xFE40     // send disk special command
#define DMA0        0xFE1F     // define & execute DMA command
#define DMA1        0xFE21     // "
#define DMA2        0xFE23     // "
#define DMODE       0xFE35     // set graphic draw mode
#define DOPEN       0xFE0D     // open channel to disk file
#define DPAT        0xFE36     // set graphic draw pattern
#define DVERIFY     0xFE14     // verify BASIC memory to file
#define ELLIPSE     0xFE30     // draw graphic ellipse
#define ENVELOPE    0xFE0A     // define musical instrument
#define ERASE       0xFE2A     // delete disk file
#define FAST        0xFE25     // set system speed to maximum
#define FILTER      0xFE03     // set audio filter parameters
#define FIND        0xFE2B     // hunt for string in BASIC program
#define FOREGROUND  0xFE39     // set foreground color
#define GCOPY       0xFE32     // graphic copy
#define GENLOCK     0xFE38     // set video sync mode
#define HIGHLIGHT   0xFE3D     // set highlight color
#define LPEN        0xCE04     // lightpen position function
#define MOUSE       0xFE3E     // set mouse parameters
#define MOVSPR      0xFE06     // set sprite position and speed
#define OFF         0xFE24     // (subcommand)
#define PALETTE     0xFE34     // set palette color
#define PEN         0xFE33     // set graphic pen color
#define PIC         0xFE37     // graphic subcommand
#define PLAY        0xFE04     // play musical notes from string
#define POINTER     0xCE0A     // address of string var function
#define POLYGON     0xFE2F     // draw graphic polygon
#define POT         0xCE02     // return paddle position
#define QUIT        0xFE1E     // (currently unimplemented)
#define RECORD      0xFE12     // set relative disk file record pointer
#define RMOUSE      0xFE3F     // read mouse position
#define RREG        0xFE09     // return processor registers after SYS
#define RSPCOLOR    0xCE07     // return sprite color function
#define RSPPOS      0xCE05     // return sprite position function
#define RSPRITE     0xCE06     // return sprite parameter function
#define RWINDOW     0xCE09     // return text window parameter function
#define SCREEN      0xFE2E     // set parameters or open graphic screen
#define SET         0xFE2D     // set system parameter, subcommand
#define SLEEP       0xFE0B     // pause BASIC program for time period
#define SLOW        0xFE26     // set system speed to minimum
#define SPRCOLOR    0xFE08     // set multicolor sprite colors
#define SPRDEF      0xFE1D     // (currently unimplemented)
#define SPRITE      0xFE07     // set sprite parameters
#define SPRSAV      0xFE16     // set or copy sprite definition
#define TEMPO       0xFE05     // set tempo (speed) of music play
#define TYPE        0xFE27     // display sequential disk file
#define VIEWPORT    0xFE31     // (currently unimplemented)
#define WIDTH       0xFE1C     // (currently unimplemented)
#define WINDOW      0xFE1A     // set text screen display window
#define XOR         0xCE08     // logical xor function

#define ERRORSTRINGLENGTH 21

// BASIC errors
#define TOOMANYFILES        1
#define FILEOPEN            2
#define FILENOTOPEN         3
#define FILENOTFOUND        4
#define DEVICENOTPRESENT    5
#define NOTINPUTFILE        6
#define NOTOUTPUTFILE       7
#define MISSINGFILENAME     8
#define ILLEGALDEVICENUMBER 9
#define NEXTWITHOUTFOR     10
#define SYNTAXERROR        11
#define RETURNWITHOUTGOSUB 12
#define OUTOFDATA          13
#define ILLEGALQUANTITY    14
#define OVERFLOWERROR      15
#define OUTOFMEMORY        16
#define UNDEFDSTATEMENT    17
#define BADSUBSCRIPT       18
#define REDIMDARRAY        19
#define DIVISIONBYZERO     20
#define ILLEGALDIRECT      21
#define TYPEMISMATCH       22
#define STRINGTOOLONG      23
#define FILEDATA           24
#define FORMULATOOCOMPLEX  25
#define CANTCONTINUE       26
#define UNDEFINEDFUNCTION  27
#define VERIFYERROR        28
#define NOGRAPHICSAREA     35
#define FILEREAD           41

// DOS errors
#define INVALIDFILENAME  61
#define FILEEXISTS       62
#define MUPARSERERROR    63

// Possible statuses for a file
#define CLOSED         0
#define OPEN_TO_READ   1
#define OPEN_TO_WRITE  2
#define OPEN_TO_APPEND 3
