/*
  HI65 - a high-level Commodore 65 emulator
  Copyright (C) 2013-2023  Simone Gremmo
  Contact: devilmaster@email.com

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see
  http://www.gnu.org/licenses/gpl.txt
*/

// key.cpp

#include <allegro.h>
#include <cstdio>
#include "f8x8.h"
#include "gdef.h"
#include "pro.h"
#include "var.h"

uchar keyboard(uchar mode)
{
 uint k;
 uchar i;
 static uchar oldkey;
 
 rest(1); // We yield CPU time when Hi65 is not running a program
 flashcursor();
 release_screen();
 if (keypressed())
 {
  k=readkey();
  switch ((uchar)k)
  {
   case ESC:
        if (!mode)
         return 1;
        release_screen();
        break;
   case BACKSPACE:
        rectfill(screen,CharX+screen_border_x,CharY+screen_border_y,CharX+(xzoom<<3)+screen_border_x,CharY+(yzoom<<3)+screen_border_y-1,backcolor);
        BackSpace();
        if (lc)
         linebuffer[lc--]=0;
        break;
   case ENTER:
        rectfill(screen,CharX+screen_border_x,CharY+screen_border_y,CharX+(xzoom<<3)+screen_border_x,CharY+(yzoom<<3)+screen_border_y-1,backcolor);
        Enter();
        interpret_line();
        for (i=0; i<80; i++)
         linebuffer[i]=0;
        lc=0;
        break;
   case TAB:
        Tab();
        break;
   default:
        if ((uchar)k>=SPACE && (uchar)k<=PLUS)
        {
         acquire_screen();
         Cout((uchar)k);
         release_screen();
         if (!((uchar)k==SPACE && !lc))
          linebuffer[lc++]=(uchar)k;
        }
        break;
  }
  clear_keybuf();
 }
 
 if (!mode)
  return 0;
 else
  return((uchar)k);
}

uchar keyboardinput(uchar from_input)
{
 uint k;
 static uint oldkey;
 
 rest(1);  // We yield CPU time when Hi65 is waiting for a keyboard input
 if (from_input)
  flashcursor();
 release_screen();
 if (keypressed())
 {
  k=readkey();
  switch ((uchar)k)
  {
   case BACKSPACE:
        if (from_input)
         rectfill(screen,CharX+screen_border_x,CharY+screen_border_y,CharX+(xzoom<<3)+screen_border_x,CharY+(yzoom<<3)+screen_border_y-1,backcolor);
        BackSpace();
        if (lc)
         lc--;
        break;
   case ENTER:
        if (from_input)
         rectfill(screen,CharX+screen_border_x,CharY+screen_border_y,CharX+(xzoom<<3)+screen_border_x,CharY+(yzoom<<3)+screen_border_y-1,backcolor);
        Enter();
        break;
   case TAB:
        Tab();
        break;
   default:
        if (from_input && (uchar)k>=SPACE && (uchar)k<=PLUS)
        {
         acquire_screen();
         Cout((uchar)k);
         release_screen();
        }
        break;
  }
  clear_keybuf();
 }
 else
  k=0;
 acquire_screen();

 return((uchar)k);
}
