/*
  HI65 - a high-level Commodore 65 emulator
  Copyright (C) 2013-2023  Simone Gremmo
  Contact: devilmaster@email.com

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see
  http://www.gnu.org/licenses/gpl.txt
*/

// pro.h

// in display.cpp
extern void Cout(uchar c);
extern void prints(uchar *str);
extern void printn(ulong number);
extern void printn(double number);
extern void printerror(double error);
extern void forebackswap(void);
extern void BackSpace(void);
extern void Enter(void);
extern void Tab(void);
extern void _putpixel32_safe(BITMAP *destscreen,uint pointx,uint pointy,uint pointcolor);
extern void c65draw(uint x, uint y);
extern void paletterestore(void);
extern void simulateloadinstructions(uchar *str, uchar runprogram);
extern void Ready(void);
extern int startscreen(uchar from_command);
extern void makeborder(uint bordercolor);
extern void alternatescreen();
extern void flashcursor(void);
extern void fastbox(uchar xoffset, uchar yoffset);

// in key.cpp
extern uchar keyboard(uchar mode);
extern uchar keyboardinput(uchar from_input);

// in file.cpp
extern uchar load(uchar *str);
extern void fprints(uchar *str);
extern void fEnter(void);
extern void fprintn(uint number);
extern void setresolution(void);

// in arrayops.cpp
extern void initvars(void);
extern void resetc65vars(void);
extern void skipspaces(void);
extern void skipdataspaces(void);
extern void skiparrayindex(void);
extern uint locatevar();
extern double evaluateexpression(void);
extern uchar evaluatecondition(void);
extern uchar conditionistrue_num(double first, uchar comp, double second);
extern uchar conditionistrue_string(uchar comp);
extern double getnum(void);
extern uint getarrayindex(void);
extern double getdatanum(void);
extern void initdatacounter(void);
extern void ticker(void);

// in interpreter.cpp
extern void getinstructionendaddress(void);
extern void processnumbercondition(void);
extern void processstringcondition(void);
extern void skipspacesandevaluateexpression(uchar index);
extern void interpret(void);
extern void interpret_line(void);
extern void getstring(uint index);
extern void getdatastring(void);
extern double Asc(void);
extern void Append(void);
extern void Bank(void);
extern void Bend(void);
extern void Box(void);
extern void Border(void);
extern void Char(void);
extern void Circle(void);
extern void Clr(void);
extern void Dclose(void);
extern void DeleteEraseScratch(uint token);
extern void Dim(void);
extern void Dload(uchar from_line);
extern void Do(void);
extern void Dopen(void);
extern void Draw(void);
extern void Ellipse(void);
extern void Else(void);
extern void End(void);
extern void Exit(void);
extern void For(void);
extern void Get(void);
extern void Go(uchar from_line);
extern void Gosub(void);
extern void Goto(void);
extern void If(void);
extern void Input(void);
extern void InputSharp(void);
extern double Len(void);
extern void Let(void);
extern void Line(void);
extern void Locate(void);
extern void Loop(void);
extern void Next(void);
extern void MuParserToggle(uchar from_line);
extern void Paint(void);
extern void Palette(void);
extern void Pen(void);
extern void Print(void);
extern void PrintSharp(void);
extern void Read(void);
extern void Rem(void);
extern void Restore(void);
extern void Return(void);
extern double Rnd(double val);
extern void Run(uchar from_line);
extern void Scnclr(void);
extern void ScreenClose(void);
extern void ScreenDef(void);
extern void ScreenOpen(void);
extern void ScreenSet(void);
extern void Sleep(void);
extern void Trap(void);
