// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


#define TIMESLOTS 30
float oldtime[TIMESLOTS];

int timepos = 0;

void writefps() {
	HDC dc;

	LARGE_INTEGER clocks, freq;

	QueryPerformanceCounter(&clocks);
	QueryPerformanceFrequency(&freq);

	oldtime[timepos] = float(clocks.QuadPart) / freq.QuadPart;

	float frametime = oldtime[timepos] - oldtime[(timepos+1) % TIMESLOTS];

	timepos++;
	timepos = timepos % TIMESLOTS;

	DX.DDSRender->GetDC(&dc);

	char str[256];
	sprintf(str, "%.2f", float(TIMESLOTS)/frametime);

	TextOut(dc,0,0,str,strlen(str));
	
	DX.DDSRender->ReleaseDC(dc);
}


XGLLINK void XGLCALL grBufferSwap(uint32 t1) {
	vlog("Called grBufferSwap");

#ifdef FRAMESKIP_BETA
	if (frame) {
#endif

	_exebuffer->Flush();

	if (Settings.fps) writefps();

	DX.D3DD->EndScene();
	DX.DDSPrimary->Flip(0, Settings.vsync ? DDFLIP_WAIT : DDFLIP_NOVSYNC); 
	DX.D3DD->BeginScene();

#ifdef FRAMESKIP_BETA
	}
	frame = !frame;
#endif

//	Sleep(100);

}




XGLLINK void XGLCALL grRenderBuffer(uint32 buf) {
	vlog("Called grRenderBuffer: buffer=" << buf);

//	_exebuffer->Flush();

//	log("  Error, unsupported function: grRenderBuffer");

}


XGLLINK void XGLCALL grDepthBufferFunction(uint32 func) {
	vlog("Called grDepthBufferFunction: func=" << func);

	_exebuffer->Flush();

	switch(func) {
	case XGLCMP_NEVER:			DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_NEVER);		break;
	case XGLCMP_LESS:			DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_LESS);			break;
	case XGLCMP_EQUAL:			DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_EQUAL);		break;
	case XGLCMP_LESSEQUAL:		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_LESSEQUAL);	break;
	case XGLCMP_GREATER:		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_GREATER);		break;
	case XGLCMP_NOTEQUAL:		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_NOTEQUAL);		break;
	case XGLCMP_GREATEREQUAL:	DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_GREATEREQUAL);	break;
	case XGLCMP_ALWAYS:			DX.D3DD->SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_ALWAYS);		break;
	}
}



XGLLINK void XGLCALL grClipWindow(uint32 left, uint32 top, uint32 right, uint32 bottom) {

	vlog("Called grClipWindow: left=" << left << "  right=" << right << "  top=" << top << "  bottom=" << bottom);

	_exebuffer->Flush();

	Voodoo.viewport.dwX = left;
	Voodoo.viewport.dwWidth = right - left;
	Voodoo.viewport.dwHeight = bottom - top;

	if (Voodoo.origin == XGL_ORIGIN_UL) {
		Voodoo.viewport.dwY = top;
	} else {
		// Flip screen if we have a lower-left origin
		Voodoo.viewport.dwY = Voodoo.height - bottom - 1;
	}

	DX.D3DViewport->SetViewport2(&Voodoo.viewport);
}



XGLLINK void XGLCALL grDepthBufferMode(uint32 dbmode) {
	vlog("Called grDepthBufferMode: mode=" << dbmode);

	_exebuffer->Flush();

	Voodoo.dbmode = dbmode;
	SetVconv();

	switch (Voodoo.dbmode) {
	case XGLDB_DISABLE:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZENABLE, D3DZB_FALSE);
		break;
	case XGLDB_ZBUF:
	case XGLDB_ZBUF2:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZENABLE, D3DZB_TRUE);
		break;
	case XGLDB_WBUF:
	case XGLDB_WBUF2:
		if (DX.D3DHD.dpcTriCaps.dwRasterCaps & D3DPRASTERCAPS_WBUFFER) {
			DX.D3DD->SetRenderState(D3DRENDERSTATE_ZENABLE, D3DZB_USEW);
		} else {
			DX.D3DD->SetRenderState(D3DRENDERSTATE_ZENABLE, D3DZB_TRUE);
		}
		break;
	}

}


XGLLINK void XGLCALL grBufferClear(uint32 color, uint32 alpha, uint32 depth) {
	vlog("Called grBufferClear");

	_exebuffer->Flush();

	D3DRECT r = {0, 0, Voodoo.width, Voodoo.height};
//	D3DVIEWPORT2


	// Todo: convert depth buffer field
	DX.D3DViewport->Clear2(1, &r, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 0x0000, 1.0, 0x0000);
//	DX.D3DViewport->Clear2(1, &Voodoo.viewport, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 0x0000, 1.0, 0x0000);
}


XGLLINK uint32 XGLCALL grBufferNumPending() {
	vlog("Called grBufferNumPending");

	return 0;
}

