/***************************************************************************

  Ladybug arcade machine emulator

  Usage:

  ladybug [name of the game to run] [options]

  options:
  -noscanlines  don't use the custom video mode with visible scan lines
  -vesa   use standard 640x480x256 VESA mode instead of custom video mode
  -nosound  turn off sound
  -nojoy  don't poll joystick

  Z80 engine by Marat Fayzulin and Marcel de Kogel
  Emulator written by Nicola Salmoria (MC6489@mclink.it)
  Thanks to Scott Decker for his help with the colors.
  Many thanks to Paul Swan for the information on the sound hardware.
  224x288 video mode created using Tweak 1.6b by Robert Schmidt, who also
  wrote TwkUser.c.
  256x256 video mode (Mode Q) definition by Gary Shepherdson (od67@dial.pipex.com)
  Allegro library by Shawn Hargreaves, 1994/96
  SEAL Synthetic Audio Library API Interface Copyright (C) 1995, 1996
  Carlos Hasan. All Rights Reserved.


  If you find out something useful, don't hesitate to submit it to :
  The arcade emultion programming repository.

  So it will be available to everyone at :
  http://valhalla.ph.tn.tudelft.nl/emul8

  Send it by email to :
  avdbas@wi.leidenuniv.nl


  Known issues:
  - The noise generator is not emulated yet.

***************************************************************************/

#include <stdio.h>
#include <string.h>
#include "machine.h"
#include "osdepend.h"

#define DEFAULT_NAME "ladybug"


int main(int argc,char **argv)
{
	if (init_machine(argc > 1 && argv[1][0] != '-' ? argv[1] : DEFAULT_NAME) == 0)
	{
		printf("\nPLEASE DO NOT DISTRIBUTE THE SOURCE FILES OR THE EXECUTABLE WITH ROM IMAGES.\n"
			   "DOING SO WILL HARM FURTHER EMULATOR DEVELOPMENT AND WILL CONSIDERABLY ANNOY\n"
			   "THE RIGHTFUL COPYRIGHT HOLDERS OF THOSE ROM IMAGES AND CAN RESULT IN LEGAL\n"
			   "ACTION UNDERTAKEN BY EARLIER MENTIONED COPYRIGHT HOLDERS.\n"
			   "\n\n"
			   "Quick keys : 3       Insert coin\n"
			   "             1       Start 1 player game\n"
			   "             2       Start 2 player game\n"
			   "             Arrows  Move around\n"
			   "             F1      Skip level\n"
			   "             F2      Reset\n"
			   "             Tab     Change dip switch settings\n"
			   "             P       Pause\n"
			   "             F12     Save a screen snapshot\n"
			   "             ESC     Exit emulator\n"
			   "\n\n"
			   "Press <ENTER> to continue.\n");

		getchar();

		if (osd_init(argc,argv) == 0)
		{
			if (run_machine(argc > 1 && argv[1][0] != '-' ? argv[1] : DEFAULT_NAME) != 0)
				printf("Unable to start emulation\n");

			osd_exit();
		}
		else printf("Unable to initialize system\n");
	}
	else printf("Unable to initialize machine emulation\n");

	exit(0);
}
