#pragma once

#include "GcnCommon.h"

namespace sce::gcn
{

	// These structure definitions can be found in
	// Radeon Sea Islands 3D/Compute
	// Register Reference Guide

	// Note:
	// The code is auto-generated using SpiShaderRegMacroToStruct.py
	// Do not edit this file manually,
	// if there are something wrong, fix the script file instead.

	struct SPI_SHADER_PGM_RSRC3_PS
	{
		uint32_t cu_en : 16;
		uint32_t wave_limit : 6;
		uint32_t lock_low_threshold : 4;
		uint32_t simd_disable : 4;
		uint32_t reserved : 2;
	};

	struct SPI_SHADER_PGM_LO_PS
	{
		uint32_t mem_base;
	};

	struct SPI_SHADER_PGM_HI_PS
	{
		uint32_t mem_base : 8;
		uint32_t reserved : 24;
	};

	struct SPI_SHADER_PGM_RSRC1_PS
	{
		uint32_t vgprs : 6;
		uint32_t sgprs : 4;
		uint32_t priority : 2;
		uint32_t float_mode : 8;
		uint32_t priv : 1;
		uint32_t dx10_clamp : 1;
		uint32_t debug_mode : 1;
		uint32_t ieee_mode : 1;
		uint32_t cu_group_disable : 1;
		uint32_t cdbg_user : 1;
		uint32_t fp16_ovfl : 1;
		uint32_t reserved : 5;
	};

	struct SPI_SHADER_PGM_RSRC2_PS
	{
		uint32_t scratch_en : 1;
		uint32_t user_sgpr : 5;
		uint32_t trap_present : 1;
		uint32_t wave_cnt_en : 1;
		uint32_t extra_lds_size : 8;
		uint32_t excp_en : 9;
		uint32_t load_collision_waveid : 1;
		uint32_t load_intrawave_collision : 1;
		uint32_t skip_usgpr0 : 1;
		uint32_t user_sgpr_msb : 1;
		uint32_t reserved : 3;
	};

	struct SPI_PS_INPUT_ENA
	{
		uint32_t persp_sample_ena : 1;
		uint32_t persp_center_ena : 1;
		uint32_t persp_centroid_ena : 1;
		uint32_t persp_pull_model_ena : 1;
		uint32_t linear_sample_ena : 1;
		uint32_t linear_center_ena : 1;
		uint32_t linear_centroid_ena : 1;
		uint32_t line_stipple_tex_ena : 1;
		uint32_t pos_x_float_ena : 1;
		uint32_t pos_y_float_ena : 1;
		uint32_t pos_z_float_ena : 1;
		uint32_t pos_w_float_ena : 1;
		uint32_t front_face_ena : 1;
		uint32_t ancillary_ena : 1;
		uint32_t sample_coverage_ena : 1;
		uint32_t pos_fixed_pt_ena : 1;
		uint32_t reserved : 16;
	};

	struct SPI_PS_INPUT_ADDR
	{
		uint32_t persp_sample_ena : 1;
		uint32_t persp_center_ena : 1;
		uint32_t persp_centroid_ena : 1;
		uint32_t persp_pull_model_ena : 1;
		uint32_t linear_sample_ena : 1;
		uint32_t linear_center_ena : 1;
		uint32_t linear_centroid_ena : 1;
		uint32_t line_stipple_tex_ena : 1;
		uint32_t pos_x_float_ena : 1;
		uint32_t pos_y_float_ena : 1;
		uint32_t pos_z_float_ena : 1;
		uint32_t pos_w_float_ena : 1;
		uint32_t front_face_ena : 1;
		uint32_t ancillary_ena : 1;
		uint32_t sample_coverage_ena : 1;
		uint32_t pos_fixed_pt_ena : 1;
		uint32_t reserved : 16;
	};

	struct SPI_SHADER_PGM_RSRC3_VS
	{
		uint32_t cu_en : 16;
		uint32_t wave_limit : 6;
		uint32_t lock_low_threshold : 4;
		uint32_t simd_disable : 4;
		uint32_t reserved : 2;
	};

	struct SPI_SHADER_PGM_LO_VS
	{
		uint32_t mem_base;
	};

	struct SPI_SHADER_PGM_HI_VS
	{
		uint32_t mem_base : 8;
		uint32_t reserved : 24;
	};

	struct SPI_SHADER_PGM_RSRC1_VS
	{
		uint32_t vgprs : 6;
		uint32_t sgprs : 4;
		uint32_t priority : 2;
		uint32_t float_mode : 8;
		uint32_t priv : 1;
		uint32_t dx10_clamp : 1;
		uint32_t debug_mode : 1;
		uint32_t ieee_mode : 1;
		uint32_t vgpr_comp_cnt : 2;
		uint32_t cu_group_enable : 1;
		uint32_t cdbg_user : 1;
		uint32_t fp16_ovfl : 1;
		uint32_t reserved : 3;
	};

	struct SPI_SHADER_PGM_RSRC2_VS
	{
		uint32_t scratch_en : 1;
		uint32_t user_sgpr : 5;
		uint32_t trap_present : 1;
		uint32_t oc_lds_en : 1;
		uint32_t so_base0_en : 1;
		uint32_t so_base1_en : 1;
		uint32_t so_base2_en : 1;
		uint32_t so_base3_en : 1;
		uint32_t so_en : 1;
		uint32_t excp_en : 9;
		uint32_t pc_base_en : 1;
		uint32_t dispatch_draw_en : 1;
		uint32_t skip_usgpr0 : 1;
		uint32_t user_sgpr_msb : 1;
		uint32_t reserved : 6;
	};

	struct SPI_SHADER_PGM_RSRC2_GS_VS
	{
		uint32_t scratch_en : 1;
		uint32_t user_sgpr : 5;
		uint32_t trap_present : 1;
		uint32_t excp_en : 9;
		uint32_t vgpr_comp_cnt : 2;
		uint32_t oc_lds_en : 1;
		uint32_t lds_size : 8;
		uint32_t skip_usgpr0 : 1;
		uint32_t user_sgpr_msb : 1;
		uint32_t reserved : 3;
	};

	struct SPI_SHADER_PGM_RSRC4_GS
	{
		uint32_t group_fifo_depth : 7;
		uint32_t spi_shader_late_alloc_gs : 7;
		uint32_t reserved : 18;
	};

	struct SPI_SHADER_PGM_LO_ES
	{
		uint32_t mem_base;
	};

	struct SPI_SHADER_PGM_HI_ES
	{
		uint32_t mem_base : 8;
		uint32_t reserved : 24;
	};

	struct SPI_SHADER_PGM_RSRC3_GS
	{
		uint32_t cu_en : 16;
		uint32_t wave_limit : 6;
		uint32_t lock_low_threshold : 4;
		uint32_t simd_disable : 4;
		uint32_t reserved : 2;
	};

	struct SPI_SHADER_PGM_LO_GS
	{
		uint32_t mem_base;
	};

	struct SPI_SHADER_PGM_HI_GS
	{
		uint32_t mem_base : 8;
		uint32_t reserved : 24;
	};

	struct SPI_SHADER_PGM_RSRC1_GS
	{
		uint32_t vgprs : 6;
		uint32_t sgprs : 4;
		uint32_t priority : 2;
		uint32_t float_mode : 8;
		uint32_t priv : 1;
		uint32_t dx10_clamp : 1;
		uint32_t debug_mode : 1;
		uint32_t ieee_mode : 1;
		uint32_t cu_group_enable : 1;
		uint32_t cdbg_user : 1;
		uint32_t gs_vgpr_comp_cnt : 2;
		uint32_t fp16_ovfl : 1;
		uint32_t reserved : 3;
	};

	struct SPI_SHADER_PGM_RSRC2_GS
	{
		uint32_t scratch_en : 1;
		uint32_t user_sgpr : 5;
		uint32_t trap_present : 1;
		uint32_t excp_en : 9;
		uint32_t es_vgpr_comp_cnt : 2;
		uint32_t oc_lds_en : 1;
		uint32_t lds_size : 8;
		uint32_t skip_usgpr0 : 1;
		uint32_t user_sgpr_msb : 1;
		uint32_t reserved : 3;
	};

	struct SPI_SHADER_PGM_RSRC4_HS
	{
		uint32_t group_fifo_depth : 7;
		uint32_t reserved : 25;
	};

	struct SPI_SHADER_PGM_LO_LS
	{
		uint32_t mem_base;
	};

	struct SPI_SHADER_PGM_HI_LS
	{
		uint32_t mem_base : 8;
		uint32_t reserved : 24;
	};

	struct SPI_SHADER_PGM_RSRC3_HS
	{
		uint32_t wave_limit : 6;
		uint32_t lock_low_threshold : 4;
		uint32_t simd_disable : 4;
		uint32_t cu_en : 16;
		uint32_t reserved : 2;
	};

	struct SPI_SHADER_PGM_LO_HS
	{
		uint32_t mem_base;
	};

	struct SPI_SHADER_PGM_HI_HS
	{
		uint32_t mem_base : 8;
		uint32_t reserved : 24;
	};

	struct SPI_SHADER_PGM_RSRC1_HS
	{
		uint32_t vgprs : 6;
		uint32_t sgprs : 4;
		uint32_t priority : 2;
		uint32_t float_mode : 8;
		uint32_t priv : 1;
		uint32_t dx10_clamp : 1;
		uint32_t debug_mode : 1;
		uint32_t ieee_mode : 1;
		uint32_t cdbg_user : 1;
		uint32_t ls_vgpr_comp_cnt : 2;
		uint32_t fp16_ovfl : 1;
		uint32_t reserved : 4;
	};

	struct SPI_SHADER_PGM_RSRC2_HS
	{
		uint32_t scratch_en : 1;
		uint32_t user_sgpr : 5;
		uint32_t trap_present : 1;
		uint32_t excp_en : 9;
		uint32_t lds_size : 9;
		uint32_t skip_usgpr0 : 1;
		uint32_t user_sgpr_msb : 1;
		uint32_t reserved : 5;
	};

	struct COMPUTE_PGM_LO
	{
		uint32_t data;
	};

	struct COMPUTE_PGM_HI
	{
		uint32_t data : 8;
		uint32_t reserved : 24;
	};

	struct COMPUTE_PGM_RSRC1
	{
		uint32_t vgprs : 6;
		uint32_t sgprs : 4;
		uint32_t priority : 2;
		uint32_t float_mode : 8;
		uint32_t priv : 1;
		uint32_t dx10_clamp : 1;
		uint32_t debug_mode : 1;
		uint32_t ieee_mode : 1;
		uint32_t bulky : 1;
		uint32_t cdbg_user : 1;
		uint32_t fp16_ovfl : 1;
		uint32_t reserved : 5;
	};

	struct COMPUTE_PGM_RSRC2
	{
		uint32_t scratch_en : 1;
		uint32_t user_sgpr : 5;
		uint32_t trap_present : 1;
		uint32_t tgid_x_en : 1;
		uint32_t tgid_y_en : 1;
		uint32_t tgid_z_en : 1;
		uint32_t tg_size_en : 1;
		uint32_t tidig_comp_cnt : 2;
		uint32_t excp_en_msb : 2;
		uint32_t lds_size : 9;
		uint32_t excp_en : 7;
		uint32_t skip_usgpr0 : 1;
	};
}  // namespace sce::gcn
