#include "PlatString.h"

namespace plat
{

#ifdef GPCS4_WINDOWS

#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#undef WIN32_LEAN_AND_MEAN

	std::string fromws(const wchar_t* ws)
	{
		size_t len = WideCharToMultiByte(CP_UTF8,
										 0, ws, -1, nullptr, 0, nullptr, nullptr);

		if (len <= 1)
			return "";

		len -= 1;

		std::string result;
		result.resize(len);
		WideCharToMultiByte(CP_UTF8, 0, ws, -1,
							&result.at(0), len, nullptr, nullptr);
		return result;
	}

	void tows(const char* mbs, wchar_t* wcs, size_t wcsLen)
	{
		MultiByteToWideChar(
			CP_UTF8, 0, mbs, -1,
			wcs, wcsLen);
	}

	std::wstring tows(const char* mbs)
	{
		size_t len = MultiByteToWideChar(CP_UTF8,
										 0, mbs, -1, nullptr, 0);

		if (len <= 1)
			return L"";

		len -= 1;

		std::wstring result;
		result.resize(len);
		MultiByteToWideChar(CP_UTF8, 0, mbs, -1,
							&result.at(0), len);
		return result;
	}

#else
	// TODO:

#endif  //GPCS4_WINDOWS

}  // namespace plat