/*
 *  CLRadeonExtender - Unofficial OpenCL Radeon Extensions Library
 *  Copyright (C) 2014-2018 Mateusz Szpakowski
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <CLRX/Config.h>
#include <CLRX/utils/GPUId.h>
#include "GCNInternals.h"

using namespace CLRX;

const GCNInstruction CLRX::gcnInstrsTable[] =
{
    { "s_add_u32",           GCNENC_SOP2,   GCN_STDMODE,              0,    ARCH_GCN_ALL  },
    { "s_sub_u32",           GCNENC_SOP2,   GCN_STDMODE,              1,    ARCH_GCN_ALL  },
    { "s_add_i32",           GCNENC_SOP2,   GCN_STDMODE,              2,    ARCH_GCN_ALL  },
    { "s_sub_i32",           GCNENC_SOP2,   GCN_STDMODE,              3,    ARCH_GCN_ALL  },
    { "s_addc_u32",          GCNENC_SOP2,   GCN_STDMODE,              4,    ARCH_GCN_ALL  },
    { "s_subb_u32",          GCNENC_SOP2,   GCN_STDMODE,              5,    ARCH_GCN_ALL  },
    { "s_min_i32",           GCNENC_SOP2,   GCN_STDMODE,              6,    ARCH_GCN_ALL  },
    { "s_min_u32",           GCNENC_SOP2,   GCN_STDMODE,              7,    ARCH_GCN_ALL  },
    { "s_max_i32",           GCNENC_SOP2,   GCN_STDMODE,              8,    ARCH_GCN_ALL  },
    { "s_max_u32",           GCNENC_SOP2,   GCN_STDMODE,              9,    ARCH_GCN_ALL  },
    { "s_cselect_b32",       GCNENC_SOP2,   GCN_STDMODE,              10,   ARCH_GCN_ALL  },
    { "s_cselect_b64",       GCNENC_SOP2,   GCN_REG_ALL_64,           11,   ARCH_GCN_ALL  },
    { "s_and_b32",           GCNENC_SOP2,   GCN_STDMODE,              14,   ARCH_GCN_1_0_1_5  },
    { "s_and_b64",           GCNENC_SOP2,   GCN_REG_ALL_64,           15,   ARCH_GCN_1_0_1_5  },
    { "s_or_b32",            GCNENC_SOP2,   GCN_STDMODE,              16,   ARCH_GCN_1_0_1_5  },
    { "s_or_b64",            GCNENC_SOP2,   GCN_REG_ALL_64,           17,   ARCH_GCN_1_0_1_5  },
    { "s_xor_b32",           GCNENC_SOP2,   GCN_STDMODE,              18,   ARCH_GCN_1_0_1_5  },
    { "s_xor_b64",           GCNENC_SOP2,   GCN_REG_ALL_64,           19,   ARCH_GCN_1_0_1_5  },
    { "s_andn2_b32",         GCNENC_SOP2,   GCN_STDMODE,              20,   ARCH_GCN_1_0_1_5  },
    { "s_andn2_b64",         GCNENC_SOP2,   GCN_REG_ALL_64,           21,   ARCH_GCN_1_0_1_5  },
    { "s_orn2_b32",          GCNENC_SOP2,   GCN_STDMODE,              22,   ARCH_GCN_1_0_1_5  },
    { "s_orn2_b64",          GCNENC_SOP2,   GCN_REG_ALL_64,           23,   ARCH_GCN_1_0_1_5  },
    { "s_nand_b32",          GCNENC_SOP2,   GCN_STDMODE,              24,   ARCH_GCN_1_0_1_5  },
    { "s_nand_b64",          GCNENC_SOP2,   GCN_REG_ALL_64,           25,   ARCH_GCN_1_0_1_5  },
    { "s_nor_b32",           GCNENC_SOP2,   GCN_STDMODE,              26,   ARCH_GCN_1_0_1_5  },
    { "s_nor_b64",           GCNENC_SOP2,   GCN_REG_ALL_64,           27,   ARCH_GCN_1_0_1_5  },
    { "s_xnor_b32",          GCNENC_SOP2,   GCN_STDMODE,              28,   ARCH_GCN_1_0_1_5  },
    { "s_xnor_b64",          GCNENC_SOP2,   GCN_REG_ALL_64,           29,   ARCH_GCN_1_0_1_5  },
    { "s_lshl_b32",          GCNENC_SOP2,   GCN_STDMODE,              30,   ARCH_GCN_1_0_1_5  },
    { "s_lshl_b64",          GCNENC_SOP2,   GCN_REG_DS0_64,           31,   ARCH_GCN_1_0_1_5  },
    { "s_lshr_b32",          GCNENC_SOP2,   GCN_STDMODE,              32,   ARCH_GCN_1_0_1_5  },
    { "s_lshr_b64",          GCNENC_SOP2,   GCN_REG_DS0_64,           33,   ARCH_GCN_1_0_1_5  },
    { "s_ashr_i32",          GCNENC_SOP2,   GCN_STDMODE,              34,   ARCH_GCN_1_0_1_5  },
    { "s_ashr_i64",          GCNENC_SOP2,   GCN_REG_DS0_64,           35,   ARCH_GCN_1_0_1_5  },
    { "s_bfm_b32",           GCNENC_SOP2,   GCN_STDMODE,              36,   ARCH_GCN_1_0_1_5  },
    { "s_bfm_b64",           GCNENC_SOP2,   GCN_REG_DST_64,           37,   ARCH_GCN_1_0_1_5  },
    { "s_mul_i32",           GCNENC_SOP2,   GCN_STDMODE,              38,   ARCH_GCN_1_0_1_5  },
    { "s_bfe_u32",           GCNENC_SOP2,   GCN_STDMODE,              39,   ARCH_GCN_1_0_1_5  },
    { "s_bfe_i32",           GCNENC_SOP2,   GCN_STDMODE,              40,   ARCH_GCN_1_0_1_5  },
    { "s_bfe_u64",           GCNENC_SOP2,   GCN_REG_DS0_64,           41,   ARCH_GCN_1_0_1_5  },
    { "s_bfe_i64",           GCNENC_SOP2,   GCN_REG_DS0_64,           42,   ARCH_GCN_1_0_1_5  },
    { "s_cbranch_g_fork",    GCNENC_SOP2,   GCN_REG_ALL_64|GCN_DST_NONE,43,   ARCH_GCN_1_0_1  },
    { "s_absdiff_i32",       GCNENC_SOP2,   GCN_STDMODE,              44,   ARCH_GCN_1_0_1_5  },
    { "s_and_b32",           GCNENC_SOP2,   GCN_STDMODE,              12,   ARCH_GCN_1_2_4  },
    { "s_and_b64",           GCNENC_SOP2,   GCN_REG_ALL_64,           13,   ARCH_GCN_1_2_4  },
    { "s_or_b32",            GCNENC_SOP2,   GCN_STDMODE,              14,   ARCH_GCN_1_2_4  },
    { "s_or_b64",            GCNENC_SOP2,   GCN_REG_ALL_64,           15,   ARCH_GCN_1_2_4  },
    { "s_xor_b32",           GCNENC_SOP2,   GCN_STDMODE,              16,   ARCH_GCN_1_2_4  },
    { "s_xor_b64",           GCNENC_SOP2,   GCN_REG_ALL_64,           17,   ARCH_GCN_1_2_4  },
    { "s_andn2_b32",         GCNENC_SOP2,   GCN_STDMODE,              18,   ARCH_GCN_1_2_4  },
    { "s_andn2_b64",         GCNENC_SOP2,   GCN_REG_ALL_64,           19,   ARCH_GCN_1_2_4  },
    { "s_orn2_b32",          GCNENC_SOP2,   GCN_STDMODE,              20,   ARCH_GCN_1_2_4  },
    { "s_orn2_b64",          GCNENC_SOP2,   GCN_REG_ALL_64,           21,   ARCH_GCN_1_2_4  },
    { "s_nand_b32",          GCNENC_SOP2,   GCN_STDMODE,              22,   ARCH_GCN_1_2_4  },
    { "s_nand_b64",          GCNENC_SOP2,   GCN_REG_ALL_64,           23,   ARCH_GCN_1_2_4  },
    { "s_nor_b32",           GCNENC_SOP2,   GCN_STDMODE,              24,   ARCH_GCN_1_2_4  },
    { "s_nor_b64",           GCNENC_SOP2,   GCN_REG_ALL_64,           25,   ARCH_GCN_1_2_4  },
    { "s_xnor_b32",          GCNENC_SOP2,   GCN_STDMODE,              26,   ARCH_GCN_1_2_4  },
    { "s_xnor_b64",          GCNENC_SOP2,   GCN_REG_ALL_64,           27,   ARCH_GCN_1_2_4  },
    { "s_lshl_b32",          GCNENC_SOP2,   GCN_STDMODE,              28,   ARCH_GCN_1_2_4  },
    { "s_lshl_b64",          GCNENC_SOP2,   GCN_REG_DS0_64,           29,   ARCH_GCN_1_2_4  },
    { "s_lshr_b32",          GCNENC_SOP2,   GCN_STDMODE,              30,   ARCH_GCN_1_2_4  },
    { "s_lshr_b64",          GCNENC_SOP2,   GCN_REG_DS0_64,           31,   ARCH_GCN_1_2_4  },
    { "s_ashr_i32",          GCNENC_SOP2,   GCN_STDMODE,              32,   ARCH_GCN_1_2_4  },
    { "s_ashr_i64",          GCNENC_SOP2,   GCN_REG_DS0_64,           33,   ARCH_GCN_1_2_4  },
    { "s_bfm_b32",           GCNENC_SOP2,   GCN_STDMODE,              34,   ARCH_GCN_1_2_4  },
    { "s_bfm_b64",           GCNENC_SOP2,   GCN_REG_DST_64,           35,   ARCH_GCN_1_2_4  },
    { "s_mul_i32",           GCNENC_SOP2,   GCN_STDMODE,              36,   ARCH_GCN_1_2_4  },
    { "s_bfe_u32",           GCNENC_SOP2,   GCN_STDMODE,              37,   ARCH_GCN_1_2_4  },
    { "s_bfe_i32",           GCNENC_SOP2,   GCN_STDMODE,              38,   ARCH_GCN_1_2_4  },
    { "s_bfe_u64",           GCNENC_SOP2,   GCN_REG_DS0_64,           39,   ARCH_GCN_1_2_4  },
    { "s_bfe_i64",           GCNENC_SOP2,   GCN_REG_DS0_64,           40,   ARCH_GCN_1_2_4  },
    { "s_cbranch_g_fork",    GCNENC_SOP2,   GCN_REG_ALL_64|GCN_DST_NONE,41,   ARCH_GCN_1_2_4  },
    { "s_absdiff_i32",       GCNENC_SOP2,   GCN_STDMODE,              42,   ARCH_GCN_1_2_4  },
    { "s_rfe_restore_b64",   GCNENC_SOP2,   GCN_REG_SRC0_64|GCN_DST_NONE,43,   ARCH_GCN_1_2_4  },
    { "s_mul_hi_u32",        GCNENC_SOP2,   GCN_STDMODE,              44,   ARCH_GCN_1_4 },
    { "s_mul_hi_i32",        GCNENC_SOP2,   GCN_STDMODE,              45,   ARCH_GCN_1_4 },
    { "s_lshl1_add_u32",     GCNENC_SOP2,   GCN_STDMODE,              46,   ARCH_GCN_1_4_5 },
    { "s_lshl2_add_u32",     GCNENC_SOP2,   GCN_STDMODE,              47,   ARCH_GCN_1_4_5 },
    { "s_lshl3_add_u32",     GCNENC_SOP2,   GCN_STDMODE,              48,   ARCH_GCN_1_4_5 },
    { "s_lshl4_add_u32",     GCNENC_SOP2,   GCN_STDMODE,              49,   ARCH_GCN_1_4_5 },
    { "s_pack_ll_b32_b16",   GCNENC_SOP2,   GCN_STDMODE,              50,   ARCH_GCN_1_4_5 },
    { "s_pack_lh_b32_b16",   GCNENC_SOP2,   GCN_STDMODE,              51,   ARCH_GCN_1_4_5 },
    { "s_pack_hh_b32_b16",   GCNENC_SOP2,   GCN_STDMODE,              52,   ARCH_GCN_1_4_5 },
    { "s_mul_hi_u32",        GCNENC_SOP2,   GCN_STDMODE,              53,   ARCH_GCN_1_5 },
    { "s_mul_hi_i32",        GCNENC_SOP2,   GCN_STDMODE,              54,   ARCH_GCN_1_5 },
    { "s_movk_i32",          GCNENC_SOPK,   GCN_STDMODE,              0,    ARCH_GCN_ALL  },
    { "s_cmovk_i32",         GCNENC_SOPK,   GCN_STDMODE,              2,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_eq_i32",       GCNENC_SOPK,   GCN_DST_SRC,              3,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_lg_i32",       GCNENC_SOPK,   GCN_DST_SRC,              4,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_gt_i32",       GCNENC_SOPK,   GCN_DST_SRC,              5,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_ge_i32",       GCNENC_SOPK,   GCN_DST_SRC,              6,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_lt_i32",       GCNENC_SOPK,   GCN_DST_SRC,              7,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_le_i32",       GCNENC_SOPK,   GCN_DST_SRC,              8,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_eq_u32",       GCNENC_SOPK,   GCN_DST_SRC,              9,    ARCH_GCN_1_0_1_5  },
    { "s_cmpk_lg_u32",       GCNENC_SOPK,   GCN_DST_SRC,              10,   ARCH_GCN_1_0_1_5  },
    { "s_cmpk_gt_u32",       GCNENC_SOPK,   GCN_DST_SRC,              11,   ARCH_GCN_1_0_1_5  },
    { "s_cmpk_ge_u32",       GCNENC_SOPK,   GCN_DST_SRC,              12,   ARCH_GCN_1_0_1_5  },
    { "s_cmpk_lt_u32",       GCNENC_SOPK,   GCN_DST_SRC,              13,   ARCH_GCN_1_0_1_5  },
    { "s_cmpk_le_u32",       GCNENC_SOPK,   GCN_DST_SRC,              14,   ARCH_GCN_1_0_1_5  },
    { "s_addk_i32",          GCNENC_SOPK,   GCN_STDMODE,              15,   ARCH_GCN_1_0_1_5  },
    { "s_mulk_i32",          GCNENC_SOPK,   GCN_STDMODE,              16,   ARCH_GCN_1_0_1_5  },
    { "s_cbranch_i_fork",    GCNENC_SOPK,   GCN_REG_DST_64|GCN_IMM_REL,17,   ARCH_GCN_1_0_1  },
    { "s_getreg_b32",        GCNENC_SOPK,   GCN_IMM_SREG,             18,   ARCH_GCN_1_0_1_5  },
    { "s_setreg_b32",        GCNENC_SOPK,   GCN_IMM_SREG|GCN_IMM_DST, 19,   ARCH_GCN_1_0_1_5  },
    { "s_getreg_regrd_b32",  GCNENC_SOPK,   GCN_IMM_SREG,             20,   ARCH_GCN_1_0_1  },
    { "s_setreg_imm32_b32",  GCNENC_SOPK,   GCN_IMM_SREG|GCN_SOPK_SRIMM32, 21,   ARCH_GCN_1_0_1_5  },
    { "s_cmovk_i32",         GCNENC_SOPK,   GCN_STDMODE,              1,    ARCH_GCN_1_2_4  },
    { "s_cmpk_eq_i32",       GCNENC_SOPK,   GCN_STDMODE,              2,    ARCH_GCN_1_2_4  },
    { "s_cmpk_lg_i32",       GCNENC_SOPK,   GCN_STDMODE,              3,    ARCH_GCN_1_2_4  },
    { "s_cmpk_gt_i32",       GCNENC_SOPK,   GCN_STDMODE,              4,    ARCH_GCN_1_2_4  },
    { "s_cmpk_ge_i32",       GCNENC_SOPK,   GCN_STDMODE,              5,    ARCH_GCN_1_2_4  },
    { "s_cmpk_lt_i32",       GCNENC_SOPK,   GCN_STDMODE,              6,    ARCH_GCN_1_2_4  },
    { "s_cmpk_le_i32",       GCNENC_SOPK,   GCN_STDMODE,              7,    ARCH_GCN_1_2_4  },
    { "s_cmpk_eq_u32",       GCNENC_SOPK,   GCN_STDMODE,              8,    ARCH_GCN_1_2_4  },
    { "s_cmpk_lg_u32",       GCNENC_SOPK,   GCN_STDMODE,              9,    ARCH_GCN_1_2_4  },
    { "s_cmpk_gt_u32",       GCNENC_SOPK,   GCN_STDMODE,              10,   ARCH_GCN_1_2_4  },
    { "s_cmpk_ge_u32",       GCNENC_SOPK,   GCN_STDMODE,              11,   ARCH_GCN_1_2_4  },
    { "s_cmpk_lt_u32",       GCNENC_SOPK,   GCN_STDMODE,              12,   ARCH_GCN_1_2_4  },
    { "s_cmpk_le_u32",       GCNENC_SOPK,   GCN_STDMODE,              13,   ARCH_GCN_1_2_4  },
    { "s_addk_i32",          GCNENC_SOPK,   GCN_STDMODE,              14,   ARCH_GCN_1_2_4  },
    { "s_mulk_i32",          GCNENC_SOPK,   GCN_STDMODE,              15,   ARCH_GCN_1_2_4  },
    { "s_cbranch_i_fork",    GCNENC_SOPK,   GCN_REG_DST_64|GCN_IMM_REL,16,   ARCH_GCN_1_2_4  },
    { "s_getreg_b32",        GCNENC_SOPK,   GCN_IMM_SREG,             17,   ARCH_GCN_1_2_4  },
    { "s_setreg_b32",        GCNENC_SOPK,   GCN_IMM_SREG|GCN_IMM_DST, 18,   ARCH_GCN_1_2_4  },
    { "s_getreg_regrd_b32",  GCNENC_SOPK,   GCN_IMM_SREG,             19,   ARCH_GCN_1_2_4  },
    { "s_setreg_imm32_b32",  GCNENC_SOPK,   GCN_IMM_SREG|GCN_SOPK_SRIMM32, 20,   ARCH_GCN_1_2_4  },
    { "s_call_b64",          GCNENC_SOPK,   GCN_REG_DST_64|GCN_IMM_REL, 21,   ARCH_GCN_1_4 },
    { "s_version",           GCNENC_SOPK,   GCN_DST_NONE,              1,   ARCH_GCN_1_5 },
    { "s_call_b64",          GCNENC_SOPK,   GCN_REG_DST_64|GCN_IMM_REL, 22,   ARCH_GCN_1_5 },
    { "s_waitcnt_vscnt",     GCNENC_SOPK,   GCN_STDMODE,              23,   ARCH_GCN_1_5 },
    { "s_waitcnt_vmcnt",     GCNENC_SOPK,   GCN_STDMODE,              24,   ARCH_GCN_1_5 },
    { "s_waitcnt_expcnt",    GCNENC_SOPK,   GCN_STDMODE,             25,   ARCH_GCN_1_5 },
    { "s_waitcnt_lgkmcnt",   GCNENC_SOPK,   GCN_STDMODE,            26,   ARCH_GCN_1_5 },
    { "s_subvector_loop_begin", GCNENC_SOPK,   GCN_IMM_REL,            27,   ARCH_GCN_1_5 },
    { "s_subvector_loop_end", GCNENC_SOPK,   GCN_IMM_REL,            28,   ARCH_GCN_1_5 },
    { "s_mov_b32",           GCNENC_SOP1,   GCN_STDMODE,              3,    ARCH_GCN_1_0_1_5  },
    { "s_mov_b64",           GCNENC_SOP1,   GCN_REG_ALL_64,           4,    ARCH_GCN_1_0_1_5  },
    { "s_cmov_b32",          GCNENC_SOP1,   GCN_STDMODE,              5,    ARCH_GCN_1_0_1_5  },
    { "s_cmov_b64",          GCNENC_SOP1,   GCN_REG_ALL_64,           6,    ARCH_GCN_1_0_1_5  },
    { "s_not_b32",           GCNENC_SOP1,   GCN_STDMODE,              7,    ARCH_GCN_1_0_1_5  },
    { "s_not_b64",           GCNENC_SOP1,   GCN_REG_ALL_64,           8,    ARCH_GCN_1_0_1_5  },
    { "s_wqm_b32",           GCNENC_SOP1,   GCN_STDMODE,              9,    ARCH_GCN_1_0_1_5  },
    { "s_wqm_b64",           GCNENC_SOP1,   GCN_REG_ALL_64,           10,   ARCH_GCN_1_0_1_5  },
    { "s_brev_b32",          GCNENC_SOP1,   GCN_STDMODE,              11,   ARCH_GCN_1_0_1_5  },
    { "s_brev_b64",          GCNENC_SOP1,   GCN_REG_ALL_64,           12,   ARCH_GCN_1_0_1_5  },
    { "s_bcnt0_i32_b32",     GCNENC_SOP1,   GCN_STDMODE,              13,   ARCH_GCN_1_0_1_5  },
    { "s_bcnt0_i32_b64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          14,   ARCH_GCN_1_0_1_5  },
    { "s_bcnt1_i32_b32",     GCNENC_SOP1,   GCN_STDMODE,              15,   ARCH_GCN_1_0_1_5  },
    { "s_bcnt1_i32_b64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          16,   ARCH_GCN_1_0_1_5  },
    { "s_ff0_i32_b32",       GCNENC_SOP1,   GCN_STDMODE,              17,   ARCH_GCN_1_0_1_5  },
    { "s_ff0_i32_b64",       GCNENC_SOP1,   GCN_REG_SRC0_64,          18,   ARCH_GCN_1_0_1_5  },
    { "s_ff1_i32_b32",       GCNENC_SOP1,   GCN_STDMODE,              19,   ARCH_GCN_1_0_1_5  },
    { "s_ff1_i32_b64",       GCNENC_SOP1,   GCN_REG_SRC0_64,          20,   ARCH_GCN_1_0_1_5  },
    { "s_flbit_i32_b32",     GCNENC_SOP1,   GCN_STDMODE,              21,   ARCH_GCN_1_0_1_5  },
    { "s_flbit_i32_b64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          22,   ARCH_GCN_1_0_1_5  },
    { "s_flbit_i32",         GCNENC_SOP1,   GCN_STDMODE,              23,   ARCH_GCN_1_0_1_5  },
    { "s_flbit_i32_i64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          24,   ARCH_GCN_1_0_1_5  },
    { "s_sext_i32_i8",       GCNENC_SOP1,   GCN_STDMODE,              25,   ARCH_GCN_1_0_1_5  },
    { "s_sext_i32_i16",      GCNENC_SOP1,   GCN_STDMODE,              26,   ARCH_GCN_1_0_1_5  },
    { "s_bitset0_b32",       GCNENC_SOP1,   GCN_STDMODE,              27,   ARCH_GCN_1_0_1_5  },
    { "s_bitset0_b64",       GCNENC_SOP1,   GCN_REG_DST_64,           28,   ARCH_GCN_1_0_1_5  },
    { "s_bitset1_b32",       GCNENC_SOP1,   GCN_STDMODE,              29,   ARCH_GCN_1_0_1_5  },
    { "s_bitset1_b64",       GCNENC_SOP1,   GCN_REG_DST_64,           30,   ARCH_GCN_1_0_1_5  },
    { "s_getpc_b64",         GCNENC_SOP1,   GCN_REG_ALL_64|GCN_SRC_NONE, 31,   ARCH_GCN_1_0_1_5  },
    { "s_setpc_b64",         GCNENC_SOP1,   GCN_REG_ALL_64|GCN_DST_NONE, 32,   ARCH_GCN_1_0_1_5  },
    { "s_swappc_b64",        GCNENC_SOP1,   GCN_REG_ALL_64,           33,   ARCH_GCN_1_0_1_5  },
    { "s_rfe_b64",           GCNENC_SOP1,   GCN_REG_ALL_64|GCN_DST_NONE, 34,   ARCH_GCN_1_0_1_5  },
    { "s_and_saveexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           36,   ARCH_GCN_1_0_1_5  },
    { "s_or_saveexec_b64",   GCNENC_SOP1,   GCN_REG_ALL_64,           37,   ARCH_GCN_1_0_1_5  },
    { "s_xor_saveexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           38,   ARCH_GCN_1_0_1_5  },
    { "s_andn2_saveexec_b64",GCNENC_SOP1,   GCN_REG_ALL_64,           39,   ARCH_GCN_1_0_1_5  },
    { "s_orn2_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           40,   ARCH_GCN_1_0_1_5  },
    { "s_nand_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           41,   ARCH_GCN_1_0_1_5  },
    { "s_nor_saveexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           42,   ARCH_GCN_1_0_1_5  },
    { "s_xnor_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           43,   ARCH_GCN_1_0_1_5  },
    { "s_quadmask_b32",      GCNENC_SOP1,   GCN_STDMODE,              44,   ARCH_GCN_1_0_1_5  },
    { "s_quadmask_b64",      GCNENC_SOP1,   GCN_REG_ALL_64,           45,   ARCH_GCN_1_0_1_5  },
    { "s_movrels_b32",       GCNENC_SOP1,   GCN_STDMODE,              46,   ARCH_GCN_1_0_1_5  },
    { "s_movrels_b64",       GCNENC_SOP1,   GCN_REG_ALL_64,           47,   ARCH_GCN_1_0_1_5  },
    { "s_movreld_b32",       GCNENC_SOP1,   GCN_STDMODE,              48,   ARCH_GCN_1_0_1_5  },
    { "s_movreld_b64",       GCNENC_SOP1,   GCN_REG_ALL_64,           49,   ARCH_GCN_1_0_1_5  },
    { "s_cbranch_join",      GCNENC_SOP1,   GCN_STDMODE|GCN_DST_NONE, 50,   ARCH_GCN_1_0_1  },
    { "s_mov_regrd_b32",     GCNENC_SOP1,   GCN_STDMODE,              51,   ARCH_GCN_1_0_1  },
    { "s_abs_i32",           GCNENC_SOP1,   GCN_STDMODE,              52,   ARCH_GCN_1_0_1_5  },
    { "s_mov_fed_b32",       GCNENC_SOP1,   GCN_STDMODE,         53, ARCH_GCN_1_0_1_5  },
    { "s_mov_b32",           GCNENC_SOP1,   GCN_STDMODE,              0,    ARCH_GCN_1_2_4  },
    { "s_mov_b64",           GCNENC_SOP1,   GCN_REG_ALL_64,           1,    ARCH_GCN_1_2_4  },
    { "s_cmov_b32",          GCNENC_SOP1,   GCN_STDMODE,              2,    ARCH_GCN_1_2_4  },
    { "s_cmov_b64",          GCNENC_SOP1,   GCN_REG_ALL_64,           3,    ARCH_GCN_1_2_4  },
    { "s_not_b32",           GCNENC_SOP1,   GCN_STDMODE,              4,    ARCH_GCN_1_2_4  },
    { "s_not_b64",           GCNENC_SOP1,   GCN_REG_ALL_64,           5,    ARCH_GCN_1_2_4  },
    { "s_wqm_b32",           GCNENC_SOP1,   GCN_STDMODE,              6,    ARCH_GCN_1_2_4  },
    { "s_wqm_b64",           GCNENC_SOP1,   GCN_REG_ALL_64,           7,    ARCH_GCN_1_2_4  },
    { "s_brev_b32",          GCNENC_SOP1,   GCN_STDMODE,              8,    ARCH_GCN_1_2_4  },
    { "s_brev_b64",          GCNENC_SOP1,   GCN_REG_ALL_64,           9,    ARCH_GCN_1_2_4  },
    { "s_bcnt0_i32_b32",     GCNENC_SOP1,   GCN_STDMODE,              10,   ARCH_GCN_1_2_4  },
    { "s_bcnt0_i32_b64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          11,   ARCH_GCN_1_2_4  },
    { "s_bcnt1_i32_b32",     GCNENC_SOP1,   GCN_STDMODE,              12,   ARCH_GCN_1_2_4  },
    { "s_bcnt1_i32_b64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          13,   ARCH_GCN_1_2_4  },
    { "s_ff0_i32_b32",       GCNENC_SOP1,   GCN_STDMODE,              14,   ARCH_GCN_1_2_4  },
    { "s_ff0_i32_b64",       GCNENC_SOP1,   GCN_REG_SRC0_64,          15,   ARCH_GCN_1_2_4  },
    { "s_ff1_i32_b32",       GCNENC_SOP1,   GCN_STDMODE,              16,   ARCH_GCN_1_2_4  },
    { "s_ff1_i32_b64",       GCNENC_SOP1,   GCN_REG_SRC0_64,          17,   ARCH_GCN_1_2_4  },
    { "s_flbit_i32_b32",     GCNENC_SOP1,   GCN_STDMODE,              18,   ARCH_GCN_1_2_4  },
    { "s_flbit_i32_b64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          19,   ARCH_GCN_1_2_4  },
    { "s_flbit_i32",         GCNENC_SOP1,   GCN_STDMODE,              20,   ARCH_GCN_1_2_4  },
    { "s_flbit_i32_i64",     GCNENC_SOP1,   GCN_REG_SRC0_64,          21,   ARCH_GCN_1_2_4  },
    { "s_sext_i32_i8",       GCNENC_SOP1,   GCN_STDMODE,              22,   ARCH_GCN_1_2_4  },
    { "s_sext_i32_i16",      GCNENC_SOP1,   GCN_STDMODE,              23,   ARCH_GCN_1_2_4  },
    { "s_bitset0_b32",       GCNENC_SOP1,   GCN_STDMODE,              24,   ARCH_GCN_1_2_4  },
    { "s_bitset0_b64",       GCNENC_SOP1,   GCN_REG_DST_64,           25,   ARCH_GCN_1_2_4  },
    { "s_bitset1_b32",       GCNENC_SOP1,   GCN_STDMODE,              26,   ARCH_GCN_1_2_4  },
    { "s_bitset1_b64",       GCNENC_SOP1,   GCN_REG_DST_64,           27,   ARCH_GCN_1_2_4  },
    { "s_getpc_b64",         GCNENC_SOP1,   GCN_REG_ALL_64|GCN_SRC_NONE, 28,   ARCH_GCN_1_2_4  },
    { "s_setpc_b64",         GCNENC_SOP1,   GCN_REG_ALL_64|GCN_DST_NONE, 29,   ARCH_GCN_1_2_4  },
    { "s_swappc_b64",        GCNENC_SOP1,   GCN_REG_ALL_64,           30,   ARCH_GCN_1_2_4  },
    { "s_rfe_b64",           GCNENC_SOP1,   GCN_REG_ALL_64|GCN_DST_NONE, 31,   ARCH_GCN_1_2_4  },
    { "s_and_saveexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           32,   ARCH_GCN_1_2_4  },
    { "s_or_saveexec_b64",   GCNENC_SOP1,   GCN_REG_ALL_64,           33,   ARCH_GCN_1_2_4  },
    { "s_xor_saveexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           34,   ARCH_GCN_1_2_4  },
    { "s_andn2_saveexec_b64",GCNENC_SOP1,   GCN_REG_ALL_64,           35,   ARCH_GCN_1_2_4  },
    { "s_orn2_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           36,   ARCH_GCN_1_2_4  },
    { "s_nand_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           37,   ARCH_GCN_1_2_4  },
    { "s_nor_saveexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           38,   ARCH_GCN_1_2_4  },
    { "s_xnor_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           39,   ARCH_GCN_1_2_4  },
    { "s_quadmask_b32",      GCNENC_SOP1,   GCN_STDMODE,              40,   ARCH_GCN_1_2_4  },
    { "s_quadmask_b64",      GCNENC_SOP1,   GCN_REG_ALL_64,           41,   ARCH_GCN_1_2_4  },
    { "s_movrels_b32",       GCNENC_SOP1,   GCN_STDMODE,              42,   ARCH_GCN_1_2_4  },
    { "s_movrels_b64",       GCNENC_SOP1,   GCN_REG_ALL_64,           43,   ARCH_GCN_1_2_4  },
    { "s_movreld_b32",       GCNENC_SOP1,   GCN_STDMODE,              44,   ARCH_GCN_1_2_4  },
    { "s_movreld_b64",       GCNENC_SOP1,   GCN_REG_ALL_64,           45,   ARCH_GCN_1_2_4  },
    { "s_cbranch_join",      GCNENC_SOP1,   GCN_STDMODE|GCN_DST_NONE, 46,   ARCH_GCN_1_2_4  },
    { "s_mov_regrd_b32",     GCNENC_SOP1,   GCN_STDMODE,              47,   ARCH_GCN_1_2_4  },
    { "s_abs_i32",           GCNENC_SOP1,   GCN_STDMODE,              48,   ARCH_GCN_1_2_4  },
    { "s_mov_fed_b32",       GCNENC_SOP1,   GCN_STDMODE,         49, ARCH_GCN_1_2_4  },
    { "s_set_gpr_idx_idx",   GCNENC_SOP1,   GCN_DST_NONE,              50,   ARCH_GCN_1_2_4  },
    { "s_andn1_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           51,   ARCH_GCN_1_4  },
    { "s_orn1_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           52,   ARCH_GCN_1_4  },
    { "s_andn1_wrexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           53,   ARCH_GCN_1_4  },
    { "s_andn2_wrexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           54,   ARCH_GCN_1_4  },
    { "s_bitreplicate_b64_b32",  GCNENC_SOP1,   GCN_REG_DST_64,           55,   ARCH_GCN_1_4  },
    { "s_andn1_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           55,   ARCH_GCN_1_5  },
    { "s_orn1_saveexec_b64", GCNENC_SOP1,   GCN_REG_ALL_64,           56,   ARCH_GCN_1_5  },
    { "s_andn1_wrexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           57,   ARCH_GCN_1_5  },
    { "s_andn2_wrexec_b64",  GCNENC_SOP1,   GCN_REG_ALL_64,           58,   ARCH_GCN_1_5  },
    { "s_bitreplicate_b64_b32",  GCNENC_SOP1,   GCN_REG_DST_64,           59,   ARCH_GCN_1_5  },
    { "s_and_saveexec_b32",  GCNENC_SOP1,   GCN_STDMODE,              60,   ARCH_GCN_1_5  },
    { "s_or_saveexec_b32",   GCNENC_SOP1,   GCN_STDMODE,              61,   ARCH_GCN_1_5  },
    { "s_xor_saveexec_b32",  GCNENC_SOP1,   GCN_STDMODE,              62,   ARCH_GCN_1_5  },
    { "s_andn2_saveexec_b32", GCNENC_SOP1,   GCN_STDMODE,              63,   ARCH_GCN_1_5  },
    { "s_orn2_saveexec_b32", GCNENC_SOP1,   GCN_STDMODE,              64,   ARCH_GCN_1_5  },
    { "s_nand_saveexec_b32", GCNENC_SOP1,   GCN_STDMODE,              65,   ARCH_GCN_1_5  },
    { "s_nor_saveexec_b32",  GCNENC_SOP1,   GCN_STDMODE,              66,   ARCH_GCN_1_5  },
    { "s_xnor_saveexec_b32", GCNENC_SOP1,   GCN_STDMODE,              67,   ARCH_GCN_1_5  },
    { "s_andn1_saveexec_b32", GCNENC_SOP1,   GCN_STDMODE,              68,   ARCH_GCN_1_5  },
    { "s_orn1_saveexec_b32", GCNENC_SOP1,   GCN_STDMODE,              69,   ARCH_GCN_1_5  },
    { "s_andn1_wrexec_b32",  GCNENC_SOP1,   GCN_STDMODE,              70,   ARCH_GCN_1_5  },
    { "s_andn2_wrexec_b32",  GCNENC_SOP1,   GCN_STDMODE,              71,   ARCH_GCN_1_5  },
    { "s_movrelsd_2_b32",  GCNENC_SOP1,     GCN_STDMODE,           73,   ARCH_GCN_1_5  },
    { "s_cmp_eq_i32",        GCNENC_SOPC,   GCN_STDMODE,              0,    ARCH_GCN_ALL  },
    { "s_cmp_lg_i32",        GCNENC_SOPC,   GCN_STDMODE,              1,    ARCH_GCN_ALL  },
    { "s_cmp_gt_i32",        GCNENC_SOPC,   GCN_STDMODE,              2,    ARCH_GCN_ALL  },
    { "s_cmp_ge_i32",        GCNENC_SOPC,   GCN_STDMODE,              3,    ARCH_GCN_ALL  },
    { "s_cmp_lt_i32",        GCNENC_SOPC,   GCN_STDMODE,              4,    ARCH_GCN_ALL  },
    { "s_cmp_le_i32",        GCNENC_SOPC,   GCN_STDMODE,              5,    ARCH_GCN_ALL  },
    { "s_cmp_eq_u32",        GCNENC_SOPC,   GCN_STDMODE,              6,    ARCH_GCN_ALL  },
    { "s_cmp_lg_u32",        GCNENC_SOPC,   GCN_STDMODE,              7,    ARCH_GCN_ALL  },
    { "s_cmp_gt_u32",        GCNENC_SOPC,   GCN_STDMODE,              8,    ARCH_GCN_ALL  },
    { "s_cmp_ge_u32",        GCNENC_SOPC,   GCN_STDMODE,              9,    ARCH_GCN_ALL  },
    { "s_cmp_lt_u32",        GCNENC_SOPC,   GCN_STDMODE,              10,   ARCH_GCN_ALL  },
    { "s_cmp_le_u32",        GCNENC_SOPC,   GCN_STDMODE,              11,   ARCH_GCN_ALL  },
    { "s_bitcmp0_b32",       GCNENC_SOPC,   GCN_STDMODE,              12,   ARCH_GCN_ALL  },
    { "s_bitcmp1_b32",       GCNENC_SOPC,   GCN_STDMODE,              13,   ARCH_GCN_ALL  },
    { "s_bitcmp0_b64",       GCNENC_SOPC,   GCN_REG_DS0_64,           14,   ARCH_GCN_ALL  },
    { "s_bitcmp1_b64",       GCNENC_SOPC,   GCN_REG_DS0_64,           15,   ARCH_GCN_ALL  },
    { "s_setvskip",          GCNENC_SOPC,   GCN_STDMODE,              16,   ARCH_GCN_1_0_1_2_4  },
    { "s_set_gpr_idx_on",    GCNENC_SOPC,   GCN_SRC1_IMM,             17,   ARCH_GCN_1_2_4  },
    { "s_cmp_eq_u64",        GCNENC_SOPC,   GCN_REG_ALL_64,           18,   ARCH_GCN_1_2_4_5  },
    { "s_cmp_lg_u64",        GCNENC_SOPC,   GCN_REG_ALL_64,           19,   ARCH_GCN_1_2_4_5  },
    { "s_cmp_ne_u64",        GCNENC_SOPC,   GCN_REG_ALL_64,           19,   ARCH_GCN_1_2_4_5  },
    { "s_nop",               GCNENC_SOPP,   GCN_STDMODE,              0,    ARCH_GCN_ALL  },
    { "s_endpgm",            GCNENC_SOPP,   GCN_IMM_NONE,             1,    ARCH_GCN_ALL  },
    { "s_branch",            GCNENC_SOPP,   GCN_IMM_REL,              2,    ARCH_GCN_ALL  },
    { "s_wakeup",            GCNENC_SOPP,   GCN_IMM_NONE,             3,    ARCH_GCN_1_2_4_5  },
    { "s_cbranch_scc0",      GCNENC_SOPP,   GCN_IMM_REL,              4,    ARCH_GCN_ALL  },
    { "s_cbranch_scc1",      GCNENC_SOPP,   GCN_IMM_REL,              5,    ARCH_GCN_ALL  },
    { "s_cbranch_vccz",      GCNENC_SOPP,   GCN_IMM_REL,              6,    ARCH_GCN_ALL  },
    { "s_cbranch_vccnz",     GCNENC_SOPP,   GCN_IMM_REL,              7,    ARCH_GCN_ALL  },
    { "s_cbranch_execz",     GCNENC_SOPP,   GCN_IMM_REL,              8,    ARCH_GCN_ALL  },
    { "s_cbranch_execnz",    GCNENC_SOPP,   GCN_IMM_REL,              9,    ARCH_GCN_ALL  },
    { "s_barrier",           GCNENC_SOPP,   GCN_IMM_NONE,             10,   ARCH_GCN_ALL  },
    { "s_setkill",           GCNENC_SOPP,   GCN_STDMODE,              11,   ARCH_GCN_1_1_2_4_5  },
    { "s_waitcnt",           GCNENC_SOPP,   GCN_IMM_LOCKS,            12,   ARCH_GCN_ALL  },
    { "s_sethalt",           GCNENC_SOPP,   GCN_STDMODE,              13,   ARCH_GCN_ALL  },
    { "s_sleep",             GCNENC_SOPP,   GCN_STDMODE,              14,   ARCH_GCN_ALL  },
    { "s_setprio",           GCNENC_SOPP,   GCN_STDMODE,              15,   ARCH_GCN_ALL  },
    { "s_sendmsg",           GCNENC_SOPP,   GCN_IMM_MSGS,             16,   ARCH_GCN_ALL  },
    { "s_sendmsghalt",       GCNENC_SOPP,   GCN_IMM_MSGS,             17,   ARCH_GCN_ALL  },
    { "s_trap",              GCNENC_SOPP,   GCN_STDMODE,              18,   ARCH_GCN_ALL  },
    { "s_icache_inv",        GCNENC_SOPP,   GCN_IMM_NONE,             19,   ARCH_GCN_ALL  },
    { "s_incperflevel",      GCNENC_SOPP,   GCN_STDMODE,              20,   ARCH_GCN_ALL  },
    { "s_decperflevel",      GCNENC_SOPP,   GCN_STDMODE,              21,   ARCH_GCN_ALL  },
    { "s_ttracedata",        GCNENC_SOPP,   GCN_IMM_NONE,             22,   ARCH_GCN_ALL  },
    { "s_cbranch_cdbgsys",   GCNENC_SOPP,   GCN_IMM_REL,              23,   ARCH_GCN_1_1_2_4_5  },
    { "s_cbranch_cdbguser",  GCNENC_SOPP,   GCN_IMM_REL,              24,   ARCH_GCN_1_1_2_4_5  },
    { "s_cbranch_cdbgsys_or_user",GCNENC_SOPP,   GCN_IMM_REL,  25,   ARCH_GCN_1_1_2_4_5  },
    { "s_cbranch_cdbgsys_and_user",GCNENC_SOPP,   GCN_IMM_REL, 26,   ARCH_GCN_1_1_2_4_5  },
    { "s_endpgm_saved",      GCNENC_SOPP,   GCN_IMM_NONE,             27,   ARCH_GCN_1_2_4_5  },
    { "s_set_gpr_idx_off",   GCNENC_SOPP,   GCN_IMM_NONE,             28,   ARCH_GCN_1_2_4  },
    { "s_set_gpr_idx_mode",  GCNENC_SOPP,   GCN_STDMODE,              29,   ARCH_GCN_1_2_4  },
    { "s_endpgm_ordered_ps_done", GCNENC_SOPP,    GCN_IMM_NONE,       30,   ARCH_GCN_1_4_5  },
    { "s_code_end",          GCNENC_SOPP,   GCN_IMM_NONE,             31,   ARCH_GCN_1_5  },
    { "s_inst_prefetch",     GCNENC_SOPP,   GCN_STDMODE,              32,   ARCH_GCN_1_5  },
    { "s_clause",            GCNENC_SOPP,   GCN_STDMODE,              33,   ARCH_GCN_1_5  },
    { "s_wait_idle",         GCNENC_SOPP,   GCN_IMM_NONE,             34,   ARCH_GCN_1_5  },
    { "s_waitcnt_decptr",    GCNENC_SOPP,   GCN_STDMODE,              35,   ARCH_GCN_1_5  },
    { "s_round_mode",        GCNENC_SOPP,   GCN_STDMODE,              36,   ARCH_GCN_1_5  },
    { "s_denorm_mode",       GCNENC_SOPP,   GCN_STDMODE,              37,   ARCH_GCN_1_5  },
    { "s_ttracedata_imm",    GCNENC_SOPP,   GCN_STDMODE,              40,   ARCH_GCN_1_5  },
    { "s_load_dword",        GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MLOAD,  0,    ARCH_GCN_ALL  },
    { "s_load_dwordx2",      GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MLOAD,  1,    ARCH_GCN_ALL  },
    { "s_load_dwordx4",      GCNENC_SMRD,   GCN_MEMOP_MX4|GCN_MLOAD,  2,    ARCH_GCN_ALL  },
    { "s_load_dwordx8",      GCNENC_SMRD,   GCN_MEMOP_MX8|GCN_MLOAD,  3,    ARCH_GCN_ALL  },
    { "s_load_dwordx16",     GCNENC_SMRD,   GCN_MEMOP_MX16|GCN_MLOAD, 4,    ARCH_GCN_ALL  },
    { "s_scratch_load_dword",        GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MLOAD,  5, ARCH_GCN_1_4_5 },
    { "s_scratch_load_dwordx2",      GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MLOAD,  6, ARCH_GCN_1_4_5 },
    { "s_scratch_load_dwordx4",      GCNENC_SMRD,   GCN_MEMOP_MX4|GCN_MLOAD,  7, ARCH_GCN_1_4_5 },
    { "s_buffer_load_dword", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MLOAD,         8,    ARCH_GCN_ALL  },
    { "s_buffer_load_dwordx2",GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MLOAD,        9,    ARCH_GCN_ALL  },
    { "s_buffer_load_dwordx4",GCNENC_SMRD,   GCN_MEMOP_MX4|GCN_SBASE4|GCN_MLOAD,        10,   ARCH_GCN_ALL  },
    { "s_buffer_load_dwordx8",GCNENC_SMRD,   GCN_MEMOP_MX8|GCN_SBASE4|GCN_MLOAD,        11,   ARCH_GCN_ALL },
    { "s_buffer_load_dwordx16",GCNENC_SMRD,   GCN_MEMOP_MX16|GCN_SBASE4|GCN_MLOAD,        12,   ARCH_GCN_ALL  },
    { "s_dcache_inv_vol",    GCNENC_SMRD,   GCN_ARG_NONE,             29,   ARCH_RX2X0     },
    { "s_memtime",           GCNENC_SMRD,   GCN_SMRD_ONLYDST|GCN_MLOAD|GCN_REG_DST_64,        30,   ARCH_GCN_1_0_1  },
    { "s_dcache_inv",        GCNENC_SMRD,   GCN_ARG_NONE,             31,   ARCH_GCN_1_0_1  },
    { "s_store_dword",       GCNENC_SMRD,   GCN_MEMOP_MX1,            16,   ARCH_GCN_1_2_4_5  },
    { "s_store_dwordx2",     GCNENC_SMRD,   GCN_MEMOP_MX2,            17,   ARCH_GCN_1_2_4_5  },
    { "s_store_dwordx4",     GCNENC_SMRD,   GCN_MEMOP_MX4,            18,   ARCH_GCN_1_2_4_5  },
    { "s_scratch_store_dword",        GCNENC_SMRD,   GCN_MEMOP_MX1,  21,    ARCH_GCN_1_4_5 },
    { "s_scratch_store_dwordx2",      GCNENC_SMRD,   GCN_MEMOP_MX2,  22,    ARCH_GCN_1_4_5 },
    { "s_scratch_store_dwordx4",      GCNENC_SMRD,   GCN_MEMOP_MX4,  23,    ARCH_GCN_1_4_5 },
    { "s_buffer_store_dword", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4,  24,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_store_dwordx2",GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4, 25,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_store_dwordx4",GCNENC_SMRD,   GCN_MEMOP_MX4|GCN_SBASE4, 26,   ARCH_GCN_1_2_4_5  },
    { "s_gl1_inv",        GCNENC_SMRD,   GCN_ARG_NONE,             31,   ARCH_GCN_1_5  },
    { "s_dcache_inv",        GCNENC_SMRD,   GCN_ARG_NONE,             32,   ARCH_GCN_1_2_4_5  },
    { "s_dcache_wb",         GCNENC_SMRD,   GCN_ARG_NONE,             33,   ARCH_GCN_1_2_4_5  },
    { "s_dcache_inv_vol",    GCNENC_SMRD,   GCN_ARG_NONE,             34,   ARCH_GCN_1_2_4  },
    { "s_dcache_wb_vol",     GCNENC_SMRD,   GCN_ARG_NONE,             35,   ARCH_GCN_1_2_4  },
    { "s_memtime",           GCNENC_SMRD,   GCN_SMRD_ONLYDST|GCN_MLOAD|GCN_REG_DST_64,        36,   ARCH_GCN_1_2_4_5  },
    { "s_memrealtime",       GCNENC_SMRD,   GCN_SMRD_ONLYDST|GCN_MLOAD|GCN_REG_DST_64,        37,   ARCH_GCN_1_2_4_5  },
    { "s_atc_probe",         GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SMEM_SDATA_IMM, 38,        ARCH_GCN_1_2_4_5  },
    { "s_atc_probe_buffer",  GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_SMEM_SDATA_IMM, 39,        ARCH_GCN_1_2_4_5  },
    { "s_dcache_discard",    GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SMEM_NOSDATA,        40, ARCH_GCN_1_4_5 },
    { "s_dcache_discard_x2",    GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SMEM_NOSDATA,        41, ARCH_GCN_1_4_5 },
    { "s_get_waveid_in_workgroup", GCNENC_SMRD,  GCN_MLOAD|GCN_SMRD_ONLYDST, 42, ARCH_GCN_1_5 },
    { "s_buffer_atomic_swap", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  64,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_cmpswap", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MCMPSWAP,  65,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_add", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  66,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_sub", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  67,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_smin", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  68,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_umin", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  69,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_smax", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  70,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_umax", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  71,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_and", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  72,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_or",  GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  73,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_xor", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  74,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_inc", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  75,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_dec", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_SBASE4|GCN_MATOMIC,  76,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_swap_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  96,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_cmpswap_x2", GCNENC_SMRD,   GCN_MEMOP_MX4|GCN_SBASE4|GCN_MCMPSWAP,  97,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_add_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  98,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_sub_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  99,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_smin_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  100,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_umin_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  101,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_smax_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  102,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_umax_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  103,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_and_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  104,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_or_x2",  GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  105,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_xor_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  106,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_inc_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  107,   ARCH_GCN_1_2_4_5  },
    { "s_buffer_atomic_dec_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_SBASE4|GCN_MATOMIC,  108,   ARCH_GCN_1_2_4_5  },
    { "s_atomic_swap", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  128,   ARCH_GCN_1_4_5  },
    { "s_atomic_cmpswap", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MCMPSWAP,  129,   ARCH_GCN_1_4_5  },
    { "s_atomic_add", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  130,   ARCH_GCN_1_4_5  },
    { "s_atomic_sub", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  131,   ARCH_GCN_1_4_5  },
    { "s_atomic_smin", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  132,   ARCH_GCN_1_4_5  },
    { "s_atomic_umin", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  133,   ARCH_GCN_1_4_5  },
    { "s_atomic_smax", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  134,   ARCH_GCN_1_4_5  },
    { "s_atomic_umax", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  135,   ARCH_GCN_1_4_5  },
    { "s_atomic_and", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  136,   ARCH_GCN_1_4_5  },
    { "s_atomic_or",  GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  137,   ARCH_GCN_1_4_5  },
    { "s_atomic_xor", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  138,   ARCH_GCN_1_4_5  },
    { "s_atomic_inc", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  139,   ARCH_GCN_1_4_5  },
    { "s_atomic_dec", GCNENC_SMRD,   GCN_MEMOP_MX1|GCN_MATOMIC,  140,   ARCH_GCN_1_4_5  },
    { "s_atomic_swap_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  160,   ARCH_GCN_1_4_5  },
    { "s_atomic_cmpswap_x2", GCNENC_SMRD,   GCN_MEMOP_MX4|GCN_MCMPSWAP,  161,   ARCH_GCN_1_4_5  },
    { "s_atomic_add_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  162,   ARCH_GCN_1_4_5  },
    { "s_atomic_sub_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  163,   ARCH_GCN_1_4_5  },
    { "s_atomic_smin_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  164,   ARCH_GCN_1_4_5  },
    { "s_atomic_umin_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  165,   ARCH_GCN_1_4_5  },
    { "s_atomic_smax_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  166,   ARCH_GCN_1_4_5  },
    { "s_atomic_umax_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  167,   ARCH_GCN_1_4_5  },
    { "s_atomic_and_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  168,   ARCH_GCN_1_4_5  },
    { "s_atomic_or_x2",  GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  169,   ARCH_GCN_1_4_5  },
    { "s_atomic_xor_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  170,   ARCH_GCN_1_4_5  },
    { "s_atomic_inc_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  171,   ARCH_GCN_1_4_5  },
    { "s_atomic_dec_x2", GCNENC_SMRD,   GCN_MEMOP_MX2|GCN_MATOMIC,  172,   ARCH_GCN_1_4_5  },
    { "v_cndmask_b32",       GCNENC_VOP2,   GCN_SRC2_VCC,             0,    ARCH_GCN_1_0_1_2_4  },
    { "v_cndmask_b32",       GCNENC_VOP3A,  GCN_SRC2_VCC|GCN_VOP3_VOP2, 256,  ARCH_GCN_1_0_1_2_4  },
    { "v_readlane_b32",      GCNENC_VOP2,   GCN_DS1_SGPR|GCN_VOP_NOWVSZ, 1,    ARCH_GCN_1_0_1  },
    { "v_readlane_b32",      GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01|GCN_VOP3_DS1_SGPR|GCN_VOP_NOWVSZ,        257,  ARCH_GCN_1_0_1  },
    { "v_cndmask_b32",       GCNENC_VOP2,   GCN_SRC2_VCC,             1,    ARCH_GCN_1_5  },
    { "v_cndmask_b32",       GCNENC_VOP3A,  GCN_SRC2_VCC|GCN_VOP3_VOP2, 257,  ARCH_GCN_1_5 },
    { "v_writelane_b32",     GCNENC_VOP2,   GCN_SRC1_SGPR|GCN_VOP_NOWVSZ, 2,    ARCH_GCN_1_0_1  },
    { "v_writelane_b32",     GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01|GCN_VOP3_SRC1_SGPR|GCN_VOP_NOWVSZ,        258,  ARCH_GCN_1_0_1  },
    { "v_dot2c_f32_f16",     GCNENC_VOP2,   GCN_F16LIT,               2,    ARCH_NAVI_DL  },
    { "v_add_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             3,    ARCH_GCN_1_0_1_5  },
    { "v_add_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        259,  ARCH_GCN_1_0_1_5  },
    { "v_sub_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             4,    ARCH_GCN_1_0_1_5  },
    { "v_sub_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        260,  ARCH_GCN_1_0_1_5  },
    { "v_subrev_f32",        GCNENC_VOP2,   GCN_FLOATLIT,             5,    ARCH_GCN_1_0_1_5  },
    { "v_subrev_f32",        GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        261,  ARCH_GCN_1_0_1_5  },
    { "v_mac_legacy_f32",    GCNENC_VOP2,   GCN_FLOATLIT,             6,    ARCH_GCN_1_0_1_5  },
    { "v_mac_legacy_f32",    GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        262,  ARCH_GCN_1_0_1_5  },
    { "v_mul_legacy_f32",    GCNENC_VOP2,   GCN_FLOATLIT,             7,    ARCH_GCN_1_0_1_5  },
    { "v_mul_legacy_f32",    GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        263,  ARCH_GCN_1_0_1_5  },
    { "v_mul_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             8,    ARCH_GCN_1_0_1_5  },
    { "v_mul_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        264,  ARCH_GCN_1_0_1_5  },
    { "v_mul_i32_i24",       GCNENC_VOP2,   GCN_STDMODE,              9,    ARCH_GCN_1_0_1_5  },
    { "v_mul_i32_i24",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       265,  ARCH_GCN_1_0_1_5  },
    { "v_mul_hi_i32_i24",    GCNENC_VOP2,   GCN_STDMODE,              10,   ARCH_GCN_1_0_1_5  },
    { "v_mul_hi_i32_i24",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       266,  ARCH_GCN_1_0_1_5  },
    { "v_mul_u32_u24",       GCNENC_VOP2,   GCN_STDMODE,              11,   ARCH_GCN_1_0_1_5  },
    { "v_mul_u32_u24",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       267,  ARCH_GCN_1_0_1_5  },
    { "v_mul_hi_u32_u24",    GCNENC_VOP2,   GCN_STDMODE,              12,   ARCH_GCN_1_0_1_5  },
    { "v_mul_hi_u32_u24",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       268,  ARCH_GCN_1_0_1_5  },
    { "v_dot4c_i32_i8",      GCNENC_VOP2,   GCN_STDMODE,              13,   ARCH_NAVI_DL  },
    { "v_min_legacy_f32",    GCNENC_VOP2,   GCN_FLOATLIT,             13,   ARCH_GCN_1_0_1  },
    { "v_min_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       269,  ARCH_GCN_1_0_1  },
    { "v_max_legacy_f32",    GCNENC_VOP2,   GCN_FLOATLIT,             14,   ARCH_GCN_1_0_1  },
    { "v_max_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       270,  ARCH_GCN_1_0_1  },
    { "v_min_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             15,   ARCH_GCN_1_0_1_5  },
    { "v_min_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        271,  ARCH_GCN_1_0_1_5  },
    { "v_max_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             16,   ARCH_GCN_1_0_1_5  },
    { "v_max_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        272,  ARCH_GCN_1_0_1_5  },
    { "v_min_i32",           GCNENC_VOP2,   GCN_STDMODE,              17,   ARCH_GCN_1_0_1_5  },
    { "v_min_i32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       273,  ARCH_GCN_1_0_1_5  },
    { "v_max_i32",           GCNENC_VOP2,   GCN_STDMODE,              18,   ARCH_GCN_1_0_1_5  },
    { "v_max_i32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       274,  ARCH_GCN_1_0_1_5  },
    { "v_min_u32",           GCNENC_VOP2,   GCN_STDMODE,              19,   ARCH_GCN_1_0_1_5  },
    { "v_min_u32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       275,  ARCH_GCN_1_0_1_5  },
    { "v_max_u32",           GCNENC_VOP2,   GCN_STDMODE,              20,   ARCH_GCN_1_0_1_5  },
    { "v_max_u32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       276,  ARCH_GCN_1_0_1_5  },
    { "v_lshr_b32",          GCNENC_VOP2,   GCN_STDMODE,              21,   ARCH_GCN_1_0_1  },
    { "v_lshr_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       277,  ARCH_GCN_1_0_1  },
    { "v_lshrrev_b32",       GCNENC_VOP2,   GCN_STDMODE,              22,   ARCH_GCN_1_0_1_5  },
    { "v_lshrrev_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       278,  ARCH_GCN_1_0_1_5  },
    { "v_ashr_i32",          GCNENC_VOP2,   GCN_STDMODE,              23,   ARCH_GCN_1_0_1  },
    { "v_ashr_i32",          GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       279,  ARCH_GCN_1_0_1  },
    { "v_ashrrev_i32",       GCNENC_VOP2,   GCN_STDMODE,              24,   ARCH_GCN_1_0_1_5  },
    { "v_ashrrev_i32",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       280,  ARCH_GCN_1_0_1_5  },
    { "v_lshl_b32",          GCNENC_VOP2,   GCN_STDMODE,              25,   ARCH_GCN_1_0_1  },
    { "v_lshl_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       281,  ARCH_GCN_1_0_1  },
    { "v_lshlrev_b32",       GCNENC_VOP2,   GCN_STDMODE,              26,   ARCH_GCN_1_0_1_5  },
    { "v_lshlrev_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       282,  ARCH_GCN_1_0_1_5  },
    { "v_and_b32",           GCNENC_VOP2,   GCN_STDMODE,              27,   ARCH_GCN_1_0_1_5  },
    { "v_and_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       283,  ARCH_GCN_1_0_1_5  },
    { "v_or_b32",            GCNENC_VOP2,   GCN_STDMODE,              28,   ARCH_GCN_1_0_1_5  },
    { "v_or_b32",            GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       284,  ARCH_GCN_1_0_1_5  },
    { "v_xor_b32",           GCNENC_VOP2,   GCN_STDMODE,              29,   ARCH_GCN_1_0_1_5  },
    { "v_xor_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       285,  ARCH_GCN_1_0_1_5  },
    { "v_xnor_b32",          GCNENC_VOP2,   GCN_STDMODE,              30,   ARCH_GCN_1_5  },
    { "v_xnor_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       286,  ARCH_GCN_1_5  },
    { "v_bfm_b32",           GCNENC_VOP2,   GCN_STDMODE,              30,   ARCH_GCN_1_0_1  },
    { "v_bfm_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       286,  ARCH_GCN_1_0_1  },
    { "v_mac_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             31,   ARCH_GCN_1_0_1_5  },
    { "v_mac_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        287,  ARCH_GCN_1_0_1_5  },
    { "v_madmk_f32",         GCNENC_VOP2,   GCN_FLOATLIT|GCN_ARG1_IMM,32,   ARCH_GCN_1_0_1_5  },
    { "v_madmk_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG1_IMM, 288,  ARCH_GCN_1_0_1_5  },
    { "v_madak_f32",         GCNENC_VOP2,   GCN_FLOATLIT|GCN_ARG2_IMM,33,   ARCH_GCN_1_0_1_5  },
    { "v_madak_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG2_IMM, 289,  ARCH_GCN_1_0_1_5  },
    { "v_bcnt_u32_b32",      GCNENC_VOP2,   GCN_STDMODE,              34,   ARCH_GCN_1_0_1  },
    { "v_bcnt_u32_b32",      GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       290,  ARCH_GCN_1_0_1  },
    { "v_mbcnt_lo_u32_b32",  GCNENC_VOP2,   GCN_STDMODE,              35,   ARCH_GCN_1_0_1  },
    { "v_mbcnt_lo_u32_b32",  GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       291,  ARCH_GCN_1_0_1  },
    { "v_mbcnt_hi_u32_b32",  GCNENC_VOP2,   GCN_STDMODE,              36,   ARCH_GCN_1_0_1  },
    { "v_mbcnt_hi_u32_b32",  GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       292,  ARCH_GCN_1_0_1  },
    { "v_add_i32",           GCNENC_VOP2,   GCN_DST_VCC,              37,   ARCH_GCN_1_0_1  },
    { "v_add_i32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 293,  ARCH_GCN_1_0_1  },
    { "v_add_u32",           GCNENC_VOP2,   GCN_DST_VCC,              37,   ARCH_GCN_1_0_1  },
    { "v_add_u32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 293,  ARCH_GCN_1_0_1  },
    { "v_add_nc_u32",        GCNENC_VOP2,   GCN_STDMODE,              37,   ARCH_GCN_1_5  },
    { "v_add_nc_u32",        GCNENC_VOP3B,  GCN_VOP3_VOP2_DS01,       293,  ARCH_GCN_1_5  },
    { "v_sub_i32",           GCNENC_VOP2,   GCN_DST_VCC,              38,   ARCH_GCN_1_0_1  },
    { "v_sub_i32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 294,  ARCH_GCN_1_0_1  },
    { "v_sub_u32",           GCNENC_VOP2,   GCN_DST_VCC,              38,   ARCH_GCN_1_0_1  },
    { "v_sub_u32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 294,  ARCH_GCN_1_0_1  },
    { "v_sub_nc_u32",        GCNENC_VOP2,   GCN_STDMODE,              38,   ARCH_GCN_1_5  },
    { "v_sub_nc_u32",        GCNENC_VOP3B,  GCN_VOP3_VOP2_DS01,       294,  ARCH_GCN_1_5  },
    { "v_subrev_i32",        GCNENC_VOP2,   GCN_DST_VCC,              39,   ARCH_GCN_1_0_1  },
    { "v_subrev_i32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 295,  ARCH_GCN_1_0_1  },
    { "v_subrev_u32",        GCNENC_VOP2,   GCN_DST_VCC,              39,   ARCH_GCN_1_0_1  },
    { "v_subrev_u32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 295,  ARCH_GCN_1_0_1  },
    { "v_subrev_nc_u32",     GCNENC_VOP2,   GCN_STDMODE,              39,   ARCH_GCN_1_5  },
    { "v_subrev_nc_u32",     GCNENC_VOP3B,  GCN_VOP3_VOP2_DS01,       295,  ARCH_GCN_1_5  },
    { "v_addc_u32",          GCNENC_VOP2,   GCN_DS2_VCC,              40,   ARCH_GCN_1_0_1_5  },
    { "v_addc_u32",          GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 296,  ARCH_GCN_1_0_1_5  },
    { "v_add_co_ci_u32",     GCNENC_VOP2,   GCN_DS2_VCC,              40,   ARCH_GCN_1_5  },
    { "v_add_co_ci_u32",     GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 296,  ARCH_GCN_1_5  },
    { "v_subb_u32",          GCNENC_VOP2,   GCN_DS2_VCC,              41,   ARCH_GCN_1_0_1_5  },
    { "v_subb_u32",          GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 297,  ARCH_GCN_1_0_1_5  },
    { "v_sub_co_ci_u32",     GCNENC_VOP2,   GCN_DS2_VCC,              41,   ARCH_GCN_1_5  },
    { "v_sub_co_ci_u32",     GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 297,  ARCH_GCN_1_5  },
    { "v_subbrev_u32",       GCNENC_VOP2,   GCN_DS2_VCC,              42,   ARCH_GCN_1_0_1_5  },
    { "v_subbrev_u32",       GCNENC_VOP3B,  GCN_DS2_VCC| GCN_VOP3_VOP2, 298,  ARCH_GCN_1_0_1_5  },
    { "v_subrev_co_ci_u32",  GCNENC_VOP2,   GCN_DS2_VCC,              42,   ARCH_GCN_1_5  },
    { "v_subrev_co_ci_u32",  GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 298,  ARCH_GCN_1_5  },
    { "v_ldexp_f32",         GCNENC_VOP2,   GCN_FLOATLIT,             43,   ARCH_GCN_1_0_1  },
    { "v_ldexp_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       299,  ARCH_GCN_1_0_1  },
    { "v_cvt_pkaccum_u8_f32",GCNENC_VOP2,   GCN_FLOATLIT,             44,   ARCH_GCN_1_0_1  },
    { "v_cvt_pkaccum_u8_f32",GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       300,  ARCH_GCN_1_0_1  },
    { "v_cvt_pknorm_i16_f32",GCNENC_VOP2,   GCN_FLOATLIT,             45,   ARCH_GCN_1_0_1  },
    { "v_cvt_pknorm_i16_f32",GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       301,  ARCH_GCN_1_0_1  },
    { "v_cvt_pknorm_u16_f32",GCNENC_VOP2,   GCN_FLOATLIT,             46,   ARCH_GCN_1_0_1  },
    { "v_cvt_pknorm_u16_f32",GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       302,  ARCH_GCN_1_0_1  },
    { "v_cvt_pkrtz_f16_f32", GCNENC_VOP2,   GCN_FLOATLIT,             47,   ARCH_GCN_1_0_1_5  },
    { "v_cvt_pkrtz_f16_f32", GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        303,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_pk_u16_u32",    GCNENC_VOP2,   GCN_STDMODE,              48,   ARCH_GCN_1_0_1  },
    { "v_cvt_pk_u16_u32",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       304,  ARCH_GCN_1_0_1  },
    { "v_cvt_pk_i16_i32",    GCNENC_VOP2,   GCN_STDMODE,              49,   ARCH_GCN_1_0_1  },
    { "v_cvt_pk_i16_i32",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       305,  ARCH_GCN_1_0_1  },
    { "v_add_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             1,    ARCH_GCN_1_2_4  },
    { "v_add_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       257,  ARCH_GCN_1_2_4  },
    { "v_sub_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             2,    ARCH_GCN_1_2_4  },
    { "v_sub_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       258,  ARCH_GCN_1_2_4  },
    { "v_subrev_f32",        GCNENC_VOP2,   GCN_FLOATLIT,             3,    ARCH_GCN_1_2_4  },
    { "v_subrev_f32",        GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       259,  ARCH_GCN_1_2_4  },
    { "v_mul_legacy_f32",    GCNENC_VOP2,   GCN_FLOATLIT,             4,    ARCH_GCN_1_2_4  },
    { "v_mul_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       260,  ARCH_GCN_1_2_4  },
    { "v_mul_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             5,    ARCH_GCN_1_2_4  },
    { "v_mul_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       261,  ARCH_GCN_1_2_4  },
    { "v_mul_i32_i24",       GCNENC_VOP2,   GCN_STDMODE,              6,    ARCH_GCN_1_2_4  },
    { "v_mul_i32_i24",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       262,  ARCH_GCN_1_2_4  },
    { "v_mul_hi_i32_i24",    GCNENC_VOP2,   GCN_STDMODE,              7,    ARCH_GCN_1_2_4  },
    { "v_mul_hi_i32_i24",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       263,  ARCH_GCN_1_2_4  },
    { "v_mul_u32_u24",       GCNENC_VOP2,   GCN_STDMODE,              8,    ARCH_GCN_1_2_4  },
    { "v_mul_u32_u24",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       264,  ARCH_GCN_1_2_4  },
    { "v_mul_hi_u32_u24",    GCNENC_VOP2,   GCN_STDMODE,              9,    ARCH_GCN_1_2_4  },
    { "v_mul_hi_u32_u24",    GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       265,  ARCH_GCN_1_2_4  },
    { "v_min_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             10,   ARCH_GCN_1_2_4  },
    { "v_min_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       266,  ARCH_GCN_1_2_4  },
    { "v_max_f32",           GCNENC_VOP2,   GCN_FLOATLIT,             11,   ARCH_GCN_1_2_4  },
    { "v_max_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       267,  ARCH_GCN_1_2_4  },
    { "v_min_i32",           GCNENC_VOP2,   GCN_STDMODE,              12,   ARCH_GCN_1_2_4  },
    { "v_min_i32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       268,  ARCH_GCN_1_2_4  },
    { "v_max_i32",           GCNENC_VOP2,   GCN_STDMODE,              13,   ARCH_GCN_1_2_4  },
    { "v_max_i32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       269,  ARCH_GCN_1_2_4  },
    { "v_min_u32",           GCNENC_VOP2,   GCN_STDMODE,              14,   ARCH_GCN_1_2_4  },
    { "v_min_u32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       270,  ARCH_GCN_1_2_4  },
    { "v_max_u32",           GCNENC_VOP2,   GCN_STDMODE,              15,   ARCH_GCN_1_2_4  },
    { "v_max_u32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       271,  ARCH_GCN_1_2_4  },
    { "v_lshrrev_b32",       GCNENC_VOP2,   GCN_STDMODE,              16,   ARCH_GCN_1_2_4  },
    { "v_lshrrev_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       272,  ARCH_GCN_1_2_4  },
    { "v_ashrrev_i32",       GCNENC_VOP2,   GCN_STDMODE,              17,   ARCH_GCN_1_2_4  },
    { "v_ashrrev_i32",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       273,  ARCH_GCN_1_2_4  },
    { "v_lshlrev_b32",       GCNENC_VOP2,   GCN_STDMODE,              18,   ARCH_GCN_1_2_4  },
    { "v_lshlrev_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       274,  ARCH_GCN_1_2_4  },
    { "v_and_b32",           GCNENC_VOP2,   GCN_STDMODE,              19,   ARCH_GCN_1_2_4  },
    { "v_and_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       275,  ARCH_GCN_1_2_4  },
    { "v_or_b32",            GCNENC_VOP2,   GCN_STDMODE,              20,   ARCH_GCN_1_2_4  },
    { "v_or_b32",            GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       276,  ARCH_GCN_1_2_4  },
    { "v_xor_b32",           GCNENC_VOP2,   GCN_STDMODE,              21,   ARCH_GCN_1_2_4  },
    { "v_xor_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       277,  ARCH_GCN_1_2_4  },
    { "v_mac_f32",           GCNENC_VOP2,   GCN_FLOATLIT|GCN_VOP_NOSDWAVEGA, 22,   ARCH_GCN_1_2_4  },
    { "v_mac_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       278,  ARCH_GCN_1_2_4  },
    { "v_madmk_f32",         GCNENC_VOP2,   GCN_FLOATLIT|GCN_ARG1_IMM|GCN_VOP_NODPPSDWA,        23,   ARCH_GCN_1_2_4  },
    { "v_madmk_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG1_IMM, 279,  ARCH_GCN_1_2_4  },
    { "v_madak_f32",         GCNENC_VOP2,   GCN_FLOATLIT|GCN_ARG2_IMM|GCN_VOP_NODPPSDWA,        24,   ARCH_GCN_1_2_4  },
    { "v_madak_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG2_IMM, 280,  ARCH_GCN_1_2_4  },
    { "v_add_u32",           GCNENC_VOP2,   GCN_DST_VCC,              25,   ARCH_RX3X0  },
    { "v_add_u32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 281,  ARCH_RX3X0  },
    { "v_add_i32",           GCNENC_VOP2,   GCN_DST_VCC,              25,   ARCH_RX3X0  },
    { "v_add_i32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 281,  ARCH_RX3X0  },
    { "v_sub_u32",           GCNENC_VOP2,   GCN_DST_VCC,              26,   ARCH_RX3X0  },
    { "v_sub_u32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 282,  ARCH_RX3X0  },
    { "v_sub_i32",           GCNENC_VOP2,   GCN_DST_VCC,              26,   ARCH_RX3X0  },
    { "v_sub_i32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 282,  ARCH_RX3X0  },
    { "v_subrev_u32",        GCNENC_VOP2,   GCN_DST_VCC,              27,   ARCH_RX3X0  },
    { "v_subrev_u32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 283,  ARCH_RX3X0  },
    { "v_subrev_i32",        GCNENC_VOP2,   GCN_DST_VCC,              27,   ARCH_RX3X0  },
    { "v_subrev_i32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 283,  ARCH_RX3X0  },
    { "v_addc_u32",          GCNENC_VOP2,   GCN_DS2_VCC,              28,   ARCH_RX3X0  },
    { "v_addc_u32",          GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 284,  ARCH_RX3X0  },
    { "v_subb_u32",          GCNENC_VOP2,   GCN_DS2_VCC,              29,   ARCH_RX3X0  },
    { "v_subb_u32",          GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 285,  ARCH_RX3X0  },
    { "v_subbrev_u32",       GCNENC_VOP2,   GCN_DS2_VCC,              30,   ARCH_RX3X0  },
    { "v_subbrev_u32",       GCNENC_VOP3B,  GCN_DS2_VCC| GCN_VOP3_VOP2, 286,  ARCH_RX3X0  },
    { "v_add_co_u32",           GCNENC_VOP2,   GCN_DST_VCC,              25,   ARCH_GCN_1_4  },
    { "v_add_co_u32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 281,  ARCH_GCN_1_4  },
    { "v_sub_co_u32",           GCNENC_VOP2,   GCN_DST_VCC,              26,   ARCH_GCN_1_4  },
    { "v_sub_co_u32",           GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 282,  ARCH_GCN_1_4  },
    { "v_subrev_co_u32",        GCNENC_VOP2,   GCN_DST_VCC,              27,   ARCH_GCN_1_4  },
    { "v_subrev_co_u32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_VOP3_VOP2, 283,  ARCH_GCN_1_4  },
    { "v_addc_co_u32",          GCNENC_VOP2,   GCN_DS2_VCC,              28,   ARCH_GCN_1_4  },
    { "v_addc_co_u32",          GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 284,  ARCH_GCN_1_4  },
    { "v_subb_co_u32",          GCNENC_VOP2,   GCN_DS2_VCC,              29,   ARCH_GCN_1_4  },
    { "v_subb_co_u32",          GCNENC_VOP3B,  GCN_DS2_VCC|GCN_VOP3_VOP2, 285,  ARCH_GCN_1_4  },
    { "v_subbrev_co_u32",       GCNENC_VOP2,   GCN_DS2_VCC,              30,   ARCH_GCN_1_4  },
    { "v_subbrev_co_u32",       GCNENC_VOP3B,  GCN_DS2_VCC| GCN_VOP3_VOP2, 286,  ARCH_GCN_1_4  },
    { "v_add_f16",           GCNENC_VOP2,   GCN_F16LIT,               31,    ARCH_GCN_1_2_4  },
    { "v_add_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       287,  ARCH_GCN_1_2_4  },
    { "v_sub_f16",           GCNENC_VOP2,   GCN_F16LIT,               32,    ARCH_GCN_1_2_4  },
    { "v_sub_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       288,  ARCH_GCN_1_2_4  },
    { "v_subrev_f16",        GCNENC_VOP2,   GCN_F16LIT,               33,    ARCH_GCN_1_2_4  },
    { "v_subrev_f16",        GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       289,  ARCH_GCN_1_2_4  },
    { "v_mul_f16",           GCNENC_VOP2,   GCN_F16LIT,               34,    ARCH_GCN_1_2_4  },
    { "v_mul_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       290,  ARCH_GCN_1_2_4  },
    { "v_mac_f16",           GCNENC_VOP2,   GCN_F16LIT|GCN_VOP_NOSDWAVEGA, 35,    ARCH_GCN_1_2_4  },
    { "v_mac_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       291,  ARCH_GCN_1_2_4  },
    { "v_madmk_f16",         GCNENC_VOP2,   GCN_F16LIT|GCN_ARG1_IMM|GCN_VOP_NODPPSDWA,        36,   ARCH_GCN_1_2_4  },
    { "v_madmk_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG1_IMM, 292,  ARCH_GCN_1_2_4  },
    { "v_madak_f16",         GCNENC_VOP2,   GCN_F16LIT|GCN_ARG2_IMM|GCN_VOP_NODPPSDWA,        37,   ARCH_GCN_1_2_4  },
    { "v_madak_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG2_IMM, 293,  ARCH_GCN_1_2_4  },
    { "v_add_u16",           GCNENC_VOP2,   GCN_STDMODE,              38,   ARCH_GCN_1_2_4  },
    { "v_add_u16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       294,  ARCH_GCN_1_2_4  },
    { "v_sub_u16",           GCNENC_VOP2,   GCN_STDMODE,              39,   ARCH_GCN_1_2_4  },
    { "v_sub_u16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       295,  ARCH_GCN_1_2_4  },
    { "v_subrev_u16",        GCNENC_VOP2,   GCN_STDMODE,              40,   ARCH_GCN_1_2_4  },
    { "v_subrev_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       296,  ARCH_GCN_1_2_4  },
    { "v_mul_lo_u16",        GCNENC_VOP2,   GCN_STDMODE,              41,   ARCH_GCN_1_2_4  },
    { "v_mul_lo_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       297,  ARCH_GCN_1_2_4  },
    { "v_lshlrev_b16",       GCNENC_VOP2,   GCN_STDMODE,              42,   ARCH_GCN_1_2_4  },
    { "v_lshlrev_b16",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       298,  ARCH_GCN_1_2_4  },
    { "v_lshrrev_b16",       GCNENC_VOP2,   GCN_STDMODE,              43,   ARCH_GCN_1_2_4  },
    { "v_lshrrev_b16",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       299,  ARCH_GCN_1_2_4  },
    { "v_ashrrev_i16",       GCNENC_VOP2,   GCN_STDMODE,              44,   ARCH_GCN_1_2_4  },
    { "v_ashrrev_i16",       GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       300,  ARCH_GCN_1_2_4  },
    { "v_max_f16",           GCNENC_VOP2,   GCN_F16LIT,               45,   ARCH_GCN_1_2_4  },
    { "v_max_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       301,  ARCH_GCN_1_2_4  },
    { "v_min_f16",           GCNENC_VOP2,   GCN_F16LIT,               46,   ARCH_GCN_1_2_4  },
    { "v_min_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       302,  ARCH_GCN_1_2_4  },
    { "v_max_u16",           GCNENC_VOP2,   GCN_STDMODE,              47,   ARCH_GCN_1_2_4  },
    { "v_max_u16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       303,  ARCH_GCN_1_2_4  },
    { "v_max_i16",           GCNENC_VOP2,   GCN_STDMODE,              48,   ARCH_GCN_1_2_4  },
    { "v_max_i16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       304,  ARCH_GCN_1_2_4  },
    { "v_min_u16",           GCNENC_VOP2,   GCN_STDMODE,              49,   ARCH_GCN_1_2_4  },
    { "v_min_u16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       305,  ARCH_GCN_1_2_4  },
    { "v_min_i16",           GCNENC_VOP2,   GCN_STDMODE,              50,   ARCH_GCN_1_2_4  },
    { "v_min_i16",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       306,  ARCH_GCN_1_2_4  },
    { "v_ldexp_f16",         GCNENC_VOP2,   GCN_F16LIT,               51,   ARCH_GCN_1_2_4  },
    { "v_ldexp_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       307,  ARCH_GCN_1_2_4  },
    { "v_add_u32",           GCNENC_VOP2,   GCN_STDMODE,              52,   ARCH_GCN_1_4  },
    { "v_add_u32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       308,  ARCH_GCN_1_4  },
    { "v_sub_u32",           GCNENC_VOP2,   GCN_STDMODE,              53,   ARCH_GCN_1_4  },
    { "v_sub_u32",           GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       309,  ARCH_GCN_1_4  },
    { "v_subrev_u32",        GCNENC_VOP2,   GCN_STDMODE,              54,   ARCH_GCN_1_4  },
    { "v_subrev_u32",        GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       310,  ARCH_GCN_1_4  },
    { "v_fmac_f32",          GCNENC_VOP2,   GCN_FLOATLIT|GCN_VOP_NOSDWA, 59,  ARCH_VEGA20  },
    { "v_fmac_f32",          GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       315, ARCH_VEGA20  },
    { "v_xnor_b32",          GCNENC_VOP2,   GCN_STDMODE,              61,   ARCH_VEGA20  },
    { "v_xnor_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       317,  ARCH_VEGA20  },
    { "v_fmac_f32",          GCNENC_VOP2,   GCN_FLOATLIT|GCN_VOP_NOSDWA, 43,  ARCH_GCN_1_5  },
    { "v_fmac_f32",          GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP2_DS01,        299, ARCH_GCN_1_5  },
    { "v_fmamk_f32",         GCNENC_VOP2,   GCN_FLOATLIT|GCN_ARG1_IMM,44,   ARCH_GCN_1_0_1_5  },
    { "v_fmamk_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG1_IMM, 300,  ARCH_GCN_1_0_1_5  },
    { "v_fmaak_f32",         GCNENC_VOP2,   GCN_FLOATLIT|GCN_ARG2_IMM,45,   ARCH_GCN_1_0_1_5  },
    { "v_fmaak_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG2_IMM, 301,  ARCH_GCN_1_0_1_5  },
    { "v_add_f16",           GCNENC_VOP2,   GCN_F16LIT,               50,    ARCH_GCN_1_5  },
    { "v_add_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        306,  ARCH_GCN_1_5  },
    { "v_sub_f16",           GCNENC_VOP2,   GCN_F16LIT,               51,    ARCH_GCN_1_5  },
    { "v_sub_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        307,  ARCH_GCN_1_5  },
    { "v_subrev_f16",        GCNENC_VOP2,   GCN_F16LIT,               52,    ARCH_GCN_1_5  },
    { "v_subrev_f16",        GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        308,  ARCH_GCN_1_5  },
    { "v_mul_f16",           GCNENC_VOP2,   GCN_F16LIT,               53,    ARCH_GCN_1_5  },
    { "v_mul_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        309,  ARCH_GCN_1_5  },
    { "v_fmac_f16",          GCNENC_VOP2,   GCN_F16LIT|GCN_VOP_NOSDWA, 54,    ARCH_GCN_1_5  },
    { "v_fmac_f16",          GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        310,  ARCH_GCN_1_5  },
    { "v_fmamk_f16",         GCNENC_VOP2,   GCN_F16LIT|GCN_ARG1_IMM,55,   ARCH_GCN_1_5  },
    { "v_fmamk_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG1_IMM, 311,  ARCH_GCN_1_5  },
    { "v_fmaak_f16",         GCNENC_VOP2,   GCN_F16LIT|GCN_ARG2_IMM,56,   ARCH_GCN_1_5  },
    { "v_fmaak_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP2|GCN_ARG2_IMM, 312,  ARCH_GCN_1_5  },
    { "v_max_f16",           GCNENC_VOP2,   GCN_F16LIT,               57,   ARCH_GCN_1_5  },
    { "v_max_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        313,  ARCH_GCN_1_5  },
    { "v_min_f16",           GCNENC_VOP2,   GCN_F16LIT,               58,   ARCH_GCN_1_5  },
    { "v_min_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        314,  ARCH_GCN_1_5  },
    { "v_ldexp_f16",         GCNENC_VOP2,   GCN_F16LIT,               59,   ARCH_GCN_1_5  },
    { "v_ldexp_f16",         GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP2_DS01,        315,  ARCH_GCN_1_5  },
    { "v_pk_fmac_f16",       GCNENC_VOP2,   GCN_F16LIT,               60,   ARCH_GCN_1_5  },
    { "v_nop",               GCNENC_VOP1,   GCN_VOP_ARG_NONE,         0,    ARCH_GCN_ALL  },
    { "v_nop",               GCNENC_VOP3A,  GCN_VOP_ARG_NONE|GCN_VOP3_VOP1, 320,  ARCH_GCN_1_2_4  },
    { "v_nop",             GCNENC_VOP3A,  GCN_VOP_ARG_NONE|GCN_VOP3_VOP1, 384,  ARCH_GCN_1_0_1_5  },
    { "v_mov_b32",           GCNENC_VOP1,   GCN_STDMODE,              1,    ARCH_GCN_ALL  },
    { "v_mov_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        321,  ARCH_GCN_1_2_4  },
    { "v_mov_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        385,  ARCH_GCN_1_0_1_5  },
    { "v_readfirstlane_b32", GCNENC_VOP1,   GCN_STDMODE|GCN_DST_SGPR|GCN_VOP_NODPPSDWA,        2,    ARCH_GCN_ALL  },
    { "v_readfirstlane_b32", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_VOP3_DST_SGPR, 322,  ARCH_GCN_1_2_4  },
    { "v_readfirstlane_b32", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_VOP3_DST_SGPR,        386, ARCH_GCN_1_0_1_5  },
    { "v_cvt_i32_f64",       GCNENC_VOP1,   GCN_REG_SRC0_64|GCN_VOP_NODPP, 3,    ARCH_GCN_ALL  },
    { "v_cvt_i32_f64",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64 ,323,  ARCH_GCN_1_2_4  },
    { "v_cvt_i32_f64",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64 ,        387,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f64_i32",       GCNENC_VOP1,   GCN_REG_DST_64|GCN_VOP_NODPP, 4,    ARCH_GCN_ALL  },
    { "v_cvt_f64_i32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DST_64 ,324,  ARCH_GCN_1_2_4  },
    { "v_cvt_f64_i32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DST_64 ,        388,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_i32",       GCNENC_VOP1,   GCN_STDMODE,              5,    ARCH_GCN_ALL  },
    { "v_cvt_f32_i32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        325,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_i32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        389,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_u32",       GCNENC_VOP1,   GCN_STDMODE,              6,    ARCH_GCN_ALL  },
    { "v_cvt_f32_u32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        326,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_u32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        390,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_u32_f32",       GCNENC_VOP1,   GCN_FLOATLIT,             7,    ARCH_GCN_ALL  },
    { "v_cvt_u32_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        327,  ARCH_GCN_1_2_4  },
    { "v_cvt_u32_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        391,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_i32_f32",       GCNENC_VOP1,   GCN_FLOATLIT,             8,    ARCH_GCN_ALL  },
    { "v_cvt_i32_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        328,  ARCH_GCN_1_2_4  },
    { "v_cvt_i32_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        392,  ARCH_GCN_1_0_1_5  },
    { "v_mov_fed_b32",       GCNENC_VOP1,   GCN_STDMODE,              9,    ARCH_GCN_ALL  },
    { "v_mov_fed_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        329,  ARCH_GCN_1_2_4  },
    { "v_mov_fed_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        393,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f16_f32",       GCNENC_VOP1,   GCN_FLOATLIT,             10,   ARCH_GCN_ALL  },
    { "v_cvt_f16_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        330,  ARCH_GCN_1_2_4  },
    { "v_cvt_f16_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        394,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_f16",       GCNENC_VOP1,   GCN_F16LIT,               11,   ARCH_GCN_ALL  },
    { "v_cvt_f32_f16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        331,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        395,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_rpi_i32_f32",   GCNENC_VOP1,   GCN_FLOATLIT,             12,   ARCH_GCN_ALL  },
    { "v_cvt_rpi_i32_f32",   GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        332,  ARCH_GCN_1_2_4  },
    { "v_cvt_rpi_i32_f32",   GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        396,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_flr_i32_f32",   GCNENC_VOP1,   GCN_FLOATLIT,             13,   ARCH_GCN_ALL  },
    { "v_cvt_flr_i32_f32",   GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        333,  ARCH_GCN_1_2_4  },
    { "v_cvt_flr_i32_f32",   GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        397,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_off_f32_i4",    GCNENC_VOP1,   GCN_STDMODE,              14,   ARCH_GCN_ALL  },
    { "v_cvt_off_f32_i4",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        334,  ARCH_GCN_1_2_4  },
    { "v_cvt_off_f32_i4",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        398,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_f64",       GCNENC_VOP1,   GCN_REG_SRC0_64|GCN_VOP_NODPP, 15,   ARCH_GCN_ALL  },
    { "v_cvt_f32_f64",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64,335,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_f64",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64,            399,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f64_f32",       GCNENC_VOP1,   GCN_REG_DST_64|GCN_FLOATLIT|GCN_VOP_NODPP,            16,   ARCH_GCN_ALL  },
    { "v_cvt_f64_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DST_64,336,  ARCH_GCN_1_2_4  },
    { "v_cvt_f64_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_FLOATLIT|GCN_REG_DST_64,            400,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_ubyte0",    GCNENC_VOP1,   GCN_STDMODE,              17,   ARCH_GCN_ALL  },
    { "v_cvt_f32_ubyte0",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        337,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_ubyte0",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        401,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_ubyte1",    GCNENC_VOP1,   GCN_STDMODE,              18,   ARCH_GCN_ALL  },
    { "v_cvt_f32_ubyte1",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        338,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_ubyte1",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        402,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_ubyte2",    GCNENC_VOP1,   GCN_STDMODE,              19,   ARCH_GCN_ALL  },
    { "v_cvt_f32_ubyte2",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        339,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_ubyte2",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        403,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f32_ubyte3",    GCNENC_VOP1,   GCN_STDMODE,              20,   ARCH_GCN_ALL  },
    { "v_cvt_f32_ubyte3",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        340,  ARCH_GCN_1_2_4  },
    { "v_cvt_f32_ubyte3",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        404,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_u32_f64",       GCNENC_VOP1,   GCN_REG_SRC0_64|GCN_VOP_NODPP, 21,   ARCH_GCN_ALL  },
    { "v_cvt_u32_f64",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64,341,  ARCH_GCN_1_2_4  },
    { "v_cvt_u32_f64",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64,        405,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_f64_u32",       GCNENC_VOP1,   GCN_REG_DST_64|GCN_VOP_NODPP, 22,   ARCH_GCN_ALL  },
    { "v_cvt_f64_u32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DST_64,342,  ARCH_GCN_1_2_4  },
    { "v_cvt_f64_u32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DST_64,        406,  ARCH_GCN_1_0_1_5  },
    { "v_trunc_f64",         GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 23, ARCH_GCN_1_1_2_4_5 },
    { "v_trunc_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 343,  ARCH_GCN_1_2_4  },
    { "v_trunc_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 407, ARCH_GCN_1_1_5 },
    { "v_ceil_f64",          GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 24, ARCH_GCN_1_1_2_4_5 },
    { "v_ceil_f64",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 344,  ARCH_GCN_1_2_4  },
    { "v_ceil_f64",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 408, ARCH_GCN_1_1_5 },
    { "v_rndne_f64",         GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 25, ARCH_GCN_1_1_2_4_5 },
    { "v_rndne_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 345,  ARCH_GCN_1_2_4  },
    { "v_rndne_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 409, ARCH_GCN_1_1_5 },
    { "v_floor_f64",         GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 26, ARCH_GCN_1_1_2_4_5 },
    { "v_floor_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 346,  ARCH_GCN_1_2_4  },
    { "v_floor_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64, 410, ARCH_GCN_1_1_5 },
    { "v_pipeflush",         GCNENC_VOP1,   GCN_VOP_ARG_NONE,         27,   ARCH_GCN_1_5 },
    { "v_pipeflush",         GCNENC_VOP3A,  GCN_VOP_ARG_NONE|GCN_VOP3_VOP1, 411,  ARCH_GCN_1_5  },
    { "v_fract_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             32,   ARCH_GCN_1_0_1_5  },
    { "v_fract_f32",         GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        416,  ARCH_GCN_1_0_1_5  },
    { "v_trunc_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             33,   ARCH_GCN_1_0_1_5  },
    { "v_trunc_f32",         GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        417,  ARCH_GCN_1_0_1_5  },
    { "v_ceil_f32",          GCNENC_VOP1,   GCN_FLOATLIT,             34,   ARCH_GCN_1_0_1_5  },
    { "v_ceil_f32",          GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        418,  ARCH_GCN_1_0_1_5  },
    { "v_rndne_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             35,   ARCH_GCN_1_0_1_5  },
    { "v_rndne_f32",         GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        419,  ARCH_GCN_1_0_1_5  },
    { "v_floor_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             36,   ARCH_GCN_1_0_1_5  },
    { "v_floor_f32",         GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        420,  ARCH_GCN_1_0_1_5  },
    { "v_exp_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             37,   ARCH_GCN_1_0_1_5  },
    { "v_exp_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        421,  ARCH_GCN_1_0_1_5  },
    { "v_log_clamp_f32",     GCNENC_VOP1,   GCN_FLOATLIT,             38,   ARCH_GCN_1_0_1  },
    { "v_log_clamp_f32",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        422,  ARCH_GCN_1_0_1  },
    { "v_log_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             39,   ARCH_GCN_1_0_1_5  },
    { "v_log_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        423,  ARCH_GCN_1_0_1_5  },
    { "v_rcp_clamp_f32",     GCNENC_VOP1,   GCN_FLOATLIT,             40,   ARCH_GCN_1_0_1  },
    { "v_rcp_clamp_f32",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        424,  ARCH_GCN_1_0_1  },
    { "v_rcp_legacy_f32",    GCNENC_VOP1,   GCN_FLOATLIT,             41,   ARCH_GCN_1_0_1  },
    { "v_rcp_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        425,  ARCH_GCN_1_0_1  },
    { "v_rcp_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             42,   ARCH_GCN_1_0_1_5  },
    { "v_rcp_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        426,  ARCH_GCN_1_0_1_5  },
    { "v_rcp_iflag_f32",     GCNENC_VOP1,   GCN_FLOATLIT,             43,   ARCH_GCN_1_0_1_5  },
    { "v_rcp_iflag_f32",     GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        427,  ARCH_GCN_1_0_1_5  },
    { "v_rsq_clamp_f32",     GCNENC_VOP1,   GCN_FLOATLIT,             44,   ARCH_GCN_1_0_1  },
    { "v_rsq_clamp_f32",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        428,  ARCH_GCN_1_0_1  },
    { "v_rsq_legacy_f32",    GCNENC_VOP1,   GCN_FLOATLIT,             45,   ARCH_GCN_1_0_1  },
    { "v_rsq_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        429,  ARCH_GCN_1_0_1  },
    { "v_rsq_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             46,   ARCH_GCN_1_0_1_5  },
    { "v_rsq_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        430,  ARCH_GCN_1_0_1_5  },
    { "v_rcp_f64",           GCNENC_VOP1,   GCN_REG_DS0_64,           47,   ARCH_GCN_1_0_1_5  },
    { "v_rcp_f64",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,        431, ARCH_GCN_1_0_1_5  },
    { "v_rcp_clamp_f64",     GCNENC_VOP1,   GCN_REG_DS0_64,           48,   ARCH_GCN_1_0_1  },
    { "v_rcp_clamp_f64",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,432,  ARCH_GCN_1_0_1  },
    { "v_rsq_f64",           GCNENC_VOP1,   GCN_REG_DS0_64,           49,   ARCH_GCN_1_0_1_5  },
    { "v_rsq_f64",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,        433,  ARCH_GCN_1_0_1_5  },
    { "v_rsq_clamp_f64",     GCNENC_VOP1,   GCN_REG_DS0_64,           50,   ARCH_GCN_1_0_1  },
    { "v_rsq_clamp_f64",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,434,  ARCH_GCN_1_0_1  },
    { "v_sqrt_f32",          GCNENC_VOP1,   GCN_FLOATLIT,             51,   ARCH_GCN_1_0_1_5  },
    { "v_sqrt_f32",          GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        435,  ARCH_GCN_1_0_1_5  },
    { "v_sqrt_f64",          GCNENC_VOP1,   GCN_REG_DS0_64,           52,   ARCH_GCN_1_0_1_5  },
    { "v_sqrt_f64",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,        436,  ARCH_GCN_1_0_1_5  },
    { "v_sin_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             53,   ARCH_GCN_1_0_1_5  },
    { "v_sin_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        437,  ARCH_GCN_1_0_1_5  },
    { "v_cos_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             54,   ARCH_GCN_1_0_1_5  },
    { "v_cos_f32",           GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        438,  ARCH_GCN_1_0_1_5  },
    { "v_not_b32",           GCNENC_VOP1,   GCN_STDMODE,              55,   ARCH_GCN_1_0_1_5  },
    { "v_not_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        439,  ARCH_GCN_1_0_1_5  },
    { "v_bfrev_b32",         GCNENC_VOP1,   GCN_STDMODE,              56,   ARCH_GCN_1_0_1_5  },
    { "v_bfrev_b32",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        440,  ARCH_GCN_1_0_1_5  },
    { "v_ffbh_u32",          GCNENC_VOP1,   GCN_STDMODE,              57,   ARCH_GCN_1_0_1_5  },
    { "v_ffbh_u32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        441,  ARCH_GCN_1_0_1_5  },
    { "v_ffbl_b32",          GCNENC_VOP1,   GCN_STDMODE,              58,   ARCH_GCN_1_0_1_5  },
    { "v_ffbl_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        442,  ARCH_GCN_1_0_1_5  },
    { "v_ffbh_i32",          GCNENC_VOP1,   GCN_STDMODE,              59,   ARCH_GCN_1_0_1_5  },
    { "v_ffbh_i32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        443,  ARCH_GCN_1_0_1_5  },
    { "v_frexp_exp_i32_f64", GCNENC_VOP1,   GCN_REG_SRC0_64,          60,   ARCH_GCN_1_0_1_5  },
    { "v_frexp_exp_i32_f64", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64,        444,  ARCH_GCN_1_0_1_5  },
    { "v_frexp_mant_f64",    GCNENC_VOP1,   GCN_REG_DS0_64,           61,   ARCH_GCN_1_0_1_5  },
    { "v_frexp_mant_f64",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,        445,  ARCH_GCN_1_0_1_5  },
    { "v_fract_f64",         GCNENC_VOP1,   GCN_REG_DS0_64,           62,   ARCH_GCN_1_0_1_5  },
    { "v_fract_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,        446,  ARCH_GCN_1_0_1_5  },
    { "v_frexp_exp_i32_f32", GCNENC_VOP1,   GCN_FLOATLIT,             63,   ARCH_GCN_1_0_1_5  },
    { "v_frexp_exp_i32_f32", GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        447,  ARCH_GCN_1_0_1_5  },
    { "v_frexp_mant_f32",    GCNENC_VOP1,   GCN_FLOATLIT,             64,   ARCH_GCN_1_0_1_5  },
    { "v_frexp_mant_f32",    GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_VOP1_DS0,        448,  ARCH_GCN_1_0_1_5  },
    { "v_clrexcp",           GCNENC_VOP1,   GCN_VOP_ARG_NONE,         65,   ARCH_GCN_1_0_1_5  },
    { "v_clrexcp",           GCNENC_VOP3A,  GCN_VOP_ARG_NONE|GCN_VOP3_VOP1,        449,  ARCH_GCN_1_0_1_5  },
    { "v_movreld_b32",       GCNENC_VOP1,   GCN_STDMODE,              66,   ARCH_GCN_1_0_1_5  },
    { "v_movreld_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        450,  ARCH_GCN_1_0_1_5  },
    { "v_movrels_b32",       GCNENC_VOP1,   GCN_STDMODE,              67,   ARCH_GCN_1_0_1_5  },
    { "v_movrels_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        451,  ARCH_GCN_1_0_1_5  },
    { "v_movrelsd_b32",      GCNENC_VOP1,   GCN_STDMODE,              68,   ARCH_GCN_1_0_1_5  },
    { "v_movrelsd_b32",      GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        452,  ARCH_GCN_1_0_1_5  },
    { "v_log_legacy_f32",    GCNENC_VOP1,   GCN_STDMODE,              69,   ARCH_RX2X0    },
    { "v_log_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        453,  ARCH_RX2X0    },
    { "v_exp_legacy_f32",    GCNENC_VOP1,   GCN_STDMODE,              70,   ARCH_RX2X0    },
    { "v_exp_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        454,  ARCH_RX2X0    },
    { "v_movrelsd_2_b32",    GCNENC_VOP1,   GCN_STDMODE,              72,   ARCH_GCN_1_5  },
    { "v_movrelsd_2_b32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        456,  ARCH_GCN_1_5  },
    { "v_fract_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             27,   ARCH_GCN_1_2_4  },
    { "v_fract_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        347,  ARCH_GCN_1_2_4  },
    { "v_trunc_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             28,   ARCH_GCN_1_2_4  },
    { "v_trunc_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        348,  ARCH_GCN_1_2_4  },
    { "v_ceil_f32",          GCNENC_VOP1,   GCN_FLOATLIT,             29,   ARCH_GCN_1_2_4  },
    { "v_ceil_f32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        349,  ARCH_GCN_1_2_4  },
    { "v_rndne_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             30,   ARCH_GCN_1_2_4  },
    { "v_rndne_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        350,  ARCH_GCN_1_2_4  },
    { "v_floor_f32",         GCNENC_VOP1,   GCN_FLOATLIT,             31,   ARCH_GCN_1_2_4  },
    { "v_floor_f32",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        351,  ARCH_GCN_1_2_4  },
    { "v_exp_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             32,   ARCH_GCN_1_2_4  },
    { "v_exp_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        352,  ARCH_GCN_1_2_4  },
    { "v_log_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             33,   ARCH_GCN_1_2_4  },
    { "v_log_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        353,  ARCH_GCN_1_2_4  },
    { "v_rcp_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             34,   ARCH_GCN_1_2_4  },
    { "v_rcp_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        354,  ARCH_GCN_1_2_4  },
    { "v_rcp_iflag_f32",     GCNENC_VOP1,   GCN_FLOATLIT,             35,   ARCH_GCN_1_2_4  },
    { "v_rcp_iflag_f32",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        355,  ARCH_GCN_1_2_4  },
    { "v_rsq_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             36,   ARCH_GCN_1_2_4  },
    { "v_rsq_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        356,  ARCH_GCN_1_2_4  },
    { "v_rcp_f64",           GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 37,   ARCH_GCN_1_2_4  },
    { "v_rcp_f64",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,357,  ARCH_GCN_1_2_4  },
    { "v_rsq_f64",           GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 38,   ARCH_GCN_1_2_4  },
    { "v_rsq_f64",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,358,  ARCH_GCN_1_2_4  },
    { "v_sqrt_f32",          GCNENC_VOP1,   GCN_FLOATLIT,             39,   ARCH_GCN_1_2_4  },
    { "v_sqrt_f32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        359,  ARCH_GCN_1_2_4  },
    { "v_sqrt_f64",          GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 40,   ARCH_GCN_1_2_4  },
    { "v_sqrt_f64",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,360,  ARCH_GCN_1_2_4  },
    { "v_sin_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             41,   ARCH_GCN_1_2_4  },
    { "v_sin_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        361,  ARCH_GCN_1_2_4  },
    { "v_cos_f32",           GCNENC_VOP1,   GCN_FLOATLIT,             42,   ARCH_GCN_1_2_4  },
    { "v_cos_f32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        362,  ARCH_GCN_1_2_4  },
    { "v_not_b32",           GCNENC_VOP1,   GCN_STDMODE,              43,   ARCH_GCN_1_2_4  },
    { "v_not_b32",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        363,  ARCH_GCN_1_2_4  },
    { "v_bfrev_b32",         GCNENC_VOP1,   GCN_STDMODE,              44,   ARCH_GCN_1_2_4  },
    { "v_bfrev_b32",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        364,  ARCH_GCN_1_2_4  },
    { "v_ffbh_u32",          GCNENC_VOP1,   GCN_STDMODE,              45,   ARCH_GCN_1_2_4  },
    { "v_ffbh_u32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        365,  ARCH_GCN_1_2_4  },
    { "v_ffbl_b32",          GCNENC_VOP1,   GCN_STDMODE,              46,   ARCH_GCN_1_2_4  },
    { "v_ffbl_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        366,  ARCH_GCN_1_2_4  },
    { "v_ffbh_i32",          GCNENC_VOP1,   GCN_STDMODE,              47,   ARCH_GCN_1_2_4  },
    { "v_ffbh_i32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        367,  ARCH_GCN_1_2_4  },
    { "v_frexp_exp_i32_f64", GCNENC_VOP1,   GCN_REG_SRC0_64|GCN_VOP_NODPP, 48,   ARCH_GCN_1_2_4  },
    { "v_frexp_exp_i32_f64", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_SRC0_64,368,  ARCH_GCN_1_2_4  },
    { "v_frexp_mant_f64",    GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 49,   ARCH_GCN_1_2_4  },
    { "v_frexp_mant_f64",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,369,  ARCH_GCN_1_2_4  },
    { "v_fract_f64",         GCNENC_VOP1,   GCN_REG_DS0_64|GCN_VOP_NODPP, 50,   ARCH_GCN_1_2_4  },
    { "v_fract_f64",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0|GCN_REG_DS0_64,370,  ARCH_GCN_1_2_4  },
    { "v_frexp_exp_i32_f32", GCNENC_VOP1,   GCN_FLOATLIT,             51,   ARCH_GCN_1_2_4  },
    { "v_frexp_exp_i32_f32", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        371,  ARCH_GCN_1_2_4  },
    { "v_frexp_mant_f32",    GCNENC_VOP1,   GCN_FLOATLIT,             52,   ARCH_GCN_1_2_4  },
    { "v_frexp_mant_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        372,  ARCH_GCN_1_2_4  },
    { "v_clrexcp",           GCNENC_VOP1,   GCN_VOP_ARG_NONE|GCN_VOP_NODPPSDWA,        53,   ARCH_GCN_1_2_4  },
    { "v_clrexcp",           GCNENC_VOP3A,  GCN_VOP_ARG_NONE|GCN_VOP3_VOP1, 373,  ARCH_GCN_1_2_4  },
    { "v_movreld_b32",       GCNENC_VOP1,   GCN_STDMODE,              54,   ARCH_RX3X0  },
    { "v_movreld_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        374,  ARCH_RX3X0  },
    { "v_movrels_b32",       GCNENC_VOP1,   GCN_STDMODE,              55,   ARCH_RX3X0  },
    { "v_movrels_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        375,  ARCH_RX3X0  },
    { "v_movrelsd_b32",      GCNENC_VOP1,   GCN_STDMODE,              56,   ARCH_RX3X0  },
    { "v_movrelsd_b32",      GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        376,  ARCH_RX3X0  },
    { "v_mov_prsv_b32",      GCNENC_VOP1,   GCN_STDMODE,              54,   ARCH_GCN_1_4  },
    { "v_mov_prsv_b32",      GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        374,  ARCH_GCN_1_4  },
    { "v_screen_partition_4se_b32", GCNENC_VOP1,   GCN_STDMODE,              55,   ARCH_GCN_1_4  },
    { "v_screen_partition_4se_b32", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        375,  ARCH_GCN_1_4  },
    { "v_cvt_f16_u16",       GCNENC_VOP1,   GCN_STDMODE,              57,   ARCH_GCN_1_2_4  },
    { "v_cvt_f16_u16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        377,  ARCH_GCN_1_2_4  },
    { "v_cvt_f16_i16",       GCNENC_VOP1,   GCN_STDMODE,              58,   ARCH_GCN_1_2_4  },
    { "v_cvt_f16_i16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        378,  ARCH_GCN_1_2_4  },
    { "v_cvt_u16_f16",       GCNENC_VOP1,   GCN_F16LIT,               59,   ARCH_GCN_1_2_4  },
    { "v_cvt_u16_f16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        379,  ARCH_GCN_1_2_4  },
    { "v_cvt_i16_f16",       GCNENC_VOP1,   GCN_F16LIT,               60,   ARCH_GCN_1_2_4  },
    { "v_cvt_i16_f16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        380,  ARCH_GCN_1_2_4  },
    { "v_rcp_f16",           GCNENC_VOP1,   GCN_F16LIT,               61,   ARCH_GCN_1_2_4  },
    { "v_rcp_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        381,  ARCH_GCN_1_2_4  },
    { "v_sqrt_f16",          GCNENC_VOP1,   GCN_F16LIT,               62,   ARCH_GCN_1_2_4  },
    { "v_sqrt_f16",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        382,  ARCH_GCN_1_2_4  },
    { "v_rsq_f16",           GCNENC_VOP1,   GCN_F16LIT,               63,   ARCH_GCN_1_2_4  },
    { "v_rsq_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        383,  ARCH_GCN_1_2_4  },
    { "v_log_f16",           GCNENC_VOP1,   GCN_F16LIT,               64,   ARCH_GCN_1_2_4  },
    { "v_log_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        384,  ARCH_GCN_1_2_4  },
    { "v_exp_f16",           GCNENC_VOP1,   GCN_F16LIT,               65,   ARCH_GCN_1_2_4  },
    { "v_exp_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        385,  ARCH_GCN_1_2_4  },
    { "v_frexp_mant_f16",    GCNENC_VOP1,   GCN_F16LIT,               66,   ARCH_GCN_1_2_4  },
    { "v_frexp_mant_f16",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        386,  ARCH_GCN_1_2_4  },
    { "v_frexp_exp_i16_f16", GCNENC_VOP1,   GCN_F16LIT,               67,   ARCH_GCN_1_2_4  },
    { "v_frexp_exp_i16_f16", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        387,  ARCH_GCN_1_2_4  },
    { "v_floor_f16",         GCNENC_VOP1,   GCN_F16LIT,               68,   ARCH_GCN_1_2_4  },
    { "v_floor_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        388,  ARCH_GCN_1_2_4  },
    { "v_ceil_f16",          GCNENC_VOP1,   GCN_F16LIT,               69,   ARCH_GCN_1_2_4  },
    { "v_ceil_f16",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        389,  ARCH_GCN_1_2_4  },
    { "v_trunc_f16",         GCNENC_VOP1,   GCN_F16LIT,               70,   ARCH_GCN_1_2_4  },
    { "v_trunc_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        390,  ARCH_GCN_1_2_4  },
    { "v_rndne_f16",         GCNENC_VOP1,   GCN_F16LIT,               71,   ARCH_GCN_1_2_4  },
    { "v_rndne_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        391,  ARCH_GCN_1_2_4  },
    { "v_fract_f16",         GCNENC_VOP1,   GCN_F16LIT,               72,   ARCH_GCN_1_2_4  },
    { "v_fract_f16",         GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        392,  ARCH_GCN_1_2_4  },
    { "v_sin_f16",           GCNENC_VOP1,   GCN_F16LIT,               73,   ARCH_GCN_1_2_4  },
    { "v_sin_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        393,  ARCH_GCN_1_2_4  },
    { "v_cos_f16",           GCNENC_VOP1,   GCN_F16LIT,               74,   ARCH_GCN_1_2_4  },
    { "v_cos_f16",           GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        394,  ARCH_GCN_1_2_4  },
    { "v_exp_legacy_f32",    GCNENC_VOP1,   GCN_FLOATLIT,             75,   ARCH_GCN_1_2_4  },
    { "v_exp_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        395,  ARCH_GCN_1_2_4  },
    { "v_log_legacy_f32",    GCNENC_VOP1,   GCN_FLOATLIT,             76,   ARCH_GCN_1_2_4  },
    { "v_log_legacy_f32",    GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        396,  ARCH_GCN_1_2_4  },
    { "v_cvt_norm_i16_f16",  GCNENC_VOP1,   GCN_F16LIT,               77,   ARCH_GCN_1_4  },
    { "v_cvt_norm_i16_f16",  GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        397,  ARCH_GCN_1_4  },
    { "v_cvt_norm_u16_f16",  GCNENC_VOP1,   GCN_F16LIT,               78,   ARCH_GCN_1_4  },
    { "v_cvt_norm_u16_f16",  GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        398,  ARCH_GCN_1_4  },
    { "v_sat_pk_u8_i16",     GCNENC_VOP1,   GCN_STDMODE,              79,   ARCH_GCN_1_4  },
    { "v_sat_pk_u8_i16",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        399,  ARCH_GCN_1_4  },
    { "v_writelane_regwr_b32", GCNENC_VOP1,   GCN_STDMODE,              80,   ARCH_GCN_1_4  },
    { "v_writelane_regwr_b32", GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        400,  ARCH_GCN_1_4  },
    { "v_swap_b32",          GCNENC_VOP1,   GCN_STDMODE|GCN_VOP_NODPPSDWA, 81,   ARCH_GCN_1_4  },
    { "v_swap_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        401,  ARCH_GCN_1_4  },
    { "v_cvt_f16_u16",       GCNENC_VOP1,   GCN_STDMODE,              80,   ARCH_GCN_1_5  },
    { "v_cvt_f16_u16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        464,  ARCH_GCN_1_5  },
    { "v_cvt_f16_i16",       GCNENC_VOP1,   GCN_STDMODE,              81,   ARCH_GCN_1_5  },
    { "v_cvt_f16_i16",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        465,  ARCH_GCN_1_5  },
    { "v_cvt_u16_f16",       GCNENC_VOP1,   GCN_F16LIT,               82,   ARCH_GCN_1_5  },
    { "v_cvt_u16_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        466,  ARCH_GCN_1_5  },
    { "v_cvt_i16_f16",       GCNENC_VOP1,   GCN_F16LIT,               83,   ARCH_GCN_1_5  },
    { "v_cvt_i16_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        467,  ARCH_GCN_1_5  },
    { "v_rcp_f16",           GCNENC_VOP1,   GCN_F16LIT,               84,   ARCH_GCN_1_5  },
    { "v_rcp_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        468,  ARCH_GCN_1_5  },
    { "v_sqrt_f16",          GCNENC_VOP1,   GCN_F16LIT,               85,   ARCH_GCN_1_5  },
    { "v_sqrt_f16",          GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        469,  ARCH_GCN_1_5  },
    { "v_rsq_f16",           GCNENC_VOP1,   GCN_F16LIT,               86,   ARCH_GCN_1_5  },
    { "v_rsq_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        470,  ARCH_GCN_1_5  },
    { "v_log_f16",           GCNENC_VOP1,   GCN_F16LIT,               87,   ARCH_GCN_1_5  },
    { "v_log_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        471,  ARCH_GCN_1_5  },
    { "v_exp_f16",           GCNENC_VOP1,   GCN_F16LIT,               88,   ARCH_GCN_1_5  },
    { "v_exp_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        472,  ARCH_GCN_1_5  },
    { "v_frexp_mant_f16",    GCNENC_VOP1,   GCN_F16LIT,               89,   ARCH_GCN_1_5  },
    { "v_frexp_mant_f16",    GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        473,  ARCH_GCN_1_5  },
    { "v_frexp_exp_i16_f16", GCNENC_VOP1,   GCN_F16LIT,               90,   ARCH_GCN_1_5  },
    { "v_frexp_exp_i16_f16", GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        474,  ARCH_GCN_1_5  },
    { "v_floor_f16",         GCNENC_VOP1,   GCN_F16LIT,               91,   ARCH_GCN_1_5  },
    { "v_floor_f16",         GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        475,  ARCH_GCN_1_5  },
    { "v_ceil_f16",          GCNENC_VOP1,   GCN_F16LIT,               92,   ARCH_GCN_1_5  },
    { "v_ceil_f16",          GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        476,  ARCH_GCN_1_5  },
    { "v_trunc_f16",         GCNENC_VOP1,   GCN_F16LIT,               93,   ARCH_GCN_1_5  },
    { "v_trunc_f16",         GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        477,  ARCH_GCN_1_5  },
    { "v_rndne_f16",         GCNENC_VOP1,   GCN_F16LIT,               94,   ARCH_GCN_1_5  },
    { "v_rndne_f16",         GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        478,  ARCH_GCN_1_5  },
    { "v_fract_f16",         GCNENC_VOP1,   GCN_F16LIT,               95,   ARCH_GCN_1_5  },
    { "v_fract_f16",         GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        479,  ARCH_GCN_1_5  },
    { "v_sin_f16",           GCNENC_VOP1,   GCN_F16LIT,               96,   ARCH_GCN_1_5  },
    { "v_sin_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        480,  ARCH_GCN_1_5  },
    { "v_cos_f16",           GCNENC_VOP1,   GCN_F16LIT,               97,   ARCH_GCN_1_5  },
    { "v_cos_f16",           GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        481,  ARCH_GCN_1_5  },
    { "v_sat_pk_u8_i16",     GCNENC_VOP1,   GCN_STDMODE,              98,   ARCH_GCN_1_5  },
    { "v_sat_pk_u8_i16",     GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        482,  ARCH_GCN_1_5  },
    { "v_cvt_norm_i16_f16",  GCNENC_VOP1,   GCN_F16LIT,               99,   ARCH_GCN_1_5  },
    { "v_cvt_norm_i16_f16",  GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        483,  ARCH_GCN_1_5  },
    { "v_cvt_norm_u16_f16",  GCNENC_VOP1,   GCN_F16LIT,               100,  ARCH_GCN_1_5  },
    { "v_cvt_norm_u16_f16",  GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VOP1_DS0,        484,  ARCH_GCN_1_5  },
    { "v_swap_b32",          GCNENC_VOP1,   GCN_STDMODE|GCN_VOP_NODPPSDWA, 101,   ARCH_GCN_1_5  },
    { "v_swap_b32",          GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        485,  ARCH_GCN_1_5  },
    { "v_swaprel_b32",       GCNENC_VOP1,   GCN_STDMODE|GCN_VOP_NODPPSDWA, 104,   ARCH_GCN_1_5  },
    { "v_swaprel_b32",       GCNENC_VOP3A,  GCN_VOP3_VOP1_DS0,        488,  ARCH_GCN_1_5  },
    { "v_cmp_f_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x00, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_f32",         GCNENC_VOP3A,  GCN_FLOATLIT|GCN_STDMODE,        0x00, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x01, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             0x01, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x02, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             0x02, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x03, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             0x03, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x04, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             0x04, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x05, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             0x05, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x06, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             0x06, ARCH_GCN_1_0_1_5  },
    { "v_cmp_o_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x07, ARCH_GCN_1_0_1_5  },
    { "v_cmp_o_f32",         GCNENC_VOP3A,  GCN_FLOATLIT,             0x07, ARCH_GCN_1_0_1_5  },
    { "v_cmp_u_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x08, ARCH_GCN_1_0_1_5  },
    { "v_cmp_u_f32",         GCNENC_VOP3A,  GCN_FLOATLIT,             0x08, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nge_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x09, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nge_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x09, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlg_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x0a, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlg_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x0a, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ngt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x0b, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ngt_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x0b, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nle_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x0c, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nle_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x0c, ARCH_GCN_1_0_1_5  },
    { "v_cmp_neq_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x0d, ARCH_GCN_1_0_1_5  },
    { "v_cmp_neq_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x0d, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x0e, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlt_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x0e, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x0f, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_f32",       GCNENC_VOP3A,  GCN_FLOATLIT,             0x0f, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x0f, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_f32",         GCNENC_VOP3A,  GCN_FLOATLIT,             0x0f, ARCH_GCN_1_0_1_5  },
    { "v_cmpx_f_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x10, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x10, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x11, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x11, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x12, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x12, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x13, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x13, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x14, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x14, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x15, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x15, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x16, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x16, ARCH_GCN_1_0_1  },
    { "v_cmpx_o_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x17, ARCH_GCN_1_0_1  },
    { "v_cmpx_o_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x17, ARCH_GCN_1_0_1  },
    { "v_cmpx_u_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x18, ARCH_GCN_1_0_1  },
    { "v_cmpx_u_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x18, ARCH_GCN_1_0_1  },
    { "v_cmpx_nge_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x19, ARCH_GCN_1_0_1  },
    { "v_cmpx_nge_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x19, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlg_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x1a, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlg_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x1a, ARCH_GCN_1_0_1  },
    { "v_cmpx_ngt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x1b, ARCH_GCN_1_0_1  },
    { "v_cmpx_ngt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x1b, ARCH_GCN_1_0_1  },
    { "v_cmpx_nle_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x1c, ARCH_GCN_1_0_1  },
    { "v_cmpx_nle_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x1c, ARCH_GCN_1_0_1  },
    { "v_cmpx_neq_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x1d, ARCH_GCN_1_0_1  },
    { "v_cmpx_neq_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x1d, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x1e, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x1e, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x1f, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x1f, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x1f, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x1f, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_f32",        GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x10, ARCH_GCN_1_5  },
    { "v_cmpx_f_f32",        GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x10, ARCH_GCN_1_5  },
    { "v_cmpx_lt_f32",       GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x11, ARCH_GCN_1_5  },
    { "v_cmpx_lt_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x11, ARCH_GCN_1_5  },
    { "v_cmpx_eq_f32",       GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x12, ARCH_GCN_1_5  },
    { "v_cmpx_eq_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x12, ARCH_GCN_1_5  },
    { "v_cmpx_le_f32",       GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x13, ARCH_GCN_1_5  },
    { "v_cmpx_le_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x13, ARCH_GCN_1_5  },
    { "v_cmpx_gt_f32",       GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x14, ARCH_GCN_1_5  },
    { "v_cmpx_gt_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x14, ARCH_GCN_1_5  },
    { "v_cmpx_lg_f32",       GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x15, ARCH_GCN_1_5  },
    { "v_cmpx_lg_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x15, ARCH_GCN_1_5  },
    { "v_cmpx_ge_f32",       GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x16, ARCH_GCN_1_5  },
    { "v_cmpx_ge_f32",       GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x16, ARCH_GCN_1_5  },
    { "v_cmpx_o_f32",        GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x17, ARCH_GCN_1_5  },
    { "v_cmpx_o_f32",        GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x17, ARCH_GCN_1_5  },
    { "v_cmpx_u_f32",        GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x18, ARCH_GCN_1_5  },
    { "v_cmpx_u_f32",        GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x18, ARCH_GCN_1_5  },
    { "v_cmpx_nge_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x19, ARCH_GCN_1_5  },
    { "v_cmpx_nge_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x19, ARCH_GCN_1_5  },
    { "v_cmpx_nlg_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1a, ARCH_GCN_1_5  },
    { "v_cmpx_nlg_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1a, ARCH_GCN_1_5  },
    { "v_cmpx_ngt_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1b, ARCH_GCN_1_5  },
    { "v_cmpx_ngt_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1b, ARCH_GCN_1_5  },
    { "v_cmpx_nle_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1c, ARCH_GCN_1_5  },
    { "v_cmpx_nle_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1c, ARCH_GCN_1_5  },
    { "v_cmpx_neq_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1d, ARCH_GCN_1_5  },
    { "v_cmpx_neq_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1d, ARCH_GCN_1_5  },
    { "v_cmpx_nlt_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1e, ARCH_GCN_1_5  },
    { "v_cmpx_nlt_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1e, ARCH_GCN_1_5  },
    { "v_cmpx_tru_f32",      GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1f, ARCH_GCN_1_5  },
    { "v_cmpx_tru_f32",      GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1f, ARCH_GCN_1_5  },
    { "v_cmpx_t_f32",        GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x1f, ARCH_GCN_1_5  },
    { "v_cmpx_t_f32",        GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x1f, ARCH_GCN_1_5  },
    { "v_cmp_f_f64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0x20, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x20, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x21, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x21, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x22, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x22, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x23, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x23, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x24, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x24, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x25, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x25, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x26, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x26, ARCH_GCN_1_0_1_5  },
    { "v_cmp_o_f64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0x27, ARCH_GCN_1_0_1_5  },
    { "v_cmp_o_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x27, ARCH_GCN_1_0_1_5  },
    { "v_cmp_u_f64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0x28, ARCH_GCN_1_0_1_5  },
    { "v_cmp_u_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x28, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nge_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x29, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nge_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x29, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlg_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x2a, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlg_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2a, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ngt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x2b, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ngt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2b, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nle_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x2c, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nle_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2c, ARCH_GCN_1_0_1_5  },
    { "v_cmp_neq_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x2d, ARCH_GCN_1_0_1_5  },
    { "v_cmp_neq_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2d, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x2e, ARCH_GCN_1_0_1_5  },
    { "v_cmp_nlt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2e, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x2f, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2f, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_f64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0x2f, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x2f, ARCH_GCN_1_0_1_5  },
    { "v_cmpx_f_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x30, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x30, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x31, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x31, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x32, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x32, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x33, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x33, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x34, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x34, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x35, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x35, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x36, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x36, ARCH_GCN_1_0_1  },
    { "v_cmpx_o_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x37, ARCH_GCN_1_0_1  },
    { "v_cmpx_o_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x37, ARCH_GCN_1_0_1  },
    { "v_cmpx_u_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x38, ARCH_GCN_1_0_1  },
    { "v_cmpx_u_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x38, ARCH_GCN_1_0_1  },
    { "v_cmpx_nge_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x39, ARCH_GCN_1_0_1  },
    { "v_cmpx_nge_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x39, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlg_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x3a, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlg_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3a, ARCH_GCN_1_0_1  },
    { "v_cmpx_ngt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x3b, ARCH_GCN_1_0_1  },
    { "v_cmpx_ngt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3b, ARCH_GCN_1_0_1  },
    { "v_cmpx_nle_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x3c, ARCH_GCN_1_0_1  },
    { "v_cmpx_nle_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3c, ARCH_GCN_1_0_1  },
    { "v_cmpx_neq_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x3d, ARCH_GCN_1_0_1  },
    { "v_cmpx_neq_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3d, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x3e, ARCH_GCN_1_0_1  },
    { "v_cmpx_nlt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3e, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x3f, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3f, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x3f, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x3f, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x30, ARCH_GCN_1_5  },
    { "v_cmpx_f_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x30, ARCH_GCN_1_5  },
    { "v_cmpx_lt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x31, ARCH_GCN_1_5  },
    { "v_cmpx_lt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x31, ARCH_GCN_1_5  },
    { "v_cmpx_eq_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x32, ARCH_GCN_1_5  },
    { "v_cmpx_eq_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x32, ARCH_GCN_1_5  },
    { "v_cmpx_le_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x33, ARCH_GCN_1_5  },
    { "v_cmpx_le_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x33, ARCH_GCN_1_5  },
    { "v_cmpx_gt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x34, ARCH_GCN_1_5  },
    { "v_cmpx_gt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x34, ARCH_GCN_1_5  },
    { "v_cmpx_lg_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x35, ARCH_GCN_1_5  },
    { "v_cmpx_lg_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x35, ARCH_GCN_1_5  },
    { "v_cmpx_ge_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x36, ARCH_GCN_1_5  },
    { "v_cmpx_ge_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x36, ARCH_GCN_1_5  },
    { "v_cmpx_o_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x37, ARCH_GCN_1_5  },
    { "v_cmpx_o_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x37, ARCH_GCN_1_5  },
    { "v_cmpx_u_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x38, ARCH_GCN_1_5  },
    { "v_cmpx_u_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x38, ARCH_GCN_1_5  },
    { "v_cmpx_nge_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x39, ARCH_GCN_1_5  },
    { "v_cmpx_nge_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x39, ARCH_GCN_1_5  },
    { "v_cmpx_nlg_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3a, ARCH_GCN_1_5  },
    { "v_cmpx_nlg_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3a, ARCH_GCN_1_5  },
    { "v_cmpx_ngt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3b, ARCH_GCN_1_5  },
    { "v_cmpx_ngt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3b, ARCH_GCN_1_5  },
    { "v_cmpx_nle_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3c, ARCH_GCN_1_5  },
    { "v_cmpx_nle_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3c, ARCH_GCN_1_5  },
    { "v_cmpx_neq_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3d, ARCH_GCN_1_5  },
    { "v_cmpx_neq_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3d, ARCH_GCN_1_5  },
    { "v_cmpx_nlt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3e, ARCH_GCN_1_5  },
    { "v_cmpx_nlt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3e, ARCH_GCN_1_5  },
    { "v_cmpx_tru_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3f, ARCH_GCN_1_5  },
    { "v_cmpx_tru_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3f, ARCH_GCN_1_5  },
    { "v_cmpx_t_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0x3f, ARCH_GCN_1_5  },
    { "v_cmpx_t_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0x3f, ARCH_GCN_1_5  },
    { "v_cmps_f_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x40, ARCH_GCN_1_0_1  },
    { "v_cmps_f_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x40, ARCH_GCN_1_0_1  },
    { "v_cmps_lt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x41, ARCH_GCN_1_0_1  },
    { "v_cmps_lt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x41, ARCH_GCN_1_0_1  },
    { "v_cmps_eq_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x42, ARCH_GCN_1_0_1  },
    { "v_cmps_eq_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x42, ARCH_GCN_1_0_1  },
    { "v_cmps_le_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x43, ARCH_GCN_1_0_1  },
    { "v_cmps_le_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x43, ARCH_GCN_1_0_1  },
    { "v_cmps_gt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x44, ARCH_GCN_1_0_1  },
    { "v_cmps_gt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x44, ARCH_GCN_1_0_1  },
    { "v_cmps_lg_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x45, ARCH_GCN_1_0_1  },
    { "v_cmps_lg_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x45, ARCH_GCN_1_0_1  },
    { "v_cmps_ge_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x46, ARCH_GCN_1_0_1  },
    { "v_cmps_ge_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x46, ARCH_GCN_1_0_1  },
    { "v_cmps_o_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x47, ARCH_GCN_1_0_1  },
    { "v_cmps_o_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x47, ARCH_GCN_1_0_1  },
    { "v_cmps_u_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x48, ARCH_GCN_1_0_1  },
    { "v_cmps_u_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x48, ARCH_GCN_1_0_1  },
    { "v_cmps_nge_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x49, ARCH_GCN_1_0_1  },
    { "v_cmps_nge_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x49, ARCH_GCN_1_0_1  },
    { "v_cmps_nlg_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x4a, ARCH_GCN_1_0_1  },
    { "v_cmps_nlg_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x4a, ARCH_GCN_1_0_1  },
    { "v_cmps_ngt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x4b, ARCH_GCN_1_0_1  },
    { "v_cmps_ngt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x4b, ARCH_GCN_1_0_1  },
    { "v_cmps_nle_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x4c, ARCH_GCN_1_0_1  },
    { "v_cmps_nle_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x4c, ARCH_GCN_1_0_1  },
    { "v_cmps_neq_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x4d, ARCH_GCN_1_0_1  },
    { "v_cmps_neq_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x4d, ARCH_GCN_1_0_1  },
    { "v_cmps_nlt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x4e, ARCH_GCN_1_0_1  },
    { "v_cmps_nlt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x4e, ARCH_GCN_1_0_1  },
    { "v_cmps_tru_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x4f, ARCH_GCN_1_0_1  },
    { "v_cmps_tru_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x4f, ARCH_GCN_1_0_1  },
    { "v_cmps_t_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x4f, ARCH_GCN_1_0_1  },
    { "v_cmps_t_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x4f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_f_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x50, ARCH_GCN_1_0_1  },
    { "v_cmpsx_f_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x50, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x51, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x51, ARCH_GCN_1_0_1  },
    { "v_cmpsx_eq_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x52, ARCH_GCN_1_0_1  },
    { "v_cmpsx_eq_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x52, ARCH_GCN_1_0_1  },
    { "v_cmpsx_le_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x53, ARCH_GCN_1_0_1  },
    { "v_cmpsx_le_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x53, ARCH_GCN_1_0_1  },
    { "v_cmpsx_gt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x54, ARCH_GCN_1_0_1  },
    { "v_cmpsx_gt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x54, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lg_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x55, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lg_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x55, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ge_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x56, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ge_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x56, ARCH_GCN_1_0_1  },
    { "v_cmpsx_o_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x57, ARCH_GCN_1_0_1  },
    { "v_cmpsx_o_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x57, ARCH_GCN_1_0_1  },
    { "v_cmpsx_u_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x58, ARCH_GCN_1_0_1  },
    { "v_cmpsx_u_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x58, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nge_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x59, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nge_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x59, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlg_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x5a, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlg_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x5a, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ngt_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x5b, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ngt_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x5b, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nle_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x5c, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nle_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x5c, ARCH_GCN_1_0_1  },
    { "v_cmpsx_neq_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x5d, ARCH_GCN_1_0_1  },
    { "v_cmpsx_neq_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x5d, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlt_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x5e, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlt_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x5e, ARCH_GCN_1_0_1  },
    { "v_cmpsx_tru_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x5f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_tru_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x5f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_t_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x5f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_t_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x5f, ARCH_GCN_1_0_1  },
    { "v_cmps_f_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x60, ARCH_GCN_1_0_1  },
    { "v_cmps_f_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x60, ARCH_GCN_1_0_1  },
    { "v_cmps_lt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x61, ARCH_GCN_1_0_1  },
    { "v_cmps_lt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x61, ARCH_GCN_1_0_1  },
    { "v_cmps_eq_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x62, ARCH_GCN_1_0_1  },
    { "v_cmps_eq_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x62, ARCH_GCN_1_0_1  },
    { "v_cmps_le_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x63, ARCH_GCN_1_0_1  },
    { "v_cmps_le_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x63, ARCH_GCN_1_0_1  },
    { "v_cmps_gt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x64, ARCH_GCN_1_0_1  },
    { "v_cmps_gt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x64, ARCH_GCN_1_0_1  },
    { "v_cmps_lg_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x65, ARCH_GCN_1_0_1  },
    { "v_cmps_lg_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x65, ARCH_GCN_1_0_1  },
    { "v_cmps_ge_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x66, ARCH_GCN_1_0_1  },
    { "v_cmps_ge_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x66, ARCH_GCN_1_0_1  },
    { "v_cmps_o_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x67, ARCH_GCN_1_0_1  },
    { "v_cmps_o_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x67, ARCH_GCN_1_0_1  },
    { "v_cmps_u_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x68, ARCH_GCN_1_0_1  },
    { "v_cmps_u_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x68, ARCH_GCN_1_0_1  },
    { "v_cmps_nge_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x69, ARCH_GCN_1_0_1  },
    { "v_cmps_nge_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x69, ARCH_GCN_1_0_1  },
    { "v_cmps_nlg_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x6a, ARCH_GCN_1_0_1  },
    { "v_cmps_nlg_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6a, ARCH_GCN_1_0_1  },
    { "v_cmps_ngt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x6b, ARCH_GCN_1_0_1  },
    { "v_cmps_ngt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6b, ARCH_GCN_1_0_1  },
    { "v_cmps_nle_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x6c, ARCH_GCN_1_0_1  },
    { "v_cmps_nle_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6c, ARCH_GCN_1_0_1  },
    { "v_cmps_neq_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x6d, ARCH_GCN_1_0_1  },
    { "v_cmps_neq_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6d, ARCH_GCN_1_0_1  },
    { "v_cmps_nlt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x6e, ARCH_GCN_1_0_1  },
    { "v_cmps_nlt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6e, ARCH_GCN_1_0_1  },
    { "v_cmps_tru_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x6f, ARCH_GCN_1_0_1  },
    { "v_cmps_tru_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6f, ARCH_GCN_1_0_1  },
    { "v_cmps_t_f64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0x6f, ARCH_GCN_1_0_1  },
    { "v_cmps_t_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_f_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x70, ARCH_GCN_1_0_1  },
    { "v_cmpsx_f_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x70, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x71, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x71, ARCH_GCN_1_0_1  },
    { "v_cmpsx_eq_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x72, ARCH_GCN_1_0_1  },
    { "v_cmpsx_eq_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x72, ARCH_GCN_1_0_1  },
    { "v_cmpsx_le_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x73, ARCH_GCN_1_0_1  },
    { "v_cmpsx_le_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x73, ARCH_GCN_1_0_1  },
    { "v_cmpsx_gt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x74, ARCH_GCN_1_0_1  },
    { "v_cmpsx_gt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x74, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lg_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x75, ARCH_GCN_1_0_1  },
    { "v_cmpsx_lg_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x75, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ge_f64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0x76, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ge_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x76, ARCH_GCN_1_0_1  },
    { "v_cmpsx_o_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x77, ARCH_GCN_1_0_1  },
    { "v_cmpsx_o_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x77, ARCH_GCN_1_0_1  },
    { "v_cmpsx_u_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x78, ARCH_GCN_1_0_1  },
    { "v_cmpsx_u_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x78, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nge_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x79, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nge_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x79, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlg_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x7a, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlg_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7a, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ngt_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x7b, ARCH_GCN_1_0_1  },
    { "v_cmpsx_ngt_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7b, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nle_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x7c, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nle_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7c, ARCH_GCN_1_0_1  },
    { "v_cmpsx_neq_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x7d, ARCH_GCN_1_0_1  },
    { "v_cmpsx_neq_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7d, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlt_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x7e, ARCH_GCN_1_0_1  },
    { "v_cmpsx_nlt_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7e, ARCH_GCN_1_0_1  },
    { "v_cmpsx_tru_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0x7f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_tru_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_t_f64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0x7f, ARCH_GCN_1_0_1  },
    { "v_cmpsx_t_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7f, ARCH_GCN_1_0_1  },
    { "v_cmp_f_i32",         GCNENC_VOPC,   GCN_STDMODE,              0x80, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_i32",         GCNENC_VOP3A,  GCN_STDMODE,              0x80, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x81, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x81, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x82, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x82, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x83, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x83, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x84, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x84, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x85, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x85, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x85, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x85, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x86, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x86, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x87, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x87, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_i32",         GCNENC_VOPC,   GCN_STDMODE,              0x87, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_i32",         GCNENC_VOP3A,  GCN_STDMODE,              0x87, ARCH_GCN_1_0_1_5  },
    { "v_cmp_class_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x88, ARCH_GCN_1_0_1_5  },
    { "v_cmp_class_f32",     GCNENC_VOP3A,  GCN_FLOATLIT,             0x88, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x89, ARCH_GCN_1_5  },
    { "v_cmp_lt_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x89, ARCH_GCN_1_5  },
    { "v_cmp_eq_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x8a, ARCH_GCN_1_5  },
    { "v_cmp_eq_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x8a, ARCH_GCN_1_5  },
    { "v_cmp_le_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x8b, ARCH_GCN_1_5  },
    { "v_cmp_le_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x8b, ARCH_GCN_1_5  },
    { "v_cmp_gt_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x8c, ARCH_GCN_1_5  },
    { "v_cmp_gt_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x8c, ARCH_GCN_1_5  },
    { "v_cmp_lg_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x8d, ARCH_GCN_1_5  },
    { "v_cmp_lg_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x8d, ARCH_GCN_1_5  },
    { "v_cmp_ne_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x8d, ARCH_GCN_1_5  },
    { "v_cmp_ne_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x8d, ARCH_GCN_1_5  },
    { "v_cmp_ge_i16",        GCNENC_VOPC,   GCN_STDMODE,              0x8e, ARCH_GCN_1_5  },
    { "v_cmp_ge_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0x8e, ARCH_GCN_1_5  },
    { "v_cmp_class_f16",     GCNENC_VOPC,   GCN_F16LIT,               0x8f, ARCH_GCN_1_5  },
    { "v_cmp_class_f16",     GCNENC_VOP3A,  GCN_F16LIT,               0x8f, ARCH_GCN_1_5  },
    { "v_cmpx_f_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x90, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x90, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x91, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x91, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x92, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x92, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x93, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x93, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x94, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x94, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x95, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x95, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x95, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x95, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_i32",       GCNENC_VOPC,   GCN_STDMODE,              0x96, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0x96, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_i32",      GCNENC_VOPC,   GCN_STDMODE,              0x97, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_i32",      GCNENC_VOP3A,  GCN_STDMODE,              0x97, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_i32",        GCNENC_VOPC,   GCN_STDMODE,              0x97, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0x97, ARCH_GCN_1_0_1  },
    { "v_cmpx_class_f32",    GCNENC_VOPC,   GCN_FLOATLIT,             0x98, ARCH_GCN_1_0_1  },
    { "v_cmpx_class_f32",    GCNENC_VOP3A,  GCN_FLOATLIT,             0x98, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_i32",        GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x90, ARCH_GCN_1_5  },
    { "v_cmpx_f_i32",        GCNENC_VOP3A,  GCN_VOP3_NODST,           0x90, ARCH_GCN_1_5  },
    { "v_cmpx_lt_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x91, ARCH_GCN_1_5  },
    { "v_cmpx_lt_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x91, ARCH_GCN_1_5  },
    { "v_cmpx_eq_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x92, ARCH_GCN_1_5  },
    { "v_cmpx_eq_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x92, ARCH_GCN_1_5  },
    { "v_cmpx_le_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x93, ARCH_GCN_1_5  },
    { "v_cmpx_le_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x93, ARCH_GCN_1_5  },
    { "v_cmpx_gt_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x94, ARCH_GCN_1_5  },
    { "v_cmpx_gt_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x94, ARCH_GCN_1_5  },
    { "v_cmpx_lg_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x95, ARCH_GCN_1_5  },
    { "v_cmpx_lg_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x95, ARCH_GCN_1_5  },
    { "v_cmpx_ne_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x95, ARCH_GCN_1_5  },
    { "v_cmpx_ne_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x95, ARCH_GCN_1_5  },
    { "v_cmpx_ge_i32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x96, ARCH_GCN_1_5  },
    { "v_cmpx_ge_i32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x96, ARCH_GCN_1_5  },
    { "v_cmpx_tru_i32",      GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x97, ARCH_GCN_1_5  },
    { "v_cmpx_tru_i32",      GCNENC_VOP3A,  GCN_VOP3_NODST,           0x97, ARCH_GCN_1_5  },
    { "v_cmpx_t_i32",        GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x97, ARCH_GCN_1_5  },
    { "v_cmpx_t_i32",        GCNENC_VOP3A,  GCN_VOP3_NODST,           0x97, ARCH_GCN_1_5  },
    { "v_cmpx_class_f32",    GCNENC_VOPC,   GCN_FLOATLIT|GCN_VOPC_NOVCC, 0x98, ARCH_GCN_1_5  },
    { "v_cmpx_class_f32",    GCNENC_VOP3A,  GCN_FLOATLIT|GCN_VOP3_NODST, 0x98, ARCH_GCN_1_5  },
    { "v_cmpx_lt_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x99, ARCH_GCN_1_5  },
    { "v_cmpx_lt_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x99, ARCH_GCN_1_5  },
    { "v_cmpx_eq_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x9a, ARCH_GCN_1_5  },
    { "v_cmpx_eq_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x9a, ARCH_GCN_1_5  },
    { "v_cmpx_le_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x9b, ARCH_GCN_1_5  },
    { "v_cmpx_le_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x9b, ARCH_GCN_1_5  },
    { "v_cmpx_gt_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x9c, ARCH_GCN_1_5  },
    { "v_cmpx_gt_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x9c, ARCH_GCN_1_5  },
    { "v_cmpx_lg_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x9d, ARCH_GCN_1_5  },
    { "v_cmpx_lg_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x9d, ARCH_GCN_1_5  },
    { "v_cmpx_ne_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x9d, ARCH_GCN_1_5  },
    { "v_cmpx_ne_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x9d, ARCH_GCN_1_5  },
    { "v_cmpx_ge_i16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0x9e, ARCH_GCN_1_5  },
    { "v_cmpx_ge_i16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0x9e, ARCH_GCN_1_5  },
    { "v_cmpx_class_f16",    GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0x9f, ARCH_GCN_1_5  },
    { "v_cmpx_class_f16",    GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0x9f, ARCH_GCN_1_5  },
    { "v_cmp_f_i64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0xa0, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_i64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa0, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa1, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa1, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa2, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa2, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa3, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa3, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa4, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa4, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xa6, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa6, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xa7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_i64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0xa7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_i64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_class_f64",     GCNENC_VOPC,   GCN_REG_ALL_64,           0xa8, ARCH_GCN_1_0_1_5  },
    { "v_cmp_class_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0xa8, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xa9, ARCH_GCN_1_5  },
    { "v_cmp_lt_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa9, ARCH_GCN_1_5  },
    { "v_cmp_eq_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xaa, ARCH_GCN_1_5  },
    { "v_cmp_eq_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xaa, ARCH_GCN_1_5  },
    { "v_cmp_le_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xab, ARCH_GCN_1_5  },
    { "v_cmp_le_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xab, ARCH_GCN_1_5  },
    { "v_cmp_gt_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xac, ARCH_GCN_1_5  },
    { "v_cmp_gt_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xac, ARCH_GCN_1_5  },
    { "v_cmp_lg_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xad, ARCH_GCN_1_5  },
    { "v_cmp_lg_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xad, ARCH_GCN_1_5  },
    { "v_cmp_ne_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xad, ARCH_GCN_1_5  },
    { "v_cmp_ne_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xad, ARCH_GCN_1_5  },
    { "v_cmp_ge_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xae, ARCH_GCN_1_5  },
    { "v_cmp_ge_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xae, ARCH_GCN_1_5  },
    { "v_cmpx_f_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xb0, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb0, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb1, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb1, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb2, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb2, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb3, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb3, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb4, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb4, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb5, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_i64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xb6, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb6, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_i64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0xb7, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_i64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb7, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_i64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xb7, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb7, ARCH_GCN_1_0_1  },
    { "v_cmpx_class_f64",    GCNENC_VOPC,   GCN_REG_ALL_64,           0xb8, ARCH_GCN_1_0_1  },
    { "v_cmpx_class_f64",    GCNENC_VOP3A,  GCN_REG_ALL_64,           0xb8, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb0, ARCH_GCN_1_5  },
    { "v_cmpx_f_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb0, ARCH_GCN_1_5  },
    { "v_cmpx_lt_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb1, ARCH_GCN_1_5  },
    { "v_cmpx_lt_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb1, ARCH_GCN_1_5  },
    { "v_cmpx_eq_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb2, ARCH_GCN_1_5  },
    { "v_cmpx_eq_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb2, ARCH_GCN_1_5  },
    { "v_cmpx_le_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb3, ARCH_GCN_1_5  },
    { "v_cmpx_le_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb3, ARCH_GCN_1_5  },
    { "v_cmpx_gt_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb4, ARCH_GCN_1_5  },
    { "v_cmpx_gt_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb4, ARCH_GCN_1_5  },
    { "v_cmpx_lg_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb5, ARCH_GCN_1_5  },
    { "v_cmpx_lg_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb5, ARCH_GCN_1_5  },
    { "v_cmpx_ne_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb5, ARCH_GCN_1_5  },
    { "v_cmpx_ne_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb5, ARCH_GCN_1_5  },
    { "v_cmpx_ge_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb6, ARCH_GCN_1_5  },
    { "v_cmpx_ge_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb6, ARCH_GCN_1_5  },
    { "v_cmpx_tru_i64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb7, ARCH_GCN_1_5  },
    { "v_cmpx_tru_i64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb7, ARCH_GCN_1_5  },
    { "v_cmpx_t_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb7, ARCH_GCN_1_5  },
    { "v_cmpx_t_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb7, ARCH_GCN_1_5  },
    { "v_cmpx_class_f64",    GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xb8, ARCH_GCN_1_5  },
    { "v_cmpx_class_f64",    GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xb8, ARCH_GCN_1_5  },
    { "v_cmpx_lt_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xb9, ARCH_GCN_1_5  },
    { "v_cmpx_lt_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xb9, ARCH_GCN_1_5  },
    { "v_cmpx_eq_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xba, ARCH_GCN_1_5  },
    { "v_cmpx_eq_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xba, ARCH_GCN_1_5  },
    { "v_cmpx_le_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xbb, ARCH_GCN_1_5  },
    { "v_cmpx_le_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xbb, ARCH_GCN_1_5  },
    { "v_cmpx_gt_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xbc, ARCH_GCN_1_5  },
    { "v_cmpx_gt_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xbc, ARCH_GCN_1_5  },
    { "v_cmpx_lg_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xbd, ARCH_GCN_1_5  },
    { "v_cmpx_lg_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xbd, ARCH_GCN_1_5  },
    { "v_cmpx_ne_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xbd, ARCH_GCN_1_5  },
    { "v_cmpx_ne_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xbd, ARCH_GCN_1_5  },
    { "v_cmpx_ge_u16",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xbe, ARCH_GCN_1_5  },
    { "v_cmpx_ge_u16",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xbe, ARCH_GCN_1_5  },
    { "v_cmp_f_u32",         GCNENC_VOPC,   GCN_STDMODE,              0xc0, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_u32",         GCNENC_VOP3A,  GCN_STDMODE,              0xc0, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc1, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc1, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc2, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc2, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc3, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc3, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc4, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc4, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc6, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc6, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xc7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xc7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_u32",         GCNENC_VOPC,   GCN_STDMODE,              0xc7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_u32",         GCNENC_VOP3A,  GCN_STDMODE,              0xc7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_f16",         GCNENC_VOPC,   GCN_F16LIT,               0xc8, ARCH_GCN_1_5  },
    { "v_cmp_f_f16",         GCNENC_VOP3A,  GCN_F16LIT,               0xc8, ARCH_GCN_1_5  },
    { "v_cmp_lt_f16",        GCNENC_VOPC,   GCN_F16LIT,               0xc9, ARCH_GCN_1_5  },
    { "v_cmp_lt_f16",        GCNENC_VOP3A,  GCN_F16LIT,               0xc9, ARCH_GCN_1_5  },
    { "v_cmp_eq_f16",        GCNENC_VOPC,   GCN_F16LIT,               0xca, ARCH_GCN_1_5  },
    { "v_cmp_eq_f16",        GCNENC_VOP3A,  GCN_F16LIT,               0xca, ARCH_GCN_1_5  },
    { "v_cmp_le_f16",        GCNENC_VOPC,   GCN_F16LIT,               0xcb, ARCH_GCN_1_5  },
    { "v_cmp_le_f16",        GCNENC_VOP3A,  GCN_F16LIT,               0xcb, ARCH_GCN_1_5  },
    { "v_cmp_gt_f16",        GCNENC_VOPC,   GCN_F16LIT,               0xcc, ARCH_GCN_1_5  },
    { "v_cmp_gt_f16",        GCNENC_VOP3A,  GCN_F16LIT,               0xcc, ARCH_GCN_1_5  },
    { "v_cmp_lg_f16",        GCNENC_VOPC,   GCN_F16LIT,               0xcd, ARCH_GCN_1_5  },
    { "v_cmp_lg_f16",        GCNENC_VOP3A,  GCN_F16LIT,               0xcd, ARCH_GCN_1_5  },
    { "v_cmp_ge_f16",        GCNENC_VOPC,   GCN_F16LIT,               0xce, ARCH_GCN_1_5  },
    { "v_cmp_ge_f16",        GCNENC_VOP3A,  GCN_F16LIT,               0xce, ARCH_GCN_1_5  },
    { "v_cmp_o_f16",         GCNENC_VOPC,   GCN_F16LIT,               0xcf, ARCH_GCN_1_5  },
    { "v_cmp_o_f16",         GCNENC_VOP3A,  GCN_F16LIT,               0xcf, ARCH_GCN_1_5  },
    { "v_cmpx_f_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xd0, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xd0, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd1, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd1, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd2, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd2, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd3, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd3, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd4, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd4, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd5, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd6, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd6, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_u32",      GCNENC_VOPC,   GCN_STDMODE,              0xd7, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_u32",      GCNENC_VOP3A,  GCN_STDMODE,              0xd7, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xd7, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xd7, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_u32",        GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd0, ARCH_GCN_1_5  },
    { "v_cmpx_f_u32",        GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd0, ARCH_GCN_1_5  },
    { "v_cmpx_lt_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd1, ARCH_GCN_1_5  },
    { "v_cmpx_lt_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd1, ARCH_GCN_1_5  },
    { "v_cmpx_eq_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd2, ARCH_GCN_1_5  },
    { "v_cmpx_eq_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd2, ARCH_GCN_1_5  },
    { "v_cmpx_le_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd3, ARCH_GCN_1_5  },
    { "v_cmpx_le_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd3, ARCH_GCN_1_5  },
    { "v_cmpx_gt_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd4, ARCH_GCN_1_5  },
    { "v_cmpx_gt_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd4, ARCH_GCN_1_5  },
    { "v_cmpx_lg_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd5, ARCH_GCN_1_5  },
    { "v_cmpx_lg_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd5, ARCH_GCN_1_5  },
    { "v_cmpx_ne_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd5, ARCH_GCN_1_5  },
    { "v_cmpx_ne_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd5, ARCH_GCN_1_5  },
    { "v_cmpx_ge_u32",       GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd6, ARCH_GCN_1_5  },
    { "v_cmpx_ge_u32",       GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd6, ARCH_GCN_1_5  },
    { "v_cmpx_tru_u32",      GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd7, ARCH_GCN_1_5  },
    { "v_cmpx_tru_u32",      GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd7, ARCH_GCN_1_5  },
    { "v_cmpx_t_u32",        GCNENC_VOPC,   GCN_VOPC_NOVCC,           0xd7, ARCH_GCN_1_5  },
    { "v_cmpx_t_u32",        GCNENC_VOP3A,  GCN_VOP3_NODST,           0xd7, ARCH_GCN_1_5  },
    { "v_cmpx_f_f16",        GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xd8, ARCH_GCN_1_5  },
    { "v_cmpx_f_f16",        GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xd8, ARCH_GCN_1_5  },
    { "v_cmpx_lt_f16",       GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xd9, ARCH_GCN_1_5  },
    { "v_cmpx_lt_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xd9, ARCH_GCN_1_5  },
    { "v_cmpx_eq_f16",       GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xda, ARCH_GCN_1_5  },
    { "v_cmpx_eq_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xda, ARCH_GCN_1_5  },
    { "v_cmpx_le_f16",       GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xdb, ARCH_GCN_1_5  },
    { "v_cmpx_le_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xdb, ARCH_GCN_1_5  },
    { "v_cmpx_gt_f16",       GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xdc, ARCH_GCN_1_5  },
    { "v_cmpx_gt_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xdc, ARCH_GCN_1_5  },
    { "v_cmpx_lg_f16",       GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xdd, ARCH_GCN_1_5  },
    { "v_cmpx_lg_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xdd, ARCH_GCN_1_5  },
    { "v_cmpx_ge_f16",       GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xde, ARCH_GCN_1_5  },
    { "v_cmpx_ge_f16",       GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xde, ARCH_GCN_1_5  },
    { "v_cmpx_o_f16",        GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xdf, ARCH_GCN_1_5  },
    { "v_cmpx_o_f16",        GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xdf, ARCH_GCN_1_5  },
    { "v_cmp_f_u64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0xe0, ARCH_GCN_1_0_1_5  },
    { "v_cmp_f_u64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe0, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe1, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lt_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe1, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe2, ARCH_GCN_1_0_1_5  },
    { "v_cmp_eq_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe2, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe3, ARCH_GCN_1_0_1_5  },
    { "v_cmp_le_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe3, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe4, ARCH_GCN_1_0_1_5  },
    { "v_cmp_gt_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe4, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_lg_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ne_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe5, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xe6, ARCH_GCN_1_0_1_5  },
    { "v_cmp_ge_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe6, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xe7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_tru_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_u64",         GCNENC_VOPC,   GCN_REG_ALL_64,           0xe7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_t_u64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe7, ARCH_GCN_1_0_1_5  },
    { "v_cmp_u_f16",         GCNENC_VOPC,   GCN_F16LIT,               0xe8, ARCH_GCN_1_5  },
    { "v_cmp_u_f16",         GCNENC_VOP3A,  GCN_F16LIT,               0xe8, ARCH_GCN_1_5  },
    { "v_cmp_nge_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xe9, ARCH_GCN_1_5  },
    { "v_cmp_nge_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xe9, ARCH_GCN_1_5  },
    { "v_cmp_nlg_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xea, ARCH_GCN_1_5  },
    { "v_cmp_nlg_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xea, ARCH_GCN_1_5  },
    { "v_cmp_ngt_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xeb, ARCH_GCN_1_5  },
    { "v_cmp_ngt_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xeb, ARCH_GCN_1_5  },
    { "v_cmp_nle_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xec, ARCH_GCN_1_5  },
    { "v_cmp_nle_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xec, ARCH_GCN_1_5  },
    { "v_cmp_neq_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xed, ARCH_GCN_1_5  },
    { "v_cmp_neq_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xed, ARCH_GCN_1_5  },
    { "v_cmp_nlt_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xee, ARCH_GCN_1_5  },
    { "v_cmp_nlt_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xee, ARCH_GCN_1_5  },
    { "v_cmp_tru_f16",       GCNENC_VOPC,   GCN_F16LIT,               0xef, ARCH_GCN_1_5  },
    { "v_cmp_tru_f16",       GCNENC_VOP3A,  GCN_F16LIT,               0xef, ARCH_GCN_1_5  },
    { "v_cmp_t_f16",         GCNENC_VOPC,   GCN_F16LIT,               0xef, ARCH_GCN_1_5  },
    { "v_cmp_t_f16",         GCNENC_VOP3A,  GCN_F16LIT,               0xef, ARCH_GCN_1_5  },
    { "v_cmpx_f_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xf0, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf0, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf1, ARCH_GCN_1_0_1  },
    { "v_cmpx_lt_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf1, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf2, ARCH_GCN_1_0_1  },
    { "v_cmpx_eq_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf2, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf3, ARCH_GCN_1_0_1  },
    { "v_cmpx_le_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf3, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf4, ARCH_GCN_1_0_1  },
    { "v_cmpx_gt_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf4, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf5, ARCH_GCN_1_0_1  },
    { "v_cmpx_lg_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ne_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf5, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_u64",       GCNENC_VOPC,   GCN_REG_ALL_64,           0xf6, ARCH_GCN_1_0_1  },
    { "v_cmpx_ge_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf6, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_u64",      GCNENC_VOPC,   GCN_REG_ALL_64,           0xf7, ARCH_GCN_1_0_1  },
    { "v_cmpx_tru_u64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf7, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_u64",        GCNENC_VOPC,   GCN_REG_ALL_64,           0xf7, ARCH_GCN_1_0_1  },
    { "v_cmpx_t_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf7, ARCH_GCN_1_0_1  },
    { "v_cmpx_f_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf0, ARCH_GCN_1_5  },
    { "v_cmpx_f_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf0, ARCH_GCN_1_5  },
    { "v_cmpx_lt_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf1, ARCH_GCN_1_5  },
    { "v_cmpx_lt_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf1, ARCH_GCN_1_5  },
    { "v_cmpx_eq_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf2, ARCH_GCN_1_5  },
    { "v_cmpx_eq_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf2, ARCH_GCN_1_5  },
    { "v_cmpx_le_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf3, ARCH_GCN_1_5  },
    { "v_cmpx_le_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf3, ARCH_GCN_1_5  },
    { "v_cmpx_gt_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf4, ARCH_GCN_1_5  },
    { "v_cmpx_gt_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf4, ARCH_GCN_1_5  },
    { "v_cmpx_lg_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf5, ARCH_GCN_1_5  },
    { "v_cmpx_lg_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf5, ARCH_GCN_1_5  },
    { "v_cmpx_ne_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf5, ARCH_GCN_1_5  },
    { "v_cmpx_ne_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf5, ARCH_GCN_1_5  },
    { "v_cmpx_ge_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf6, ARCH_GCN_1_5  },
    { "v_cmpx_ge_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf6, ARCH_GCN_1_5  },
    { "v_cmpx_tru_u64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf7, ARCH_GCN_1_5  },
    { "v_cmpx_tru_u64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf7, ARCH_GCN_1_5  },
    { "v_cmpx_t_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOPC_NOVCC, 0xf7, ARCH_GCN_1_5  },
    { "v_cmpx_t_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VOP3_NODST, 0xf7, ARCH_GCN_1_5  },
    { "v_cmpx_u_f16",        GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xf8, ARCH_GCN_1_5  },
    { "v_cmpx_u_f16",        GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xf8, ARCH_GCN_1_5  },
    { "v_cmpx_nge_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xf9, ARCH_GCN_1_5  },
    { "v_cmpx_nge_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xf9, ARCH_GCN_1_5  },
    { "v_cmpx_nlg_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xfa, ARCH_GCN_1_5  },
    { "v_cmpx_nlg_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xfa, ARCH_GCN_1_5  },
    { "v_cmpx_ngt_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xfb, ARCH_GCN_1_5  },
    { "v_cmpx_ngt_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xfb, ARCH_GCN_1_5  },
    { "v_cmpx_nle_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xfc, ARCH_GCN_1_5  },
    { "v_cmpx_nle_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xfc, ARCH_GCN_1_5  },
    { "v_cmpx_neq_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xfd, ARCH_GCN_1_5  },
    { "v_cmpx_neq_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xfd, ARCH_GCN_1_5  },
    { "v_cmpx_nlt_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xfe, ARCH_GCN_1_5  },
    { "v_cmpx_nlt_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xfe, ARCH_GCN_1_5  },
    { "v_cmpx_tru_f16",      GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xff, ARCH_GCN_1_5  },
    { "v_cmpx_tru_f16",      GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xff, ARCH_GCN_1_5  },
    { "v_cmpx_t_f16",        GCNENC_VOPC,   GCN_F16LIT|GCN_VOPC_NOVCC, 0xff, ARCH_GCN_1_5  },
    { "v_cmpx_t_f16",        GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_NODST, 0xff, ARCH_GCN_1_5  },
    { "v_cmp_class_f32",     GCNENC_VOPC,   GCN_FLOATLIT,             0x10, ARCH_GCN_1_2_4  },
    { "v_cmp_class_f32",     GCNENC_VOP3A,  GCN_STDMODE,              0x10, ARCH_GCN_1_2_4  },
    { "v_cmpx_class_f32",    GCNENC_VOPC,   GCN_FLOATLIT,             0x11, ARCH_GCN_1_2_4  },
    { "v_cmpx_class_f32",    GCNENC_VOP3A,  GCN_STDMODE,              0x11, ARCH_GCN_1_2_4  },
    { "v_cmp_class_f64",     GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x12, ARCH_GCN_1_2_4  },
    { "v_cmp_class_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           0x12, ARCH_GCN_1_2_4  },
    { "v_cmpx_class_f64",    GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x13, ARCH_GCN_1_2_4  },
    { "v_cmpx_class_f64",    GCNENC_VOP3A,  GCN_REG_ALL_64,           0x13, ARCH_GCN_1_2_4  },
    { "v_cmp_class_f16",     GCNENC_VOPC,   GCN_F16LIT,               0x14, ARCH_GCN_1_2_4  },
    { "v_cmp_class_f16",     GCNENC_VOP3A,  GCN_STDMODE,              0x14, ARCH_GCN_1_2_4  },
    { "v_cmpx_class_f16",    GCNENC_VOPC,   GCN_F16LIT,               0x15, ARCH_GCN_1_2_4  },
    { "v_cmpx_class_f16",    GCNENC_VOP3A,  GCN_STDMODE,              0x15, ARCH_GCN_1_2_4  },
    { "v_cmp_f_f16",         GCNENC_VOPC,   GCN_F16LIT,               0x20, ARCH_GCN_1_2_4  },
    { "v_cmp_f_f16",         GCNENC_VOP3A,  GCN_STDMODE,              0x20, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x21, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x21, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x22, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x22, ARCH_GCN_1_2_4  },
    { "v_cmp_le_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x23, ARCH_GCN_1_2_4  },
    { "v_cmp_le_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x23, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x24, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x24, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x25, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x25, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x26, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x26, ARCH_GCN_1_2_4  },
    { "v_cmp_o_f16",         GCNENC_VOPC,   GCN_F16LIT,               0x27, ARCH_GCN_1_2_4  },
    { "v_cmp_o_f16",         GCNENC_VOP3A,  GCN_STDMODE,              0x27, ARCH_GCN_1_2_4  },
    { "v_cmp_u_f16",         GCNENC_VOPC,   GCN_F16LIT,               0x28, ARCH_GCN_1_2_4  },
    { "v_cmp_u_f16",         GCNENC_VOP3A,  GCN_STDMODE,              0x28, ARCH_GCN_1_2_4  },
    { "v_cmp_nge_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x29, ARCH_GCN_1_2_4  },
    { "v_cmp_nge_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x29, ARCH_GCN_1_2_4  },
    { "v_cmp_nlg_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x2a, ARCH_GCN_1_2_4  },
    { "v_cmp_nlg_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x2a, ARCH_GCN_1_2_4  },
    { "v_cmp_ngt_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x2b, ARCH_GCN_1_2_4  },
    { "v_cmp_ngt_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x2b, ARCH_GCN_1_2_4  },
    { "v_cmp_nle_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x2c, ARCH_GCN_1_2_4  },
    { "v_cmp_nle_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x2c, ARCH_GCN_1_2_4  },
    { "v_cmp_neq_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x2d, ARCH_GCN_1_2_4  },
    { "v_cmp_neq_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x2d, ARCH_GCN_1_2_4  },
    { "v_cmp_nlt_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x2e, ARCH_GCN_1_2_4  },
    { "v_cmp_nlt_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x2e, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x2f, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x2f, ARCH_GCN_1_2_4  },
    { "v_cmp_t_f16",         GCNENC_VOPC,   GCN_F16LIT,               0x2f, ARCH_GCN_1_2_4  },
    { "v_cmp_t_f16",         GCNENC_VOP3A,  GCN_STDMODE,              0x2f, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x30, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x30, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x31, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x31, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x32, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x32, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x33, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x33, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x34, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x34, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x35, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x35, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_f16",       GCNENC_VOPC,   GCN_F16LIT,               0x36, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_f16",       GCNENC_VOP3A,  GCN_STDMODE,              0x36, ARCH_GCN_1_2_4  },
    { "v_cmpx_o_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x37, ARCH_GCN_1_2_4  },
    { "v_cmpx_o_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x37, ARCH_GCN_1_2_4  },
    { "v_cmpx_u_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x38, ARCH_GCN_1_2_4  },
    { "v_cmpx_u_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x38, ARCH_GCN_1_2_4  },
    { "v_cmpx_nge_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x39, ARCH_GCN_1_2_4  },
    { "v_cmpx_nge_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x39, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlg_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x3a, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlg_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x3a, ARCH_GCN_1_2_4  },
    { "v_cmpx_ngt_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x3b, ARCH_GCN_1_2_4  },
    { "v_cmpx_ngt_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x3b, ARCH_GCN_1_2_4  },
    { "v_cmpx_nle_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x3c, ARCH_GCN_1_2_4  },
    { "v_cmpx_nle_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x3c, ARCH_GCN_1_2_4  },
    { "v_cmpx_neq_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x3d, ARCH_GCN_1_2_4  },
    { "v_cmpx_neq_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x3d, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlt_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x3e, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlt_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x3e, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_f16",      GCNENC_VOPC,   GCN_F16LIT,               0x3f, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_f16",      GCNENC_VOP3A,  GCN_STDMODE,              0x3f, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_f16",        GCNENC_VOPC,   GCN_F16LIT,               0x3f, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_f16",        GCNENC_VOP3A,  GCN_STDMODE,              0x3f, ARCH_GCN_1_2_4  },
    { "v_cmp_f_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x40, ARCH_GCN_1_2_4  },
    { "v_cmp_f_f32",         GCNENC_VOP3A,  GCN_STDMODE,              0x40, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x41, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x41, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x42, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x42, ARCH_GCN_1_2_4  },
    { "v_cmp_le_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x43, ARCH_GCN_1_2_4  },
    { "v_cmp_le_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x43, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x44, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x44, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x45, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x45, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x46, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x46, ARCH_GCN_1_2_4  },
    { "v_cmp_o_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x47, ARCH_GCN_1_2_4  },
    { "v_cmp_o_f32",         GCNENC_VOP3A,  GCN_STDMODE,              0x47, ARCH_GCN_1_2_4  },
    { "v_cmp_u_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x48, ARCH_GCN_1_2_4  },
    { "v_cmp_u_f32",         GCNENC_VOP3A,  GCN_STDMODE,              0x48, ARCH_GCN_1_2_4  },
    { "v_cmp_nge_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x49, ARCH_GCN_1_2_4  },
    { "v_cmp_nge_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x49, ARCH_GCN_1_2_4  },
    { "v_cmp_nlg_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x4a, ARCH_GCN_1_2_4  },
    { "v_cmp_nlg_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x4a, ARCH_GCN_1_2_4  },
    { "v_cmp_ngt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x4b, ARCH_GCN_1_2_4  },
    { "v_cmp_ngt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x4b, ARCH_GCN_1_2_4  },
    { "v_cmp_nle_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x4c, ARCH_GCN_1_2_4  },
    { "v_cmp_nle_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x4c, ARCH_GCN_1_2_4  },
    { "v_cmp_neq_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x4d, ARCH_GCN_1_2_4  },
    { "v_cmp_neq_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x4d, ARCH_GCN_1_2_4  },
    { "v_cmp_nlt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x4e, ARCH_GCN_1_2_4  },
    { "v_cmp_nlt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x4e, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x4f, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x4f, ARCH_GCN_1_2_4  },
    { "v_cmp_t_f32",         GCNENC_VOPC,   GCN_FLOATLIT,             0x4f, ARCH_GCN_1_2_4  },
    { "v_cmp_t_f32",         GCNENC_VOP3A,  GCN_STDMODE,              0x4f, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x50, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x50, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x51, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x51, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x52, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x52, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x53, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x53, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x54, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x54, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x55, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x55, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_f32",       GCNENC_VOPC,   GCN_FLOATLIT,             0x56, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_f32",       GCNENC_VOP3A,  GCN_STDMODE,              0x56, ARCH_GCN_1_2_4  },
    { "v_cmpx_o_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x57, ARCH_GCN_1_2_4  },
    { "v_cmpx_o_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x57, ARCH_GCN_1_2_4  },
    { "v_cmpx_u_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x58, ARCH_GCN_1_2_4  },
    { "v_cmpx_u_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x58, ARCH_GCN_1_2_4  },
    { "v_cmpx_nge_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x59, ARCH_GCN_1_2_4  },
    { "v_cmpx_nge_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x59, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlg_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x5a, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlg_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x5a, ARCH_GCN_1_2_4  },
    { "v_cmpx_ngt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x5b, ARCH_GCN_1_2_4  },
    { "v_cmpx_ngt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x5b, ARCH_GCN_1_2_4  },
    { "v_cmpx_nle_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x5c, ARCH_GCN_1_2_4  },
    { "v_cmpx_nle_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x5c, ARCH_GCN_1_2_4  },
    { "v_cmpx_neq_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x5d, ARCH_GCN_1_2_4  },
    { "v_cmpx_neq_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x5d, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlt_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x5e, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlt_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x5e, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_f32",      GCNENC_VOPC,   GCN_FLOATLIT,             0x5f, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_f32",      GCNENC_VOP3A,  GCN_STDMODE,              0x5f, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_f32",        GCNENC_VOPC,   GCN_FLOATLIT,             0x5f, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_f32",        GCNENC_VOP3A,  GCN_STDMODE,              0x5f, ARCH_GCN_1_2_4  },
    { "v_cmp_f_f64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x60, ARCH_GCN_1_2_4  },
    { "v_cmp_f_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x60, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x61, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x61, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x62, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x62, ARCH_GCN_1_2_4  },
    { "v_cmp_le_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x63, ARCH_GCN_1_2_4  },
    { "v_cmp_le_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x63, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x64, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x64, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x65, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x65, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x66, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x66, ARCH_GCN_1_2_4  },
    { "v_cmp_o_f64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x67, ARCH_GCN_1_2_4  },
    { "v_cmp_o_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x67, ARCH_GCN_1_2_4  },
    { "v_cmp_u_f64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x68, ARCH_GCN_1_2_4  },
    { "v_cmp_u_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x68, ARCH_GCN_1_2_4  },
    { "v_cmp_nge_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x69, ARCH_GCN_1_2_4  },
    { "v_cmp_nge_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x69, ARCH_GCN_1_2_4  },
    { "v_cmp_nlg_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6a, ARCH_GCN_1_2_4  },
    { "v_cmp_nlg_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6a, ARCH_GCN_1_2_4  },
    { "v_cmp_ngt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6b, ARCH_GCN_1_2_4  },
    { "v_cmp_ngt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6b, ARCH_GCN_1_2_4  },
    { "v_cmp_nle_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6c, ARCH_GCN_1_2_4  },
    { "v_cmp_nle_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6c, ARCH_GCN_1_2_4  },
    { "v_cmp_neq_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6d, ARCH_GCN_1_2_4  },
    { "v_cmp_neq_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6d, ARCH_GCN_1_2_4  },
    { "v_cmp_nlt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6e, ARCH_GCN_1_2_4  },
    { "v_cmp_nlt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6e, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6f, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6f, ARCH_GCN_1_2_4  },
    { "v_cmp_t_f64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x6f, ARCH_GCN_1_2_4  },
    { "v_cmp_t_f64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0x6f, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x70, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x70, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x71, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x71, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x72, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x72, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x73, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x73, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x74, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x74, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x75, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x75, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_f64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x76, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_f64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0x76, ARCH_GCN_1_2_4  },
    { "v_cmpx_o_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x77, ARCH_GCN_1_2_4  },
    { "v_cmpx_o_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x77, ARCH_GCN_1_2_4  },
    { "v_cmpx_u_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x78, ARCH_GCN_1_2_4  },
    { "v_cmpx_u_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x78, ARCH_GCN_1_2_4  },
    { "v_cmpx_nge_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x79, ARCH_GCN_1_2_4  },
    { "v_cmpx_nge_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x79, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlg_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7a, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlg_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7a, ARCH_GCN_1_2_4  },
    { "v_cmpx_ngt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7b, ARCH_GCN_1_2_4  },
    { "v_cmpx_ngt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7b, ARCH_GCN_1_2_4  },
    { "v_cmpx_nle_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7c, ARCH_GCN_1_2_4  },
    { "v_cmpx_nle_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7c, ARCH_GCN_1_2_4  },
    { "v_cmpx_neq_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7d, ARCH_GCN_1_2_4  },
    { "v_cmpx_neq_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7d, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlt_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7e, ARCH_GCN_1_2_4  },
    { "v_cmpx_nlt_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7e, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_f64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7f, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7f, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_f64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0x7f, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_f64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0x7f, ARCH_GCN_1_2_4  },
    { "v_cmp_f_i16",         GCNENC_VOPC,   GCN_STDMODE,              0xa0, ARCH_GCN_1_2_4  },
    { "v_cmp_f_i16",         GCNENC_VOP3A,  GCN_STDMODE,              0xa0, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa1, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa1, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa2, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa2, ARCH_GCN_1_2_4  },
    { "v_cmp_le_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa3, ARCH_GCN_1_2_4  },
    { "v_cmp_le_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa3, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa4, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa4, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa5, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa5, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa5, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa5, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xa6, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa6, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xa7, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xa7, ARCH_GCN_1_2_4  },
    { "v_cmp_t_i16",         GCNENC_VOPC,   GCN_STDMODE,              0xa7, ARCH_GCN_1_2_4  },
    { "v_cmp_t_i16",         GCNENC_VOP3A,  GCN_STDMODE,              0xa7, ARCH_GCN_1_2_4  },
    { "v_cmp_f_u16",         GCNENC_VOPC,   GCN_STDMODE,              0xa8, ARCH_GCN_1_2_4  },
    { "v_cmp_f_u16",         GCNENC_VOP3A,  GCN_STDMODE,              0xa8, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xa9, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xa9, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xaa, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xaa, ARCH_GCN_1_2_4  },
    { "v_cmp_le_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xab, ARCH_GCN_1_2_4  },
    { "v_cmp_le_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xab, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xac, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xac, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xad, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xad, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xad, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xad, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xae, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xae, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xaf, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xaf, ARCH_GCN_1_2_4  },
    { "v_cmp_t_u16",         GCNENC_VOPC,   GCN_STDMODE,              0xaf, ARCH_GCN_1_2_4  },
    { "v_cmp_t_u16",         GCNENC_VOP3A,  GCN_STDMODE,              0xaf, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xb0, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xb0, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb1, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb1, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb2, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb2, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb3, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb3, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb4, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb4, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb5, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_i16",       GCNENC_VOPC,   GCN_STDMODE,              0xb6, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_i16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb6, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_i16",      GCNENC_VOPC,   GCN_STDMODE,              0xb7, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_i16",      GCNENC_VOP3A,  GCN_STDMODE,              0xb7, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_i16",        GCNENC_VOPC,   GCN_STDMODE,              0xb7, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_i16",        GCNENC_VOP3A,  GCN_STDMODE,              0xb7, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xb8, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xb8, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xb9, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xb9, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xba, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xba, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xbb, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xbb, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xbc, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xbc, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xbd, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xbd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xbd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xbd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_u16",       GCNENC_VOPC,   GCN_STDMODE,              0xbe, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_u16",       GCNENC_VOP3A,  GCN_STDMODE,              0xbe, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_u16",      GCNENC_VOPC,   GCN_STDMODE,              0xbf, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_u16",      GCNENC_VOP3A,  GCN_STDMODE,              0xbf, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_u16",        GCNENC_VOPC,   GCN_STDMODE,              0xbf, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_u16",        GCNENC_VOP3A,  GCN_STDMODE,              0xbf, ARCH_GCN_1_2_4  },
    { "v_cmp_f_i32",         GCNENC_VOPC,   GCN_STDMODE,              0xc0, ARCH_GCN_1_2_4  },
    { "v_cmp_f_i32",         GCNENC_VOP3A,  GCN_STDMODE,              0xc0, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc1, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc1, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc2, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc2, ARCH_GCN_1_2_4  },
    { "v_cmp_le_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc3, ARCH_GCN_1_2_4  },
    { "v_cmp_le_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc3, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc4, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc4, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc5, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc5, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc5, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc5, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xc6, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc6, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xc7, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xc7, ARCH_GCN_1_2_4  },
    { "v_cmp_t_i32",         GCNENC_VOPC,   GCN_STDMODE,              0xc7, ARCH_GCN_1_2_4  },
    { "v_cmp_t_i32",         GCNENC_VOP3A,  GCN_STDMODE,              0xc7, ARCH_GCN_1_2_4  },
    { "v_cmp_f_u32",         GCNENC_VOPC,   GCN_STDMODE,              0xc8, ARCH_GCN_1_2_4  },
    { "v_cmp_f_u32",         GCNENC_VOP3A,  GCN_STDMODE,              0xc8, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xc9, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xc9, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xca, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xca, ARCH_GCN_1_2_4  },
    { "v_cmp_le_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xcb, ARCH_GCN_1_2_4  },
    { "v_cmp_le_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xcb, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xcc, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xcc, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xcd, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xcd, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xcd, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xcd, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xce, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xce, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xcf, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xcf, ARCH_GCN_1_2_4  },
    { "v_cmp_t_u32",         GCNENC_VOPC,   GCN_STDMODE,              0xcf, ARCH_GCN_1_2_4  },
    { "v_cmp_t_u32",         GCNENC_VOP3A,  GCN_STDMODE,              0xcf, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xd0, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xd0, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd1, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd1, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd2, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd2, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd3, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd3, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd4, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd4, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd5, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_i32",       GCNENC_VOPC,   GCN_STDMODE,              0xd6, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_i32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd6, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_i32",      GCNENC_VOPC,   GCN_STDMODE,              0xd7, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_i32",      GCNENC_VOP3A,  GCN_STDMODE,              0xd7, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_i32",        GCNENC_VOPC,   GCN_STDMODE,              0xd7, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_i32",        GCNENC_VOP3A,  GCN_STDMODE,              0xd7, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xd8, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xd8, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xd9, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xd9, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xda, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xda, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xdb, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xdb, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xdc, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xdc, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xdd, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xdd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xdd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xdd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_u32",       GCNENC_VOPC,   GCN_STDMODE,              0xde, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_u32",       GCNENC_VOP3A,  GCN_STDMODE,              0xde, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_u32",      GCNENC_VOPC,   GCN_STDMODE,              0xdf, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_u32",      GCNENC_VOP3A,  GCN_STDMODE,              0xdf, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_u32",        GCNENC_VOPC,   GCN_STDMODE,              0xdf, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_u32",        GCNENC_VOP3A,  GCN_STDMODE,              0xdf, ARCH_GCN_1_2_4  },
    { "v_cmp_f_i64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe0, ARCH_GCN_1_2_4  },
    { "v_cmp_f_i64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe0, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe1, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe1, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe2, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe2, ARCH_GCN_1_2_4  },
    { "v_cmp_le_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe3, ARCH_GCN_1_2_4  },
    { "v_cmp_le_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe3, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe4, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe4, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe5, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe5, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe5, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe5, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe6, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe6, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe7, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe7, ARCH_GCN_1_2_4  },
    { "v_cmp_t_i64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe7, ARCH_GCN_1_2_4  },
    { "v_cmp_t_i64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe7, ARCH_GCN_1_2_4  },
    { "v_cmp_f_u64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe8, ARCH_GCN_1_2_4  },
    { "v_cmp_f_u64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe8, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xe9, ARCH_GCN_1_2_4  },
    { "v_cmp_lt_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xe9, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xea, ARCH_GCN_1_2_4  },
    { "v_cmp_eq_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xea, ARCH_GCN_1_2_4  },
    { "v_cmp_le_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xeb, ARCH_GCN_1_2_4  },
    { "v_cmp_le_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xeb, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xec, ARCH_GCN_1_2_4  },
    { "v_cmp_gt_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xec, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xed, ARCH_GCN_1_2_4  },
    { "v_cmp_lg_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xed, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xed, ARCH_GCN_1_2_4  },
    { "v_cmp_ne_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xed, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xee, ARCH_GCN_1_2_4  },
    { "v_cmp_ge_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xee, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xef, ARCH_GCN_1_2_4  },
    { "v_cmp_tru_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xef, ARCH_GCN_1_2_4  },
    { "v_cmp_t_u64",         GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xef, ARCH_GCN_1_2_4  },
    { "v_cmp_t_u64",         GCNENC_VOP3A,  GCN_REG_ALL_64,           0xef, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf0, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf0, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf1, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf1, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf2, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf2, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf3, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf3, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf4, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf4, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf5, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf5, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_i64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf6, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_i64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf6, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_i64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf7, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_i64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf7, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_i64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf7, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_i64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf7, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf8, ARCH_GCN_1_2_4  },
    { "v_cmpx_f_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf8, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xf9, ARCH_GCN_1_2_4  },
    { "v_cmpx_lt_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xf9, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xfa, ARCH_GCN_1_2_4  },
    { "v_cmpx_eq_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xfa, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xfb, ARCH_GCN_1_2_4  },
    { "v_cmpx_le_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xfb, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xfc, ARCH_GCN_1_2_4  },
    { "v_cmpx_gt_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xfc, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xfd, ARCH_GCN_1_2_4  },
    { "v_cmpx_lg_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xfd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xfd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ne_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xfd, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_u64",       GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xfe, ARCH_GCN_1_2_4  },
    { "v_cmpx_ge_u64",       GCNENC_VOP3A,  GCN_REG_ALL_64,           0xfe, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_u64",      GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xff, ARCH_GCN_1_2_4  },
    { "v_cmpx_tru_u64",      GCNENC_VOP3A,  GCN_REG_ALL_64,           0xff, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_u64",        GCNENC_VOPC,   GCN_REG_ALL_64|GCN_VOP_NODPP, 0xff, ARCH_GCN_1_2_4  },
    { "v_cmpx_t_u64",        GCNENC_VOP3A,  GCN_REG_ALL_64,           0xff, ARCH_GCN_1_2_4  },
    { "v_mad_legacy_f32",    GCNENC_VOP3A,  GCN_STDMODE,              320,  ARCH_GCN_1_0_1_5  },
    { "v_mad_f32",           GCNENC_VOP3A,  GCN_STDMODE,              321,  ARCH_GCN_1_0_1_5  },
    { "v_mad_i32_i24",       GCNENC_VOP3A,  GCN_STDMODE,              322,  ARCH_GCN_1_0_1_5  },
    { "v_mad_u32_u24",       GCNENC_VOP3A,  GCN_STDMODE,              323,  ARCH_GCN_1_0_1_5  },
    { "v_cubeid_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             324,  ARCH_GCN_1_0_1_5  },
    { "v_cubesc_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             325,  ARCH_GCN_1_0_1_5  },
    { "v_cubetc_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             326,  ARCH_GCN_1_0_1_5  },
    { "v_cubema_f32",        GCNENC_VOP3A,  GCN_FLOATLIT,             327,  ARCH_GCN_1_0_1_5  },
    { "v_bfe_u32",           GCNENC_VOP3A,  GCN_STDMODE,              328,  ARCH_GCN_1_0_1_5  },
    { "v_bfe_i32",           GCNENC_VOP3A,  GCN_STDMODE,              329,  ARCH_GCN_1_0_1_5  },
    { "v_bfi_b32",           GCNENC_VOP3A,  GCN_STDMODE,              330,  ARCH_GCN_1_0_1_5  },
    { "v_fma_f32",           GCNENC_VOP3A,  GCN_STDMODE,              331,  ARCH_GCN_1_0_1_5  },
    { "v_fma_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64,           332,  ARCH_GCN_1_0_1_5  },
    { "v_lerp_u8",           GCNENC_VOP3A,  GCN_STDMODE,              333,  ARCH_GCN_1_0_1_5  },
    { "v_alignbit_b32",      GCNENC_VOP3A,  GCN_STDMODE,              334,  ARCH_GCN_1_0_1_5  },
    { "v_alignbyte_b32",     GCNENC_VOP3A,  GCN_STDMODE,              335,  ARCH_GCN_1_0_1_5  },
    { "v_mullit_f32",        GCNENC_VOP3A,  GCN_STDMODE,              336,  ARCH_GCN_1_0_1_5  },
    { "v_min3_f32",          GCNENC_VOP3A,  GCN_FLOATLIT,             337,  ARCH_GCN_1_0_1_5  },
    { "v_min3_i32",          GCNENC_VOP3A,  GCN_STDMODE,              338,  ARCH_GCN_1_0_1_5  },
    { "v_min3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              339,  ARCH_GCN_1_0_1_5  },
    { "v_max3_f32",          GCNENC_VOP3A,  GCN_FLOATLIT,             340,  ARCH_GCN_1_0_1_5  },
    { "v_max3_i32",          GCNENC_VOP3A,  GCN_STDMODE,              341,  ARCH_GCN_1_0_1_5  },
    { "v_max3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              342,  ARCH_GCN_1_0_1_5  },
    { "v_med3_f32",          GCNENC_VOP3A,  GCN_FLOATLIT,             343,  ARCH_GCN_1_0_1_5  },
    { "v_med3_i32",          GCNENC_VOP3A,  GCN_STDMODE,              344,  ARCH_GCN_1_0_1_5  },
    { "v_med3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              345,  ARCH_GCN_1_0_1_5  },
    { "v_sad_u8",            GCNENC_VOP3A,  GCN_STDMODE,              346,  ARCH_GCN_1_0_1_5  },
    { "v_sad_hi_u8",         GCNENC_VOP3A,  GCN_STDMODE,              347,  ARCH_GCN_1_0_1_5  },
    { "v_sad_u16",           GCNENC_VOP3A,  GCN_STDMODE,              348,  ARCH_GCN_1_0_1_5  },
    { "v_sad_u32",           GCNENC_VOP3A,  GCN_STDMODE,              349,  ARCH_GCN_1_0_1_5  },
    { "v_cvt_pk_u8_f32",     GCNENC_VOP3A,  GCN_FLOATLIT,             350,  ARCH_GCN_1_0_1_5  },
    { "v_div_fixup_f32",     GCNENC_VOP3A,  GCN_FLOATLIT,             351,  ARCH_GCN_1_0_1_5  },
    { "v_div_fixup_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           352,  ARCH_GCN_1_0_1_5  },
    { "v_lshl_b64",          GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE,353,  ARCH_GCN_1_0_1  },
    { "v_lshr_b64",          GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE,354,  ARCH_GCN_1_0_1  },
    { "v_ashr_i64",          GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE,355,  ARCH_GCN_1_0_1  },
    { "v_add_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,356,  ARCH_GCN_1_0_1_5  },
    { "v_mul_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,357,  ARCH_GCN_1_0_1_5  },
    { "v_min_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,358,  ARCH_GCN_1_0_1_5  },
    { "v_max_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,359,  ARCH_GCN_1_0_1_5  },
    { "v_ldexp_f64",         GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE,360,  ARCH_GCN_1_0_1_5  },
    { "v_mul_lo_u32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            361,  ARCH_GCN_1_0_1_5  },
    { "v_mul_hi_u32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            362,  ARCH_GCN_1_0_1_5  },
    { "v_mul_lo_i32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            363,  ARCH_GCN_1_0_1_5  },
    { "v_mul_hi_i32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            364,  ARCH_GCN_1_0_1_5  },
    { "v_div_fmas_f32",      GCNENC_VOP3A,  GCN_STDMODE|GCN_VCC_IMPL_READ,            367,  ARCH_GCN_1_0_1_5  },
    { "v_div_fmas_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VCC_IMPL_READ,            368,  ARCH_GCN_1_0_1_5  },
    { "v_msad_u8",           GCNENC_VOP3A,  GCN_STDMODE,              369,  ARCH_GCN_1_0_1_5  },
    { "v_qsad_u8",           GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 370,  ARCH_HD7X00   },
    { "v_mqsad_u8",          GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 371,  ARCH_HD7X00   },
    { "v_qsad_u8",           GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 370,  ARCH_RX2X0   },
    { "v_mqsad_u8",          GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 371,  ARCH_RX2X0   },
    { "v_qsad_pk_u16_u8",    GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 370, ARCH_GCN_1_1_5 },
    { "v_mqsad_pk_u16_u8",   GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 371, ARCH_GCN_1_1_5 },
    { "v_trig_preop_f64",    GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE, 372,  ARCH_GCN_1_0_1_5 },
    { "v_mqsad_u32_u8",      GCNENC_VOP3A,  GCN_REG_SRC0_64|GCN_VOP3_DS2_128,        373, ARCH_GCN_1_1_5 },
    { "v_mad_u64_u32",       GCNENC_VOP3B,  GCN_REG_DS2_64|GCN_DST_VCC_VSRC2,        374, ARCH_GCN_1_1_5 },
    { "v_mad_i64_i32",       GCNENC_VOP3B,  GCN_REG_DS2_64|GCN_DST_VCC_VSRC2,        375,  ARCH_GCN_1_1_5 },
    { "v_div_scale_f32",     GCNENC_VOP3B,  GCN_FLOATLIT|GCN_S0EQS12|GCN_VCC_IMPL_WRITE,        365,  ARCH_GCN_1_0_1_5  },
    { "v_div_scale_f64",     GCNENC_VOP3B,  GCN_REG_ALL_64|GCN_S0EQS12|GCN_VCC_IMPL_WRITE,        366,  ARCH_GCN_1_0_1_5  },
    { "v_xor3_b32",          GCNENC_VOP3A,  GCN_STDMODE,              376,  ARCH_GCN_1_5  },
    { "v_mad_legacy_f32",    GCNENC_VOP3A,  GCN_STDMODE,              448,  ARCH_GCN_1_2_4  },
    { "v_mad_f32",           GCNENC_VOP3A,  GCN_STDMODE,              449,  ARCH_GCN_1_2_4  },
    { "v_mad_i32_i24",       GCNENC_VOP3A,  GCN_STDMODE,              450,  ARCH_GCN_1_2_4  },
    { "v_mad_u32_u24",       GCNENC_VOP3A,  GCN_STDMODE,              451,  ARCH_GCN_1_2_4  },
    { "v_cubeid_f32",        GCNENC_VOP3A,  GCN_STDMODE,              452,  ARCH_GCN_1_2_4  },
    { "v_cubesc_f32",        GCNENC_VOP3A,  GCN_STDMODE,              453,  ARCH_GCN_1_2_4  },
    { "v_cubetc_f32",        GCNENC_VOP3A,  GCN_STDMODE,              454,  ARCH_GCN_1_2_4  },
    { "v_cubema_f32",        GCNENC_VOP3A,  GCN_STDMODE,              455,  ARCH_GCN_1_2_4  },
    { "v_bfe_u32",           GCNENC_VOP3A,  GCN_STDMODE,              456,  ARCH_GCN_1_2_4  },
    { "v_bfe_i32",           GCNENC_VOP3A,  GCN_STDMODE,              457,  ARCH_GCN_1_2_4  },
    { "v_bfi_b32",           GCNENC_VOP3A,  GCN_STDMODE,              458,  ARCH_GCN_1_2_4  },
    { "v_fma_f32",           GCNENC_VOP3A,  GCN_STDMODE,              459,  ARCH_GCN_1_2_4  },
    { "v_fma_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64,           460,  ARCH_GCN_1_2_4  },
    { "v_lerp_u8",           GCNENC_VOP3A,  GCN_STDMODE,              461,  ARCH_GCN_1_2_4  },
    { "v_alignbit_b32",      GCNENC_VOP3A,  GCN_STDMODE,              462,  ARCH_GCN_1_2_4  },
    { "v_alignbyte_b32",     GCNENC_VOP3A,  GCN_STDMODE,              463,  ARCH_GCN_1_2_4  },
    { "v_min3_f32",          GCNENC_VOP3A,  GCN_STDMODE,              464,  ARCH_GCN_1_2_4  },
    { "v_min3_i32",          GCNENC_VOP3A,  GCN_STDMODE,              465,  ARCH_GCN_1_2_4  },
    { "v_min3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              466,  ARCH_GCN_1_2_4  },
    { "v_max3_f32",          GCNENC_VOP3A,  GCN_STDMODE,              467,  ARCH_GCN_1_2_4  },
    { "v_max3_i32",          GCNENC_VOP3A,  GCN_STDMODE,              468,  ARCH_GCN_1_2_4  },
    { "v_max3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              469,  ARCH_GCN_1_2_4  },
    { "v_med3_f32",          GCNENC_VOP3A,  GCN_STDMODE,              470,  ARCH_GCN_1_2_4  },
    { "v_med3_i32",          GCNENC_VOP3A,  GCN_STDMODE,              471,  ARCH_GCN_1_2_4  },
    { "v_med3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              472,  ARCH_GCN_1_2_4  },
    { "v_sad_u8",            GCNENC_VOP3A,  GCN_STDMODE,              473,  ARCH_GCN_1_2_4  },
    { "v_sad_hi_u8",         GCNENC_VOP3A,  GCN_STDMODE,              474,  ARCH_GCN_1_2_4  },
    { "v_sad_u16",           GCNENC_VOP3A,  GCN_STDMODE,              475,  ARCH_GCN_1_2_4  },
    { "v_sad_u32",           GCNENC_VOP3A,  GCN_STDMODE,              476,  ARCH_GCN_1_2_4  },
    { "v_cvt_pk_u8_f32",     GCNENC_VOP3A,  GCN_STDMODE,              477,  ARCH_GCN_1_2_4  },
    { "v_div_fixup_f32",     GCNENC_VOP3A,  GCN_STDMODE,              478,  ARCH_GCN_1_2_4  },
    { "v_div_fixup_f64",     GCNENC_VOP3A,  GCN_REG_ALL_64,           479,  ARCH_GCN_1_2_4  },
    { "v_div_fmas_f32",      GCNENC_VOP3A,  GCN_STDMODE|GCN_VCC_IMPL_READ,        482,  ARCH_GCN_1_2_4  },
    { "v_div_fmas_f64",      GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_VCC_IMPL_READ,        483,  ARCH_GCN_1_2_4  },
    { "v_msad_u8",           GCNENC_VOP3A,  GCN_STDMODE,              484,  ARCH_GCN_1_2_4  },
    { "v_qsad_pk_u16_u8",    GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 485,  ARCH_GCN_1_2_4  },
    { "v_mqsad_pk_u16_u8",   GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 486,  ARCH_GCN_1_2_4  },
    { "v_qsad_u8",           GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 485,  ARCH_GCN_1_2_4  },
    { "v_mqsad_u8",          GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_REG_SRC2_64, 486,  ARCH_GCN_1_2_4  },
    { "v_mqsad_u32_u8",      GCNENC_VOP3A,  GCN_REG_SRC0_64|GCN_VOP3_DS2_128 , 487,  ARCH_GCN_1_2_4  },
    { "v_mad_f16",           GCNENC_VOP3A,  GCN_STDMODE,              490,  ARCH_RX3X0  },
    { "v_mad_u16",           GCNENC_VOP3A,  GCN_STDMODE,              491,  ARCH_RX3X0  },
    { "v_mad_i16",           GCNENC_VOP3A,  GCN_STDMODE,              492,  ARCH_RX3X0  },
    { "v_perm_b32",          GCNENC_VOP3A,  GCN_STDMODE,              493,  ARCH_GCN_1_2_4  },
    { "v_fma_f16",           GCNENC_VOP3A,  GCN_STDMODE,              494,  ARCH_RX3X0  },
    { "v_div_fixup_f16",     GCNENC_VOP3A,  GCN_STDMODE,              495,  ARCH_RX3X0  },
    { "v_mad_legacy_f16",    GCNENC_VOP3A,  GCN_STDMODE,              490,  ARCH_GCN_1_4  },
    { "v_mad_legacy_u16",    GCNENC_VOP3A,  GCN_STDMODE,              491,  ARCH_GCN_1_4  },
    { "v_mad_legacy_i16",    GCNENC_VOP3A,  GCN_STDMODE,              492,  ARCH_GCN_1_4  },
    { "v_fma_legacy_f16",    GCNENC_VOP3A,  GCN_STDMODE,              494,  ARCH_GCN_1_4  },
    { "v_div_fixup_legacy_f16", GCNENC_VOP3A,  GCN_STDMODE,             495,  ARCH_GCN_1_4  },
    { "v_cvt_pkaccum_u8_f32",GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01,       496,  ARCH_GCN_1_2_4  },
    { "v_mad_u32_u16",       GCNENC_VOP3A,  GCN_STDMODE,              497,  ARCH_GCN_1_4   },
    { "v_mad_i32_i16",       GCNENC_VOP3A,  GCN_STDMODE,              498,  ARCH_GCN_1_4   },
    { "v_xad_u32",           GCNENC_VOP3A,  GCN_STDMODE,              499,  ARCH_GCN_1_4   },
    { "v_min3_f16",          GCNENC_VOP3A,  GCN_STDMODE,              500,  ARCH_GCN_1_4   },
    { "v_min3_i16",          GCNENC_VOP3A,  GCN_STDMODE,              501,  ARCH_GCN_1_4   },
    { "v_min3_u16",          GCNENC_VOP3A,  GCN_STDMODE,              502,  ARCH_GCN_1_4   },
    { "v_max3_f16",          GCNENC_VOP3A,  GCN_STDMODE,              503,  ARCH_GCN_1_4   },
    { "v_max3_i16",          GCNENC_VOP3A,  GCN_STDMODE,              504,  ARCH_GCN_1_4   },
    { "v_max3_u16",          GCNENC_VOP3A,  GCN_STDMODE,              505,  ARCH_GCN_1_4   },
    { "v_med3_f16",          GCNENC_VOP3A,  GCN_STDMODE,              506,  ARCH_GCN_1_4   },
    { "v_med3_i16",          GCNENC_VOP3A,  GCN_STDMODE,              507,  ARCH_GCN_1_4   },
    { "v_med3_u16",          GCNENC_VOP3A,  GCN_STDMODE,              508,  ARCH_GCN_1_4   },
    { "v_lshl_add_u32",      GCNENC_VOP3A,  GCN_STDMODE,              509,  ARCH_GCN_1_4   },
    { "v_add_lshl_u32",      GCNENC_VOP3A,  GCN_STDMODE,              510,  ARCH_GCN_1_4   },
    { "v_add3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              511,  ARCH_GCN_1_4   },
    { "v_lshl_or_b32",       GCNENC_VOP3A,  GCN_STDMODE,              512,  ARCH_GCN_1_4   },
    { "v_and_or_b32",        GCNENC_VOP3A,  GCN_STDMODE,              513,  ARCH_GCN_1_4   },
    { "v_or3_b32",           GCNENC_VOP3A,  GCN_STDMODE,              514,  ARCH_GCN_1_4   },
    { "v_mad_f16",           GCNENC_VOP3A,  GCN_STDMODE,              515,  ARCH_GCN_1_4   },
    { "v_mad_u16",           GCNENC_VOP3A,  GCN_STDMODE,              516,  ARCH_GCN_1_4   },
    { "v_mad_i16",           GCNENC_VOP3A,  GCN_STDMODE,              517,  ARCH_GCN_1_4   },
    { "v_fma_f16",           GCNENC_VOP3A,  GCN_STDMODE,              518,  ARCH_GCN_1_4   },
    { "v_div_fixup_f16",     GCNENC_VOP3A,  GCN_STDMODE,              519,  ARCH_GCN_1_4   },
    { "v_interp_p1_f32",     GCNENC_VOP3A,  GCN_VOP3_VINTRP,          624,  ARCH_GCN_1_2_4  },
    { "v_interp_p2_f32",     GCNENC_VOP3A,  GCN_VOP3_VINTRP,          625,  ARCH_GCN_1_2_4  },
    { "v_interp_mov_f32",    GCNENC_VOP3A,  GCN_VOP3_VINTRP|GCN_P0_P10_P20, 626,  ARCH_GCN_1_2_4  },
    { "v_interp_p1ll_f16",   GCNENC_VOP3A,  GCN_VOP3_VINTRP_NEW,      628,  ARCH_GCN_1_2_4  },
    { "v_interp_p1lv_f16",   GCNENC_VOP3A,  GCN_VOP3_VINTRP_NEW|GCN_VINTRP_SRC2,        629,  ARCH_GCN_1_2_4  },
    { "v_interp_p2_f16",     GCNENC_VOP3A,  GCN_VOP3_VINTRP_NEW|GCN_VINTRP_SRC2, 630,  ARCH_RX3X0  },
    { "v_interp_p2_legacy_f16", GCNENC_VOP3A,         GCN_VOP3_VINTRP_NEW|GCN_VINTRP_SRC2|GCN_STDMODE,    630,  ARCH_GCN_1_4 },
    { "v_interp_p2_f16",     GCNENC_VOP3A,  GCN_VOP3_VINTRP_NEW|GCN_VINTRP_SRC2,        631,  ARCH_GCN_1_4  },
    { "v_add_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,640,  ARCH_GCN_1_2_4  },
    { "v_mul_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,641,  ARCH_GCN_1_2_4  },
    { "v_min_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,642,  ARCH_GCN_1_2_4  },
    { "v_max_f64",           GCNENC_VOP3A,  GCN_REG_ALL_64|GCN_SRC2_NONE,643,  ARCH_GCN_1_2_4  },
    { "v_ldexp_f64",         GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE,644,  ARCH_GCN_1_2_4  },
    { "v_mul_lo_u32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            645,  ARCH_GCN_1_2_4  },
    { "v_mul_hi_u32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            646,  ARCH_GCN_1_2_4  },
    { "v_mul_hi_i32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            647,  ARCH_GCN_1_2_4  },
    { "v_ldexp_f32",         GCNENC_VOP3A,  GCN_SRC2_NONE,            648,  ARCH_GCN_1_2_4  },
    { "v_readlane_b32",      GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_VOP3_DS1_SGPR|GCN_VOP_NOWVSZ,        649,  ARCH_GCN_1_2_4  },
    { "v_writelane_b32",     GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_VOP3_SRC1_SGPR|GCN_VOP_NOWVSZ,        650, ARCH_GCN_1_2_4  },
    { "v_bcnt_u32_b32",      GCNENC_VOP3A,  GCN_SRC2_NONE,            651,  ARCH_GCN_1_2_4  },
    { "v_mbcnt_lo_u32_b32",  GCNENC_VOP3A,  GCN_SRC2_NONE,            652,  ARCH_GCN_1_2_4  },
    { "v_mbcnt_hi_u32_b32",  GCNENC_VOP3A,  GCN_SRC2_NONE,            653,  ARCH_GCN_1_2_4  },
    { "v_mac_legacy_f32",    GCNENC_VOP3A,  GCN_SRC2_NONE,            654,  ARCH_GCN_1_2_4  },
    { "v_lshlrev_b64",       GCNENC_VOP3A,  GCN_REG_DS1_64|GCN_SRC2_NONE,655,  ARCH_GCN_1_2_4  },
    { "v_lshrrev_b64",       GCNENC_VOP3A,  GCN_REG_DS1_64|GCN_SRC2_NONE,656,  ARCH_GCN_1_2_4  },
    { "v_ashrrev_i64",       GCNENC_VOP3A,  GCN_REG_DS1_64|GCN_SRC2_NONE,657,  ARCH_GCN_1_2_4  },
    { "v_trig_preop_f64",    GCNENC_VOP3A,  GCN_REG_DS0_64|GCN_SRC2_NONE, 658,  ARCH_GCN_1_2_4  },
    { "v_bfm_b32",           GCNENC_VOP3A,  GCN_SRC2_NONE,            659,     ARCH_GCN_1_2_4  },
    { "v_cvt_pknorm_i16_f32",GCNENC_VOP3A,  GCN_SRC2_NONE,            660,  ARCH_GCN_1_2_4  },
    { "v_cvt_pknorm_u16_f32",GCNENC_VOP3A,  GCN_SRC2_NONE,            661,  ARCH_GCN_1_2_4  },
    { "v_cvt_pkrtz_f16_f32", GCNENC_VOP3A,  GCN_SRC2_NONE,            662,  ARCH_GCN_1_2_4  },
    { "v_cvt_pk_u16_u32",    GCNENC_VOP3A,  GCN_SRC2_NONE,            663,  ARCH_GCN_1_2_4  },
    { "v_cvt_pk_i16_i32",    GCNENC_VOP3A,  GCN_SRC2_NONE,            664,  ARCH_GCN_1_2_4  },
    { "v_cvt_pknorm_i16_f16", GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_STDMODE,    665,  ARCH_GCN_1_4  },
    { "v_cvt_pknorm_u16_f16", GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_STDMODE,    666,  ARCH_GCN_1_4  },
    { "v_readlane_regrd_b32", GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_VOP3_DS1_SGPR, 667,  ARCH_GCN_1_4  },
    { "v_add_i32",           GCNENC_VOP3A,  GCN_SRC2_NONE,            668,  ARCH_GCN_1_4  },
    { "v_sub_i32",           GCNENC_VOP3A,  GCN_SRC2_NONE,            669,  ARCH_GCN_1_4  },
    { "v_add_i16",           GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_STDMODE,    670,  ARCH_GCN_1_4  },
    { "v_sub_i16",           GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_STDMODE,    671,  ARCH_GCN_1_4  },
    { "v_pack_b32_f16",      GCNENC_VOP3A,  GCN_SRC2_NONE|GCN_STDMODE,    672,  ARCH_GCN_1_4  },
    { "v_mad_u64_u32",       GCNENC_VOP3B,  GCN_REG_DS2_64|GCN_DST_VCC_VSRC2,        488,  ARCH_GCN_1_2_4  },
    { "v_mad_i64_i32",       GCNENC_VOP3B,  GCN_REG_DS2_64|GCN_DST_VCC_VSRC2,        489,  ARCH_GCN_1_2_4  },
    { "v_div_scale_f32",     GCNENC_VOP3B,  GCN_STDMODE|GCN_S0EQS12|GCN_VCC_IMPL_WRITE,        480,  ARCH_GCN_1_2_4  },
    { "v_div_scale_f64",     GCNENC_VOP3B,  GCN_REG_ALL_64|GCN_S0EQS12|GCN_VCC_IMPL_WRITE,        481,  ARCH_GCN_1_2_4  },
    { "v_pk_mad_i16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P,           896, ARCH_GCN_1_4   },
    { "v_pk_mul_lo_u16",     GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 897, ARCH_GCN_1_4   },
    { "v_pk_add_i16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 898, ARCH_GCN_1_4   },
    { "v_pk_sub_i16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 899, ARCH_GCN_1_4   },
    { "v_pk_lshlrev_b16",    GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 900, ARCH_GCN_1_4   },
    { "v_pk_lshrrev_b16",    GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 901, ARCH_GCN_1_4   },
    { "v_pk_ashrrev_i16",    GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 902, ARCH_GCN_1_4   },
    { "v_pk_max_i16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 903, ARCH_GCN_1_4   },
    { "v_pk_min_i16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 904, ARCH_GCN_1_4   },
    { "v_pk_mad_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P,           905, ARCH_GCN_1_4   },
    { "v_pk_add_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 906, ARCH_GCN_1_4   },
    { "v_pk_sub_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 907, ARCH_GCN_1_4   },
    { "v_pk_max_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 908, ARCH_GCN_1_4   },
    { "v_pk_min_u16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 909, ARCH_GCN_1_4   },
    { "v_pk_fma_f16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P,           910, ARCH_GCN_1_4   },
    { "v_pk_add_f16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 911, ARCH_GCN_1_4   },
    { "v_pk_mul_f16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 912, ARCH_GCN_1_4   },
    { "v_pk_min_f16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 913, ARCH_GCN_1_4   },
    { "v_pk_max_f16",        GCNENC_VOP3A,  GCN_VOP3_VOP3P|GCN_SRC2_NONE, 914, ARCH_GCN_1_4   },
    { "v_mad_mix_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP3P,            928, ARCH_GCN_1_4   },
    { "v_mad_mixlo_f16",     GCNENC_VOP3A,  GCN_VOP3_VOP3P,            929, ARCH_GCN_1_4   },
    { "v_mad_mixhi_f16",     GCNENC_VOP3A,  GCN_VOP3_VOP3P,            930, ARCH_GCN_1_4   },
    { "v_fma_mix_f32",       GCNENC_VOP3A,  GCN_VOP3_VOP3P,            928, ARCH_VEGA20   },
    { "v_fma_mixlo_f16",     GCNENC_VOP3A,  GCN_VOP3_VOP3P,            929, ARCH_VEGA20   },
    { "v_fma_mixhi_f16",     GCNENC_VOP3A,  GCN_VOP3_VOP3P,            930, ARCH_VEGA20   },
    { "v_dot2_f32_f16",      GCNENC_VOP3A,  GCN_VOP3_VOP3P,            931, ARCH_VEGA20   },
    { "v_dot2_i32_i16",      GCNENC_VOP3A,  GCN_VOP3_VOP3P,            934, ARCH_VEGA20   },
    { "v_dot2_u32_u16",      GCNENC_VOP3A,  GCN_VOP3_VOP3P,            935, ARCH_VEGA20   },
    { "v_dot4_i32_i8",       GCNENC_VOP3A,  GCN_VOP3_VOP3P,            936, ARCH_VEGA20   },
    { "v_dot4_u32_u8",       GCNENC_VOP3A,  GCN_VOP3_VOP3P,            937, ARCH_VEGA20   },
    { "v_dot8_i32_i4",       GCNENC_VOP3A,  GCN_VOP3_VOP3P,            938, ARCH_VEGA20   },
    { "v_dot8_u32_u4",       GCNENC_VOP3A,  GCN_VOP3_VOP3P,            939, ARCH_VEGA20   },
    { "v_lshlrev_b64",       GCNENC_VOP3A,  GCN_REG_DS1_64|GCN_SRC2_NONE, 767, ARCH_GCN_1_5 },
    { "v_lshrrev_b64",       GCNENC_VOP3A,  GCN_REG_DS1_64|GCN_SRC2_NONE, 768, ARCH_GCN_1_5 },
    { "v_ashrrev_i64",       GCNENC_VOP3A,  GCN_REG_DS1_64|GCN_SRC2_NONE, 769, ARCH_GCN_1_5 },
    { "v_add_nc_u16",        GCNENC_VOP3A,  GCN_SRC2_NONE,            771,  ARCH_GCN_1_5 },
    { "v_sub_nc_u16",        GCNENC_VOP3A,  GCN_SRC2_NONE,            772,  ARCH_GCN_1_5 },
    { "v_mul_lo_u16",        GCNENC_VOP3A,  GCN_SRC2_NONE,            773,  ARCH_GCN_1_5 },
    { "v_lshrrev_b16",       GCNENC_VOP3A,  GCN_SRC2_NONE,            775,  ARCH_GCN_1_5 },
    { "v_ashrrev_i16",       GCNENC_VOP3A,  GCN_SRC2_NONE,            776,  ARCH_GCN_1_5 },
    { "v_max_u16",           GCNENC_VOP3A,  GCN_SRC2_NONE,            777,  ARCH_GCN_1_5 },
    { "v_max_i16",           GCNENC_VOP3A,  GCN_SRC2_NONE,            778,  ARCH_GCN_1_5 },
    { "v_min_u16",           GCNENC_VOP3A,  GCN_SRC2_NONE,            779,  ARCH_GCN_1_5 },
    { "v_min_i16",           GCNENC_VOP3A,  GCN_SRC2_NONE,            780,  ARCH_GCN_1_5 },
    { "v_add_nc_i16",        GCNENC_VOP3A,  GCN_SRC2_NONE,            781,  ARCH_GCN_1_5 },
    { "v_sub_nc_i16",        GCNENC_VOP3A,  GCN_SRC2_NONE,            782,  ARCH_GCN_1_5 },
    { "v_add_co_u32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_SRC2_NONE, 783,  ARCH_GCN_1_5 },
    { "v_sub_co_u32",        GCNENC_VOP3B,  GCN_DST_VCC|GCN_SRC2_NONE, 784,  ARCH_GCN_1_5 },
    { "v_pack_b32_f16",      GCNENC_VOP3A,  GCN_SRC2_NONE,            785,  ARCH_GCN_1_5 },
    { "v_cvt_pknorm_i16_f16", GCNENC_VOP3A,  GCN_F16LIT|GCN_SRC2_NONE, 786,  ARCH_GCN_1_5 },
    { "v_cvt_pknorm_u16_f16", GCNENC_VOP3A,  GCN_F16LIT|GCN_SRC2_NONE, 787,  ARCH_GCN_1_5 },
    { "v_lshlrev_b16",       GCNENC_VOP3A,  GCN_SRC2_NONE,            788,  ARCH_GCN_1_5 },
    { "v_subrev_co_u32",     GCNENC_VOP3B,  GCN_DST_VCC|GCN_SRC2_NONE, 793,  ARCH_GCN_1_5 },
    { "v_mad_u16",           GCNENC_VOP3A,  GCN_STDMODE,              832,  ARCH_GCN_1_5 },
    { "v_interp_p1ll_f16",   GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VINTRP_NEW, 834,  ARCH_GCN_1_5  },
    { "v_interp_p1lv_f16",   GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VINTRP_NEW|GCN_VINTRP_SRC2,        835,  ARCH_GCN_1_5  },
    { "v_perm_b32",          GCNENC_VOP3A,  GCN_STDMODE,              836,  ARCH_GCN_1_5 },
    { "v_xad_u32",           GCNENC_VOP3A,  GCN_STDMODE,              837,  ARCH_GCN_1_5 },
    { "v_lshl_add_u32",      GCNENC_VOP3A,  GCN_STDMODE,              838,  ARCH_GCN_1_5 },
    { "v_add_lshl_u32",      GCNENC_VOP3A,  GCN_STDMODE,              839,  ARCH_GCN_1_5 },
    { "v_fma_f16",           GCNENC_VOP3A,  GCN_F16LIT,               843,  ARCH_GCN_1_5 },
    { "v_min3_f16",          GCNENC_VOP3A,  GCN_F16LIT,               849,  ARCH_GCN_1_5 },
    { "v_min3_i16",          GCNENC_VOP3A,  GCN_STDMODE,              850,  ARCH_GCN_1_5 },
    { "v_min3_u16",          GCNENC_VOP3A,  GCN_STDMODE,              851,  ARCH_GCN_1_5 },
    { "v_max3_f16",          GCNENC_VOP3A,  GCN_F16LIT,               852,  ARCH_GCN_1_5 },
    { "v_max3_i16",          GCNENC_VOP3A,  GCN_STDMODE,              853,  ARCH_GCN_1_5 },
    { "v_max3_u16",          GCNENC_VOP3A,  GCN_STDMODE,              854,  ARCH_GCN_1_5 },
    { "v_med3_f16",          GCNENC_VOP3A,  GCN_F16LIT,               855,  ARCH_GCN_1_5 },
    { "v_med3_i16",          GCNENC_VOP3A,  GCN_STDMODE,              856,  ARCH_GCN_1_5 },
    { "v_med3_u16",          GCNENC_VOP3A,  GCN_STDMODE,              857,  ARCH_GCN_1_5 },
    { "v_interp_p2_f16",     GCNENC_VOP3A,  GCN_F16LIT|GCN_VOP3_VINTRP_NEW|GCN_VINTRP_SRC2,        858,  ARCH_GCN_1_5  },
    { "v_mad_i16",           GCNENC_VOP3A,  GCN_STDMODE,              862,  ARCH_GCN_1_5 },
    { "v_div_fixup_f16",     GCNENC_VOP3A,  GCN_F16LIT,               863,  ARCH_GCN_1_5 },
    { "v_readlane_b32",      GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01|GCN_VOP3_DS1_SGPR|GCN_VOP_NOWVSZ,        864,  ARCH_GCN_1_5  },
    { "v_writelane_b32",     GCNENC_VOP3A,  GCN_VOP3_VOP2_DS01|GCN_VOP3_SRC1_SGPR|GCN_VOP_NOWVSZ,        865,  ARCH_GCN_1_5  },
    { "v_ldexp_f32",         GCNENC_VOP3A,  GCN_FLOATLIT|GCN_SRC2_NONE, 866,  ARCH_GCN_1_5 },
    { "v_bfm_b32",           GCNENC_VOP3A,  GCN_SRC2_NONE,            867,  ARCH_GCN_1_5 },
    { "v_bcnt_u32_b32",      GCNENC_VOP3A,  GCN_SRC2_NONE,            868,  ARCH_GCN_1_5 },
    { "v_mbcnt_lo_u32_b32",  GCNENC_VOP3A,  GCN_SRC2_NONE,            869,  ARCH_GCN_1_5 },
    { "v_mbcnt_hi_u32_b32",  GCNENC_VOP3A,  GCN_SRC2_NONE,            870,  ARCH_GCN_1_5 },
    { "v_cvt_pknorm_i16_f32", GCNENC_VOP3A,  GCN_FLOATLIT|GCN_SRC2_NONE, 872,  ARCH_GCN_1_5 },
    { "v_cvt_pknorm_u16_f32", GCNENC_VOP3A,  GCN_FLOATLIT|GCN_SRC2_NONE, 873,  ARCH_GCN_1_5 },
    { "v_cvt_pk_u16_u32",    GCNENC_VOP3A,  GCN_SRC2_NONE,            874,  ARCH_GCN_1_5 },
    { "v_cvt_pk_i16_i32",    GCNENC_VOP3A,  GCN_SRC2_NONE,            875,  ARCH_GCN_1_5 },
    { "v_add3_u32",          GCNENC_VOP3A,  GCN_STDMODE,              877,  ARCH_GCN_1_5 },
    { "v_lshl_or_b32",       GCNENC_VOP3A,  GCN_STDMODE,              879,  ARCH_GCN_1_5 },
    { "v_and_or_b32",        GCNENC_VOP3A,  GCN_STDMODE,              881,  ARCH_GCN_1_5 },
    { "v_or3_b32",           GCNENC_VOP3A,  GCN_STDMODE,              882,  ARCH_GCN_1_5 },
    { "v_mad_u32_u16",       GCNENC_VOP3A,  GCN_STDMODE,              883,  ARCH_GCN_1_5 },
    { "v_mad_i32_i16",       GCNENC_VOP3A,  GCN_STDMODE,              885,  ARCH_GCN_1_5 },
    { "v_sub_nc_i32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            886,  ARCH_GCN_1_5 },
    { "v_permlane16_b32",    GCNENC_VOP3A,  GCN_STDMODE,              887,  ARCH_GCN_1_5 },
    { "v_permlanex16_b32",   GCNENC_VOP3A,  GCN_STDMODE,              888,  ARCH_GCN_1_5 },
    { "v_add_nc_i32",        GCNENC_VOP3A,  GCN_SRC2_NONE,            895,  ARCH_GCN_1_5 },
    { "v_pk_mad_i16",        GCNENC_VOP3P,  GCN_STDMODE,              0, ARCH_GCN_1_5   },
    { "v_pk_mul_lo_u16",     GCNENC_VOP3P,  GCN_SRC2_NONE,            1, ARCH_GCN_1_5   },
    { "v_pk_add_i16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            2, ARCH_GCN_1_5   },
    { "v_pk_sub_i16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            3, ARCH_GCN_1_5   },
    { "v_pk_lshlrev_b16",    GCNENC_VOP3P,  GCN_SRC2_NONE,            4, ARCH_GCN_1_5   },
    { "v_pk_lshrrev_b16",    GCNENC_VOP3P,  GCN_SRC2_NONE,            5, ARCH_GCN_1_5   },
    { "v_pk_ashrrev_i16",    GCNENC_VOP3P,  GCN_SRC2_NONE,            6, ARCH_GCN_1_5   },
    { "v_pk_max_i16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            7, ARCH_GCN_1_5   },
    { "v_pk_min_i16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            8, ARCH_GCN_1_5   },
    { "v_pk_mad_u16",        GCNENC_VOP3P,  GCN_STDMODE,              9, ARCH_GCN_1_5   },
    { "v_pk_add_u16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            10, ARCH_GCN_1_5   },
    { "v_pk_sub_u16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            11, ARCH_GCN_1_5   },
    { "v_pk_max_u16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            12, ARCH_GCN_1_5   },
    { "v_pk_min_u16",        GCNENC_VOP3P,  GCN_SRC2_NONE,            13, ARCH_GCN_1_5   },
    { "v_pk_fma_f16",        GCNENC_VOP3P,  GCN_F16LIT,               14, ARCH_GCN_1_5   },
    { "v_pk_add_f16",        GCNENC_VOP3P,  GCN_F16LIT|GCN_SRC2_NONE, 15, ARCH_GCN_1_5   },
    { "v_pk_mul_f16",        GCNENC_VOP3P,  GCN_F16LIT|GCN_SRC2_NONE, 16, ARCH_GCN_1_5   },
    { "v_pk_min_f16",        GCNENC_VOP3P,  GCN_F16LIT|GCN_SRC2_NONE, 17, ARCH_GCN_1_5   },
    { "v_pk_max_f16",        GCNENC_VOP3P,  GCN_F16LIT|GCN_SRC2_NONE, 18, ARCH_GCN_1_5   },
    { "v_dot2_f32_f16",      GCNENC_VOP3P,  GCN_F16LIT,               19, ARCH_NAVI_DL   },
    { "v_dot2_i32_i16",      GCNENC_VOP3P,  GCN_STDMODE,              20, ARCH_NAVI_DL   },
    { "v_dot2_u32_u16",      GCNENC_VOP3P,  GCN_STDMODE,              21, ARCH_NAVI_DL   },
    { "v_dot4_i32_i8",       GCNENC_VOP3P,  GCN_STDMODE,              22, ARCH_NAVI_DL   },
    { "v_dot4_u32_u8",       GCNENC_VOP3P,  GCN_STDMODE,              23, ARCH_NAVI_DL   },
    { "v_dot8_i32_i4",       GCNENC_VOP3P,  GCN_STDMODE,              24, ARCH_NAVI_DL   },
    { "v_dot8_u32_u4",       GCNENC_VOP3P,  GCN_STDMODE,              25, ARCH_NAVI_DL   },
    { "v_fma_mix_f32",       GCNENC_VOP3P,  GCN_FLOATLIT,             32, ARCH_GCN_1_5   },
    { "v_fma_mixlo_f16",     GCNENC_VOP3P,  GCN_F16LIT,               33, ARCH_GCN_1_5   },
    { "v_fma_mixhi_f16",     GCNENC_VOP3P,  GCN_F16LIT,               34, ARCH_GCN_1_5   },
    { "v_interp_p1_f32",     GCNENC_VINTRP, GCN_STDMODE,              0,    ARCH_GCN_ALL  },
    { "v_interp_p2_f32",     GCNENC_VINTRP, GCN_STDMODE,              1,    ARCH_GCN_ALL  },
    { "v_interp_mov_f32",    GCNENC_VINTRP, GCN_P0_P10_P20,           2,    ARCH_GCN_ALL  },
    { "ds_add_u32",          GCNENC_DS,     GCN_ADDR_DST,             0,    ARCH_GCN_ALL  },
    { "ds_sub_u32",          GCNENC_DS,     GCN_ADDR_DST,             1,    ARCH_GCN_ALL  },
    { "ds_rsub_u32",         GCNENC_DS,     GCN_ADDR_DST,             2,    ARCH_GCN_ALL  },
    { "ds_inc_u32",          GCNENC_DS,     GCN_ADDR_DST,             3,    ARCH_GCN_ALL  },
    { "ds_dec_u32",          GCNENC_DS,     GCN_ADDR_DST,             4,    ARCH_GCN_ALL  },
    { "ds_min_i32",          GCNENC_DS,     GCN_ADDR_DST,             5,    ARCH_GCN_ALL  },
    { "ds_max_i32",          GCNENC_DS,     GCN_ADDR_DST,             6,    ARCH_GCN_ALL  },
    { "ds_min_u32",          GCNENC_DS,     GCN_ADDR_DST,             7,    ARCH_GCN_ALL  },
    { "ds_max_u32",          GCNENC_DS,     GCN_ADDR_DST,             8,    ARCH_GCN_ALL  },
    { "ds_and_b32",          GCNENC_DS,     GCN_ADDR_DST,             9,    ARCH_GCN_ALL  },
    { "ds_or_b32",           GCNENC_DS,     GCN_ADDR_DST,             10,   ARCH_GCN_ALL  },
    { "ds_xor_b32",          GCNENC_DS,     GCN_ADDR_DST,             11,   ARCH_GCN_ALL  },
    { "ds_mskor_b32",        GCNENC_DS,     GCN_ADDR_DST|GCN_2SRCS,   12,   ARCH_GCN_ALL  },
    { "ds_write_b32",        GCNENC_DS,     GCN_ADDR_DST,             13,   ARCH_GCN_ALL  },
    { "ds_write2_b32",       GCNENC_DS,     GCN_ADDR_DST|GCN_VDATA2,  14,   ARCH_GCN_ALL  },
    { "ds_write2st64_b32",   GCNENC_DS,     GCN_ADDR_DST|GCN_VDATA2,  15,   ARCH_GCN_ALL  },
    { "ds_cmpst_b32",        GCNENC_DS,     GCN_ADDR_DST|GCN_2SRCS,   16,   ARCH_GCN_ALL  },
    { "ds_cmpst_f32",        GCNENC_DS,     GCN_ADDR_DST|GCN_2SRCS,   17,   ARCH_GCN_ALL  },
    { "ds_min_f32",          GCNENC_DS,     GCN_ADDR_DST,             18,   ARCH_GCN_ALL  },
    { "ds_max_f32",          GCNENC_DS,     GCN_ADDR_DST,             19,   ARCH_GCN_ALL  },
    { "ds_nop",              GCNENC_DS,     GCN_ADDR_STD,             20,   ARCH_GCN_1_1_2_4_5    },
    { "ds_add_f32",          GCNENC_DS,     GCN_ADDR_DST,             21,   ARCH_GCN_1_2_4_5  },
    { "ds_gws_sema_release_all", GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        24, ARCH_GCN_1_1_5    },
    { "ds_gws_init",         GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        25, ARCH_GCN_1_0_1_5  },
    { "ds_gws_sema_v",       GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        26, ARCH_GCN_1_0_1_5  },
    { "ds_gws_sema_br",      GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        27, ARCH_GCN_1_0_1_5  },
    { "ds_gws_sema_p",       GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        28, ARCH_GCN_1_0_1_5  },
    { "ds_gws_barrier",      GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        29, ARCH_GCN_1_0_1_5  },
    { "ds_write_addtid_b32", GCNENC_DS,     GCN_ADDR_SRC|GCN_ONLY_SRC, 29,   ARCH_GCN_1_4  },
    { "ds_write_b8",         GCNENC_DS,     GCN_ADDR_DST,             30,   ARCH_GCN_ALL  },
    { "ds_write_b16",        GCNENC_DS,     GCN_ADDR_DST,             31,   ARCH_GCN_ALL  },
    { "ds_add_rtn_u32",      GCNENC_DS,     GCN_ADDR_SRC,             32,   ARCH_GCN_ALL  },
    { "ds_sub_rtn_u32",      GCNENC_DS,     GCN_ADDR_SRC,             33,   ARCH_GCN_ALL  },
    { "ds_rsub_rtn_u32",     GCNENC_DS,     GCN_ADDR_SRC,             34,   ARCH_GCN_ALL  },
    { "ds_inc_rtn_u32",      GCNENC_DS,     GCN_ADDR_SRC,             35,   ARCH_GCN_ALL  },
    { "ds_dec_rtn_u32",      GCNENC_DS,     GCN_ADDR_SRC,             36,   ARCH_GCN_ALL  },
    { "ds_min_rtn_i32",      GCNENC_DS,     GCN_ADDR_SRC,             37,   ARCH_GCN_ALL  },
    { "ds_max_rtn_i32",      GCNENC_DS,     GCN_ADDR_SRC,             38,   ARCH_GCN_ALL  },
    { "ds_min_rtn_u32",      GCNENC_DS,     GCN_ADDR_SRC,             39,   ARCH_GCN_ALL  },
    { "ds_max_rtn_u32",      GCNENC_DS,     GCN_ADDR_SRC,             40,   ARCH_GCN_ALL  },
    { "ds_and_rtn_b32",      GCNENC_DS,     GCN_ADDR_SRC,             41,   ARCH_GCN_ALL  },
    { "ds_or_rtn_b32",       GCNENC_DS,     GCN_ADDR_SRC,             42,   ARCH_GCN_ALL  },
    { "ds_xor_rtn_b32",      GCNENC_DS,     GCN_ADDR_SRC,             43,   ARCH_GCN_ALL  },
    { "ds_mskor_rtn_b32",    GCNENC_DS,     GCN_ADDR_SRC|GCN_2SRCS,   44,   ARCH_GCN_ALL  },
    { "ds_wrxchg_rtn_b32",   GCNENC_DS,     GCN_ADDR_SRC,             45,   ARCH_GCN_ALL  },
    { "ds_wrxchg2_rtn_b32",  GCNENC_DS,     GCN_ADDR_SRC_D64|GCN_VDATA2,  46,   ARCH_GCN_ALL  },
    { "ds_wrxchg2st64_rtn_b32", GCNENC_DS,     GCN_ADDR_SRC_D64|GCN_VDATA2,  47,   ARCH_GCN_ALL  },
    { "ds_cmpst_rtn_b32",    GCNENC_DS,     GCN_ADDR_SRC|GCN_2SRCS,   48,   ARCH_GCN_ALL  },
    { "ds_cmpst_rtn_f32",    GCNENC_DS,     GCN_ADDR_SRC|GCN_2SRCS,   49,   ARCH_GCN_ALL  },
    { "ds_min_rtn_f32",      GCNENC_DS,     GCN_ADDR_SRC,             50,   ARCH_GCN_ALL  },
    { "ds_max_rtn_f32",      GCNENC_DS,     GCN_ADDR_SRC,             51,   ARCH_GCN_ALL  },
    { "ds_wrap_rtn_b32",     GCNENC_DS,     GCN_ADDR_SRC|GCN_2SRCS,   52,   ARCH_GCN_1_1_2_4_5  },
    { "ds_swizzle_b32",      GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   53,   ARCH_GCN_1_0_1_5  },
    { "ds_add_rtn_f32",      GCNENC_DS,     GCN_ADDR_SRC,             53,   ARCH_GCN_1_2_4  },
    { "ds_read_b32",         GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   54,   ARCH_GCN_ALL  },
    { "ds_read2_b32",        GCNENC_DS,     GCN_ADDR_SRC_D64|GCN_NOSRC_2OFF, 55,   ARCH_GCN_ALL  },
    { "ds_read2st64_b32",    GCNENC_DS,     GCN_ADDR_SRC_D64|GCN_NOSRC_2OFF, 56,   ARCH_GCN_ALL  },
    { "ds_read_i8",          GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   57,   ARCH_GCN_ALL  },
    { "ds_read_u8",          GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   58,   ARCH_GCN_ALL  },
    { "ds_read_i16",         GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   59,   ARCH_GCN_ALL  },
    { "ds_read_u16",         GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   60,   ARCH_GCN_ALL  },
    { "ds_swizzle_b32",      GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   61,   ARCH_GCN_1_2_4  },
    { "ds_consume",          GCNENC_DS,     GCN_ONLYDST,              61,   ARCH_GCN_1_0_1_5  },
    { "ds_permute_b32",      GCNENC_DS,     GCN_ADDR_SRC,             62,   ARCH_GCN_1_2_4  },
    { "ds_bpermute_b32",     GCNENC_DS,     GCN_ADDR_SRC,             63,   ARCH_GCN_1_2_4  },
    { "ds_append",           GCNENC_DS,     GCN_ONLYDST,              62,   ARCH_GCN_1_0_1_5  },
    { "ds_ordered_count",    GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   63,   ARCH_GCN_1_0_1_5  },
    { "ds_add_u64",          GCNENC_DS,     GCN_ADDR_DST64,           64,   ARCH_GCN_ALL  },
    { "ds_sub_u64",          GCNENC_DS,     GCN_ADDR_DST64,           65,   ARCH_GCN_ALL  },
    { "ds_rsub_u64",         GCNENC_DS,     GCN_ADDR_DST64,           66,   ARCH_GCN_ALL  },
    { "ds_inc_u64",          GCNENC_DS,     GCN_ADDR_DST64,           67,   ARCH_GCN_ALL  },
    { "ds_dec_u64",          GCNENC_DS,     GCN_ADDR_DST64,           68,   ARCH_GCN_ALL  },
    { "ds_min_i64",          GCNENC_DS,     GCN_ADDR_DST64,           69,   ARCH_GCN_ALL  },
    { "ds_max_i64",          GCNENC_DS,     GCN_ADDR_DST64,           70,   ARCH_GCN_ALL  },
    { "ds_min_u64",          GCNENC_DS,     GCN_ADDR_DST64,           71,   ARCH_GCN_ALL  },
    { "ds_max_u64",          GCNENC_DS,     GCN_ADDR_DST64,           72,   ARCH_GCN_ALL  },
    { "ds_and_b64",          GCNENC_DS,     GCN_ADDR_DST64,           73,   ARCH_GCN_ALL  },
    { "ds_or_b64",           GCNENC_DS,     GCN_ADDR_DST64,           74,   ARCH_GCN_ALL  },
    { "ds_xor_b64",          GCNENC_DS,     GCN_ADDR_DST64,           75,   ARCH_GCN_ALL  },
    { "ds_mskor_b64",        GCNENC_DS,     GCN_ADDR_DST64|GCN_2SRCS, 76,   ARCH_GCN_ALL  },
    { "ds_write_b64",        GCNENC_DS,     GCN_ADDR_DST64,           77,   ARCH_GCN_ALL  },
    { "ds_write2_b64",       GCNENC_DS,     GCN_ADDR_DST64|GCN_VDATA2, 78,   ARCH_GCN_ALL  },
    { "ds_write2st64_b64",   GCNENC_DS,     GCN_ADDR_DST64|GCN_VDATA2, 79,   ARCH_GCN_ALL  },
    { "ds_cmpst_b64",        GCNENC_DS,     GCN_ADDR_DST64|GCN_2SRCS, 80,   ARCH_GCN_ALL  },
    { "ds_cmpst_f64",        GCNENC_DS,     GCN_ADDR_DST64|GCN_2SRCS, 81,   ARCH_GCN_ALL  },
    { "ds_min_f64",          GCNENC_DS,     GCN_ADDR_DST64,           82,   ARCH_GCN_ALL  },
    { "ds_max_f64",          GCNENC_DS,     GCN_ADDR_DST64,           83,   ARCH_GCN_ALL  },
    { "ds_add_rtn_f32",      GCNENC_DS,     GCN_ADDR_SRC,             85,   ARCH_GCN_1_5  },
    { "ds_write_b8_d16_hi",  GCNENC_DS,     GCN_ADDR_DST,             84,   ARCH_GCN_1_4  },
    { "ds_write_b16_d16_hi", GCNENC_DS,     GCN_ADDR_DST,             85,   ARCH_GCN_1_4  },
    { "ds_read_u8_d16",      GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   86,   ARCH_GCN_1_4  },
    { "ds_read_u8_d16_hi",   GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   87,   ARCH_GCN_1_4  },
    { "ds_read_i8_d16",      GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   88,   ARCH_GCN_1_4  },
    { "ds_read_i8_d16_hi",   GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   89,   ARCH_GCN_1_4  },
    { "ds_read_u16_d16",     GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   90,   ARCH_GCN_1_4  },
    { "ds_read_u16_d16_hi",  GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   91,   ARCH_GCN_1_4  },
    { "ds_add_rtn_u64",      GCNENC_DS,     GCN_ADDR_SRC64,           96,   ARCH_GCN_ALL  },
    { "ds_sub_rtn_u64",      GCNENC_DS,     GCN_ADDR_SRC64,           97,   ARCH_GCN_ALL  },
    { "ds_rsub_rtn_u64",     GCNENC_DS,     GCN_ADDR_SRC64,           98,   ARCH_GCN_ALL  },
    { "ds_inc_rtn_u64",      GCNENC_DS,     GCN_ADDR_SRC64,           99,   ARCH_GCN_ALL  },
    { "ds_dec_rtn_u64",      GCNENC_DS,     GCN_ADDR_SRC64,           100,  ARCH_GCN_ALL  },
    { "ds_min_rtn_i64",      GCNENC_DS,     GCN_ADDR_SRC64,           101,  ARCH_GCN_ALL  },
    { "ds_max_rtn_i64",      GCNENC_DS,     GCN_ADDR_SRC64,           102,  ARCH_GCN_ALL  },
    { "ds_min_rtn_u64",      GCNENC_DS,     GCN_ADDR_SRC64,           103,  ARCH_GCN_ALL  },
    { "ds_max_rtn_u64",      GCNENC_DS,     GCN_ADDR_SRC64,           104,  ARCH_GCN_ALL  },
    { "ds_and_rtn_b64",      GCNENC_DS,     GCN_ADDR_SRC64,           105,  ARCH_GCN_ALL  },
    { "ds_or_rtn_b64",       GCNENC_DS,     GCN_ADDR_SRC64,           106,  ARCH_GCN_ALL  },
    { "ds_xor_rtn_b64",      GCNENC_DS,     GCN_ADDR_SRC64,           107,  ARCH_GCN_ALL  },
    { "ds_mskor_rtn_b64",    GCNENC_DS,     GCN_ADDR_SRC64|GCN_2SRCS, 108,  ARCH_GCN_ALL  },
    { "ds_wrxchg_rtn_b64",   GCNENC_DS,     GCN_ADDR_SRC64,             109,  ARCH_GCN_ALL  },
    { "ds_wrxchg2_rtn_b64",  GCNENC_DS,     GCN_ADDR_SRC64|GCN_VDATA2|GCN_DST128, 110,  ARCH_GCN_ALL  },
    { "ds_wrxchg2st64_rtn_b64", GCNENC_DS,     GCN_ADDR_SRC64|GCN_VDATA2|GCN_DST128,  111,  ARCH_GCN_ALL  },
    { "ds_cmpst_rtn_b64",    GCNENC_DS,     GCN_ADDR_SRC64|GCN_2SRCS, 112,  ARCH_GCN_ALL  },
    { "ds_cmpst_rtn_f64",    GCNENC_DS,     GCN_ADDR_SRC64|GCN_2SRCS, 113,  ARCH_GCN_ALL  },
    { "ds_min_rtn_f64",      GCNENC_DS,     GCN_ADDR_SRC64,           114,  ARCH_GCN_ALL  },
    { "ds_max_rtn_f64",      GCNENC_DS,     GCN_ADDR_SRC64,           115,  ARCH_GCN_ALL  },
    { "ds_read_b64",         GCNENC_DS,     GCN_ADDR_SRC64|GCN_NOSRC, 118,  ARCH_GCN_ALL  },
    { "ds_read2_b64",        GCNENC_DS,     GCN_ADDR_SRC64|GCN_NOSRC_2OFF|GCN_DST128, 119,  ARCH_GCN_ALL  },
    { "ds_read2st64_b64",    GCNENC_DS,     GCN_ADDR_SRC64|GCN_NOSRC_2OFF|GCN_DST128, 120,  ARCH_GCN_ALL  },
    { "ds_condxchg32_rtn_b64", GCNENC_DS,     GCN_ADDR_SRC64,         126,   ARCH_GCN_1_1_2_4_5  },
    { "ds_add_src2_u32",     GCNENC_DS,     GCN_SRC_ADDR2,            128,  ARCH_GCN_ALL  },
    { "ds_sub_src2_u32",     GCNENC_DS,     GCN_SRC_ADDR2,            129,  ARCH_GCN_ALL  },
    { "ds_rsub_src2_u32",    GCNENC_DS,     GCN_SRC_ADDR2,            130,  ARCH_GCN_ALL  },
    { "ds_inc_src2_u32",     GCNENC_DS,     GCN_SRC_ADDR2,            131,  ARCH_GCN_ALL  },
    { "ds_dec_src2_u32",     GCNENC_DS,     GCN_SRC_ADDR2,            132,  ARCH_GCN_ALL  },
    { "ds_min_src2_i32",     GCNENC_DS,     GCN_SRC_ADDR2,            133,  ARCH_GCN_ALL  },
    { "ds_max_src2_i32",     GCNENC_DS,     GCN_SRC_ADDR2,            134,  ARCH_GCN_ALL  },
    { "ds_min_src2_u32",     GCNENC_DS,     GCN_SRC_ADDR2,            135,  ARCH_GCN_ALL  },
    { "ds_max_src2_u32",     GCNENC_DS,     GCN_SRC_ADDR2,            136,  ARCH_GCN_ALL  },
    { "ds_and_src2_b32",     GCNENC_DS,     GCN_SRC_ADDR2,            137,  ARCH_GCN_ALL  },
    { "ds_or_src2_b32",      GCNENC_DS,     GCN_SRC_ADDR2,            138,  ARCH_GCN_ALL  },
    { "ds_xor_src2_b32",     GCNENC_DS,     GCN_SRC_ADDR2,            139,  ARCH_GCN_ALL  },
    { "ds_write_src2_b32",   GCNENC_DS,     GCN_SRC_ADDR2, 141,  ARCH_GCN_ALL  },
    { "ds_min_src2_f32",     GCNENC_DS,     GCN_SRC_ADDR2,            146,  ARCH_GCN_ALL  },
    { "ds_max_src2_f32",     GCNENC_DS,     GCN_SRC_ADDR2,            147,  ARCH_GCN_ALL  },
    { "ds_add_src2_f32",     GCNENC_DS,     GCN_SRC_ADDR2,            149,  ARCH_GCN_1_2_4_5  },
    { "ds_gws_sema_release_all", GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        152,   ARCH_GCN_1_2_4  },
    { "ds_gws_init",         GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        153,  ARCH_GCN_1_2_4  },
    { "ds_gws_sema_v",       GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        154,  ARCH_GCN_1_2_4  },
    { "ds_gws_sema_br",      GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        155,  ARCH_GCN_1_2_4  },
    { "ds_gws_sema_p",       GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        156,  ARCH_GCN_1_2_4  },
    { "ds_gws_barrier",      GCNENC_DS,     GCN_ADDR_DST|GCN_NOSRC|GCN_ONLYGDS,        157,  ARCH_GCN_1_2_4  },
    { "ds_write_b8_d16_hi",  GCNENC_DS,     GCN_ADDR_DST,             160,  ARCH_GCN_1_5  },
    { "ds_write_b16_d16_hi", GCNENC_DS,     GCN_ADDR_DST,             161,  ARCH_GCN_1_5  },
    { "ds_read_u8_d16",      GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   162,  ARCH_GCN_1_5  },
    { "ds_read_u8_d16_hi",   GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   163,  ARCH_GCN_1_5  },
    { "ds_read_i8_d16",      GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   164,  ARCH_GCN_1_5  },
    { "ds_read_i8_d16_hi",   GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   165,  ARCH_GCN_1_5  },
    { "ds_read_u16_d16",     GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   166,  ARCH_GCN_1_5  },
    { "ds_read_u16_d16_hi",  GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   167,  ARCH_GCN_1_5  },
    { "ds_write_addtid_b32", GCNENC_DS,     GCN_ADDR_SRC|GCN_ONLY_SRC, 176,   ARCH_GCN_1_5  },
    { "ds_read_addtid_b32",  GCNENC_DS,     GCN_ONLYDST,              177,  ARCH_GCN_1_5  },
    { "ds_permute_b32",      GCNENC_DS,     GCN_ADDR_SRC,             178,  ARCH_GCN_1_5  },
    { "ds_bpermute_b32",     GCNENC_DS,     GCN_ADDR_SRC,             179,   ARCH_GCN_1_5  },
    { "ds_read_addtid_b32",  GCNENC_DS,     GCN_ONLYDST,              182,  ARCH_GCN_1_4  },
    { "ds_consume",          GCNENC_DS,     GCN_ONLYDST,              189,  ARCH_GCN_1_2_4  },
    { "ds_append",           GCNENC_DS,     GCN_ONLYDST,              190,  ARCH_GCN_1_2_4  },
    { "ds_ordered_count",    GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC,   191,  ARCH_GCN_1_2_4  },
    { "ds_add_src2_u64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         192,  ARCH_GCN_ALL  },
    { "ds_sub_src2_u64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         193,  ARCH_GCN_ALL  },
    { "ds_rsub_src2_u64",    GCNENC_DS,     GCN_SRC_ADDR2_64,         194,  ARCH_GCN_ALL  },
    { "ds_inc_src2_u64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         195,  ARCH_GCN_ALL  },
    { "ds_dec_src2_u64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         196,  ARCH_GCN_ALL  },
    { "ds_min_src2_i64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         197,  ARCH_GCN_ALL  },
    { "ds_max_src2_i64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         198,  ARCH_GCN_ALL  },
    { "ds_min_src2_u64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         199,  ARCH_GCN_ALL  },
    { "ds_max_src2_u64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         200,  ARCH_GCN_ALL  },
    { "ds_and_src2_b64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         201,  ARCH_GCN_ALL  },
    { "ds_or_src2_b64",      GCNENC_DS,     GCN_SRC_ADDR2_64,         202,  ARCH_GCN_ALL  },
    { "ds_xor_src2_b64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         203,  ARCH_GCN_ALL  },
    { "ds_write_src2_b64",   GCNENC_DS,     GCN_SRC_ADDR2_64,         205,  ARCH_GCN_ALL  },
    { "ds_min_src2_f64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         210,  ARCH_GCN_ALL  },
    { "ds_max_src2_f64",     GCNENC_DS,     GCN_SRC_ADDR2_64,         211,  ARCH_GCN_ALL  },
    { "ds_write_b96",        GCNENC_DS,     GCN_ADDR_DST|GCN_DS_96,   222,  ARCH_GCN_1_1_2_4_5  },
    { "ds_write_b128",       GCNENC_DS,     GCN_ADDR_DST|GCN_DS_128,  223,  ARCH_GCN_1_1_2_4_5  },
    // ds_condxchg32_rtn_b128 - for GCN 1.5 (NAVI) ????
    { "ds_condxchg32_rtn_b128", GCNENC_DS,     GCN_ONLYDST|GCN_DS_128, 253,   ARCH_GCN_1_1_2_4_5 },
    { "ds_read_b96",         GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC|GCN_DS_96,            254,  ARCH_GCN_1_1_2_4_5  },
    { "ds_read_b128",        GCNENC_DS,     GCN_ADDR_SRC|GCN_NOSRC|GCN_DS_128,            255,  ARCH_GCN_1_1_2_4_5  },
    { "buffer_load_format_x", GCNENC_MUBUF,  GCN_MUBUF_X|GCN_MLOAD,   0,    ARCH_GCN_ALL  },
    { "buffer_load_format_xy", GCNENC_MUBUF,  GCN_MUBUF_XY|GCN_MLOAD, 1,    ARCH_GCN_ALL  },
    { "buffer_load_format_xyz", GCNENC_MUBUF,  GCN_MUBUF_XYZ|GCN_MLOAD, 2,    ARCH_GCN_ALL  },
    { "buffer_load_format_xyzw", GCNENC_MUBUF,  GCN_MUBUF_XYZW|GCN_MLOAD, 3,    ARCH_GCN_ALL  },
    { "buffer_store_format_x", GCNENC_MUBUF,  GCN_MUBUF_X,            4,    ARCH_GCN_ALL  },
    { "buffer_store_format_xy", GCNENC_MUBUF,  GCN_MUBUF_XY,          5,    ARCH_GCN_ALL  },
    { "buffer_store_format_xyz", GCNENC_MUBUF,  GCN_MUBUF_XYZ,        6,    ARCH_GCN_ALL  },
    { "buffer_store_format_xyzw", GCNENC_MUBUF,  GCN_MUBUF_XYZW,      7,    ARCH_GCN_ALL  },
    { "buffer_load_ubyte",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  8,    ARCH_GCN_1_0_1_5  },
    { "buffer_load_sbyte",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  9,    ARCH_GCN_1_0_1_5  },
    { "buffer_load_ushort",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  10,   ARCH_GCN_1_0_1_5  },
    { "buffer_load_sshort",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  11,   ARCH_GCN_1_0_1_5  },
    { "buffer_load_dword",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  12,   ARCH_GCN_1_0_1_5  },
    { "buffer_load_dwordx2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MLOAD,  13,   ARCH_GCN_1_0_1_5  },
    { "buffer_load_dwordx4", GCNENC_MUBUF,  GCN_MUBUF_MX4|GCN_MLOAD,  14,   ARCH_GCN_1_0_1_5  },
    { "buffer_load_dwordx3", GCNENC_MUBUF,  GCN_MUBUF_MX3|GCN_MLOAD,  15,   ARCH_GCN_1_1_5 },
    { "buffer_store_byte",   GCNENC_MUBUF,  GCN_MUBUF_MX1,            24,   ARCH_GCN_ALL  },
    { "buffer_store_byte_d16_hi", GCNENC_MUBUF,  GCN_MUBUF_MX1,       25,   ARCH_GCN_1_4_5  },
    { "buffer_store_short",  GCNENC_MUBUF,  GCN_MUBUF_MX1,            26,   ARCH_GCN_ALL  },
    { "buffer_store_short_d16_hi", GCNENC_MUBUF,  GCN_MUBUF_MX1,       27,   ARCH_GCN_1_4_5  },
    { "buffer_store_dword",  GCNENC_MUBUF,  GCN_MUBUF_MX1,            28,   ARCH_GCN_ALL  },
    { "buffer_store_dwordx2", GCNENC_MUBUF,  GCN_MUBUF_MX2,           29,   ARCH_GCN_ALL  },
    { "buffer_store_dwordx4", GCNENC_MUBUF,  GCN_MUBUF_MX4,           30,   ARCH_GCN_1_0_1_5  },
    { "buffer_store_dwordx3", GCNENC_MUBUF,  GCN_MUBUF_MX3,           31,   ARCH_GCN_1_1_5  },
    { "buffer_store_dwordx3", GCNENC_MUBUF,  GCN_MUBUF_MX3,           30,   ARCH_GCN_1_2_4  },
    { "buffer_store_dwordx4", GCNENC_MUBUF,  GCN_MUBUF_MX4,           31,   ARCH_GCN_1_2_4  },
    { "buffer_load_ubyte_d16", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  32,    ARCH_GCN_1_4_5 },
    { "buffer_load_ubyte_d16_hi", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  33,    ARCH_GCN_1_4_5 },
    { "buffer_load_sbyte_d16", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  34,    ARCH_GCN_1_4_5  },
    { "buffer_load_sbyte_d16_hi", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  35,    ARCH_GCN_1_4_5 },
    { "buffer_load_short_d16", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  36,   ARCH_GCN_1_4_5  },
    { "buffer_load_short_d16_hi", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  37,   ARCH_GCN_1_4_5 },
    { "buffer_load_format_d16_hi_x", GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  38,  ARCH_GCN_1_4  },
    { "buffer_store_format_d16_hi_x", GCNENC_MUBUF,  GCN_MUBUF_MX1,   39,    ARCH_GCN_1_4  },
    { "buffer_atomic_swap",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 48,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_cmpswap", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MCMPSWAP, 49,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_add",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 50,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_sub",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 51,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_rsub",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 52,   ARCH_HD7X00   },
    { "buffer_atomic_smin",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 53,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_umin",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 54,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_smax",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 55,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_umax",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 56,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_and",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 57,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_or",    GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 58,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_xor",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 59,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_inc",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 60,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_dec",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 61,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_fcmpswap", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MCMPSWAP, 62,   ARCH_GCN_1_0_1  },
    { "buffer_atomic_fmin",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 63,   ARCH_GCN_1_0_1  },
    { "buffer_atomic_fmax",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 64,   ARCH_GCN_1_0_1  },
    { "buffer_atomic_swap_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 80, ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_cmpswap_x2", GCNENC_MUBUF, GCN_MUBUF_MX4|GCN_MCMPSWAP, 81, ARCH_GCN_1_0_1_5 },
    { "buffer_atomic_add_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 82,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_sub_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 83,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_rsub_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 84,   ARCH_HD7X00   },
    { "buffer_atomic_smin_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 85,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_umin_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 86,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_smax_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 87,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_umax_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 88,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_and_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 89,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_or_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 90,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_xor_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 91,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_inc_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 92,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_dec_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 93,   ARCH_GCN_1_0_1_5  },
    { "buffer_atomic_fcmpswap_x2", GCNENC_MUBUF,  GCN_MUBUF_MX4|GCN_MCMPSWAP, 94,   ARCH_GCN_1_0_1  },
    { "buffer_atomic_fmin_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 95,   ARCH_GCN_1_0_1  },
    { "buffer_atomic_fmax_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 96,   ARCH_GCN_1_0_1  },
    { "buffer_wbinvl1_sc",   GCNENC_MUBUF,  GCN_MUBUF_X|GCN_ARG_NONE, 112,  ARCH_GCN_1_0_1  },
    { "buffer_wbinvl1",      GCNENC_MUBUF,  GCN_MUBUF_X|GCN_ARG_NONE, 113,  ARCH_GCN_1_0_1_5  },
    { "buffer_gl0_inv",      GCNENC_MUBUF,  GCN_MUBUF_X|GCN_ARG_NONE, 113,  ARCH_GCN_1_5  },
    { "buffer_gl1_inv",      GCNENC_MUBUF,  GCN_MUBUF_X|GCN_ARG_NONE, 114,  ARCH_GCN_1_5  },
    { "buffer_load_format_d16_x", GCNENC_MUBUF,  GCN_MUBUF_X_D16|GCN_MLOAD, 8,    ARCH_GCN_1_2_4  },
    { "buffer_load_format_d16_xy", GCNENC_MUBUF,  GCN_MUBUF_XY_D16|GCN_MLOAD, 9,    ARCH_GCN_1_2_4  },
    { "buffer_load_format_d16_xyz", GCNENC_MUBUF,  GCN_MUBUF_XYZ_D16|GCN_MLOAD, 10,   ARCH_GCN_1_2_4  },
    { "buffer_load_format_d16_xyzw", GCNENC_MUBUF,  GCN_MUBUF_XYZW_D16|GCN_MLOAD, 11,   ARCH_GCN_1_2_4  },
    { "buffer_store_format_d16_x", GCNENC_MUBUF,  GCN_MUBUF_X_D16,    12,   ARCH_GCN_1_2_4  },
    { "buffer_store_format_d16_xy", GCNENC_MUBUF,  GCN_MUBUF_XY_D16,  13,   ARCH_GCN_1_2_4  },
    { "buffer_store_format_d16_xyz", GCNENC_MUBUF,  GCN_MUBUF_XYZ_D16, 14,   ARCH_GCN_1_2_4  },
    { "buffer_store_format_d16_xyzw", GCNENC_MUBUF,  GCN_MUBUF_XYZW_D16, 15,   ARCH_GCN_1_2_4  },
    { "buffer_load_ubyte",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  16,   ARCH_GCN_1_2_4  },
    { "buffer_load_sbyte",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  17,   ARCH_GCN_1_2_4  },
    { "buffer_load_ushort",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  18,   ARCH_GCN_1_2_4  },
    { "buffer_load_sshort",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  19,   ARCH_GCN_1_2_4  },
    { "buffer_load_dword",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MLOAD,  20,   ARCH_GCN_1_2_4  },
    { "buffer_load_dwordx2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MLOAD,  21,   ARCH_GCN_1_2_4  },
    { "buffer_load_dwordx3", GCNENC_MUBUF,  GCN_MUBUF_MX3|GCN_MLOAD,  22,   ARCH_GCN_1_2_4  },
    { "buffer_load_dwordx4", GCNENC_MUBUF,  GCN_MUBUF_MX4|GCN_MLOAD,  23,   ARCH_GCN_1_2_4  },
    { "buffer_store_lds_dword", GCNENC_MUBUF,  GCN_MUBUF_NOVAD,       61,   ARCH_GCN_1_2_4  },
    { "buffer_wbinvl1",      GCNENC_MUBUF,  GCN_MUBUF_X|GCN_ARG_NONE, 62,   ARCH_GCN_1_2_4  },
    { "buffer_wbinvl1_vol",  GCNENC_MUBUF,  GCN_MUBUF_X|GCN_ARG_NONE, 63,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_swap",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 64,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_cmpswap", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MCMPSWAP, 65,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_add",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 66,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_sub",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 67,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_smin",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 68,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_umin",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 69,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_smax",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 70,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_umax",  GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 71,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_and",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 72,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_or",    GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 73,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_xor",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 74,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_inc",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 75,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_dec",   GCNENC_MUBUF,  GCN_MUBUF_MX1|GCN_MATOMIC, 76,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_swap_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 96,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_cmpswap_x2", GCNENC_MUBUF,  GCN_MUBUF_MX4|GCN_MCMPSWAP, 97,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_add_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 98,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_sub_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 99,   ARCH_GCN_1_2_4  },
    { "buffer_atomic_smin_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 100,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_umin_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 101,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_smax_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 102,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_umax_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 103,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_and_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 104,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_or_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 105,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_xor_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 106,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_inc_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 107,  ARCH_GCN_1_2_4  },
    { "buffer_atomic_dec_x2", GCNENC_MUBUF,  GCN_MUBUF_MX2|GCN_MATOMIC, 108,  ARCH_GCN_1_2_4  },
    { "tbuffer_load_format_x", GCNENC_MTBUF,  GCN_MUBUF_X|GCN_MLOAD,  0,    ARCH_GCN_ALL  },
    { "tbuffer_load_format_xy", GCNENC_MTBUF,  GCN_MUBUF_XY|GCN_MLOAD, 1,    ARCH_GCN_ALL  },
    { "tbuffer_load_format_xyz", GCNENC_MTBUF,  GCN_MUBUF_XYZ|GCN_MLOAD, 2,    ARCH_GCN_ALL  },
    { "tbuffer_load_format_xyzw", GCNENC_MTBUF,  GCN_MUBUF_XYZW|GCN_MLOAD, 3,    ARCH_GCN_ALL  },
    { "tbuffer_store_format_x", GCNENC_MTBUF,  GCN_MUBUF_X,           4,    ARCH_GCN_ALL  },
    { "tbuffer_store_format_xy", GCNENC_MTBUF,  GCN_MUBUF_XY,         5,    ARCH_GCN_ALL  },
    { "tbuffer_store_format_xyz", GCNENC_MTBUF,  GCN_MUBUF_XYZ,       6,    ARCH_GCN_ALL  },
    { "tbuffer_store_format_xyzw", GCNENC_MTBUF,  GCN_MUBUF_XYZW,     7,    ARCH_GCN_ALL  },
    { "tbuffer_load_format_d16_x", GCNENC_MTBUF,  GCN_MUBUF_X_D16|GCN_MLOAD,        8, ARCH_GCN_1_2_4_5  },
    { "tbuffer_load_format_d16_xy", GCNENC_MTBUF,  GCN_MUBUF_XY_D16|GCN_MLOAD,        9, ARCH_GCN_1_2_4_5  },
    { "tbuffer_load_format_d16_xyz", GCNENC_MTBUF,  GCN_MUBUF_XYZ_D16|GCN_MLOAD,        10, ARCH_GCN_1_2_4_5  },
    { "tbuffer_load_format_d16_xyzw", GCNENC_MTBUF,  GCN_MUBUF_XYZW_D16|GCN_MLOAD,        11, ARCH_GCN_1_2_4_5  },
    { "tbuffer_store_format_d16_x", GCNENC_MTBUF,  GCN_MUBUF_X_D16,        12, ARCH_GCN_1_2_4_5  },
    { "tbuffer_store_format_d16_xy", GCNENC_MTBUF,  GCN_MUBUF_XY_D16,        13, ARCH_GCN_1_2_4_5  },
    { "tbuffer_store_format_d16_xyz", GCNENC_MTBUF,  GCN_MUBUF_XYZ_D16,        14, ARCH_GCN_1_2_4_5  },
    { "tbuffer_store_format_d16_xyzw", GCNENC_MTBUF,  GCN_MUBUF_XYZW_D16,        15, ARCH_GCN_1_2_4_5  },
    { "image_load",          GCNENC_MIMG,   GCN_MLOAD,                0,    ARCH_GCN_ALL  },
    { "image_load_mip",      GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MLOAD|GCN_MIMG_VA_MIP,        1,    ARCH_GCN_ALL  },
    { "image_load_pck",      GCNENC_MIMG,   GCN_MLOAD,                2,    ARCH_GCN_ALL  },
    { "image_load_pck_sgn",  GCNENC_MIMG,   GCN_MLOAD,                3,    ARCH_GCN_ALL  },
    { "image_load_mip_pck",  GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MLOAD|GCN_MIMG_VA_MIP,        4,    ARCH_GCN_ALL  },
    { "image_load_mip_pck_sgn", GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MLOAD|GCN_MIMG_VA_MIP,        5,    ARCH_GCN_ALL  },
    { "image_store",         GCNENC_MIMG,   GCN_STDMODE,              8,    ARCH_GCN_ALL  },
    { "image_store_mip",     GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MIMG_VA_MIP,        9,    ARCH_GCN_ALL  },
    { "image_store_pck",     GCNENC_MIMG,   GCN_STDMODE,              10,   ARCH_GCN_ALL  },
    { "image_store_mip_pck", GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MIMG_VA_MIP,        11,   ARCH_GCN_ALL  },
    { "image_get_resinfo",   GCNENC_MIMG,   GCN_MLOAD,                14,   ARCH_GCN_ALL  },
    { "image_atomic_swap",   GCNENC_MIMG,   GCN_MATOMIC,              15,   ARCH_GCN_1_0_1_5  },
    { "image_atomic_cmpswap", GCNENC_MIMG,   GCN_MCMPSWAP,             16,   ARCH_GCN_1_0_1_5  },
    { "image_atomic_add",    GCNENC_MIMG,   GCN_MATOMIC,              17,   ARCH_GCN_1_0_1_5  },
    { "image_atomic_sub",    GCNENC_MIMG,   GCN_MATOMIC,              18,   ARCH_GCN_1_0_1_5  },
    { "image_atomic_rsub",   GCNENC_MIMG,   GCN_MATOMIC,              19,   ARCH_HD7X00   },
    
    { "image_atomic_swap",   GCNENC_MIMG,   GCN_MATOMIC,              16,   ARCH_GCN_1_2_4  },
    { "image_atomic_cmpswap", GCNENC_MIMG,   GCN_MCMPSWAP,             17,   ARCH_GCN_1_2_4  },
    { "image_atomic_add",    GCNENC_MIMG,   GCN_MATOMIC,              18,   ARCH_GCN_1_2_4  },
    { "image_atomic_sub",    GCNENC_MIMG,   GCN_MATOMIC,              19,   ARCH_GCN_1_2_4  },
    { "image_atomic_smin",   GCNENC_MIMG,   GCN_MATOMIC,              20,   ARCH_GCN_ALL  },
    { "image_atomic_umin",   GCNENC_MIMG,   GCN_MATOMIC,              21,   ARCH_GCN_ALL  },
    { "image_atomic_smax",   GCNENC_MIMG,   GCN_MATOMIC,              22,   ARCH_GCN_ALL  },
    { "image_atomic_umax",   GCNENC_MIMG,   GCN_MATOMIC,              23,   ARCH_GCN_ALL  },
    { "image_atomic_and",    GCNENC_MIMG,   GCN_MATOMIC,              24,   ARCH_GCN_ALL  },
    { "image_atomic_or",     GCNENC_MIMG,   GCN_MATOMIC,              25,   ARCH_GCN_ALL  },
    { "image_atomic_xor",    GCNENC_MIMG,   GCN_MATOMIC,              26,   ARCH_GCN_ALL  },
    { "image_atomic_inc",    GCNENC_MIMG,   GCN_MATOMIC,              27,   ARCH_GCN_ALL  },
    { "image_atomic_dec",    GCNENC_MIMG,   GCN_MATOMIC,              28,   ARCH_GCN_ALL  },
    { "image_atomic_fcmpswap", GCNENC_MIMG,   GCN_MCMPSWAP,            29,   ARCH_GCN_1_0_1  },
    { "image_atomic_fmin",   GCNENC_MIMG,   GCN_MATOMIC,              30,   ARCH_GCN_1_0_1  },
    { "image_atomic_fmax",   GCNENC_MIMG,   GCN_MATOMIC,              31,   ARCH_GCN_1_0_1  },
    { "image_sample",        GCNENC_MIMG,   GCN_MIMG_SAMPLE|GCN_MLOAD, 32,   ARCH_GCN_ALL  },
    { "image_sample_cl",     GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_CL, 33,   ARCH_GCN_ALL  },
    { "image_sample_d",      GCNENC_MIMG,   GCN_MIMG_VAGE3D|GCN_MIMG_SAMPLE|GCN_MLOAD, 34,   ARCH_GCN_ALL  },
    { "image_sample_d_cl",   GCNENC_MIMG,        GCN_MIMG_VAGE4D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_CL, 35,   ARCH_GCN_ALL  },
    { "image_sample_l",      GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_L, 36,   ARCH_GCN_ALL  },
    { "image_sample_b",      GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_B, 37,   ARCH_GCN_ALL  },
    { "image_sample_b_cl",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_B_CL, 38,   ARCH_GCN_ALL  },
    { "image_sample_lz",     GCNENC_MIMG,   GCN_MIMG_SAMPLE|GCN_MLOAD, 39,   ARCH_GCN_ALL  },
    { "image_sample_c",      GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C, 40,   ARCH_GCN_ALL  },
    { "image_sample_c_cl",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_CL, 41,   ARCH_GCN_ALL  },
    { "image_sample_c_d",    GCNENC_MIMG,        GCN_MIMG_VAGE4D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C, 42,   ARCH_GCN_ALL  },
    { "image_sample_c_d_cl", GCNENC_MIMG,        GCN_MIMG_VAGE5D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_CL, 43,   ARCH_GCN_ALL  },
    { "image_sample_c_l",    GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_L, 44,   ARCH_GCN_ALL  },
    { "image_sample_c_b",    GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_B, 45,   ARCH_GCN_ALL  },
    { "image_sample_c_b_cl", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_B_CL, 46,   ARCH_GCN_ALL  },
    { "image_sample_c_lz",   GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C, 47,   ARCH_GCN_ALL  },
    { "image_sample_o",      GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_O, 48,   ARCH_GCN_ALL  },
    { "image_sample_cl_o",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_CL_O, 49,   ARCH_GCN_ALL  },
    { "image_sample_d_o",    GCNENC_MIMG,        GCN_MIMG_VAGE4D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_O, 50,   ARCH_GCN_ALL  },
    { "image_sample_d_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE5D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_CL_O, 51,   ARCH_GCN_ALL  },
    { "image_sample_l_o",    GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_L_O, 52,   ARCH_GCN_ALL  },
    { "image_sample_b_o",    GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_B_O, 53,   ARCH_GCN_ALL  },
    { "image_sample_b_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_B_CL_O, 54,   ARCH_GCN_ALL  },
    { "image_sample_lz_o",   GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_O, 55,   ARCH_GCN_ALL  },
    { "image_sample_c_o",    GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_O, 56,   ARCH_GCN_ALL  },
    { "image_sample_c_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_CL_O, 57,   ARCH_GCN_ALL  },
    { "image_sample_c_d_o",  GCNENC_MIMG,        GCN_MIMG_VAGE5D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_O, 58,   ARCH_GCN_ALL  },
    { "image_sample_c_d_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE6D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_CL_O, 59,   ARCH_GCN_ALL  },
    { "image_sample_c_l_o",  GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_L_O, 60,   ARCH_GCN_ALL  },
    { "image_sample_c_b_o",  GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_B_O, 61,   ARCH_GCN_ALL  },
    { "image_sample_c_b_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE5|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_B_CL_O, 62,   ARCH_GCN_ALL  },
    { "image_sample_c_lz_o", GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_O, 63,   ARCH_GCN_ALL  },
    { "image_gather4",       GCNENC_MIMG,   GCN_MIMG_GATHER|GCN_MLOAD, 64,   ARCH_GCN_ALL  },
    { "image_gather4_cl",    GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_CL, 65,   ARCH_GCN_ALL  },
    { "image_gather4h",      GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD, 66,   ARCH_GCN_1_4  },
    { "image_gather4_l",     GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_L, 68,   ARCH_GCN_ALL  },
    { "image_gather4_b",     GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_B, 69,   ARCH_GCN_ALL  },
    { "image_gather4_b_cl",  GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_B_CL, 70,   ARCH_GCN_ALL  },
    { "image_gather4_lz",    GCNENC_MIMG,   GCN_MIMG_GATHER|GCN_MLOAD, 71,   ARCH_GCN_ALL  },
    { "image_gather4_c",     GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C, 72,   ARCH_GCN_ALL  },
    { "image_gather4_c_cl",  GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_CL, 73,   ARCH_GCN_ALL  },
    { "image_gather4h_pck",  GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD, 74,   ARCH_GCN_1_4  },
    { "image_gather8h_pck",  GCNENC_MIMG,   GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD, 75,   ARCH_GCN_1_4  },
    { "image_gather4_c_l",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_L, 76,   ARCH_GCN_ALL  },
    { "image_gather4_c_b",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_B, 77,   ARCH_GCN_ALL  },
    { "image_gather4_c_b_cl", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_B_CL, 78,   ARCH_GCN_ALL  },
    { "image_gather4_c_lz",  GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C, 79,   ARCH_GCN_ALL  },
    { "image_gather4_o",     GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_O, 80,   ARCH_GCN_ALL  },
    { "image_gather4_cl_o",  GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_CL_O, 81,   ARCH_GCN_ALL  },
    { "image_gather4_l_o",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_L_O, 84,   ARCH_GCN_ALL  },
    { "image_gather4_b_o",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_B_O, 85,   ARCH_GCN_ALL  },
    { "image_gather4_b_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_B_CL_O, 86,   ARCH_GCN_ALL  },
    { "image_gather4_lz_o",  GCNENC_MIMG,        GCN_MIMG_VAGE2|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_O, 87,   ARCH_GCN_ALL  },
    { "image_gather4_c_o",   GCNENC_MIMG,        GCN_MIMG_VAGE3|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_O, 88,   ARCH_GCN_ALL  },
    { "image_gather4_c_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_CL_O, 89,   ARCH_GCN_ALL  },
    { "image_gather4_c_l_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_L_O, 92,   ARCH_GCN_ALL  },
    { "image_gather4_c_b_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_B_O, 93,   ARCH_GCN_ALL  },
    { "image_gather4_c_b_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE5|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_B_CL_O, 94,   ARCH_GCN_ALL  },
    { "image_gather4_c_lz_o", GCNENC_MIMG,        GCN_MIMG_VAGE4|GCN_MIMG_GATHER|GCN_MLOAD|GCN_MIMG_VA_C_O, 95,   ARCH_GCN_ALL  },
    { "image_get_lod",       GCNENC_MIMG,   GCN_MIMG_SAMPLE|GCN_MLOAD, 96,   ARCH_GCN_ALL  },
    { "image_sample_cd",     GCNENC_MIMG,   GCN_MIMG_VAGE3D|GCN_MIMG_SAMPLE|GCN_MLOAD, 104,  ARCH_GCN_ALL  },
    { "image_sample_cd_cl",  GCNENC_MIMG,        GCN_MIMG_VAGE4D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_CL, 105,  ARCH_GCN_ALL  },
    { "image_sample_c_cd",   GCNENC_MIMG,        GCN_MIMG_VAGE4D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C, 106,  ARCH_GCN_ALL  },
    { "image_sample_c_cd_cl", GCNENC_MIMG,        GCN_MIMG_VAGE5D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_CL, 107,  ARCH_GCN_ALL  },
    { "image_sample_cd_o",   GCNENC_MIMG,        GCN_MIMG_VAGE4D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_O, 108,  ARCH_GCN_ALL  },
    { "image_sample_cd_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE5D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_CL_O, 109,  ARCH_GCN_ALL  },
    { "image_sample_c_cd_o", GCNENC_MIMG,        GCN_MIMG_VAGE5D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_O, 110,  ARCH_GCN_ALL  },
    { "image_sample_c_cd_cl_o", GCNENC_MIMG,        GCN_MIMG_VAGE6D|GCN_MIMG_SAMPLE|GCN_MLOAD|GCN_MIMG_VA_C_CL_O, 111,  ARCH_GCN_ALL  },
    { "exp",                 GCNENC_EXP,    GCN_STDMODE,              0,    ARCH_GCN_ALL  },
    { "flat_load_ubyte",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 8,    ARCH_GCN_1_1_5  },
    { "flat_load_sbyte",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 9,    ARCH_GCN_1_1_5  },
    { "flat_load_ushort",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 10,   ARCH_GCN_1_1_5  },
    { "flat_load_sshort",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 11,   ARCH_GCN_1_1_5  },
    { "flat_load_dword",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 12,   ARCH_GCN_1_1_5  },
    { "flat_load_dwordx2",   GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_FLAT_NODATA, 13,   ARCH_GCN_1_1_5  },
    { "flat_load_dwordx4",   GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_FLAT_NODATA, 14,   ARCH_GCN_1_1_5  },
    { "flat_load_dwordx3",   GCNENC_FLAT,   GCN_MUBUF_MX3|GCN_FLAT_NODATA, 15,   ARCH_GCN_1_1_5  },
    { "flat_store_byte",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_STORE, 24, ARCH_GCN_1_1_2_4_5  },
    { "flat_store_byte_d16_hi", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_STORE, 25, ARCH_GCN_1_4_5  },
    { "flat_store_short",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_STORE, 26, ARCH_GCN_1_1_2_4_5  },
    { "flat_store_short_d16_hi", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_STORE, 27, ARCH_GCN_1_4_5  },
    { "flat_store_dword",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_STORE, 28, ARCH_GCN_1_1_2_4_5  },
    { "flat_store_dwordx2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_FLAT_STORE, 29, ARCH_GCN_1_1_2_4_5  },
    { "flat_store_dwordx4",  GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_FLAT_STORE, 30,   ARCH_GCN_1_1_5  },
    { "flat_store_dwordx3",  GCNENC_FLAT,   GCN_MUBUF_MX3|GCN_FLAT_STORE, 31,   ARCH_GCN_1_1_5  },
    { "flat_store_dwordx3",  GCNENC_FLAT,   GCN_MUBUF_MX3|GCN_FLAT_STORE, 30,   ARCH_GCN_1_2_4  },
    { "flat_store_dwordx4",  GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_FLAT_STORE, 31,   ARCH_GCN_1_2_4  },
    { "flat_load_ubyte_d16", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 32, ARCH_GCN_1_4_5  },
    { "flat_load_ubyte_d16_hi", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 33, ARCH_GCN_1_4_5  },
    { "flat_load_sbyte_d16", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 34, ARCH_GCN_1_4_5  },
    { "flat_load_sbyte_d16_hi", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 35, ARCH_GCN_1_4_5  },
    { "flat_load_short_d16", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 36, ARCH_GCN_1_4_5  },
    { "flat_load_short_d16_hi", GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 37, ARCH_GCN_1_4_5  },
    { "flat_atomic_swap",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 48,   ARCH_GCN_1_1_5  },
    { "flat_atomic_cmpswap", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_ACMPSWAP, 49,   ARCH_GCN_1_1_5  },
    { "flat_atomic_add",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 50,   ARCH_GCN_1_1_5  },
    { "flat_atomic_sub",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 51,   ARCH_GCN_1_1_5  },
    { "flat_atomic_smin",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 53,   ARCH_GCN_1_1_5  },
    { "flat_atomic_umin",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 54,   ARCH_GCN_1_1_5  },
    { "flat_atomic_smax",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 55,   ARCH_GCN_1_1_5  },
    { "flat_atomic_umax",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 56,   ARCH_GCN_1_1_5  },
    { "flat_atomic_and",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 57,   ARCH_GCN_1_1_5  },
    { "flat_atomic_or",      GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 58,   ARCH_GCN_1_1_5  },
    { "flat_atomic_xor",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 59,   ARCH_GCN_1_1_5  },
    { "flat_atomic_inc",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 60,   ARCH_GCN_1_1_5  },
    { "flat_atomic_dec",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 61,   ARCH_GCN_1_1_5  },
    { "flat_atomic_fcmpswap", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_ACMPSWAP, 62,   ARCH_GCN_1_1_5  },
    { "flat_atomic_fmin",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 63,   ARCH_GCN_1_1_5  },
    { "flat_atomic_fmax",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 64,   ARCH_GCN_1_1_5  },
    { "flat_atomic_swap_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 80,   ARCH_GCN_1_1_5  },
    { "flat_atomic_cmpswap_x2", GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_ACMPSWAP, 81,   ARCH_GCN_1_1_5  },
    { "flat_atomic_add_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 82,   ARCH_GCN_1_1_5  },
    { "flat_atomic_sub_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 83,   ARCH_GCN_1_1_5  },
    { "flat_atomic_smin_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 85,   ARCH_GCN_1_1_5  },
    { "flat_atomic_umin_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 86,   ARCH_GCN_1_1_5  },
    { "flat_atomic_smax_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 87,   ARCH_GCN_1_1_5  },
    { "flat_atomic_umax_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 88,   ARCH_GCN_1_1_5  },
    { "flat_atomic_and_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 89,   ARCH_GCN_1_1_5  },
    { "flat_atomic_or_x2",   GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 90,   ARCH_GCN_1_1_5  },
    { "flat_atomic_xor_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 91,   ARCH_GCN_1_1_5  },
    { "flat_atomic_inc_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 92,   ARCH_GCN_1_1_5  },
    { "flat_atomic_dec_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 93,   ARCH_GCN_1_1_5  },
    { "flat_atomic_fcmpswap_x2", GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_ACMPSWAP, 94,   ARCH_GCN_1_1_5  },
    { "flat_atomic_fmin_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 95,   ARCH_GCN_1_1_5  },
    { "flat_atomic_fmax_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 96,   ARCH_GCN_1_1_5  },
    { "flat_load_ubyte",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 16,   ARCH_GCN_1_2_4  },
    { "flat_load_sbyte",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 17,   ARCH_GCN_1_2_4  },
    { "flat_load_ushort",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 18,   ARCH_GCN_1_2_4  },
    { "flat_load_sshort",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 19,   ARCH_GCN_1_2_4  },
    { "flat_load_dword",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_FLAT_NODATA, 20,   ARCH_GCN_1_2_4  },
    { "flat_load_dwordx2",   GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_FLAT_NODATA, 21,   ARCH_GCN_1_2_4  },
    { "flat_load_dwordx3",   GCNENC_FLAT,   GCN_MUBUF_MX3|GCN_FLAT_NODATA, 22,   ARCH_GCN_1_2_4  },
    { "flat_load_dwordx4",   GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_FLAT_NODATA, 23,   ARCH_GCN_1_2_4  },
    { "flat_atomic_swap",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 64,   ARCH_GCN_1_2_4  },
    { "flat_atomic_cmpswap", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_ACMPSWAP, 65,   ARCH_GCN_1_2_4  },
    { "flat_atomic_add",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 66,   ARCH_GCN_1_2_4  },
    { "flat_atomic_sub",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 67,   ARCH_GCN_1_2_4  },
    { "flat_atomic_smin",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 68,   ARCH_GCN_1_2_4  },
    { "flat_atomic_umin",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 69,   ARCH_GCN_1_2_4  },
    { "flat_atomic_smax",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 70,   ARCH_GCN_1_2_4  },
    { "flat_atomic_umax",    GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 71,   ARCH_GCN_1_2_4  },
    { "flat_atomic_and",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 72,   ARCH_GCN_1_2_4  },
    { "flat_atomic_or",      GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 73,   ARCH_GCN_1_2_4  },
    { "flat_atomic_xor",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 74,   ARCH_GCN_1_2_4  },
    { "flat_atomic_inc",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 75,   ARCH_GCN_1_2_4  },
    { "flat_atomic_dec",     GCNENC_FLAT,   GCN_MUBUF_MX1|GCN_MATOMIC, 76,   ARCH_GCN_1_2_4  },
    { "flat_atomic_swap_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 96,   ARCH_GCN_1_2_4  },
    { "flat_atomic_cmpswap_x2", GCNENC_FLAT,   GCN_MUBUF_MX4|GCN_ACMPSWAP, 97,   ARCH_GCN_1_2_4  },
    { "flat_atomic_add_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 98,   ARCH_GCN_1_2_4  },
    { "flat_atomic_sub_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 99,   ARCH_GCN_1_2_4  },
    { "flat_atomic_smin_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 100,  ARCH_GCN_1_2_4  },
    { "flat_atomic_umin_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 101,  ARCH_GCN_1_2_4  },
    { "flat_atomic_smax_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 102,  ARCH_GCN_1_2_4  },
    { "flat_atomic_umax_x2", GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 103,  ARCH_GCN_1_2_4  },
    { "flat_atomic_and_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 104,  ARCH_GCN_1_2_4  },
    { "flat_atomic_or_x2",   GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 105,  ARCH_GCN_1_2_4  },
    { "flat_atomic_xor_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 106,  ARCH_GCN_1_2_4  },
    { "flat_atomic_inc_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 107,  ARCH_GCN_1_2_4  },
    { "flat_atomic_dec_x2",  GCNENC_FLAT,   GCN_MUBUF_MX2|GCN_MATOMIC, 108,  ARCH_GCN_1_2_4  },
    { "scratch_load_ubyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 8,    ARCH_GCN_1_5  },
    { "scratch_load_sbyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 9,    ARCH_GCN_1_5  },
    { "scratch_load_ushort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 10,   ARCH_GCN_1_5  },
    { "scratch_load_sshort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 11,   ARCH_GCN_1_5  },
    { "scratch_load_dword",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 12,   ARCH_GCN_1_5  },
    { "scratch_load_dwordx2",   GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 13,   ARCH_GCN_1_5  },
    { "scratch_load_dwordx4",   GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 14,   ARCH_GCN_1_5  },
    { "scratch_load_dwordx3",   GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 15,   ARCH_GCN_1_5  },
    { "scratch_load_ubyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 16,   ARCH_GCN_1_4 },
    { "scratch_load_sbyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 17,   ARCH_GCN_1_4 },
    { "scratch_load_ushort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 18,   ARCH_GCN_1_4 },
    { "scratch_load_sshort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 19,   ARCH_GCN_1_4 },
    { "scratch_load_dword",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 20,   ARCH_GCN_1_4 },
    { "scratch_load_dwordx2",   GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 21,   ARCH_GCN_1_4 },
    { "scratch_load_dwordx3",   GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 22,   ARCH_GCN_1_4 },
    { "scratch_load_dwordx4",   GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 23,   ARCH_GCN_1_4 },
    { "scratch_store_byte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 24,   ARCH_GCN_1_4_5 },
    { "scratch_store_byte_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 25,   ARCH_GCN_1_4_5 },
    { "scratch_store_short",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 26,   ARCH_GCN_1_4_5 },
    { "scratch_store_short_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 27,   ARCH_GCN_1_4_5 },
    { "scratch_store_dword",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 28,   ARCH_GCN_1_4_5 },
    { "scratch_store_dwordx2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 29,   ARCH_GCN_1_4_5 },
    { "scratch_store_dwordx3",  GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 30,   ARCH_GCN_1_4 },
    { "scratch_store_dwordx4",  GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 31,   ARCH_GCN_1_4 },
    { "scratch_store_dwordx4",  GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 30,   ARCH_GCN_1_5 },
    { "scratch_store_dwordx3",  GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_STORE|GCN_FLAT_SCRATCH, 31,   ARCH_GCN_1_5 },
    { "scratch_load_ubyte_d16", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 32,   ARCH_GCN_1_4_5 },
    { "scratch_load_ubyte_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 33,   ARCH_GCN_1_4_5 },
    { "scratch_load_sbyte_d16", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 34,   ARCH_GCN_1_4_5 },
    { "scratch_load_sbyte_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 35,   ARCH_GCN_1_4_5 },
    { "scratch_load_short_d16", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 36,   ARCH_GCN_1_4_5 },
    { "scratch_load_short_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_SCRATCH, 37,   ARCH_GCN_1_4_5 },
    { "global_load_ubyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 8,    ARCH_GCN_1_5  },
    { "global_load_sbyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 9,    ARCH_GCN_1_5  },
    { "global_load_ushort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 10,   ARCH_GCN_1_5  },
    { "global_load_sshort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 11,   ARCH_GCN_1_5  },
    { "global_load_dword",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 12,   ARCH_GCN_1_5  },
    { "global_load_dwordx2",   GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 13,   ARCH_GCN_1_5  },
    { "global_load_dwordx4",   GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 14,   ARCH_GCN_1_5  },
    { "global_load_dwordx3",   GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 15,   ARCH_GCN_1_5  },
    { "global_load_ubyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 16,   ARCH_GCN_1_4 },
    { "global_load_sbyte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 17,   ARCH_GCN_1_4 },
    { "global_load_ushort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 18,   ARCH_GCN_1_4 },
    { "global_load_sshort",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 19,   ARCH_GCN_1_4 },
    { "global_load_dword",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 20,   ARCH_GCN_1_4 },
    { "global_load_dwordx2",   GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 21,   ARCH_GCN_1_4 },
    { "global_load_dwordx3",   GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 22,   ARCH_GCN_1_4 },
    { "global_load_dwordx4",   GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 23,   ARCH_GCN_1_4 },
    { "global_store_byte",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 24,   ARCH_GCN_1_4_5 },
    { "global_store_byte_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 25,   ARCH_GCN_1_4_5 },
    { "global_store_short",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 26,   ARCH_GCN_1_4_5 },
    { "global_store_short_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 27,   ARCH_GCN_1_4_5 },
    { "global_store_dword",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 28,   ARCH_GCN_1_4_5 },
    { "global_store_dwordx2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 29,   ARCH_GCN_1_4_5 },
    { "global_store_dwordx3",  GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 30,   ARCH_GCN_1_4 },
    { "global_store_dwordx4",  GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 31,   ARCH_GCN_1_4 },
    { "global_store_dwordx4",  GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 30,   ARCH_GCN_1_5 },
    { "global_store_dwordx3",  GCNENC_FLAT,        GCN_MUBUF_MX3|GCN_FLAT_STORE|GCN_FLAT_GLOBAL, 31,   ARCH_GCN_1_5 },
    { "global_load_ubyte_d16", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 32,   ARCH_GCN_1_4_5 },
    { "global_load_ubyte_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 33,   ARCH_GCN_1_4_5 },
    { "global_load_sbyte_d16", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 34,   ARCH_GCN_1_4_5 },
    { "global_load_sbyte_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 35,   ARCH_GCN_1_4_5 },
    { "global_load_short_d16", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 36,   ARCH_GCN_1_4_5 },
    { "global_load_short_d16_hi", GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_FLAT_NODATA|GCN_FLAT_GLOBAL, 37,   ARCH_GCN_1_4_5 },
    { "global_atomic_swap",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 48,   ARCH_GCN_1_5 },
    { "global_atomic_cmpswap", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_ACMPSWAP|GCN_FLAT_GLOBAL, 49,   ARCH_GCN_1_5 },
    { "global_atomic_add",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 50,   ARCH_GCN_1_5 },
    { "global_atomic_sub",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 51,   ARCH_GCN_1_5 },
    { "global_atomic_smin",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 53,   ARCH_GCN_1_5 },
    { "global_atomic_umin",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 54,   ARCH_GCN_1_5 },
    { "global_atomic_smax",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 55,   ARCH_GCN_1_5 },
    { "global_atomic_umax",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 56,   ARCH_GCN_1_5 },
    { "global_atomic_and",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 57,   ARCH_GCN_1_5 },
    { "global_atomic_or",      GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 58,   ARCH_GCN_1_5 },
    { "global_atomic_xor",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 59,   ARCH_GCN_1_5 },
    { "global_atomic_inc",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 60,   ARCH_GCN_1_5 },
    { "global_atomic_dec",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 61,   ARCH_GCN_1_5 },
    { "global_atomic_fcmpswap", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_ACMPSWAP|GCN_FLAT_GLOBAL, 62,   ARCH_GCN_1_5  },
    { "global_atomic_fmin",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 63,   ARCH_GCN_1_5  },
    { "global_atomic_fmax",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 64,   ARCH_GCN_1_5  },
    { "global_atomic_swap",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 64,   ARCH_GCN_1_4 },
    { "global_atomic_cmpswap", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_ACMPSWAP|GCN_FLAT_GLOBAL, 65,   ARCH_GCN_1_4 },
    { "global_atomic_add",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 66,   ARCH_GCN_1_4 },
    { "global_atomic_sub",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 67,   ARCH_GCN_1_4 },
    { "global_atomic_smin",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 68,   ARCH_GCN_1_4 },
    { "global_atomic_umin",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 69,   ARCH_GCN_1_4 },
    { "global_atomic_smax",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 70,   ARCH_GCN_1_4 },
    { "global_atomic_umax",    GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 71,   ARCH_GCN_1_4 },
    { "global_atomic_and",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 72,   ARCH_GCN_1_4 },
    { "global_atomic_or",      GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 73,   ARCH_GCN_1_4 },
    { "global_atomic_xor",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 74,   ARCH_GCN_1_4 },
    { "global_atomic_inc",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 75,   ARCH_GCN_1_4 },
    { "global_atomic_dec",     GCNENC_FLAT,        GCN_MUBUF_MX1|GCN_MATOMIC|GCN_FLAT_GLOBAL, 76,   ARCH_GCN_1_4 },
    { "global_atomic_swap_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 80,   ARCH_GCN_1_5 },
    { "global_atomic_cmpswap_x2", GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_ACMPSWAP|GCN_FLAT_GLOBAL, 81,   ARCH_GCN_1_5 },
    { "global_atomic_add_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 82,   ARCH_GCN_1_5 },
    { "global_atomic_sub_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 83,   ARCH_GCN_1_5 },
    { "global_atomic_smin_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 85,  ARCH_GCN_1_5 },
    { "global_atomic_umin_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 86,  ARCH_GCN_1_5 },
    { "global_atomic_smax_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 87,  ARCH_GCN_1_5 },
    { "global_atomic_umax_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 88,  ARCH_GCN_1_5 },
    { "global_atomic_and_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 89,  ARCH_GCN_1_5 },
    { "global_atomic_or_x2",   GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 90,  ARCH_GCN_1_5 },
    { "global_atomic_xor_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 91,  ARCH_GCN_1_5 },
    { "global_atomic_inc_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 92,  ARCH_GCN_1_5 },
    { "global_atomic_dec_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 93,  ARCH_GCN_1_5 },
    { "global_atomic_fcmpswap_x2", GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_ACMPSWAP|GCN_FLAT_GLOBAL, 94,   ARCH_GCN_1_5  },
    { "global_atomic_fmin_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 95,   ARCH_GCN_1_5  },
    { "global_atomic_fmax_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 96,   ARCH_GCN_1_5  },
    { "global_atomic_swap_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 96,   ARCH_GCN_1_4 },
    { "global_atomic_cmpswap_x2", GCNENC_FLAT,        GCN_MUBUF_MX4|GCN_ACMPSWAP|GCN_FLAT_GLOBAL, 97,   ARCH_GCN_1_4 },
    { "global_atomic_add_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 98,   ARCH_GCN_1_4 },
    { "global_atomic_sub_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 99,   ARCH_GCN_1_4 },
    { "global_atomic_smin_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 100,  ARCH_GCN_1_4 },
    { "global_atomic_umin_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 101,  ARCH_GCN_1_4 },
    { "global_atomic_smax_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 102,  ARCH_GCN_1_4 },
    { "global_atomic_umax_x2", GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 103,  ARCH_GCN_1_4 },
    { "global_atomic_and_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 104,  ARCH_GCN_1_4 },
    { "global_atomic_or_x2",   GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 105,  ARCH_GCN_1_4 },
    { "global_atomic_xor_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 106,  ARCH_GCN_1_4 },
    { "global_atomic_inc_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 107,  ARCH_GCN_1_4 },
    { "global_atomic_dec_x2",  GCNENC_FLAT,        GCN_MUBUF_MX2|GCN_MATOMIC|GCN_FLAT_GLOBAL, 108,  ARCH_GCN_1_4 },
};
