/*
		    TTTTTTT    OOOOO    7777777
		       T      O     O        7
		       T      O     O       7
		       T      O     O      7
		       T      O     O     7
		       T       OOOOO     7

			     EMULATEUR

			  Par Sylvain HUET
		    (huet@poly.polytechnique.fr)
			       1994

  emup2.c : emulateur 6809. 2eme partie

*/

#include "monitor.h"
#include "emuto7.h"

void nega()             /* H?NxZxVxCx */
	{
	m1=ar; m2=-ar;          /* bit V */
	ar=-ar;
	ovfl=res=sign=ar;
	ar&=255;
	}

void coma()             /* NxZxV0C1 */
	{
	m1=ovfl;
	ar=(~ar)&255;
	sign=ar;
	res=sign|0x100; /* bit C a 1 */
	}

void lsra()             /* N0ZxCx */
	{
	res=(ar&1)<<8;  /* bit C */
	ar>>=1;
	sign=0;
	res|=ar;
	}

void rora()             /* NxZxCx */
	{
		int     i;
	i=ar;
	ar=(ar|(res&0x100))>>1;
	sign=ar;
	res=((i&1)<<8)|sign;
	}

void asra()             /* H?NxZxCx */
	{
	res=(ar&1)<<8;
	ar=(ar>>1)|(ar&0x80);
	sign=ar;
	res|=sign;
	}

void asla()             /* H?NxZxVxCx */
	{
	m1=m2=ar;
	ar<<=1;
	ovfl=sign=res=ar;
	ar&=255;
	}

void rola()             /* NxZxVxCx */
	{
		int     i;
	i=ar;
	m1=m2=ar;
	ar=(ar<<1)|((res&0x100)>>8);
	ovfl=sign=res=ar;
	ar&=255;
	}

void deca()             /* NxZxVx */
	{
	m1=ar; m2=0x80;
	ar=(ar-1)&255;
	ovfl=sign=ar;
	res=(res&0x100)|sign;
	}

void inca()             /* NxZxVx */
	{
	m1=ar; m2=0;
	ar=(ar+1)&255;
	ovfl=sign=ar;
	res=(res&0x100)|sign;
	}

void tsta()             /* NxZxV0 */
	{
	m1=ovfl;
	sign=ar;
	res=(res&0x100)|sign;
	}

void clra()             /* N0Z1V0C0 */
	{
	ar=0;
	m1=ovfl;
	sign=res=0;
	}

void negb()             /* H?NxZxVxCx */
	{
	m1=br; m2=-br;          /* bit V */
	br=-br;
	ovfl=res=sign=br;
	br&=255;
	}

void comb()             /* NxZxV0C1 */
	{
	m1=ovfl;
	br=(~br)&255;
	sign=br;
	res=sign|0x100; /* bit C a 1 */
	}

void lsrb()             /* N0ZxCx */
	{
	res=(br&1)<<8;  /* bit C */
	br>>=1;
	sign=0;
	res|=br;
	}

void rorb()             /* NxZxCx */
	{
		int     i;
	i=br;
	br=(br|(res&0x100))>>1;
	sign=br;
	res=((i&1)<<8)|sign;
	}

void asrb()             /* H?NxZxCx */
	{
	res=(br&1)<<8;
	br=(br>>1)|(br&0x80);
	sign=br;
	res|=sign;
	}

void aslb()             /* H?NxZxVxCx */
	{
	m1=m2=br;
	br<<=1;
	ovfl=sign=res=br;
	br&=255;
	}

void rolb()             /* NxZxVxCx */
	{
		int     i;
	i=br;
	m1=m2=br;
	br=(br<<1)|((res&0x100)>>8);
	ovfl=sign=res=br;
	br&=255;
	}

void decb()             /* NxZxVx */
	{
	m1=br; m2=0x80;
	br=(br-1)&255;
	ovfl=sign=br;
	res=(res&0x100)|sign;
	}

void incb()             /* NxZxVx */
	{
	m1=br; m2=0;
	br=(br+1)&255;
	ovfl=sign=br;
	res=(res&0x100)|sign;
	}

void tstb()             /* NxZxV0 */
	{
	m1=ovfl;
	sign=br;
	res=(res&0x100)|sign;
	}

void clrb()             /* N0Z1V0C0 */
	{
	br=0;
	m1=ovfl;
	sign=res=0;
	}

void suba()             /* H?NxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ar; m2=-val;
	ar-=val;
	ovfl=res=sign=ar;
	ar&=255;
	}

void cmpa()             /* H?NxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ar; m2=-val;
	ovfl=res=sign=ar-val;
	}

void sbca()             /* H?NxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ar; m2=-val;
	ar-=val+((res&0x100)>>8);
	ovfl=res=sign=ar;
	ar&=255;
	}

void subd()             /* NxZxVxCx */
	{
		long    dr,val;
	val=loadl((*adresl[ad])());
	m1=ar; m2=(-val)>>8;
	dr=(ar<<8)+br-val;
	ar=dr>>8;
	br=dr&255;
	ovfl=res=sign=ar;
	res|=br;
	ar&=255;
	}

void anda()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	ar&=val;
	sign=ar;
	res=(res&0x100)|sign;
	}

void bita()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	sign=ar&val;
	res=(res&0x100)|sign;
	}

void ldam()             /* NxZxV0 */
	{
	sign=ar=loads((*adresc[ad])());
	m1=ovfl;
	res=(res&0x100)|sign;
	}

void stam()             /* NxZxV0 */
	{
	stocs((*adresc[ad])(),ar);
	sign=ar;
	m1=ovfl;
	res=(res&0x100)|sign;
	}

void eora()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	ar^=val;
	sign=ar;
	res=(res&0x100)|sign;
	}

void adca()             /* HxNxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=h1=ar; m2=val;
	h2=val+((res&0x100)>>8);
	ar+=h2;
	ovfl=res=sign=ar;
	ar&=255;
	}

void oram()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	ar|=val;
	sign=ar;
	res=(res&0x100)|sign;
	}

void adda()             /* HxNxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=h1=ar; m2=h2=val;
	ar+=val;
	ovfl=res=sign=ar;
	ar&=255;
	}

void cmpx()             /* NxZxVxCx */
	{
		long    val;
	val=loadl((*adresl[ad])());
	m1=xr>>8; m2=(-val)>>8;
	ovfl=res=sign=(xr-val)>>8;
	res|=(xr-val)&255;
	}

void bsrm()
	{
	sr=(sr-2)&0xffff;
	stocl(sr,pc);
	pc=(pc+op[0])&0xffff;
	}

void ldxm()     /* NxZxV0 */
	{
	xr=loadl((*adresl[ad])());
	m1=ovfl;
	sign=xr>>8;
	res=(res&0x100)|((sign|xr)&255);
	}

void stxm()             /* NxZxV0 */
	{
	stocl((*adresl[ad])(),xr);
	m1=0; m2=0x80;
	sign=xr>>8;
	res=(res&0x100)|((sign|xr)&255);
	}


void subb()             /* H?NxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=br; m2=-val;
	br-=val;
	ovfl=res=sign=br;
	br&=255;
	}

void cmpb()             /* H?NxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=br; m2=-val;
	ovfl=res=sign=br-val;
	}

void sbcb()             /* H?NxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=br; m2=-val;
	br-=val+((res&0x100)>>8);
	ovfl=res=sign=br;
	br&=255;
	}

void addd()             /* NxZxVxCx */
	{
		long    dr,val;
	val=loadl((*adresl[ad])());
	m1=ar; m2=val>>8;
	dr=(ar<<8)+br+val;
	ar=dr>>8;
	br=dr&255;
	ovfl=res=sign=ar;
	res|=br;
	ar&=255;
	}

void andb()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	br&=val;
	sign=br;
	res=(res&0x100)|sign;
	}

void bitb()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	sign=br&val;
	res=(res&0x100)|sign;
	}

void ldbm()             /* NxZxV0 */
	{
	sign=br=loads((*adresc[ad])());
	m1=ovfl;
	res=(res&0x100)|sign;
	}

void stbm()             /* NxZxV0 */
	{
	stocs((*adresc[ad])(),br);
	sign=br;
	m1=ovfl;
	res=(res&0x100)|sign;
	}

void eorb()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	br^=val;
	sign=br;
	res=(res&0x100)|sign;
	}

void adcb()             /* HxNxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=h1=br; m2=val;
	h2=val+((res&0x100)>>8);
	br+=h2;
	ovfl=res=sign=br;
	br&=255;
	}

void orbm()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=ovfl;
	br|=val;
	sign=br;
	res=(res&0x100)|sign;
	}

void addb()             /* HxNxZxVxCx */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=h1=br; m2=h2=val;
	br+=val;
	ovfl=res=sign=br;
	br&=255;
	}

void lddm()             /* NxZxV0 */
	{
		long    dr;
	dr=loadl((*adresl[ad])());
	m1=ovfl;
	ar=(dr>>8)&255;
	br=dr&255;
	sign=ar;
	res=(res&0x100)|br|ar;
	}

void stdm()             /* NxZxV0 */
	{
	stocl((*adresl[ad])(),(ar<<8)+br);
	m1=ovfl;
	sign=ar;
	res=(res&0x100)|ar|br;
	}

void ldum()     /* NxZxV0 */
	{
	ur=loadl((*adresl[ad])());
	m1=ovfl;
	sign=ur>>8;
	res=(res&0x100)|((sign|ur)&255);
	}

void stum()             /* NxZxV0 */
	{
	stocl((*adresl[ad])(),ur);
	m1=ovfl;
	sign=ur>>8;
	res=(res&0x100)|((sign|ur)&255);
	}


