// Routines graphiques et clavier


// Codes utilisables avec inkey()

#define SKEY_RIGHT_ARROW 0x4DE0
#define SKEY_LEFT_ARROW  0x4BE0
#define SKEY_UP_ARROW    0x48E0
#define SKEY_DOWN_ARROW  0x50E0
#define SKEY_PAGE_UP     0x49E0
#define SKEY_PAGE_DOWN   0x51E0
#define SKEY_HOME        0x47E0
#define SKEY_END         0x4FE0

#define SKEY_ALT_RIGHT_ARROW     0x9D00
#define SKEY_ALT_LEFT_ARROW      0x9B00
#define SKEY_ALT_UP_ARROW        0x9800
#define SKEY_ALT_DOWN_ARROW      0xA000
#define SKEY_ALT_PAGE_UP         0x9900
#define SKEY_ALT_PAGE_DOWN       0xA100
#define SKEY_ALT_HOME            0x9700
#define SKEY_ALT_END             0x9F00

#define SKEY_CTRL_RIGHT_ARROW    0x74E0
#define SKEY_CTRL_LEFT_ARROW     0x73E0
#define SKEY_CTRL_UP_ARROW       0x8DE0
#define SKEY_CTRL_DOWN_ARROW     0x91E0
#define SKEY_CTRL_PAGE_UP        0x84E0
#define SKEY_CTRL_PAGE_DOWN      0x76E0
#define SKEY_CTRL_HOME           0x77E0
#define SKEY_CTRL_END            0x75E0

#define SKEY_ESC                 0x1B


// Routines diverses

// passage en mode 320x200x256
extern void cdecl vga256();

// passage en mode text monochrome 80 colonnes
extern void cdecl text80();

// cls de l'ecran vga (8bits)
extern void cdecl cls(int adec, short col);

// cls de l'ecran vga (16 bits)
extern void cdecl cls16(int adec, short col);

// copie d'une zone
extern void cdecl movsc(int nb, char *src, char *dest);

// affichage d'un point (sans test de sortie d'ecran)
extern void cdecl pset(int adec, short x, short y, short col);

// affichage d'un point avec test de sortie d'ecran
extern void cdecl psetwin(int adec, int x, int y, short col
										, int xmin, int xmax, int ymin, int ymax);

// affichage d'une ligne (sans test de sortie d'ecran)
extern void cdecl line(int adec, short xa, short ya
												, short xb,short yb, short col);

// affichage d'une ligne avec test de sortie d'ecran
extern void cdecl linewin(int adec, int xa, int ya, int xb, int yb, short col
										, int xmin, int xmax, int ymin, int ymax);

// attente du debut du retour rayon
extern void cdecl waitd();

// attente de la fin du retour rayon
extern void cdecl waite();

// routine inkey$
extern short cdecl inkey();

// changement d'une couleur (attend le retour rayon)
extern void cdecl palette(short n, short rouge, short vert, short bleu);

// changement de plusieurs couleurs simultanement
extern void cdecl multipal(short prem, short n, char *pn);



