/*
		    TTTTTTT    OOOOO    7777777
		       T      O     O        7
		       T      O     O       7
		       T      O     O      7
		       T      O     O     7
		       T       OOOOO     7

			     EMULATEUR

			  Par Sylvain HUET
		    (huet@poly.polytechnique.fr)
			       1994

  video.c : routines video de l'emulateur (+gestion memoire)

*/


#include <conio.h>
#include <dos.h>
#include <bios.h>

#include "monitor.h"
#include "emuto7.h"
#include "pgraf.h"
#include "scancode.h"

#define nbtouche 68
#define v1 48
#define v2 63

int	tabcol[256*16];

int     tch[2];
int     lkey[256];
int     ckey[256];
FILE    *fl2;
FILE    *fk7;
int     crayx,crayy;
int     lasttour;
int			light;

int     nbwait;
int			nb45,nb63;

int     codel[]=
{0x01,0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x04,0x08,0x10,0x20,0x40,0x80
,0x04,0x08,0x10,0x20,0x40,0x80,0x80,0x40,0x20,0x10
,0x04,0x08,0x10,0x20,0x40,0x80,0x80,0x40,0x20,0x10
,0x04,0x08,0x10,0x20,0x40,0x80,0x80,0x40,0x20,0x10
,0x02,0x04,0x02,0x04,0x08,0x80
,0x04,0x08,0x04,0x08,0x10,0x20,0x40,0x08
,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00
};
int     codec[]=
{0x01,0x01,0x80,0x40,0x20,0x10,0x08,0x02,0x02,0x02,0x02,0x02,0x02,0x02
,0x80,0x80,0x80,0x80,0x80,0x80,0x40,0x40,0x40,0x40
,0x20,0x20,0x20,0x20,0x20,0x20,0x10,0x10,0x10,0x10
,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x04
,0x01,0x01,0x04,0x04,0x04,0x01
,0x40,0x40,0x10,0x10,0x01,0x01,0x01,0x01
,0xfe,0xfb,0xfd,0xf7,0x1
,0xef,0xbf,0xdf,0x7f,0x2
};

void inicray()
	{

	printf("initialisation du crayon optique\n");
	crayx=-1;
	}

void inikey(char *name)
	{
		int     i,key;

	printf("initialisation clavier et joysticks\n");
	for(i=0;i<256;i++)
		{
		lkey[i]=0;
		ckey[i]=255;
		}
	tch[0]=tch[1]=0;

	if (fl2=fopen(name,"r"))
		{
		for(i=0;i<nbtouche;i++)
			{
			fscanf(fl2,"%d",&key);
			lkey[key&255]=codel[i];
			ckey[key&255]=(~codec[i])&255;
			}
		fclose(fl2);
		}
		else
		{
		printf("lancer d'abord enterkey\n");
		exit(0);
		}
	buf[0xe7cc]=0;
	buf[0xe7cd]=0;
	buf[0xe7ce]=0;
	buf[0xe7cf]=0;
	}

void newcass(char *c)
	{
	if (fk7) fclose(fk7);
	if ((fk7=fopen(c,"rb+"))==NULL) fk7=fopen(c,"wb+");
	if (fk7==NULL) if (fk7=fopen(c,"rb")) printf("LECTURE SEULE\n");
	if (fk7==NULL) printf("impossible\n");
		else
		printf("cassette %s\n",c);
	}

void avanck7(long k)
	{
	if (fk7==NULL)
		printf("impossible\n");
		else
		{
		if (k>=0) fseek(fk7,k,0);
		printhx(ftell(fk7),4);
		printf(" : position courante\n");
		}
	}

void inik7()
	{
	fk7=NULL;
	printf("initialisation des k7\n");
	}

int getk7(FILE *f)
{
		int	i,b,j,k;

	i=fgetc(f);
	if((i!=EOF)&&(!fastk7))
		{
			b=128;
			while(b)
				{
					if (b&i)
						for(j=0;j<14;j++)
							{
								for(k=0;k<nb63;k++);
								if (sound) outp(0x61,inp(0x61)^2);
							}
					else
						for(j=0;j<10;j++)
							{
								for(k=0;k<nb45;k++);
								if (sound) outp(0x61,inp(0x61)^2);
							}
					b>>=1;
				}
		}		
	return i;
}
	
void iniscreen(char *name)
	{
		int	i,j,k,b,colfd,colfr;
		char	*p;

	for(i=0;i<256;i++)
		{
			colfd=(i&7)+(((~i)&0x80)>>4)+1;
			colfr=((i>>3)&7)+(((~i)&0x40)>>3)+1;
			for(j=0;j<16;j++)
				{
					b=j;
					p=(char*)&tabcol[i*16+j];

					for(k=0;k<4;k++)
						{
							if (b&0x8) *(p++)=colfr;
							else				*(p++)=colfd;
							b<<=1;
						}
				}
		}

	inikey(name);
	inicray();
	inik7();
	light=0;
	}

void affcur(long k)
	{
			int		i,b;
			int		*p;

		if (k>0x6000) k-=0xc000;
		b=buf[k]&255;
		i=(buf[k+0xc000]&255)<<4;

		k=0xa0000+(k-0x4000)*8;
		p=(int*)k;
		p[0]=tabcol[i+(b>>4)];
		p[1]=tabcol[i+(b&15)];
	}			

long loads(long k)
	{
	if ((k&0xe000)==0x4000)
		{
		if (!(buf[0xe7c3]&1)) k+=0xc000;
		}
		else
		{
		if ((k&0xffc0)==0xe7C0)
			{               /* gestion des io       */
			if (k==0xe7c8)  /* lecture clavier */
				{
					int pb=~buf[0xe7c9];
				return (0xff
					&((pb&lkey[tch[0]])?ckey[tch[0]]:0xff)
					&((pb&lkey[tch[1]])?ckey[tch[1]]:0xff));
				}
			if (k==0xe7c0) return 0x81;
			if (k>0xe7d0)   {
					printhx(pc,8);
					printf("\n");
					}
			return buf[k]&255;
			}
		}
	return buf[k]&255;
	}

long loadl(long k)
	{
	if ((k&0xe000)==0x4000)
		{
		if (!(buf[0xe7c3]&1)) k+=0xc000;
		}
		else
		{
		if ((k&0xffc0)==0xe7C0)
			{               /* gestion des io       */
			return loads(k)<<8+loads(k+1);
			}
		}
	return ((buf[k]&255)<<8)+(buf[k+1]&255);
	}

int stocs(long k,long val)
	{
	if (k<0x6000)
		{
		if (k<0x4000) return 0;
		if (!(buf[0xe7c3]&1))
				{
				k+=0xc000;
				if ((pc>endmem)||(flto7)) val|=mask;
				}
		buf[k]=val;
		affcur(k);
		return 0;
		}
		else
		{
		if (k>endmem)
			{
			if ((k<0xe7c0)||(k>0xe7cb)) return 0;
			if ((k==0xe7c1)&&(snd)) outp(0x61,(inp(0x61)&0xfd)|((val>>2)&2));
			}
		}
	buf[k]=val;
	return 0;
	}

int stocl(long k,long val)
	{
	if (k<0x6000)
		{
		if (k<0x4000) return 0;
		if (!(buf[0xe7c3]&1))
				{
				k+=0xc000;
				if ((pc>endmem)||(flto7)) val|=mask;
				}
		buf[k+1]=val;
		val>>=8;
		buf[k]=val;
		affcur(k);
		affcur(k+1);
		return 0;
		}
		else
		{
		if (k>endmem)
			{
			if ((k<0xe7c0)||(k>0xe7cb)) return 0;
			}
		}
	buf[k+1]=val;
	val>>=8;
	buf[k]=val;
	return 0;
	}

void inivga()
{
		int	i;

	vga256();

	palette(0,0,0,0);
	palette(1+0,0,0,0);
	palette(1+1,v2,0,0);
	palette(1+2,0,v2,0);
	palette(1+3,v2,v2,0);
	palette(1+4,0,0,v2);
	palette(1+5,v2,0,v2);
	palette(1+6,0,v2,v2);
	palette(1+7,v2,v2,v2);

	palette(1+8,v1,v1,v1);
	palette(1+9,v2,v1,v1);
	palette(1+10,v1,v2,v1);
	palette(1+11,v2,v2,v1);
	palette(1+12,v1,v1,v2);
	palette(1+13,v2,v1,v2);
	palette(1+14,v1,v2,v2);
	palette(1+15,v2,v1,0);

	palette(1+16+0,v2,v2,v2);
	palette(1+16+1,0,v2,v2);
	palette(1+16+2,v2,0,v2);
	palette(1+16+3,0,0,v2);
	palette(1+16+4,v2,v2,0);
	palette(1+16+5,0,v2,0);
	palette(1+16+6,v2,0,0);
	palette(1+16+7,0,0,0);

	palette(1+16+8,0,0,0);
	palette(1+16+9,0,0,0);
	palette(1+16+10,0,0,0);
	palette(1+16+11,0,0,0);
	palette(1+16+12,0,0,0);
	palette(1+16+13,0,0,0);
	palette(1+16+14,0,0,0);
	palette(1+16+15,0,0,v2);

	for(i=0x4000;i<0x5f40;i++) affcur(i);
	
	lasttour=0;
}

void readmouse()
{
		union REGS r;

	r.x.eax = 0x0003;               // lit coordonnees souris
	int386 (0x33, &r, &r);
	crayx=r.w.cx;
	crayy=r.w.dx;
	if (r.w.bx&1) buf[0xe7c3]|=2;
	else					buf[0xe7c3]&=0xfd;
}

void inimouse()
{
		union REGS r;

	r.x.eax = 0x0000;               // initialise souris
	int386 (0x33, &r, &r);

	r.x.eax = 0x0007;               // initialise fenetre
	r.x.ecx=0;
	r.x.edx=319;
	int386 (0x33, &r, &r);

	r.x.eax = 0x0008;
	r.x.ecx=0;
	r.x.edx=199;
	int386 (0x33, &r, &r);

	readmouse();
}

long    compt;
int     quitf;

int bouclex()
	{
		int     i,j,k,key;
		int			lx,ly;
		int     mynb;

	if (initkbr(light)) return 1;
	light=1;

	inivga();

	inimouse();

	j=0;
	compt=0;
	tch[0]=tch[1]=0;
	quitf=1;

	mynb=nbwait;

	while(quitf)
	{
	for(i=0;i<11000;i++)
		{
			exe6809();
			for(k=0;k<mynb;k++);
		}
			
	if ((++j)==3)
		{
		if (!(ccrest&0x10))
			{
			ccrest|=0x80;
			pshsr(0xff);
			ccrest|=0x10;
			pc=((buf[0xfff8]<<8)+(buf[0xfff9]&255))&0xffff;
			}
		j=0;
		}

	while(dt->r_recv!=dt->w_recv)
		{
			key=*((short*)&bufr[dt->r_recv]);
			dt->r_recv=(dt->r_recv+2)&maskbuf;
			if (key==2) quitf=0;
			if (key&256)
				{
					key&=255;
					if (lkey[key])
						{
							if (tch[0]==key)
								{
									tch[0]=tch[1];
									tch[1]=0;
								}
							if (tch[1]==key) tch[1]=0;
						}
					else  if ((i=ckey[key])!=255)
						{
							if (i<0xfd)     buf[0xe7cc]|=i;
							if (i==0xfe)    
								{
									buf[0xe7cd]|=0x40;
									buf[0xe7ce]|=0x80;
								}
							if (i==0xfd)    
								{
									buf[0xe7cd]|=0x80;
									buf[0xe7cf]|=0x80;
								}
						}
				}
			else
				{
					if (lkey[key])
						{
							if (tch[0]==0) tch[0]=key;
							else if (tch[0]!=key) tch[1]=key;
						}
					else  if ((i=ckey[key])!=255)
						{
							if (i==0xfe)
								{
									buf[0xe7cd]&=0xbf;
									buf[0xe7ce]&=0x7f;
								}
							if (i==0xfd)    
								{
									buf[0xe7cd]&=0x7f;
									buf[0xe7cf]&=0x7f;
								}
							if (i<0xfd)     buf[0xe7cc]&=~i;
						}
				}		
		}		
	lx=crayx; ly=crayy;
	readmouse();
	if((crayx!=lx)||(crayy!=ly))
		{
			affcur(0x4000+ly*40+(lx>>3));
			pset(0xa0000,crayx,crayy,16+*((char*)(0xa0000+crayy*320+crayx)));
		}	

	if (lasttour!=(buf[0xe7c3]&0x70))
		{
			lasttour=(buf[0xe7c3]&0x70);
			switch(lasttour>>4) {
				case 0:
					palette(0,0,0,0);
					break;
				case 1:
					palette(0,v2,0,0);
					break;
				case 2:
					palette(0,0,v2,0);
					break;
				case 3:
					palette(0,v2,v2,0);
					break;
				case 4:
					palette(0,0,0,v2);
					break;
				case 5:
					palette(0,v2,0,v2);
					break;
				case 6:
					palette(0,0,v2,v2);
					break;
				case 7:
					palette(0,v2,v2,v2);
					break;
			}
		}			


	}
	cleankbr();

	text80();
	return 0;
	}

