; routines graphiques VGA 320*200, une page

	.386p
  	OPTION	OLDSTRUCTS
	OPTION	SEGMENT:USE32

; Section CODE

_TEXT  SEGMENT FLAT PUBLIC 'CODE'
	ASSUME cs:FLAT,ds:FLAT,es:FLAT,ss:FLAT

; passage en mode 320x200
vga256	proc near
	push    ebp
	push	esi
	push	edi
	push	ebx
	
	mov	ax,13h
	int	10h
	
	pop	ebx
	pop	edi
	pop	esi
	pop	ebp
	ret

vga256	endp

; passage en mode texte standard
text80	proc near
	push    ebp
	push	esi
	push	edi
	
	mov	ax,2
	int	10h
	
	pop	edi
	pop	esi
	pop	ebp
	ret

text80	endp


; routine de cls

clsadec	equ	8
clscol	equ	12

cls	proc	near
	push	ebp
	mov	ebp,esp

	push	edi
	mov	edi,[ebp+clsadec]
	mov	ax,[ebp+clscol]
	mov	ecx,64000
	cld
	rep	stosb
	pop	edi
	pop	ebp
	ret

cls	endp

; routine de cls 16 bits

cls16adec	equ	8
cls16col	equ	12

cls16	proc	near
	push	ebp
	mov	ebp,esp

	push	edi
	mov	edi,[ebp+cls16adec]
	mov	ax,[ebp+cls16col]
	mov	ecx,32000
	cld
	rep	stosw
	pop	edi
	pop	ebp
	ret

cls16	endp

; transfert une zone de longueur nb de src vers dest
movnb	equ	8
movsrc	equ	12
movdest	equ	16

movsc	proc	near
	push	ebp
	mov	ebp,esp
	push	edi
	push	esi
	cld
	
	mov	esi,[ebp+movsrc]
	mov	edi,[ebp+movdest]
	mov	ecx,[ebp+movnb]
	mov	edx,ecx
	shr	ecx,2
	rep	movsd
	mov	ecx,edx
	and	ecx,3
	or	ecx,ecx
	je	movsc1
	rep	movsb

movsc1:	pop	esi
	pop	edi
	pop	ebp
	ret

movsc	endp


; routine de pset

psetadec	equ	8
psetx	equ	12
psety	equ	16
psetcol	equ	20

pset	proc	near
	push	ebp
	mov	ebp,esp
	
	push	edi
	mov	edi,[ebp+psetadec]

	mov	eax,320
	mul	word ptr[ebp+psety]
	add	ax,[ebp+psetx]

	add	edi,eax
	mov	ax,[ebp+psetcol]
	stosb
	pop	edi
	
	mov	esp,ebp
	pop	ebp
	ret
pset	endp


; routine de pset avec test de sortie d'ecran

psetwadec	equ	8
psetwx	equ	12
psetwy	equ	16
psetwcol	equ	20
psetwxmin	equ	24
psetwxmax	equ	28
psetwymin	equ	32
psetwymax	equ	36

psetwin	proc	near
	push	ebp
	mov	ebp,esp
	push	edi
	mov	edi,[ebp+psetwadec]

	mov	eax,[ebp+psetwy]
	cmp	eax,[ebp+psetwymin]
	jl	psetwf
	cmp	eax,[ebp+psetwymax]
	jg	psetwf
	mov	edx,320
	imul	edx

	mov	edx,[ebp+psetwx]
	cmp	edx,[ebp+psetwxmin]
	jl	psetwf
	cmp	edx,[ebp+psetwxmax]
	jg	psetwf
	add	eax,edx

	add	edi,eax
	mov	al,[ebp+psetwcol]
	mov	[edi],al

psetwf:	pop	edi	
	mov	esp,ebp
	pop	ebp
	ret
psetwin	endp


; routine de tracer de ligne

lineadec	equ	8
linexa	equ	12
lineya	equ	16
linexb	equ	20
lineyb	equ	24
linecol	equ	28

linedlx	equ	-4
linedpx	equ	-8
linedpy	equ	-12
lineend	equ	-16

line	proc	near
	push	ebp
	mov	ebp,esp
	add	esp,lineend
	push	edi

	mov	edi,[ebp+lineadec]
	mov	eax,320  
	mul	word ptr [ebp+lineya]
	add	ax,[ebp+linexa]
	add	edi,eax

	mov     dword ptr [ebp+linedpx],1
	mov	cx,[ebp+linexb]
	sub	cx,[ebp+linexa]
	jge	lin0
	neg	cx
	neg	dword ptr[ebp+linedpx]
lin0:	inc	cx
	mov	[ebp+linedlx],cx

	mov	dword ptr [ebp+linedpy],320
	mov	bx,[ebp+lineyb]
	sub	bx,[ebp+lineya]
	jge	lin1
	neg	bx
	neg	dword ptr[ebp+linedpy]
lin1:	inc	bx

	cmp	cx,bx
	jg	lin1a
	mov	cx,bx
lin1a:	xor	dx,dx
	mov	ax,[ebp+linecol]

lin2:	add	dx,[ebp+linedlx]
lin3:	mov	[edi],al
	dec	cx
	jne	lin4
	pop	edi
	mov	esp,ebp
	pop	ebp
	ret
lin4:	cmp	dx,bx
	jl	lin5
	sub	dx,bx
	add	edi,[ebp+linedpx]
	cmp	dx,bx
	jge	lin3
lin5:	add	edi,[ebp+linedpy]
	jmp	lin2

line	endp

; routine de tracer de ligne avec sortie d'ecran

linewadec	equ	8
linewxa	equ	12
linewya	equ	16
linewxb	equ	20
linewyb	equ	24
linewcol	equ	28
linewxmin	equ	32
linewxmax	equ	36
linewymin	equ	40
linewymax	equ	44

linewdlx	equ	-4
linewdpx	equ	-8
linewdpy	equ	-12
linewend	equ	-16

linewin	proc	near
	push	ebp
	mov	ebp,esp
	add	esp,linewend
	push	edi

linwg0:	mov	eax,[ebp+linewxa]
	mov	ecx,[ebp+linewxb]
	cmp	eax,[ebp+linewxmin]
	jge	linwg1
	cmp	ecx,[ebp+linewxmin]
	jl	linwfin
	mov	edi,ebp
	add	edi,linewxa
	jmp	linwg2
linwg1:	cmp	ecx,[ebp+linewxmin]
	jge	linwd0
	mov	edi,ebp
	add	edi,linewxb
linwg2:	sub	ecx,eax
	sub	eax,[ebp+linewxmin]
	neg	eax
	mov	edx,[ebp+linewyb]
	sub	edx,[ebp+linewya]
	imul	edx
	idiv	ecx
	add	eax,[ebp+linewya]
	mov	[edi+4],eax
	mov	eax,[ebp+linewxmin]
	mov	[edi],eax

linwd0:	mov	eax,[ebp+linewxa]
	mov	ecx,[ebp+linewxb]
	cmp	eax,[ebp+linewxmax]
	jle	linwd1
	cmp	ecx,[ebp+linewxmax]
	jg	linwfin
	mov	edi,ebp
	add	edi,linewxa
	jmp	linwd2
linwd1:	cmp	ecx,[ebp+linewxmax]
	jle	linwh0
	mov	edi,ebp
	add	edi,linewxb
linwd2:	sub	ecx,eax
	sub	eax,[ebp+linewxmax]
	neg	eax
	mov	edx,[ebp+linewyb]
	sub	edx,[ebp+linewya]
	imul	edx
	idiv	ecx
	add	eax,[ebp+linewya]
	mov	[edi+4],eax
	mov	eax,[ebp+linewxmax]
	mov	[edi],eax

linwh0:	mov	eax,[ebp+linewya]
	mov	ecx,[ebp+linewyb]
	cmp	eax,[ebp+linewymin]
	jge	linwh1
	cmp	ecx,[ebp+linewymin]
	jl	linwfin
	mov	edi,ebp
	add	edi,linewxa
	jmp	linwh2
linwh1:	cmp	ecx,[ebp+linewymin]
	jge	linwb0
	mov	edi,ebp
	add	edi,linewxb
linwh2:	sub	ecx,eax
	sub	eax,[ebp+linewymin]
	neg	eax
	mov	edx,[ebp+linewxb]
	sub	edx,[ebp+linewxa]
	imul	edx
	idiv	ecx
	add	eax,[ebp+linewxa]
	mov	[edi],eax
	mov	eax,[ebp+linewymin]
	mov	[edi+4],eax

linwb0:	mov	eax,[ebp+linewya]
	mov	ecx,[ebp+linewyb]
	cmp	eax,[ebp+linewymax]
	jle	linwb1
	cmp	ecx,[ebp+linewymax]
	jg	linwfin
	mov	edi,ebp
	add	edi,linewxa
	jmp	linwb2
linwb1:	cmp	ecx,[ebp+linewymax]
	jle	linw0a
	mov	edi,ebp
	add	edi,linewxb
linwb2:	sub	ecx,eax
	sub	eax,[ebp+linewymax]
	neg	eax
	mov	edx,[ebp+linewxb]
	sub	edx,[ebp+linewxa]
	imul	edx
	idiv	ecx
	add	eax,[ebp+linewxa]
	mov	[edi],eax
	mov	eax,[ebp+linewymax]
	mov	[edi+4],eax

linw0a:	mov	edi,[ebp+linewadec]
	mov	eax,320  
	imul	word ptr [ebp+linewya]
	add	ax,[ebp+linewxa]
	add	edi,eax

	mov     dword ptr [ebp+linewdpx],1
	mov	cx,[ebp+linewxb]
	sub	cx,[ebp+linewxa]
	jge	linw0
	neg	cx
	neg	dword ptr[ebp+linewdpx]
linw0:	inc	cx
	mov	[ebp+linewdlx],cx

	mov	dword ptr [ebp+linewdpy],320
	mov	bx,[ebp+linewyb]
	sub	bx,[ebp+linewya]
	jge	linw1
	neg	bx
	neg	dword ptr[ebp+linewdpy]
linw1:	inc	bx

	cmp	cx,bx
	jg	linw1a
	mov	cx,bx
linw1a:	xor	dx,dx
	mov	ax,[ebp+linewcol]

linw2:	add	dx,[ebp+linewdlx]
linw3:	mov	[edi],al
	dec	cx
	je	linwfin
	cmp	dx,bx
	jl	linw5
	sub	dx,bx
	add	edi,[ebp+linewdpx]
	cmp	dx,bx
	jge	linw3
linw5:	add	edi,[ebp+linewdpy]
	jmp	linw2

linwfin:	pop	edi
	mov	esp,ebp
	pop	ebp
	ret

linewin	endp


; attend le debut du prochain retour vertical du spot

waitd	proc	near
	mov	dx,3dah


waitd0:	in	al,dx
	and	al,8
	jnz	waitd0

waitd1:	in	al,dx
	and	al,8
	jz	waitd1
	ret

waitd	endp


; attend la fin du prochain retour vertical du spot

waite	proc	near
	mov	dx,3dah


waite0:	in	al,dx
	and	al,8
	jz	waite0

waite1:	in	al,dx
	and	al,8
	jnz	waite1
	ret

waite	endp


; fonction inkey$

inkey	proc	near
	mov	ah,11h
	int	16h
	mov	ax,0
	jz	inkey0
	mov	ah,10h
	int	16h
	cmp	al,0
	je	inkey0
	cmp	al,0e0h
	je	inkey0
	xor	ah,ah
inkey0:	ret

inkey	endp


; redefinit la couleur 'n', a partir de l'intensite des trois composantes
; (comprises entre 0 et 63)
; palette(short n, short rouge, short vert, short bleu)

palette	proc	near
	push	ebp
	mov	ebp,esp

	mov	dx,[ebp+12]
	mov	dh,dl
	mov	bx,[ebp+16]
	mov	cx,[ebp+20]
	mov	ch,bl
	mov	bx,[ebp+8]
	mov	ax,1010h
	int	10h
	
	mov	esp,ebp
	pop	ebp
	ret
palette	endp

; redefinit plusieurs couleurs en meme temps
; 'prem' est le numero de la premiere couleur
; 'n' est le nombre de couleurs a modifier
; 'pn' est un pointeur sur le tableau des nouvelles couleurs :
;  3 caracteres par couleur : rouge, vert puis bleu (compris entre 0 et 63)
; multipal(short prem, short n, char *pn)

multipal	proc	near
	push	ebp
	mov	ebp,esp
	push	esi

	mov	ax,[ebp+8]
	mov	dx,3c8h
	out	dx,al

	movzx	ecx,word ptr [ebp+12]
	mov	eax,ecx
	add	eax,eax
	add	ecx,eax
	mov	esi,[ebp+16]
	mov	dx,3c9h

	rep	outsb
			
	pop	esi
	mov	esp,ebp
	pop	ebp
	ret
multipal	endp

_TEXT	ENDS
	END



