//
//       ROUTINES DE COMMUNICATION SERIE
//          PAR INTERRUPTION BIMODALE
//
//     d'apres l'exemple fourni par Watcom
//

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <bios.h>

#define D32RealSeg(P)   ((((DWORD) (P)) >> 4) & 0xFFFF)
#define D32RealOff(P)   (((DWORD) (P)) & 0xF)


#define OffdataRS	232
#define Offbufr		256
#define Offbufs		2304
#define maskbuf		2047

struct DataRS
	{
		short		compt1;
		short		compt2;
		int		r_send;
		int		w_send;
		int		r_recv;
		int		w_recv;
		short	suspend;
		short	port;
	};
typedef struct DataRS *dataRS;


typedef unsigned short WORD;
typedef unsigned long DWORD;

void extern cdecl pmhandler (void);
void extern cdecl rmhandler (void);

char		*lowp;
dataRS	dt;
WORD		orig_rm_seg;
WORD		orig_rm_off;
DWORD		orig_pm_off;
WORD		orig_pm_sel;
char		*bufr;
char		*bufs;

unsigned char com_id;
unsigned char com_int;
unsigned short com_port;
unsigned short lowmem_seg;

void *D32DosMemAlloc (DWORD size, WORD *selector)
	{
	union REGS r;

	r.x.eax = 0x0100;               // DPMI allocate DOS memory
	r.x.ebx = (size + 15) >> 4;     // Number of paragraphs requested
	int386 (0x31, &r, &r);

	if (r.x.cflag)
		return ((DWORD) 0);                                     // Failed
	if (selector)
		*selector = r.w.dx;
	return (void *) ((r.x.eax & 0xFFFF) << 4);
	}

// initialisation d'un port serie (1 ou 2)
int initkbr(int light)
{
		union REGS	r;
		char 				*src;
		void far		*fh;
		int					i;
	
	com_int=0x09;
	com_port=0x60;

	// Save the starting real-mode and protected-mode handler addresses.
	r.x.eax = 0x0204;              // DPMI get protected mode vector
	r.h.bl = com_int;
	int386 (0x31, &r, &r);
	orig_pm_sel = (WORD) r.x.ecx;
	orig_pm_off = r.x.edx;

	r.x.eax = 0x0200;              // DPMI get real mode vector
	r.h.bl = com_int;
	int386 (0x31, &r, &r);
	orig_rm_seg = (WORD) r.x.ecx;
	orig_rm_off = (WORD) r.x.edx;

if (!light)
	{
	// alloue en memoire basse la place necessaire a la routine reelle
	if (! (lowp = D32DosMemAlloc (256 + 2048*2, &lowmem_seg)))
		{
		printf ("Couldn't get low memory!\n");
		return 1;
		}
	src=(char*) rmhandler;
	for(i=0;i<256;i++) lowp[i]=src[i];
	}

	dt=(dataRS)&lowp[OffdataRS];
	dt->compt1=0;
	dt->compt2=0;
	dt->r_send=0;
	dt->w_send=0;
	dt->r_recv=0;
	dt->w_recv=0;
	dt->suspend=0;
	dt->port=com_port;

	bufr=&lowp[Offbufr];
	bufs=&lowp[Offbufs];

	// installe handler protege

	fh = (void far *) pmhandler;
	r.x.eax = 0x0205;            // DPMI set protected mode vector
	r.x.ebx = (DWORD) com_int;
	r.x.ecx = (DWORD) FP_SEG(fh);
	r.x.edx = FP_OFF(fh);
	int386 (0x31, &r, &r);

if (!light)
	{
	r.x.eax = 0x0600;            // DPMI lock linear region
	r.x.ebx = ((DWORD) pmhandler) >> 16;
	r.x.ecx = ((DWORD) pmhandler) & 0xFFFF;
	r.x.esi = 0;
	r.x.edi = 256;               // lock 256 bytes
	int386 (0x31, &r, &r);
	r.x.eax = 0x0600;
	r.x.ebx = ((DWORD) &lowmem_seg) >> 16;
	r.x.ecx = ((DWORD) &lowmem_seg) & 0xFFFF;
	r.x.esi = 0;
	r.x.edi = sizeof(WORD);      // lock 2 bytes
	int386 (0x31, &r, &r);
	}

	// installe handler reel
	r.x.eax = 0x0201;            // DPMI set real mode vector
	r.x.ebx = (DWORD) com_int;
	r.x.ecx = D32RealSeg(lowp);  // CX:DX == real mode &handler
	r.x.edx = D32RealOff(lowp);
	int386 (0x31, &r, &r);

	return 0;
}	

// Clean up.
void cleankbr()
{
		union REGS	r;
	
	r.x.eax = 0x0201;              // DPMI set real mode vector
	r.x.ebx = (DWORD) com_int;
	r.x.ecx = (DWORD) orig_rm_seg; // CX:DX == real mode &handler
	r.x.edx = (DWORD) orig_rm_off;
	int386 (0x31, &r, &r);

	r.x.eax = 0x0205;              // DPMI set protected mode vector
	r.x.ebx = (DWORD) com_int;
	r.x.ecx = (DWORD) orig_pm_sel;
	r.x.edx = orig_pm_off;
	int386 (0x31, &r, &r);
}


