;**
;** bimo.asm:
;**	Interrupt handlers for real- and protected-mode INT 0xC, or 0x0B
;** if the -2 command-line option is used.  See the bimodal.c example
;** program for details.
;**

.286

_TEXT16	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	cs:_TEXT16

rscode	equ	0
rscompt1	equ	232
rscompt2	equ	234
rsr_send	equ	236
rsw_send	equ	240
rsr_recv	equ	244
rsw_recv	equ	248
rssuspend	equ	252
rsport	equ	254
rsbuf_recv	equ	256
rsbuf_send	equ	2304

maskbuf	equ	2047

	PUBLIC	rmhandler
rmhandler:
	push	ds
	push	bx
	push	ax
	push	dx

	mov	dx,cs:[rsport]
	mov	ax,cs:[rssuspend]
	in	al,dx
	inc	word ptr cs:[rscompt1]

	cmp	al,0e0h
	jne	rmhandler1

           	mov	word ptr cs:[rssuspend],08000h
	jmp	rmhandler3

rmhandler1:	cmp	ax,0802ah
	je	rmhandler2
	cmp	ax,080aah
	je	rmhandler2
	
	rol	ax,1
	mov	bx,cs:[rsw_recv]	; get buffer index
	mov	cs:[rsbuf_recv+bx], ax	; store data

	add	bx,2			; incremente compteur

	and	bx,maskbuf
	mov	cs:[rsw_recv],bx 
rmhandler2:	mov	word ptr cs:[rssuspend],0

rmhandler3:	mov	dx,020h
	mov	al,dl
	out	dx,al		       ; Send EOI
	pop	dx
	pop	ax
	pop	bx
	pop	ds
	iret
	ASSUME	cs:NOTHING


_TEXT16	ENDS

.386p
  	OPTION	OLDSTRUCTS
	OPTION	SEGMENT:USE32

externdef syscall com_port:WORD
externdef syscall com_id:BYTE
externdef syscall lowmem_seg:WORD
_DATA	SEGMENT DWORD PUBLIC 'DATA'
_DATA	ENDS

_TEXT	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	cs:_TEXT, ds:_DATA

	PUBLIC	com_init
com_init:
	mov	ax,0F3h		       ; 9600,n,8,1
	mov	dl,[com_id]
	sub	dh,dh
	dec	dx		       ; 0 = COM1, 1 = COM2
	int	14h		       ; Initialize device
	mov	bx,[com_port]	       ; Base of port space
	lea	edx,[ebx+5]	       ; line status register
	in	al,dx                  
	lea	edx,[ebx+4]	       ; modem control register
	in	al,dx
	or	al,8		       ; enable OUT2 interrupt
	out	dx,al
	lea	edx,[ebx+2]	       ; int id register
	in	al,dx
	mov	dx,bx		       ; data receive register
	in	al,dx
	mov	dl,NOT 10h	       ; mask for IRQ4
	cmp	[com_id],1
	je	maskit                 
	mov	dl,NOT 8h	       ; mask for IRQ3
maskit:
	in	al,21h		       ; interrupt mask register
	and	al,dl		       ; force IRQ unmasked
	out	21h,al
	lea	edx,[ebx+1]	       ; int enable register
	mov	al,3
	out	dx,al		       ; enable received-data int
	ret

	ASSUME	ds:NOTHING

	;**
	;** The protected-mode interrupt handler is in a 32-bit code
	;** segment.  Even so, we have to be sure to force an IRETD
	;** at the end of the handler, because MASM doesn't generate
	;** one.  This handler will be called on a 32-bit stack by
	;** DOS/4GW.
	;**

	PUBLIC	pmhandler
pmhandler:
	push	ds
	push	ebx
	mov	bx,_DATA
	mov	ds,bx
	ASSUME	ds:_DATA
	push	eax

	mov	bx, [lowmem_seg]
	mov	ds, bx		; Get DS addressability to buffer

	ASSUME	ds:NOTHING

	push	edx

	mov	dx, ds:[rsport]
	mov	ax, ds:[rssuspend]
	in	al,dx

	inc	word ptr ds:[rscompt2]

	cmp	al,0e0h
	jne	pmhandler1

           	mov	word ptr ds:[rssuspend],08000h
	jmp	pmhandler3

pmhandler1:	cmp	ax,0802ah
	je	pmhandler2
	cmp	ax,080aah
	je	pmhandler2
	
	rol	ax,1
	mov	ebx,ds:[rsw_recv]	; get buffer index
	mov	ds:[rsbuf_recv+ebx],ax	; store data
	add	ebx,2			; incremente compteur
	and	ebx,maskbuf
	mov	ds:[rsw_recv],ebx 

pmhandler2:	mov	word ptr ds:[rssuspend],0

pmhandler3:	mov	dx,020h
	mov	al,dl
	out	dx,al		       ; Send EOI
	pop	edx
	pop	eax
	pop	ebx
	pop	ds
	iretd

_TEXT	ENDS

END
