/*
		    TTTTTTT    OOOOO    7777777
		       T      O     O        7
		       T      O     O       7
		       T      O     O      7
		       T      O     O     7
		       T       OOOOO     7

			     EMULATEUR

			  Par Sylvain HUET
		    (huet@poly.polytechnique.fr)
			       1994

 emup1.c : emulateur 6809. 1ere partie (+io to7)

*/

#include "monitor.h"
#include "emuto7.h"
#include "video.h"

void negm()             /* H?NxZxVxCx */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	m1=val; m2=-val;                /* bit V */
	stocs(k,val=-val);
	ovfl=res=sign=val;
	}

void comm()             /* NxZxV0C1 */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	m1=~m2;
	stocs(k,val=(~val)&255);
	sign=val;
	res=sign|0x100; /* bit C a 1 */
	}

void lsrm()             /* N0ZxCx */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	res=(val&1)<<8; /* bit C */
	stocs(k,val>>=1);
	sign=0;
	res|=val;
	}

void rorm()             /* NxZxCx */
	{
		long    k;
		int     val,i;
	i=val=loads(k=(*adresc[ad])());
	stocs(k,val=(val|(res&0x100))>>1);
	sign=val;
	res=((i&1)<<8)|sign;
	}

void asrm()             /* H?NxZxCx */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	res=(val&1)<<8;
	stocs(k,val=(val>>1)|(val&0x80));
	sign=val;
	res|=sign;
	}

void aslm()             /* H?NxZxVxCx */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	m1=m2=val;
	stocs(k,val<<=1);
	ovfl=sign=res=val;
	}

void rolm()             /* NxZxVxCx */
	{
		long    k;
		int     val,i;
	i=val=loads(k=(*adresc[ad])());
	m1=m2=val;
	stocs(k,val=(val<<1)|((res&0x100)>>8) );
	ovfl=sign=res=val;
	}

void decm()             /* NxZxVx */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	m1=val; m2=0x80;
	stocs(k,--val);
	ovfl=sign=val&255;
	res=(res&0x100)|sign;
	}

void incm()             /* NxZxVx */
	{
		long    k;
		int     val;
	val=loads(k=(*adresc[ad])());
	m1=val; m2=0;
	stocs(k,++val);
	ovfl=sign=val&255;
	res=(res&0x100)|sign;
	}

void tstm()             /* NxZxV0 */
	{
		int     val;
	val=loads((*adresc[ad])());
	m1=~m2;
	sign=val;
	res=(res&0x100)|sign;
	}

long posit()
	{
	if (fk7) return ftell(fk7);
	return 0;
	}

void iosb()
	{
	if (pc==0xfd3f) /*      crayon optique  */
			{
			res&=0xff;
			xr=crayx%320;
			yr=crayy%200;
			}
	if (pc==0xfc10) /*      k7      */
			{
				int     i;

			res&=0xff;
			switch(buf[0x6029]&15)  {
			case 1:
/*
 				printf("\n");
				printhx(posit(),4);
				printf(" : ouverture lecture\n");
 */
				buf[0x602a]=1;
				break;
			case 2:
//				printf("*");
				if (fk7) i=getk7(fk7);
					else i=EOF;
				if (i==EOF)     {
						res|=0x100;
						buf[0x602a]=-0x80;
						}
				br=i&255;
				break;
			case 4:
/*
 				printf("\n");
				printhx(posit(),4);
				printf(" : ouverture ecriture\n");
*/
				if ((fk7)&&(buf[0x602a]!=4))
					for(i=0;i<10;i++) fputc(br,fk7);
				buf[0x602a]=4;
				break;
			case 8:
//				printf(".");
				if (fk7) fputc(br,fk7);
				break;
			default:
/*				printf("\n");
				printhx(posit(),4);
				printf(" : fermeture\n");
*/
				buf[0x602a]=16;
				break;  }
			}
	}

void jmpm()
	{
	pc=(*adresl[ad])();
	}

void jsrm()
	{
		long k;
	k=(*adresl[ad])();
	sr=(sr-2)&0xffff;
	stocl(sr,pc);
	pc=k;
	}

void clrm()     /* N0Z1V0C0 */
	{
	stocs((*adresc[ad])(),0);
	m1=~m2;
	sign=res=0;
	}

void nopm()
	{
	}

void synm()
	{
/*      printf("sync\n");
*/      }

void lbra()
	{
	pc=(pc+((*op)<<8)+(op[1]&255))&0xffff;
	}

void lbsr()
	{
	sr=(sr-2)&0xffff;
	stocl(sr,pc);
	pc=(pc+((*op)<<8)+(op[1]&255))&0xffff;
	}

void daam()     /* NxZxV?Cx */
	{
		int     i=ar+(res&0x100);
	if (((ar&15)>9)||((h1&15)+(h2&15)>15)) i+=6;
  if (i>0x99) i+=0x60;
	res=sign=i;
//	printf("daa %x %x\n",ar,i);
	ar=i&255;
	}

void orcc()
	{
	setcc(getcc()|(*op));
	}

void andc()
	{
	setcc(getcc()&(*op));
	}

void sexm()     /* NxZx */
	{
	if (br&0x80) ar=0xff;
		else ar=0;
	sign=br;
	res=(res&0x100)|sign;
	}


void exgm()
	{
		long    k,l;
		int     o1,o2;
		long    *p,*q;

	o1=((*op)&0xf0)>>4;
	o2=(*op)&15;
	if (p=exreg[o1]) k=*p;
		else    if (o1) k=getcc();
				else k=(ar<<8)+br;
	if (q=exreg[o2])
			{
			l=*q;
			*q=k;
			}
		else    if (o2) {
				l=getcc();
				setcc(k);
				}
				else
				{
				l=(ar<<8)+br;
				ar=(k>>8)&255;
				br=k&255;
				}
	if (p) *p=l;
		else    if (o1) setcc(l);
				else
				{
				ar=(l>>8)&255;
				br=l&255;
				}
	}

void tfrm()
	{
		long    k;
		int     o1,o2;
		long    *p,*q;

	o1=((*op)&0xf0)>>4;
	o2=(*op)&15;
	if (p=exreg[o1]) k=*p;
		else    if (o1) k=getcc();
				else k=(ar<<8)+br;
	if (q=exreg[o2]) *q=k;
		else    if (o2) setcc(k);
				else
				{
				ar=(k>>8)&255;
				br=k&255;
				}
	}

void bras()
	{
	pc+=op[0];
	}
void brns()
	{
	}

void bhis()     /* c|z=0 */
	{
	if ((!(res&0x100))&&(res&0xff)) pc+=op[0];
	}
void blss()     /* c|z=1 */
	{
	if ((res&0x100)||(!(res&0xff))) pc+=op[0];
	}

void bccs()     /* c=0 */
	{
	if (!(res&0x100)) pc+=op[0];
	}
void blos()     /* c=1 */
	{
	if (res&0x100) pc+=op[0];
	}

void bnes()     /* z=0 */
	{
	if (res&0xff) pc+=op[0];
	}
void beqs()     /* z=1 */
	{
	if (!(res&0xff)) pc+=op[0];
	}

void bvcs()     /* v=0 */
	{
	if ( ((m1^m2)&0x80)||(!((m1^ovfl)&0x80)) ) pc+=op[0];
	}
void bvss()     /* v=1 */
	{
	if ( (!((m1^m2)&0x80))&&((m1^ovfl)&0x80) ) pc+=op[0];
	}

void bpls()     /* n=0 */
	{
	if (!(sign&0x80)) pc+=op[0];
	}
void bmis()     /* n=1 */
	{
	if (sign&0x80) pc+=op[0];
	}

void bges()     /* n^v=0 */
	{
	if (!((sign^((~(m1^m2))&(m1^ovfl)))&0x80)) pc+=op[0];
	}
void blts()     /* n^v=1 */
	{
	if ((sign^((~(m1^m2))&(m1^ovfl)))&0x80) pc+=op[0];
	}

void bgts()     /* z|(n^v)=0 */
	{
	if ( (res&0xff)
	   &&(!((sign^((~(m1^m2))&(m1^ovfl)))&0x80)) ) pc+=op[0];
	}
void bles()     /* z|(n^v)=1 */
	{
	if ( (!(res&0xff))
	   ||((sign^((~(m1^m2))&(m1^ovfl)))&0x80) ) pc+=op[0];
	}


void leax()     /* Zx */
	{
	xr=(*adresc[ad])();
	res=(res&0x100)|((xr|(xr>>8))&255);
	}

void leay()     /* Zx */
	{
	yr=(*adresc[ad])();
	res=(res&0x100)|((yr|(yr>>8))&255);
	}

void leas()
	{
	sr=(*adresc[ad])();
	}

void leau()
	{
	ur=(*adresc[ad])();
	}

void pshsr(int i)
	{
	if (i&0x80)     {
			sr=(sr-2)&0xffff;
			stocl(sr,pc);
			}
	if (i&0x40)     {
			sr=(sr-2)&0xffff;
			stocl(sr,ur);
			}
	if (i&0x20)     {
			sr=(sr-2)&0xffff;
			stocl(sr,yr);
			}
	if (i&0x10)     {
			sr=(sr-2)&0xffff;
			stocl(sr,xr);
			}
	if (i&0x8)      {
			sr=(sr-1)&0xffff;
			stocs(sr,dp);
			}
	if (i&0x4)      {
			sr=(sr-1)&0xffff;
			stocs(sr,br);
			}
	if (i&0x2)      {
			sr=(sr-1)&0xffff;
			stocs(sr,ar);
			}
	if (i&0x1)      {
			sr=(sr-1)&0xffff;
			stocs(sr,getcc());
			}
	}

void pshs()
	{
	pshsr(*op);
	}

void pulsr(int i)
	{
	if (i&0x1)      {
			setcc(loads(sr));
			sr=(sr+1)&0xffff;
			}
	if (i&0x2)      {
			ar=loads(sr);
			sr=(sr+1)&0xffff;
			}
	if (i&0x4)      {
			br=loads(sr);
			sr=(sr+1)&0xffff;
			}
	if (i&0x8)      {
			dp=loads(sr);
			sr=(sr+1)&0xffff;
			}
	if (i&0x10)     {
			xr=loadl(sr);
			sr=(sr+2)&0xffff;
			}
	if (i&0x20)     {
			yr=loadl(sr);
			sr=(sr+2)&0xffff;
			}
	if (i&0x40)     {
			ur=loadl(sr);
			sr=(sr+2)&0xffff;
			}
	if (i&0x80)     {
			pc=loadl(sr);
			sr=(sr+2)&0xffff;
			}
	}

void puls()
	{
	pulsr(*op);
	}

void pshu()
	{
		int     i=*op;

	if (i&0x80)     {
			ur=(ur-2)&0xffff;
			stocl(ur,pc);
			}
	if (i&0x40)     {
			ur=(ur-2)&0xffff;
			stocl(ur,sr);
			}
	if (i&0x20)     {
			ur=(ur-2)&0xffff;
			stocl(ur,yr);
			}
	if (i&0x10)     {
			ur=(ur-2)&0xffff;
			stocl(ur,xr);
			}
	if (i&0x8)      {
			ur=(ur-1)&0xffff;
			stocs(ur,dp);
			}
	if (i&0x4)      {
			ur=(ur-1)&0xffff;
			stocs(ur,br);
			}
	if (i&0x2)      {
			ur=(ur-1)&0xffff;
			stocs(ur,ar);
			}
	if (i&0x1)      {
			ur=(ur-1)&0xffff;
			stocs(ur,getcc());
			}
	}

void pulu()
	{
		int     i=*op;

	if (i&0x1)      {
			setcc(loads(ur));
			ur=(ur+1)&0xffff;
			}
	if (i&0x2)      {
			ar=loads(ur);
			ur=(ur+1)&0xffff;
			}
	if (i&0x4)      {
			br=loads(ur);
			ur=(ur+1)&0xffff;
			}
	if (i&0x8)      {
			dp=loads(ur);
			ur=(ur+1)&0xffff;
			}
	if (i&0x10)     {
			xr=loadl(ur);
			ur=(ur+2)&0xffff;
			}
	if (i&0x20)     {
			yr=loadl(ur);
			ur=(ur+2)&0xffff;
			}
	if (i&0x40)     {
			sr=loadl(ur);
			ur=(ur+2)&0xffff;
			}
	if (i&0x80)     {
			pc=loadl(ur);
			ur=(ur+2)&0xffff;
			}
	}

void rtsm()
	{
	pc=loadl(sr);
	sr=(sr+2)&0xffff;
	}

void abxm()
	{
	xr=(xr+br)&0xffff;
	}

void rtim()
	{
	pulsr(1);
	if (ccrest&0x80) pulsr(0xfe);
		else    pulsr(0x80);
	}

void cwai()
	{
		/* a priori inutile */
/*      printf("cwai\n");
*/      }

void mulm()             /* ZxCx */ 
	{
		long    k;
	k=ar*br;
	ar=(k>>8)&255;
	br=k&255;
	res=((br&0x80)<<1)|( (k|(k>>8)) &255);  /* c=bit7 de br */
	}

void swim()
	{
	ccrest|=0x80;
	pshsr(0xff);
	ccrest|=0x50;
	pc=((buf[0xfffa]<<8)+(buf[0xfffb]&255))&0xffff;
	}

























