void WrSpeaker()
{
    static byte wb = 0xFF; 
    int cycles;
    int wavbytes;
    int n;
    float cycles_to_secs;
  
    //
    // get cpu cycles since last speaker toggle
    //
    cycles = spkr_cycles - Regs.ICount;
    
    //
    // convert to seconds to get VZ elapsed time 
    //
    cycles_to_secs = 1.0 / (Regs.IPeriod * 50 / cycles);        

    // 
    // calculate number of wave bytes for sample rate of 11025
    //
    wavbytes = cycles_to_secs * 11025;

    //
    // invert the waveform and write to sound buffer
    //
    wb = ~wb;
    for (n=0; n < wavbytes; n++)   
    {
        if (bpos < SAMPLE_SIZE)
        {
          audio_buffer[bpos] = wb;
          bpos++;
        }
    }

    //
    // remember this frame for next cycle count
    //
    spkr_cycles = Regs.ICount;
}


byte readVZKbrd(int A)
{
    byte    k = 0xFF;

    if (!(A & 0x0001)) k &= vzkbrd[0];
    if (!(A & 0x0002)) k &= vzkbrd[1];
    if (!(A & 0x0004)) k &= vzkbrd[2];
    if (!(A & 0x0008)) k &= vzkbrd[3];
    if (!(A & 0x0010)) k &= vzkbrd[4];
    if (!(A & 0x0020)) k &= vzkbrd[5];
    if (!(A & 0x0040)) k &= vzkbrd[6];
    if (!(A & 0x0080)) k &= vzkbrd[7];

    return k;
}


byte RdZ80(word A)
{
    byte    b;

    b = RAM[A];
    if ((A > 0x67FF) && (A < 0x7000))               // reading keyboard
    {
	b = readVZKbrd(A);
        if (retrace)
        {
            b &= 0x7F;
            retrace = 0;
        }
    }
    return b;
}


void WrZ80(word A, byte v)
{
    int     y;

    //
    // trap writes to ROM or cartridge memory
    //
    if (A > 0x67FF) 
    {
       RAM[A] = v;
    }

    //
    // writing to screen memory
    //
    if ((A > 0x6FFF) && (A < 0x7800))
    {
       y = (A - 0x7000) / 32;      // get the scanline
       scanline[y] = 1;            // and flag to redraw
    }               

    //
    // writing to latch
    //
    if ((A > 0x67FF) && (A < 0x7000))
    {
	// changing screen or background color?
	if ((vz_latch ^ v) & 0x18 ) redraw_screen = 1;

	// speaker bits toggle? 
	if( (vz_latch ^ v ) & 0x41 )
           WrSpeaker();

	vz_latch = v;
    }
}


byte InZ80(word P)
{
    byte b = 0xFF;

    //
    // Disk reads
    //

    if ((P >= 0x10) && (P <= 0x1F)) 
    {
	b = vtech1_fdc_r(P - 0x10);
    }
	      
    return b;
}

void OutZ80(word P, byte B)
{
    static int current_page = 0;
    int i;
    long cpoffs, apoffs;

    //
    // Disk writes
    //

    if ((P >= 0x10) && (P <= 0x1F))
    {
       vtech1_fdc_w(P - 0x10, B);
    }

    //
    // Memory Bank switch
    //
    if ((P >= 0x70) && ( P <= 0x7F))
    {
        active_page = B;
        cpoffs = current_page * 16384;
        apoffs = active_page * 16384;
        for (i = 0; i < 16384; i++)
        {
           // copy current page to bank memory
           BKMEM[cpoffs+i] = VZMEM[0x8000 + i];

           // copy bank memory to selected page
           VZMEM[0x8000 + i] = BKMEM[apoffs + i];
        }

        current_page = active_page;
    }
}


void PatchZ80(Z80 *R)
{
}

word LoopZ80(Z80 *R)
{
    return R->PC.W;
}
