struct vzfile
{
    int         header;
    byte        filename[17];
    byte        type;
    byte        startaddr_l;
    byte        startaddr_h;
};

struct vzdir
{
    byte        ftype;
    char        fname[13];
};

struct vzdir vzd[1000];
word bp_addr = 65535;


void box(int x1, int y1, int x2, int y2, int C)
{
    int n;


    textcolor(C);
    for (n=x1;n<x2;n++)
    {
       gotoxy(n,y1); cprintf("%c",196);
       gotoxy(n,y2); cprintf("%c",196);
    }

    for (n=y1;n<y2;n++)
    {
       gotoxy(x1,n); cprintf("%c",179);
       gotoxy(x2,n); cprintf("%c",179);
    }

    gotoxy(x1,y1); cprintf("%c",218);
    gotoxy(x2,y1); cprintf("%c",191);
    gotoxy(x1,y2); cprintf("%c",192);
    gotoxy(x2,y2); cprintf("%c",217);
}



void Display_regs(Z80 *Regs)
{
	int	n;
	byte	b,F;

	box(66,3,80,23,LIGHTCYAN);
	gotoxy(67,4);
	textcolor(LIGHTCYAN);cprintf("Registers:");
	textcolor(LIGHTGREEN); gotoxy(67,6);  cprintf("AF  ");
	textcolor(WHITE); cprintf("%04X ",Regs->AF.W);
	textcolor(LIGHTGREEN); gotoxy(67,7);  cprintf("BC  ");
	textcolor(WHITE); cprintf("%04X ",Regs->BC.W);
	textcolor(LIGHTGREEN); gotoxy(67,8);  cprintf("DE  ");
	textcolor(WHITE); cprintf("%04X ",Regs->DE.W);
	textcolor(LIGHTGREEN); gotoxy(67,9); cprintf("HL  ");
	textcolor(WHITE); cprintf("%04X",Regs->HL.W);
	textcolor(LIGHTGREEN); gotoxy(67,10); cprintf("IX  ");
	textcolor(WHITE); cprintf("%04X ",Regs->IX.W);
	textcolor(LIGHTGREEN); gotoxy(67,11); cprintf("IY  ");
	textcolor(WHITE); cprintf("%04X ",Regs->IY.W);
	textcolor(LIGHTGREEN); gotoxy(67,12); cprintf("PC  ");
	textcolor(WHITE); cprintf("%04X",Regs->PC.W);
	textcolor(LIGHTGREEN); gotoxy(67,13); cprintf("SP  ");
	textcolor(WHITE); cprintf("%04X ",Regs->SP.W);
	gotoxy(67,15); textcolor(LIGHTCYAN); cprintf("Flags:");
	gotoxy(67,14);
	for (n=67;n<80;n++) cprintf("%c",196);
	gotoxy(67,17); textcolor(LIGHTGREEN); cprintf("S Z H P V N C");

	textcolor(WHITE);
	F = Regs->AF.B.l;
	gotoxy(67,18);
	if ((F & 0x80) == 0x80) cprintf("1 "); else cprintf("0 ");
	if ((F & 0x40) == 0x40) cprintf("1 "); else cprintf("0 ");
	if ((F & 0x10) == 0x10) cprintf("1 "); else cprintf("0 ");
	if ((F & 0x04) == 0x04) cprintf("1 "); else cprintf("0 ");
	if ((F & 0x04) == 0x04) cprintf("1 "); else cprintf("0 ");
	if ((F & 0x02) == 0x02) cprintf("1 "); else cprintf("0 ");
	if ((F & 0x01) == 0x01) cprintf("1"); else cprintf("0");
	gotoxy(67,19); textcolor(LIGHTCYAN);
	for (n=67;n<80;n++) cprintf("%c",196);
	gotoxy(67,20); cprintf("Stack: ");
	textcolor(LIGHTGREEN); cprintf("+00  ");
	textcolor(WHITE);
	gotoxy(67,22);
	for (n=0;n<4;n++)
	{
	   b = RAM[Regs->SP.W + n];
	   cprintf("%02X ",b);
	}

}

void Display_disassembly(word da)
{
	int	 n,i,I,J;
	unsigned bytes;
	word     Addr;
	char     ch,S[64];
	byte	 Buf[32];

	textcolor(LIGHTCYAN);
	gotoxy(29,15); cprintf("Disassembly: ");

	textcolor(YELLOW);
	gotoxy(28,17);cprintf("%c",16);
	Addr = da;
	for (n=0;n<7;n++)
	{
	    if (n > 0) textcolor(WHITE);
	    gotoxy(30,17+n);
            cprintf("                                 ");
	    gotoxy(30,17+n);
	    cprintf("%04X ",Addr);
	    for (i=0;i<32;i++) Buf[i] = RAM[Addr+i];
	    for (i=0;i<64;i++) S[i] = 32;
	    I=DAsm(S,Buf);
	    for(J=0;J<I;J++) cprintf(" %02X",RAM[Addr+J]);
	    gotoxy(48,17+n);
	    for (i=0;i<15;i++)
	    {
		ch = S[i];
		if (ch < 31) break;
		cprintf("%c",ch);
	    }
	    Addr += I;
	}
}

long gethex(int c)
{
      int   n,d,ch, *p;
      word  v;
      long  sum;
      char  hex[6];

      if (c == 4) d = 4096;
      if (c == 2) d = 16;

       hex[0] = c+1;
       p = cgets(&hex);
       if (hex[1] == 0) return(65535);
       sum = 0;
       for (n=0;n<hex[1];n++)
       {
	  ch = hex[2+n];
	  if ((ch > 47) && (ch < 58))  sum += ((ch-48) * d);  // 0-9
	  if ((ch > 64) && (ch < 71))  sum += ((ch-55) * d);  // A-F
	  if ((ch > 96) && (ch < 103)) sum += ((ch-87) * d);  // a-f
	  d = d / 16;
       }
       return(sum);
}

void build_dirlist(char *s)
{
	struct find_t ffblk;
	int	n,done;

	for (n=0;n<1000;n++) vzd[n].ftype = 0;	// reset directory list
	n=0;

	// build the file list, starting from index 1
	// first get the directories

	done = findfirst("*.",&ffblk,FA_DIREC);
	while (!done)
	{
	  n++;
	  strcpy(&vzd[n].fname,&ffblk.name);
	  vzd[n].ftype = 1;		// directory
	  done = findnext(&ffblk);
	}

	// now get the files

        done = findfirst(s,&ffblk,0);
	while (!done)
	{
		n++;
		strcpy(&vzd[n].fname,&ffblk.name);
		vzd[n].ftype = 2;
		done = findnext(&ffblk);
	}
}

int select_vzf(char *s)
{
	int	done;
	int	cs,ss;		//
	int	n,idx,ch;

	idx = 0;
	gotoxy(10,25); textcolor(YELLOW);
	cprintf("Use cursor keys to select file then press <ENTER>   ");

	// clear the text window

	for (n=0;n<7;n++)
	{
	    gotoxy(2,16+n); cprintf("                       ");
	}

	done=0;
	cs = 1;		// current selection, will be 0 - 7
	ss = 0;		// scroll selection
	while (!done)
	{
		// display the next 6 files

		textcolor(WHITE);textbackground(BLACK);
		for (n = 0; n < 7; n++)
		{
			gotoxy(2,16+n); cprintf("                       ");
			gotoxy(4,16+n);
			if (vzd[ss+n+1].ftype > 0)
                        {
                            vzd[ss+n+1].fname[12] = 0x00;
			    cprintf("%s\r\n",vzd[ss+n+1].fname);
                        }
			if (vzd[ss+n+1].ftype == 1)
			{
				gotoxy(20,16+n);
				cprintf("<DIR>");
			}
		}

		// display current selection

		gotoxy(4,16+cs);
		textcolor(BLACK); textbackground(WHITE);
		cprintf("%s\r\n",vzd[cs+ss+1].fname);
		gotoxy(2,16+cs);

		ch = getch();
		if (ch == 0) ch = getch();
		if (ch == 27) done = 1;
		if (ch == 72)	// up arrow
		{
		    cs--;
		    if (cs < 0)
		    {
			cs = 0;
			if (ss > 0) ss--;
		    }
		}
		if (ch == 80)  // down arrow
		{
		    cs++;
		    if (cs > 6)
		    {
			cs = 6;
			if (vzd[cs+ss+2].ftype > 0) ss++;
		    }
		}
		if (ch == 13)
		{
			if (vzd[cs+ss+1].ftype == 1)		// directory
			{
				chdir(vzd[cs+ss+1].fname);
                                build_dirlist(s);
				cs=1;
				ss=0;
			}
			if (vzd[cs+ss+1].ftype == 2)		// file
			{
				done = 1;
				idx = cs+ss+1;
			}
		}
	}
	return(idx);
}

void load_program(Z80 *R)
{
     FILE  	*vz;
     struct 	vzfile lfile;
     long	addr;
     byte	b;
     int	n,ch,selection;

     build_dirlist("*.vz");
     selection = select_vzf("*.vz");  // 0 - esc, 1 - file selected
     if (selection != 0)
     {
	textcolor(YELLOW);
	textbackground(BLACK);
	for (n=0;n<7;n++)
	{
	      gotoxy(2,16+n); cprintf("                       ");
	}
	gotoxy(2,17); cprintf("Opening....");
	if ((vz = fopen(vzd[selection].fname, "rb")) == NULL)
	   {
	     cprintf("error! -  could not find file");
	   }
	else
	   {
	     cprintf("OK!\r\n");
	     fread(&lfile,1,24,vz);
	     addr = lfile.startaddr_l + 256 * lfile.startaddr_h;

	     gotoxy(2,19); cprintf("Filename...%s\r\n",lfile. filename);
	     gotoxy(2,20); cprintf("filetype...%2X\r\n",lfile.type);
	     gotoxy(2,21); cprintf("StartAddr..%4X\r\n",addr);

	     //
	     // Set start of program pointer to file start address
	     //

	     if (lfile.type == 0xF0)
	     {
		RAM[0x78A4] = lfile.startaddr_l;
		RAM[0x78A5] = lfile.startaddr_h;
	     }

	     if (lfile.type == 0xF1)
	     {
		RAM[0x788E] = lfile.startaddr_l;
		RAM[0x788F] = lfile.startaddr_h;
		R -> PC.W = addr;
	     }

	     //
	     // Read the rest of the file
	     //

	     fread(&b,1,1,vz);
	     while (!feof(vz))
	     {
		RAM[addr] = b;
		addr++;
		fread(&b,1,1,vz);
	     }
	     fclose(vz);

	     //
	     // Set end of program pointer to addr
	     //
	     if (lfile.type == 0xF0)
	     {
		RAM[0x78F9] = (addr & 0x00FF);
		RAM[0x78FA] = ((addr & 0xFF00) >> 8);
                RAM[0x78FB] = (addr & 0x00FF);
                RAM[0x78FC] = ((addr & 0xFF00) >> 8);
                RAM[0x78FD] = (addr & 0x00FF);
                RAM[0x78FE] = ((addr & 0xFF00) >> 8);

	     }
	   }
     }
}

void map_disk()
{
     FILE  	*vz;
     byte	b;
     int	n,ch,selection;

     build_dirlist("*.dsk");
     selection = select_vzf("*.dsk");  // 0 - esc, 1 - file selected
     if (selection != 0)
     {
	textcolor(YELLOW);
	textbackground(BLACK);
	for (n=0;n<7;n++)
	{
	      gotoxy(2,16+n); cprintf("                       ");
	}
	gotoxy(2,17); cprintf("Opening....");
        vtech1_floppy_init(0,vzd[selection].fname);
        cprintf("OK!\r\n");
     }
}



void save_program()
{
	struct vzfile lfile;
	byte	lb,hb;
	long	start_addr,end_addr;
	char	b,filename[80],*fptr;
	int	n;
	FILE	*vz;

	for (n=0;n<6;n++)
	{
	    gotoxy(2,17+n); cprintf("                       ");
	}

	lfile.header = 0x2020;
	textcolor(YELLOW);
	gotoxy(2,17);
	_setcursortype(_SOLIDCURSOR);
	cprintf("BASIC or M/C ? (B-M) : ");
	n = getche();
	if ((n == 'B') || (n == 'b'))
	{
	    lfile.startaddr_l = RAM[0x78A4];
	    lfile.startaddr_h = RAM[0x78A5];
	    lfile.type = 0xF0;
	    lb = RAM[0x78F9];
	    hb = RAM[0x78FA];
	    start_addr = lfile.startaddr_l + 256 * lfile.startaddr_h;
	    end_addr   = lb + 256 * hb;
	    gotoxy(2,18); cprintf("Start of program : %4X\r\n",start_addr);
	    gotoxy(2,19); cprintf("End of program   : %4X\r\n",end_addr);
	}
	else
	{
	    lfile.type = 0xF1;
	    gotoxy(2,18); cprintf("Enter start addr: ");
	    start_addr = gethex(4);
	    gotoxy(2,19); cprintf("Enter end addr  : ");
	    end_addr = gethex(4);
	    hb = start_addr / 256;
	    lb = start_addr - 256*hb;
	    lfile.startaddr_h = hb;
	    lfile.startaddr_l = lb;
	}

	gotoxy(2,20); cprintf("Enter PC filename: ");

	// save filename

	filename[0] = 70;
	gotoxy(2,21); fptr = cgets(filename);

	for (n=0;n<17;n++) lfile.filename[n] = 0x00;
	for (n=0;n<filename[1];n++)
	{
		b = filename[2+n];
		lfile.filename[n] = b;
	}

	// create file

	gotoxy(2,22);
	if ((vz = fopen(fptr, "wb")) == NULL)
	{
	    cprintf("Error! - could not create file");
	}
	else
	{
		fwrite(&lfile,1,24,vz);
		while (start_addr <= end_addr)
		{
		    b = RAM[start_addr];
		    fwrite(&b, 1, 1, vz);
		    start_addr++;
		}
		fclose(vz);
		cprintf("OK!");
	}

}

void Display_instructions()
{
      int   n;

      box(1,3,27,23,LIGHTCYAN);
      textcolor(LIGHTCYAN); gotoxy(2,4); cprintf("Instructions:");
      textcolor(LIGHTGREEN);
      gotoxy(2,6);  cprintf("<1> "); cprintf("Load Program");
      gotoxy(2,7);  cprintf("<2> "); cprintf("Save Program");
      gotoxy(2,8);  cprintf("<3> "); cprintf("Map Disk Image");
      gotoxy(2,9);  cprintf("<4> "); cprintf("Disassemble");
      gotoxy(2,10); cprintf("<5> "); cprintf("Edit Memory");
      gotoxy(2,11); cprintf("<6> "); cprintf("Single Step");
      textcolor(LIGHTCYAN);gotoxy(2,15);
      for (n=1;n<26;n++) cprintf("%c",196);
      textcolor(YELLOW);gotoxy(22,8);
      if (bp_addr == 65535)
		cprintf("    ");
      else
		cprintf("%04X",bp_addr);


}

void Display_pointers()
{
	textcolor(LIGHTCYAN); gotoxy(2,16); cprintf("System Pointers:");
	textcolor(LIGHTGREEN);
	gotoxy(2,18); cprintf("Top of Memory : ");
	gotoxy(2,19); cprintf("Start of Basic: ");
	gotoxy(2,20); cprintf("End of Basic  : ");
	gotoxy(2,21); cprintf("USR Address   : ");
	gotoxy(2,22); cprintf("Interrupt Exit: ");
	textcolor(WHITE);
	gotoxy(18,18); cprintf(" %04X",RAM[0x78B1]+256*RAM[0x78B2]);
	gotoxy(18,19); cprintf(" %04X",RAM[0x78A4]+256*RAM[0x78A5]);
	gotoxy(18,20); cprintf(" %04X",RAM[0x78F9]+256*RAM[0x78FA]);
	gotoxy(18,21); cprintf(" %04X",RAM[0x788E]+256*RAM[0x788F]);
	gotoxy(18,22); cprintf(" %04X",RAM[0x787E]+256*RAM[0x787F]);
}

void Display_memory(word addr)
{
      word r,c,a;
      byte b;

      textcolor(LIGHTCYAN);
      gotoxy(30,4); cprintf("Memory dump: ");
      textcolor(WHITE);
      for (r=0;r<8;r++)
      {
	  gotoxy(30,6+r);
	  a = addr + r*8;
	  cprintf("%04X  ",a);
	  for (c=0;c<8;c++)
	  {
	      b = RAM[a+c];
	      cprintf("%02X ",b);
	  }
      }
}

void set_breakpoint()
{
	gotoxy(12,25); textcolor(YELLOW);
	//_setcursortype(_SOLIDCURSOR);
	cprintf("                                                 ");
	gotoxy(12,25);
	cprintf("Type breakpoint address in hex or ENTER to clear: ");
	bp_addr = gethex(4);
	Display_instructions();
}

void edit_memory()
{
	word	st_addr, cu_addr,w;
	byte	b;
	int	done;

	done = 0;
	gotoxy(12,25); textcolor(YELLOW);
	_setcursortype(_SOLIDCURSOR);
	cprintf("                                                 ");
	gotoxy(12,25);
	cprintf("Type memory start address in hex: ");
	st_addr = gethex(4);
	Display_memory(st_addr);
	cu_addr = st_addr;
	while (!done)
	{
		gotoxy(12,25); textcolor(YELLOW);
		cprintf("Enter byte or <ENTER> to finish    ");
		textcolor(LIGHTGREEN);
		cprintf("%04X  ",cu_addr);
		w = gethex(2);
		if (w == 65535)
			done = 1;
		else
		{
			b = w;
			RAM[cu_addr] = b;
			cu_addr++;
			Display_memory(st_addr);
		}
	}
}


void disassemble()
{
	word	addr;
	int	ch, n, done, I;
	char	S[64];
	byte	Buf[32];

	gotoxy(12,25); textcolor(YELLOW);
	//_setcursortype(_SOLIDCURSOR);
	cprintf("                                                 ");
	gotoxy(12,25);
	cprintf("Type disassembly start address in hex: ");
	addr = gethex(4);
	Display_disassembly(addr);
	gotoxy(12,25); textcolor(YELLOW);
	cprintf("      Use down arrow to scroll or <esc> to exit  ");
	//_setcursortype(_NOCURSOR);
	done = 0;
	while (!done)
	{
		Display_disassembly(addr);
		for (n=0;n<32;n++) Buf[n] = RAM[addr+n];
		I=DAsm(S,Buf);
		ch = getch();
		if (ch == 0) ch = getch();
		if (ch == 27) done = 1;
		if (ch == 80) addr+=I;   // down arrow
	}

}


void debugger(Z80 *R)
{
	int	n;
	byte	b;


	remove_keyboard();
	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	textcolor(LIGHTGREEN);gotoxy(3,2);
	gotoxy(1,1);
        cprintf("** VZEM ** VZ200/300 Emulator version 2.0");
	gotoxy(1,2);
	for (n=1;n<=80;n++) cprintf("%c",196);

	gotoxy(67,1); textcolor(YELLOW);
        //if (extended) cprintf ("VZ+ enabled"); else cprintf ("VZ+ disabled");
	gotoxy(1,24); textcolor(GREEN);
	for (n=1;n<=80;n++) cprintf("%c",196);

	Display_regs(R);
	Display_disassembly(R->PC.W);
	Display_memory(R->SP.W);
	Display_instructions();
	Display_pointers();
	gotoxy(12,25);
	textcolor(YELLOW);
	textbackground(BLACK);
	//_setcursortype(_NOCURSOR);
	cprintf("Enter selection, or <ENTER> to return to emulator   ");

	n = getch();
	while (n != 13)
	{
	    if (n == '1') load_program(R);
	    if (n == '2') save_program();
            if (n == '3') map_disk();
	    if (n == '4') disassemble();
	    if (n == '5') edit_memory();
	    if (n == '6')
	    {
		ExecZ80(R);
		Display_regs(R);
		Display_disassembly(R->PC.W);
	    }
	    if (n == '7')
	    {
		gotoxy(67,1); textcolor(YELLOW);
		cprintf ("VZ+ enabled ");
                //extended = 1;
	    }

	    textcolor(YELLOW); textbackground(BLACK);
	    gotoxy(1,25); for (n=0;n<79;n++) cprintf(" ");
	    gotoxy(12,25);
	    //_setcursortype(_NOCURSOR);
	    cprintf("Enter selection, or <ENTER> to return to emulator");
	    n = getch();
	}
	debug = 0;
	install_keyboard();
        set_gfx_mode(GFX_MODEX, 320, 240, 320, 480);
        redraw_screen = 1;
        InstallGfx();
}
