#include	<windows.h>
#include	<windowsx.h>
#include	<shlobj.h>
#include	"resource.h"
#include	"about.h"

static	HFONT		hFontLink;
static	FARPROC		oldLinkProc = NULL;
static	HCURSOR		hCurHand;

		BYTE		licenced[LICENCED_POS + LICENCED_LENG + 1]
													= "Licenced to ";

LRESULT CALLBACK linkProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp);


void AboutDialogInit(HINSTANCE hInst) {

	hCurHand = LoadCursor(hInst, MAKEINTRESOURCE(IDC_HAND));
}


// AboutDialog : _CAO vV[W

LRESULT CALLBACK linkProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp) {

	PAINTSTRUCT	ps;
	HDC			hdc;
	char		szTextTmp[100];

	switch(msg) {
		case WM_SETCURSOR:
			SetCursor(hCurHand);
			return(0);

		case WM_PAINT:
			GetWindowText(hWnd, szTextTmp, 100);
			hdc=BeginPaint(hWnd, &ps);
			SelectObject(hdc, hFontLink);
			SetTextColor(hdc, RGB(0, 0, 255));	//
			SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));
			SetBkMode(hdc, OPAQUE);
			TextOut(hdc, 0, 0, szTextTmp, lstrlen(szTextTmp));
			EndPaint(hWnd, &ps);
			return(0);
	}
	return(CallWindowProc(oldLinkProc, hWnd, msg, wp, lp));
}

LRESULT CALLBACK AboutDialogProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp) {

	LOGFONT logfont;

	switch (msg) {
		case WM_INITDIALOG:
			hFontLink = (HFONT)SendMessage(GetDlgItem(hWnd, IDC_WWW),
											WM_GETFONT, 0, 0);
			GetObject(hFontLink, sizeof(logfont), &logfont);
			logfont.lfUnderline = TRUE;
			hFontLink = CreateFontIndirect(&logfont);
			SendDlgItemMessage(hWnd, IDC_WWW, WM_SETFONT,
										(WPARAM)hFontLink, 0);
			oldLinkProc = (FARPROC)GetWindowLong(GetDlgItem(hWnd, IDC_WWW),
															GWL_WNDPROC);
			SetWindowLong(GetDlgItem(hWnd, IDC_WWW), GWL_WNDPROC,
									(LONG)linkProc);
			if (licenced[LICENCED_POS]) {
				SetDlgItemText(hWnd, IDC_LICENCE, (char *)licenced);
			}
			return(FALSE);
		case WM_COMMAND:
			switch (LOWORD(wp)) {
				case IDOK:
					EndDialog(hWnd, IDOK);
					break;
				case IDC_WWW:
					if (HIWORD(wp) == STN_CLICKED) {
						char szTextTmp[100];
						GetDlgItemText(hWnd, LOWORD(wp), szTextTmp, 100);
						ShellExecute(hWnd, NULL, szTextTmp, NULL, NULL,
															SW_SHOWNORMAL);
					}
					return(FALSE);
				default:
					return(FALSE);
			}
		case WM_CLOSE:
			PostMessage(hWnd, WM_COMMAND, IDOK, 0);
			break;
		default:
			return(FALSE);
	}
	return(TRUE);
}

