#include	<windows.h>
#include	"common.h"
#include	"xmil.h"
#include	"draw_sub.h"


// --------------------------------------------------- 16C ANK LN^

										// esi = font face pointer
										// edi = vrampos
										// edx = text color | reverse flag
										// ecx = loop count (text height)

static LABEL void txt16_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_right4half(void) {			// ׂEShbg

	__asm {
				mov		dh, dl
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_right4x2(void) {			// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_halfx2(void) {				// ׂďc{p

	__asm {
				mov		dh, dl

				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_halfx4left(void) {			// ׂĂS{p

	__asm {
				shl		dl, 2
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shl		dl, 2
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------- 16C PCG LN^

										// esi = font face pointer
										// edi = vrampos
										// edx = text color | reverse flag
										// ecx = loop count (text height)

static LABEL void pcg16_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				or		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_right4half(void) {			// ׂEShbg

	__asm {
				mov		dh, dl
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_right4x2(void) {			// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				inc		bl
				and		bl, 15
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_halfx2(void) {				// ׂďc{p

	__asm {
				mov		dh, dl

				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_halfx4left(void) {			// ׂĂS{p

	__asm {
				shl		dl, 2
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	shr		dh, 4
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg16_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shl		dl, 2
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	and		dh, 15
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------- 16C LN^

										// esi = font face pointer
										// edi = vrampos
										// edx = text color | reverse flag
										// ecx = loop count (text height)
										// ebx = 0

static LABEL void knj16_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		cl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*1
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_right4half(void) {			// ׂEShbg

	__asm {
				mov		dh, dl

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_right4x2(void) {			// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		eax, eax
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 4
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_halfx2(void) {				// ׂďc{p

	__asm {
				mov		dh, dl

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_halfx4left(void) {			// ׂĂS{p

	__asm {
				shl		dl, 2

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shl		dl, 2

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------------------------------

extern	void draw_nop(void);

// --------------------------------------------------------------------------


void (*txt16effects[])(void) = {
						txt16_nor,					// m[}
						txt16_halfx2,				// ׂďc{p
						txt16_right4dot,			// EShbg
						txt16_right4half,			// ׂEShbg

						txt16_Yx2,					// c{p
						draw_nop,
						txt16_right4x2,				// EShbgc{p
						draw_nop,

						txt16_x2left,				// {p
						txt16_halfx4left,			// ׂĂS{p
						txt16_x2right,				// {pE
						txt16_halfx4right,			// ׂĂS{pE

						txt16_x4left,				// S{p
						draw_nop,
						txt16_x4right,				// S{pE
						draw_nop
};


void (*pcg16effects[])(void) = {
						pcg16_nor,					// m[}
						pcg16_halfx2,				// ׂďc{p
						pcg16_right4dot,			// EShbg
						pcg16_right4half,			// ׂEShbg

						pcg16_Yx2,					// c{p
						draw_nop,
						pcg16_right4x2,				// EShbgc{p
						draw_nop,

						pcg16_x2left,				// {p
						pcg16_halfx4left,			// ׂĂS{p
						pcg16_x2right,				// {pE
						pcg16_halfx4right,			// ׂĂS{pE

						pcg16_x4left,				// S{p
						draw_nop,
						pcg16_x4right,				// S{pE
						draw_nop
};


void (*knj16effects[])(void) = {
						knj16_nor,					// m[}
						knj16_halfx2,				// ׂďc{p
						knj16_right4dot,			// EShbg
						knj16_right4half,			// ׂEShbg

						knj16_Yx2,					// c{p
						draw_nop,
						knj16_right4x2,				// EShbgc{p
						draw_nop,

						knj16_x2left,				// {p
						knj16_halfx4left,			// ׂĂS{p
						knj16_x2right,				// {pE
						knj16_halfx4right,			// ׂĂS{pE

						knj16_x4left,				// S{p
						draw_nop,
						knj16_x4right,				// S{pE
						draw_nop
};
