#include	<windows.h>
#include	"common.h"
#include	"xmil.h"
#include	"draw_sub.h"


// --------------------------------------------------- 16C ANK LN^

										// ds:esi = font face pointer
										// es:edi = dest
										//    ecx = loop count (text height)

static LABEL void txt16_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		ax, [esi + ebx]
				mov		[edi+64], ah
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				movzx	eax, byte ptr [esi + ebx + 1]
				mov		al, byte ptr x2left[eax]
				mov		[edi+63], al
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				movzx	eax, byte ptr [esi + ebx + 1]
				mov		al, byte ptr x2right[eax]
				mov		[edi+63], al
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	mov		al, [esi + ebx]
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		ax, [esi + ebx]
				shl		al, 4
				shl		ah, 4
				mov		[edi+64], ah
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_right4half(void) {			// ׂEShbg

	__asm {
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	shl		al, 4
				mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_right4x2(void) {			// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				mov		[edi+64], al
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_halfx2(void) {				// ׂďc{p

	__asm {
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_halfx4left(void) {			// ׂĂS{p

	__asm {
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		al, byte ptr x2left[eax]
				mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


static LABEL void txt16_halfx4right(void) {			// ׂĂS{pE

	__asm {
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 2
				and		bl, 15
makefaceout:	mov		al, byte ptr x2right[eax]
				mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


// -------------------------------------------------- 8C PCG LN^x2

										// ds:esi = font face pointer
										// es:edi = dest
										//    ecx = loop count (text height)

static LABEL void pcg8x2_nor(void) {				// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_x2right(void) {			// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_Yx2(void) {				// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	mov		al, [esi + ebx]
				mov		ah, al
				mov		[edi+64], ax
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				mov		ah, al
				mov		[edi+64], ax
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_x4right(void) {			// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				mov		ah, al
				mov		[edi+64], ax
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				mov		[edi+64], al
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_right4half(void) {			// ׂEShbg

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	shl		al, 4
				mov		ah, al
				mov		[edi+64], ax
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_right4x2(void) {			// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				mov		ah, al
				mov		[edi+64], ax
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_halfx2(void) {				// ׂďc{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		ah, al
				mov		[edi+64], ax
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_halfx4left(void) {			// ׂĂS{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		al, byte ptr x2left[eax]
				mov		ah, al
				mov		[edi+64], ax
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8x2_halfx4right(void) {		// ׂĂS{pE

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		al, byte ptr x2right[eax]
				mov		ah, al
				mov		[edi+64], ax
				stosw
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------- 16C LN^

										// ds:esi = font face pointer
										// es:edi = vrampos
										//    ecx = loop count (text height)

static LABEL void knj16_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				stosb
				mov		al, [esi + ebx + 2]
				mov		[edi+63], al
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				movzx	eax, [esi + ebx + 2]
				mov		al, byte ptr x2left[eax]
				mov		[edi+63], al
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				movzx	eax, byte ptr [esi + ebx + 2]
				mov		al, byte ptr x2right[eax]
				mov		[edi+63], al
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_Yx2(void) {				// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	mov		al, [esi + ebx]
				mov		[edi+64], al
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x4left(void) {			// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				mov		[edi+64], al
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				mov		[edi+64], al
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				stosb
				mov		al, [esi + ebx + 2]
				shl		al, 4
				mov		[edi+63], al
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_right4half(void) {			// ׂEShbg

	__asm {
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	shl		al, 4
				mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_right4x2(void) {			// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				mov		[edi+64], al
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_halfx2(void) {				// ׂďc{p

	__asm {
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_halfx4left(void) {			// ׂĂS{p

	__asm {
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	mov		al, byte ptr x2left[eax]
				mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


static LABEL void knj16_halfx4right(void) {			// ׂĂS{pE

	__asm {
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 4
				and		bl, 31
makefaceout:	mov		al, byte ptr x2right[eax]
				mov		[edi+64], al
				stosb
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------------------------------

extern	void draw_nop(void);

// --------------------------------------------------------------------------

void (*txtbeffects16[])(void) = {
						txt16_nor,					// m[}
						txt16_halfx2,				// ׂďc{p
						txt16_right4dot,			// EShbg
						txt16_right4half,			// ׂEShbg

						txt16_Yx2,					// c{p
						draw_nop,					// 肦Ȃ
						txt16_right4x2,				// EShbgc{p
						draw_nop,					// 肦Ȃ

						txt16_x2left,				// {p
						txt16_halfx4left,			// ׂĂS{p
						txt16_x2right,				// {pE
						txt16_halfx4right,			// ׂĂS{pE

						txt16_x4left,				// S{p
						draw_nop,					// 肦Ȃ
						txt16_x4right,				// S{pE
						draw_nop					// 肦Ȃ
};

void (*knjbeffects16[])(void) = {
						knj16_nor,					// m[}
						knj16_halfx2,				// ׂďc{p
						knj16_right4dot,			// EShbg
						knj16_right4half,			// ׂEShbg

						knj16_Yx2,					// c{p
						draw_nop,					// 
						knj16_right4x2,				// EShbgc{p
						draw_nop,					//

						knj16_x2left,				// {p
						knj16_halfx4left,			// ׂĂS{p
						knj16_x2right,				// {pE
						knj16_halfx4right,			// ׂĂS{pE

						knj16_x4left,				// S{p
						draw_nop,					//
						knj16_x4right,				// S{pE
						draw_nop					//
};

void (*pcgbeffectsx2[])(void) = {
						pcg8x2_nor,					// m[}
						pcg8x2_halfx2,				// ׂďc{p
						pcg8x2_right4dot,			// EShbg
						pcg8x2_right4half,			// ׂEShbg

						pcg8x2_Yx2,					// c{p
						draw_nop,					// 肦Ȃ
						pcg8x2_right4x2,			// EShbgc{p
						draw_nop,					// 肦Ȃ

						pcg8x2_x2left,				// {p
						pcg8x2_halfx4left,			// ׂĂS{p
						pcg8x2_x2right,				// {pE
						pcg8x2_halfx4right,			// ׂĂS{pE

						pcg8x2_x4left,				// S{p
						draw_nop,					// 肦Ȃ
						pcg8x2_x4right,				// S{pE
						draw_nop					// 肦Ȃ
};
