#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<math.h>
#include	"dsounds.h"
#include	"opm.h"
#include	"opmcore.h"

#ifndef PI
#define PI 3.14159265357989
#endif

#define	OPM_ARRATE		 399128L
#define	OPM_DRRATE		5514396L

#define	SC(db)			(long)(db*(((double)3.0/EG_STEP)*(1L<<ENV_BITS))) + \
						EC_DECAY
#define	KF(seminote)	(seminote << KF_BITS)
#define	D2(value)		(WORD)(((double)(6 << KF_BITS)*log((double)value) / \
									log(2.0))+0.5)
#define	FREQBASE4096	((double)OPM_CLOCK / ds_rate / 64)
#define	FREQ_RATE		(1L << (21-FREQ_BITS))


		long	detunetable[8][32];
		long	attacktable[94];
		long	decaytable[94];
		long	keycodetable[8*12*64+610];
		WORD	env_curve[EVC_ENT*2 + 1];
		WORD	detune2table[4];
		long	envtable[EVC_ENT];
		short	sintable[SIN_ENT];

		WORD 	halftunetable[] = {
					KF( 0),KF( 1),KF( 2),KF( 3),KF( 3),KF( 4),KF( 5),KF( 6),
					KF( 6),KF( 7),KF( 8),KF( 9),KF( 9),KF(10),KF(11),KF(12)};

		long	decayleveltable[16] = {
		 			SC( 0),SC( 1),SC( 2),SC( 3),SC( 4),SC( 5),SC( 6),SC( 7),
		 			SC( 8),SC( 9),SC(10),SC(11),SC(12),SC(13),SC(14),SC(31)};
		BYTE	multipletable[] = {
				    	 1,  2,  4,  6,  8, 10, 12, 14,
				    	16, 18, 20, 22, 24, 26, 28, 30};
		long	nulltable[] = {
						0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
						0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static	BYTE	OPM_DTTABLE[] = {
					0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
					2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 8, 8,
					1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5,
					5, 6, 6, 7, 8, 8, 9,10,11,12,13,14,16,16,16,16,
					2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7,
					8, 8, 9,10,11,12,13,14,16,17,19,20,22,22,22,22};

		WORD	psgvol[16];

		WORD	psg_puchidec;
		WORD	psg_puchinoisecnt;

extern	DWORD	psgbase;


void INX1F_inittable(void) {

	int		i, j;
	double	pom, rate;

	for (i=0; i<EVC_ENT; i++) {
		pom = (double)(1 << ENVTBL_BIT) / pow(10, EG_STEP*(EVC_ENT-i)/20);
		envtable[i] = (long)pom;
	}
	for (i=0; i<SIN_ENT; i++) {
		pom = (double)(3 << (SINTBL_BIT - 2)) * sin(2*PI*i/SIN_ENT);
		sintable[i] = (short)pom;
	}
	for (i=0; i<EVC_ENT; i++) {
		pom = pow(((double)(EVC_ENT-1-i)/EVC_ENT), 8) * EVC_ENT;
		env_curve[i] = (WORD)pom;
		env_curve[EVC_ENT + i] = i;
	}
	env_curve[EVC_ENT*2] = EVC_ENT;

	rate = (double)(1L << FREQ_BITS) / (3579545.0 / OPM_CLOCK * ds_rate);
	for (i=0; i<8*12*64+D2(3.0); i++) {
		pom = 6.875 * pow(2, ((i+4*64)*1.5625/1200.0));
		keycodetable[i] = (long)(pom * rate);
	}
	for (i=0; i<4; i++) {
		for (j=0; j<32; j++) {
			rate = FREQBASE4096 * OPM_DTTABLE[i*32 + j] / FREQ_RATE;
			detunetable[i][j]   = (long)rate;
			detunetable[i+4][j] = (long)-rate;
		}
	}
	for (i=0; i<4; i++) {
		attacktable[i] = decaytable[i] = 0;
	}
	for (i=4; i<64; i++) {
		rate = (double)(EVC_ENT << ENV_BITS) * FREQBASE4096;
		if (i<60) {
			rate *= 1.0+(i&3)*0.25;		// 4JEg 1/2
		}
		rate *= 1L << ((i>>2) - 1);
		attacktable[i] = (long)(rate / OPM_ARRATE);
		decaytable[i] = (long)(rate / OPM_DRRATE);
	}
	attacktable[62] = EC_DECAY - 1;
	attacktable[63] = EC_DECAY - 1;
	for (i=64; i<94; i++) {
		attacktable[i] = attacktable[63];
		decaytable[i] = decaytable[63];
	}

	detune2table[0] = D2(1.0);
	detune2table[1] = D2(2.0);
	detune2table[2] = D2(2.5);
	detune2table[3] = D2(3.0);

	psgbase = (25000L << (16-2)) / (ds_rate / 5);
	pom = 0x1000L << (OPM_OUTSB+1-3);
	for (i=15; i; i--) {
		psgvol[i] = (WORD)pom;
		pom /= 1.41492;
	}
	psgvol[0] = 0;

	psg_puchidec = ds_rate / 8000;
	if (!psg_puchidec) {
		psg_puchidec = 1;
	}
	psg_puchinoisecnt = 55500 / ds_rate;
}
