#include	<windows.h>
#include	<stdio.h>
#include	<string.h>

#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_fdc.h"
#include	"x1_scpu.h"
#include	"dosio.h"
#include	"trace.h"
#include	"ddraws.h"

//	ԓfo@

extern	Z80_Regs	R;

extern	BYTE		KEY_TBL[];
extern	BYTE		updatetmp[];

#define	FUNCKEY1	0
#define	FUNCKEY2	1
#define	FUNCKEY3	1
#define	FUNCKEY4	1
#define	FUNCKEY5	(!trace_sw)

void debug_status(void) {

static	int		filenum = 0;
		FILEH	fh;
		char	work[512];

	sprintf(work, "z80reg.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		sprintf(work,	"PC = %04x\n"	\
						"AF = %04x\n"	\
						"BC = %04x\n"	\
						"DE = %04x\n"	\
						"HL = %04x\n"	\
						"IX = %04x\n"	\
						"IY = %04x\n"	\
						"SP = %04x\n"	\
						"AF'= %04x\n"	\
						"BC'= %04x\n"	\
						"DE'= %04x\n"	\
						"HL'= %04x\n"	\
						"\n"			\
						"IM = %2d\n"	\
						"ADRS = %02x%02x\n\n"	\
						"CRT_YL = %3d\n"		\
						"CRT_VS = %3d\n"		\
						"\n"					\
						"FNT_YL = %3d\n"		\
						"TXT_YL = %3d\n"		\
						"SCRN_b =  %02x\n",
						R.PC.W, R.AF.W, R.BC.W, R.DE.W,
						R.HL.W, R.IX.W, R.IY.W, R.SP.W,
						R.AF2.W, R.BC2.W, R.DE2.W, R.HL2.W,
						R.IM, R.I, scpu.Ex[4][0],
						crtc.CRT_YL, crtc.CRT_VS,
						crtc.FNT_YL, crtc.TXT_YL, crtc.SCRN_BITS);


		file_write(fh, work, strlen(work));
		file_close(fh);
	}

	sprintf(work, "z80ram.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_lwrite(fh, mMAIN, 0x10000);
		file_close(fh);
	}
#if 0
	sprintf(work, "extram0.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_write(fh, mBANK[0], 0x8000);
		file_close(fh);
	}
	sprintf(work, "extram1.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_write(fh, mBANK[1], 0x8000);
		file_close(fh);
	}
#endif
	sprintf(work, "x1vram1.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_write(fh, &GRP_RAM[GRAM_BANK0 + 0x0000], 0x8000);
		file_write(fh, &GRP_RAM[GRAM_BANK0 + 0x8000], 0x8000);
		file_close(fh);
	}
	sprintf(work, "x1vram2.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_write(fh, &GRP_RAM[GRAM_BANK1 + 0x0000], 0x8000);
		file_write(fh, &GRP_RAM[GRAM_BANK1 + 0x8000], 0x8000);
		file_close(fh);
	}
	sprintf(work, "x1tram.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_write(fh, TXT_RAM, 0x1800);
		file_close(fh);
	}
#if 0
	sprintf(work, "upt.%03d", filenum);
	if ((fh = file_create_c(work)) != (FILEH)-1) {
		file_write(fh, updatetmp, 0x800);
		file_close(fh);
	}
	{
		extern	BYTE	screenmap[];
		int		i;
		sprintf(work, "fupt.%03d", filenum);
		if ((fh = file_create_c(work)) != (FILEH)-1) {
			for (i=0; i<400; i++) {
				file_write(fh, &screenmap[i*640], 640);
			}
			file_close(fh);
		}
	}
	{
		extern	PALETTE_TABLE	GRPHPAL4096[4096+8];
		sprintf(work, "pal4096.%03d", filenum);
		if ((fh = file_create_c(work)) != (FILEH)-1) {
			file_write(fh, GRPHPAL4096, (4096+8)*4);
			file_close(fh);
		}
	}
#endif
	filenum++;
}



#ifdef TRACE

static	FILEH		dfh = (FILEH)-1;
extern	FDC_REGS	FDC;
		BYTE		trace_sw = 0;

void tracelog_start(void) {

	dfh = file_create_c("tracelog.txt");
}

void tracelog_end(void) {

	if (dfh != (FILEH)-1) {
		file_close(dfh);
	}
}

void pcwatchforce(void) {

	char	work[64];

	if (dfh != (FILEH)-1) {
		sprintf(work, "force:%04x-\r\n", R.PC.W);
		file_write(dfh, work, 13);
	}
}

void fdc_trace(void) {

	char	work[64];

	if (FUNCKEY3) {
		return;
	}
	if (dfh != (FILEH)-1) {
		sprintf(work, "read %d-%d:%2x:%2x:%3x [%02x]\n",
						FDC.drv, FDC.h, FDC.c, FDC.r, FDC.off, FDC.data);
		file_write(dfh, work, strlen(work));
	}
}


void dma_trace(WORD a, WORD b, BYTE c) {

	char	work[64];

	if (FUNCKEY4) {
		return;
	}
	sprintf(work, "d:%04x  s:%04x  val=%02x\n", a, b, c);
	file_write(dfh, work, strlen(work));
}



void trkwrt(WORD pnt, BYTE dat) {

	char	work[64];

	if (dfh != (FILEH)-1) {
		sprintf(work, "[%04x] = $%02x\n", pnt, dat);
		file_write(dfh, work, strlen(work));
	}
}


void pcwatch(void) {

	char	work[64];

	if (FUNCKEY2) {
		return;
	}
#if 0
	if (RAM0r != mBANK[1]) {
		return;
	}
#endif
#if 0
	if (x1flg.ROM_SW) {
		return;
	}
#endif
	if (dfh != (FILEH)-1) {
		sprintf(work, "%04x:\r\n", R.PC.W);
		file_write(dfh, work, 7);
	}
}



void trace_inport(WORD a) {

	char	work[64];

	if (FUNCKEY5) {
		return;
	}
	if (dfh != (FILEH)-1) {
		sprintf(work, "in  %04x [%04x]\r\n", a, R.PC.W);
		file_write(dfh, work, strlen(work));
	}
}

void trace_inport_a(WORD a, BYTE b) {

	char	work[64];

	if (FUNCKEY2) {
		return;
	}
	if (dfh != (FILEH)-1) {
		sprintf(work, "in  %04x (=%02x)  [%04x]\r\n", a, b, R.PC.W);
		file_write(dfh, work, strlen(work));
	}
}

void trace_outport(WORD a, BYTE b) {

	char	work[64];

	if (FUNCKEY5) {
		return;
	}
	if (dfh != (FILEH)-1) {
//                     123456789  01 2 3
		sprintf(work, "out %04x,%02x - %04x\r\n", a, b, R.PC.W);
		file_write(dfh, work, strlen(work));
	}
}



void outstrbyte(char *str, WORD val) {

	char	work[64];

	if (FUNCKEY5) {
		return;
	}
	if (dfh != (FILEH)-1) {
		sprintf(work, "%s %x\r\n", str, val);
		file_write(dfh, work, strlen(work));
	}
}

void outstrbytel(char *str, DWORD val) {

	char	work[64];

	if (FUNCKEY3) {
		return;
	}
	if (dfh != (FILEH)-1) {
		sprintf(work, "%s %ld\r\n", str, val);
		file_write(dfh, work, strlen(work));
	}
}

#endif

