#include	<windows.h>
#include	<stdio.h>
#include	<string.h>
#include	"x1.h"
#include	"x1_ctc.h"

#include	"dosio.h"
#include	"trace.h"

/***********************************************************************
	CTC
***********************************************************************/

		CTC_TABLE	CTC[3];
extern	Z80_Regs	R;


void init_ctc(void) {

	int		i, j;

	ZeroMemory(CTC, sizeof(CTC));
	for (j=0; j<3; j++) {
		for (i=0; i<4; i++) {
			CTC[j].value[i] = 0x83;
		}
	}
}


void x1_ctc_int(void) {

	CTC_TABLE	*ctc;
	WORD		clk0, clk4, clk2;
	WORD		subcnt;
	int			i, j;
	BYTE		bit;
	BYTE		ctcint_flg;

	ctcint_flg = Z80_Able_interrupt();

	clk4 = x1flg.HSYNC_CLK;
	clk2 = clk4 >> 1;

	if (x1flg.ROM_TYPE >= 2) {
		ctc = CTC;
		j = 0;
	}
	else {
		ctc = &CTC[2];
		j = 2;
	}

	for (; j<3; j++, ctc++) {
		clk0 = 0;
		bit = 1;
		for (i=0; i<4; i++, bit<<=1) {
			if (!(ctc->value[i] & 0x02)) {
				if (ctc->count[i] <= 0L) {
					ctc->count[i] += ctc->countmax[i];
				}
				if (!(ctc->value[i] & 0x40)) {
					subcnt = clk4;
				}
				else if (i == 3) {
					subcnt = clk0;
				}
				else {
					subcnt = clk2;
				}
				ctc->count[i] -= (long)subcnt;
				if (ctc->count[i] <= 0L) {
					ctc->int_flag |= bit;
					if (!i) {
						clk0 = 1;
					}
				}
			}
		}

		bit = 1;
		for (i=0; i<4; i++, bit<<=1) {
			if (ctc->int_flag & bit) {
				if (!(ctc->value[i] & 0x80)) {
					ctc->int_flag ^= bit;
				}
				else if (ctcint_flg) {
					ctcint_flg = 0;
					ctc->int_flag ^= bit;
					Z80_Cause_Interrupt(ctc->vector + (BYTE)(i << 1));
				}
			}
		}
	}
}

//----------------------------------------------------------------------

CTC_TABLE *ctctablep(WORD port) {

	port &= 0xfffc;
	if (port == 0x1fa0) {
		return(CTC);
	}
	if (port == 0x1fa8) {
		return(&CTC[1]);
	}
	if ((x1flg.SOUND_SW) && (port == 0x0704)) {
		return(&CTC[2]);
	}
	return(NULL);
}


X1_IOW x1_ctc_w(WORD port, BYTE value) {

	CTC_TABLE	*ctc;
	WORD		p = port;

	if ((ctc = ctctablep(port)) == NULL) {
		return;
	}
	port &= 3;

	if (ctc->value[port] & 0x04) {
		WORD scale = 0;
		long count = 256L;
		ctc->bakval[port] = value;
		if (value) {
			count = (long)value;
		}
		if (!(ctc->value[port] & 0x40)) {
			if (ctc->value[port] & 0x20) {
				scale = 8;
			}
			else {
				scale = 4;
			}
		}
		ctc->countmax[port] = count << scale;
		ctc->count[port] = ctc->countmax[port];
		ctc->value[port] &= (BYTE)~6;
	}
	else if (value & 1) {
		ctc->value[port] = value;
	}
	else {
		if (!port) {								// ver0.25
			ctc->vector = value & 0xf8;
		}
	}
}


X1_IOR x1_ctc_r(WORD port) {

	CTC_TABLE	*ctc;

	if (ctc = ctctablep(port)) {
		port &= 3;
		return(ctc->bakval[port]);
	}
	return(0xff);
}
