//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#include	<windows.h>

#include	"common.h"
#include	"x1_io.h"
#include	"x1_mem.h"
#include	"z80r.h"
#include	"z80r_mcr.h"

extern	Z80RPUB _iycb_proc(void);

#define	R_Z80IYL	R.IY.B.l
#define	R_Z80IYH	R.IY.B.h

#define	GET_IY														\
			GET_PC_BYTE												\
			__asm {	cbw											}	\
			__asm {	add		ax, R_Z80IY							}

#define	GET_XIY														\
			GET_PC_BYTE												\
			__asm {	cbw											}	\
			__asm {	add		ax, R_Z80IY							}	\
			__asm {	mov		cx, ax								}	\
			__asm {	call	fast_RDMEM							}

#define	XIY2R(reg)													\
			GET_XIY													\
			__asm {	mov		reg, al								}	\
			__asm {	ret											}	\

#define	R2XIY(reg)													\
			GET_IY													\
			__asm {	mov		cx, ax								}	\
			__asm {	mov		dl, reg								}	\
			__asm {	jmp		fast_WRMEM							}


Z80RASM _and_iyl(void) { regAND(R_Z80IYL) }
Z80RASM _and_iyh(void) { regAND(R_Z80IYH) }
Z80RASM _or_iyl(void) { regOR(R_Z80IYL) }
Z80RASM _or_iyh(void) { regOR(R_Z80IYH) }
Z80RASM _xor_iyl(void) { regXOR(R_Z80IYL) }
Z80RASM _xor_iyh(void) { regXOR(R_Z80IYH) }
Z80RASM _cp_iyl(void) { regCP(R_Z80IYL) }
Z80RASM _cp_iyh(void) { regCP(R_Z80IYL) }

Z80RASM _inc_iyl(void) { MCR_INC(R_Z80IYL) }
Z80RASM _inc_iyh(void) { MCR_INC(R_Z80IYH) }
Z80RASM _dec_iyl(void) { MCR_DEC(R_Z80IYL) }
Z80RASM _dec_iyh(void) { MCR_DEC(R_Z80IYH) }

Z80RASM _add_a_iyl(void) { regADD(R_Z80IYL) }
Z80RASM _add_a_iyh(void) { regADD(R_Z80IYH) }
Z80RASM _adc_a_iyl(void) { regADC(R_Z80IYL) }
Z80RASM _adc_a_iyh(void) { regADC(R_Z80IYH) }
Z80RASM _sub_iyl(void) { regSUB(R_Z80IYL) }
Z80RASM _sub_iyh(void) { regSUB(R_Z80IYH) }
Z80RASM _sbc_a_iyl(void) { regSBC(R_Z80IYL) }
Z80RASM _sbc_a_iyh(void) { regSBC(R_Z80IYH) }

Z80RASM _ld_a_iyl(void) { MCR_LD(R_Z80A, R_Z80IYL) }
Z80RASM _ld_b_iyl(void) { MCR_LD(R_Z80B, R_Z80IYL) }
Z80RASM _ld_c_iyl(void) { MCR_LD(R_Z80C, R_Z80IYL) }
Z80RASM _ld_d_iyl(void) { MCR_LD(R_Z80D, R_Z80IYL) }
Z80RASM _ld_e_iyl(void) { MCR_LD(R_Z80E, R_Z80IYL) }
Z80RASM _ld_iyl_a(void) { MCR_LD(R_Z80IYL, R_Z80A) }
Z80RASM _ld_iyl_b(void) { MCR_LD(R_Z80IYL, R_Z80B) }
Z80RASM _ld_iyl_c(void) { MCR_LD(R_Z80IYL, R_Z80C) }
Z80RASM _ld_iyl_d(void) { MCR_LD(R_Z80IYL, R_Z80D) }
Z80RASM _ld_iyl_e(void) { MCR_LD(R_Z80IYL, R_Z80E) }
Z80RASM _ld_iyl_iyh(void) { MCR_LD(R_Z80IYL, R_Z80IYH) }
Z80RASM _ld_iyl_byte(void) { LDB_b(R_Z80IYL) }

Z80RASM _ld_a_iyh(void) { MCR_LD(R_Z80A, R_Z80IYH) }
Z80RASM _ld_b_iyh(void) { MCR_LD(R_Z80B, R_Z80IYH) }
Z80RASM _ld_c_iyh(void) { MCR_LD(R_Z80C, R_Z80IYH) }
Z80RASM _ld_d_iyh(void) { MCR_LD(R_Z80D, R_Z80IYH) }
Z80RASM _ld_e_iyh(void) { MCR_LD(R_Z80E, R_Z80IYH) }
Z80RASM _ld_iyh_a(void) { MCR_LD(R_Z80IYH, R_Z80A) }
Z80RASM _ld_iyh_b(void) { MCR_LD(R_Z80IYH, R_Z80B) }
Z80RASM _ld_iyh_c(void) { MCR_LD(R_Z80IYH, R_Z80C) }
Z80RASM _ld_iyh_d(void) { MCR_LD(R_Z80IYH, R_Z80D) }
Z80RASM _ld_iyh_e(void) { MCR_LD(R_Z80IYH, R_Z80E) }
Z80RASM _ld_iyh_iyl(void) { MCR_LD(R_Z80IYH, R_Z80IYL) }
Z80RASM _ld_iyh_byte(void) { LDB_b(R_Z80IYH) }

Z80RASM _and_xiy(void)	{ GET_XIY	MCR_AND 		}
Z80RASM _or_xiy(void)	{ GET_XIY	MCR_OR			}
Z80RASM _xor_xiy(void)	{ GET_XIY	MCR_XOR			}
Z80RASM _cp_xiy(void)	{ GET_XIY	MCR_CP			}

Z80RASM _inc_xiy(void)	{ GET_IY	MCR_INC_MEM(ax)	}
Z80RASM _dec_xiy(void)	{ GET_IY	MCR_DEC_MEM(ax)	}

Z80RASM	_add_a_xiy(void)	{ GET_XIY	MCR_ADD			}
Z80RASM _adc_a_xiy(void) 	{ GET_XIY	MCR_ADC			}
Z80RASM	_sub_xiy(void)		{ GET_XIY	MCR_SUB			}
Z80RASM _sbc_a_xiy(void)	{ GET_XIY	MCR_SBC			}

Z80RASM _add_iy_bc(void)	{ MCR_ADD_W(R_Z80IY, R_Z80BC) }
Z80RASM _add_iy_de(void)	{ MCR_ADD_W(R_Z80IY, R_Z80DE) }
Z80RASM _add_iy_iy(void)	{ MCR_ADDx2(R_Z80IY) }
Z80RASM _add_iy_sp(void)	{ MCR_ADD_W(R_Z80IY, R_Z80SP) }

Z80RASM _ld_a_xiy(void) { XIY2R(R_Z80A) }
Z80RASM _ld_b_xiy(void) { XIY2R(R_Z80B) }
Z80RASM _ld_c_xiy(void) { XIY2R(R_Z80C) }
Z80RASM _ld_d_xiy(void) { XIY2R(R_Z80D) }
Z80RASM _ld_e_xiy(void) { XIY2R(R_Z80E) }
Z80RASM _ld_l_xiy(void) { XIY2R(R_Z80L) }
Z80RASM _ld_h_xiy(void) { XIY2R(R_Z80H) }
Z80RASM _ld_xiy_a(void) { R2XIY(R_Z80A) }
Z80RASM _ld_xiy_b(void) { R2XIY(R_Z80B) }
Z80RASM _ld_xiy_c(void) { R2XIY(R_Z80C) }
Z80RASM _ld_xiy_d(void) { R2XIY(R_Z80D) }
Z80RASM _ld_xiy_e(void) { R2XIY(R_Z80E) }
Z80RASM _ld_xiy_l(void) { R2XIY(R_Z80L) }
Z80RASM _ld_xiy_h(void) { R2XIY(R_Z80H) }

Z80RASM _ld_xiy_byte(void) {

	__asm {
				GET_IY
				push	ax
				GET_PC_BYTE
				mov		dl, al
				pop		cx
				jmp		fast_WRMEM
	}
}

Z80RASM _push_iy(void) { MCR_PUSH(R_Z80IY) }
Z80RASM _pop_iy(void) { MCR_POP(R_Z80IY) }
Z80RASM _inc_iy(void) { MCR_INC_W(R_Z80IY) }
Z80RASM _dec_iy(void) { MCR_DEC_W(R_Z80IY) }
Z80RASM _ex_xsp_iy(void) { MCR_EX_XSP(R_Z80IY) }
Z80RASM _ld_xword_iy(void) { LDx_W(R_Z80IY) }
Z80RASM _ld_iy_xword(void) { LDW_x(R_Z80IY) }
Z80RASM _ld_iy_word(void) { LDW_w(R_Z80IY) }
Z80RASM _ld_sp_iy(void) { MCR_LD_W(R_Z80SP, R_Z80IY) }
Z80RASM _jp_iy(void) { MCR_LD_W(R_Z80PC, R_Z80IY) }

Z80RASM _ld_nop(void) { __asm { ret } }

Z80RASM _no_op(void) { MCR_DEC_W(R_Z80PC) }


Z80ROPCODE opcode_fd[256] = {
		_no_op,			_no_op,			_no_op,			_no_op,			// 00
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_add_iy_bc,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 10
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_add_iy_de,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_ld_iy_word,	_ld_xword_iy,	_inc_iy,		// 20
		_inc_iyh,		_dec_iyh,		_ld_iyh_byte,	_no_op,
		_no_op,			_add_iy_iy,		_ld_iy_xword,	_dec_iy,
		_inc_iyl,		_dec_iyl,		_ld_iyl_byte,	_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 30
		_inc_xiy,		_dec_xiy,		_ld_xiy_byte,	_no_op,
		_no_op,			_add_iy_sp,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 40
		_ld_b_iyh,		_ld_b_iyl,		_ld_b_xiy,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_ld_c_iyh,		_ld_c_iyl,		_ld_c_xiy,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 50
		_ld_d_iyh,		_ld_d_iyl,		_ld_d_xiy,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_ld_e_iyh,		_ld_e_iyl,		_ld_e_xiy,		_no_op,

		_ld_iyh_b,		_ld_iyh_c,		_ld_iyh_d,		_ld_iyh_e,		// 60
		_ld_nop,		_ld_iyh_iyl,	_ld_h_xiy,		_ld_iyh_a,
		_ld_iyl_b,		_ld_iyl_c,		_ld_iyl_d,		_ld_iyl_e,
		_ld_iyl_iyh,	_ld_nop,		_ld_l_xiy,		_ld_iyl_a,

		_ld_xiy_b,		_ld_xiy_c,		_ld_xiy_d,		_ld_xiy_e,		// 70
		_ld_xiy_h,		_ld_xiy_l,		_no_op,			_ld_xiy_a,
		_no_op,			_no_op,			_no_op,			_no_op,
		_ld_a_iyh,		_ld_a_iyl,		_ld_a_xiy,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 80
		_add_a_iyh,		_add_a_iyl,		_add_a_xiy,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_adc_a_iyh,		_adc_a_iyl,		_adc_a_xiy,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 90
		_sub_iyh,		_sub_iyl,		_sub_xiy,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_sbc_a_iyh,		_sbc_a_iyl,		_sbc_a_xiy,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// a0
		_and_iyh,		_and_iyl,		_and_xiy,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_xor_iyh,		_xor_iyl,		_xor_xiy,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// b0
		_or_iyh,		_or_iyl,		_or_xiy,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_cp_iyh,		_cp_iyl,		_cp_xiy,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// c0
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_iycb_proc,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// d0
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_pop_iy,		_no_op,			_ex_xsp_iy,		// e0
		_no_op,			_push_iy,		_no_op,			_no_op,
		_no_op,			_jp_iy,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// f0
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_ld_sp_iy,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op};

