#include	<windows.h>
// #include	<dinput.h>

#include	"common.h"
#include	"xmil.h"
#include	"menu.h"

extern	HWND	hWndMain;
extern	HWND	hInst;

//	LPDIRECTINPUT7			pDInput = NULL;
//	LPDIRECTINPUTDEVICE7	pDIJoystick = NULL;

static	int		joyactive = 0;
static	BYTE	joyflag = 0xff;

#define	JOY_LEFT_BIT	0x04
#define	JOY_RIGHT_BIT	0x08
#define	JOY_UP_BIT		0x01
#define	JOY_DOWN_BIT	0x02
#define	JOY_BTN1_BIT	0x40
#define	JOY_BTN2_BIT	0x20
#define	JOY_BTN3_BIT	0x80
#define	JOY_BTN4_BIT	0x10



void mx_initdinput(void) {

	JOYINFO		ji;

	if ((!joyGetNumDevs()) ||
		(joyGetPos(JOYSTICKID1, &ji) == JOYERR_UNPLUGGED)) {
		xmenu_setjoystick(xmilcfg.JOYSTICK | 2);
	}
}

void mx_termdinput(void) { }
void joy_foregroundprc(UINT wParam) { }

void joy_flash(void) {

	xmilcfg.JOYSTICK &= 0x7f;
	joyflag = 0xff;
}

BYTE joy_getflag(void) {

	JOYINFO		ji;

	if ((xmilcfg.JOYSTICK == 1) &&
		(joyGetPos(JOYSTICKID1, &ji) == JOYERR_NOERROR)) {
		xmilcfg.JOYSTICK |= 0x80;
		joyflag = 0xff;
		if (ji.wXpos < 0x4000U) {
			joyflag ^= JOY_LEFT_BIT;
		}
		else if (ji.wXpos > 0xc000U) {
			joyflag ^= JOY_RIGHT_BIT;
		}
		if (ji.wYpos < 0x4000U) {
			joyflag ^= JOY_UP_BIT;
		}
		else if (ji.wYpos > 0xc000U) {
			joyflag ^= JOY_DOWN_BIT;
		}
		if (ji.wButtons & JOY_BUTTON1) {
			joyflag ^= JOY_BTN1_BIT;
		}
		if (ji.wButtons & JOY_BUTTON2) {
			joyflag ^= JOY_BTN2_BIT;
		}
		if (ji.wButtons & JOY_BUTTON3) {
			joyflag ^= JOY_BTN3_BIT;
		}
		if (ji.wButtons & JOY_BUTTON4) {
			joyflag ^= JOY_BTN4_BIT;
		}
	}
	return(joyflag);
}

