#include	<windows.h>
#include	<dinput.h>

#include	"common.h"

extern	HWND	hWndMain;
extern	HWND	hInst;

	LPDIRECTINPUT7			pDInput = NULL;
	LPDIRECTINPUTDEVICE7	pDIJoystick = NULL;

		BYTE	use_joystick = 0;
static	int		joyactive = 0;


#define	JOY_LEFT_BIT	0x04
#define	JOY_RIGHT_BIT	0x08
#define	JOY_UP_BIT		0x01
#define	JOY_DOWN_BIT	0x02
#define	JOY_BTN1_BIT	0x40
#define	JOY_BTN2_BIT	0x20
#define	JOY_BTN3_BIT	0x80
#define	JOY_BTN4_BIT	0x10


BOOL CALLBACK joycheckproc(LPDIDEVICEINSTANCE lpddi,LPVOID /*pvRef*/) {

	if (SUCCEEDED(pDInput->CreateDeviceEx(lpddi->guidInstance,
					IID_IDirectInputDevice7, (void **)&pDIJoystick, NULL))) {
		return(DIENUM_STOP);
	}
	return(DIENUM_CONTINUE);
}


void mx_initdinput(void) {

	HRESULT	r;

	use_joystick = 0;

	if (FAILED(DirectInputCreateEx(hInst, DIRECTINPUT_VERSION,
						IID_IDirectInput7, (void**)&pDInput, NULL))) {
		return;
	}



	pDInput->EnumDevices(DIDEVTYPE_JOYSTICK,
						(LPDIENUMDEVICESCALLBACK)joycheckproc,
						NULL, DIEDFL_ATTACHEDONLY);
	if ((pDIJoystick != NULL) &&
		(SUCCEEDED(pDIJoystick->SetDataFormat(&c_dfDIJoystick)))) {
		r = pDIJoystick->SetCooperativeLevel(hWndMain,
									DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
		if (SUCCEEDED(r)) {
			DIPROPRANGE diprg;
			ZeroMemory(&diprg, sizeof(diprg));
			diprg.diph.dwSize = sizeof(diprg);
			diprg.diph.dwHeaderSize	= sizeof(diprg.diph);
			diprg.diph.dwObj = DIJOFS_X;
			diprg.diph.dwHow = DIPH_BYOFFSET;
			diprg.lMin = -1000;
			diprg.lMax = 1000;
			pDIJoystick->SetProperty(DIPROP_RANGE, &diprg.diph);
			diprg.diph.dwObj = DIJOFS_Y;
			pDIJoystick->SetProperty(DIPROP_RANGE, &diprg.diph);
			pDIJoystick->Acquire();
			use_joystick = 1;
		}
	}
}

void mx_termdinput(void) {

	RELEASE(pDIJoystick);
	RELEASE(pDInput);
}



void joy_foregroundprc(UINT wParam) {

	if (use_joystick) {
		joyactive = (wParam != WA_INACTIVE);
		if (joyactive) {
			pDIJoystick->Acquire();
		}
		else {
			pDIJoystick->Unacquire();
		}
	}
}


BYTE joy_getflag(void) {

	BYTE		ret;
	HRESULT		r;
	DIJOYSTATE	dijs;

	ret = 0xff;
	if (use_joystick) {
		pDIJoystick->Poll();
		r = pDIJoystick->GetDeviceState(sizeof(DIJOYSTATE), &dijs);
		if (SUCCEEDED(r)) {

			if (dijs.lX < -500) {
				ret ^= JOY_LEFT_BIT;
			}
			else if (dijs.lX > 500) {
				ret ^= JOY_RIGHT_BIT;
			}
			if (dijs.lY < -500) {
				ret ^= JOY_UP_BIT;
			}
			else if (dijs.lY > 500) {
				ret ^= JOY_DOWN_BIT;
			}
			if (dijs.rgbButtons[0] & 0x80) {
				ret ^= JOY_BTN1_BIT;
			}
			if (dijs.rgbButtons[1] & 0x80) {
				ret ^= JOY_BTN2_BIT;
			}
			if (dijs.rgbButtons[2] & 0x80) {
				ret ^= JOY_BTN3_BIT;
			}
			if (dijs.rgbButtons[3] & 0x80) {
				ret ^= JOY_BTN4_BIT;
			}
		}
		else if ((joyactive) && (r == DIERR_INPUTLOST)) {
			pDIJoystick->Acquire();
		}
	}
	return(ret);
}

