#include	<windows.h>
#include	"common.h"
#include	"xmil.h"
#include	"draw_sub.h"


// ---------------------------------------------------- 8C ANK LN^

										// ds:esi = font face pointer
										// es:edi = dest
										//    ecx = loop count (text height)

static LABEL void txt8_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	mov		al, [esi + ebx]
				mov		ah, al
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				mov		ah, al
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				mov		ah, al
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				stosb
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_right4half(void) {			// ׂEShbg

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	shl		al, 4
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_right4x2(void) {				// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				mov		ah, al
				stosw
				inc		bl
				and		bl, 7
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_halfx2(void) {				// ׂďc{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_halfx4left(void) {			// ׂĂS{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		al, byte ptr x2left[eax]
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		al, byte ptr x2right[eax]
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


// ---------------------------------------------------- 8C LN^

										// ds:esi = font face pointer
										// es:edi = vrampos
										//    ecx = loop count (text height)

static LABEL void knj8_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				stosb
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	mov		al, [esi + ebx]
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				stosb
				add		bl, 4
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_right4half(void) {			// ׂEShbg

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	shl		al, 4
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_right4x2(void) {				// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				add		bl, bl
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				stosb
				add		bl, 2
				and		bl, 31
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_halfx2(void) {				// ׂďc{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_halfx4left(void) {			// ׂĂS{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	mov		al, byte ptr x2left[eax]
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				add		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	mov		al, byte ptr x2right[eax]
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


// ---------------------------------------------------- 8C extLN^

										// ds:esi = font face pointer
										// es:edi = vrampos
										//    ecx = loop count (text height)

static LABEL void ext8_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	mov		al, [esi + ebx]
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2left[eax]
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				mov		al, byte ptr x2right[eax]
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				stosb
				add		bl, 2
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_right4half(void) {			// ׂEShbg

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 4
				and		bl, 15
makefaceout:	shl		al, 4
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_right4x2(void) {				// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
makefaceloop:	mov		al, [esi + ebx]
				shl		al, 4
				stosb
				inc		bl
				and		bl, 15
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_halfx2(void) {				// ׂďc{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				mov		al, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	mov		al, [esi + ebx]
				add		bl, 4
				and		bl, 15
makefaceout:	mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_halfx4left(void) {			// ׂĂS{p

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 4
				and		bl, 15
makefaceout:	mov		al, byte ptr x2left[eax]
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


static LABEL void ext8_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shr		cl, 1
				movzx	ebx, fontycnt
				or		bl, bl
				je		makefaceloop
				movzx	eax, byte ptr [esi + ebx]	// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout
makefaceloop:	movzx	eax, byte ptr [esi + ebx]
				add		bl, 4
				and		bl, 15
makefaceout:	mov		al, byte ptr x2right[eax]
				mov		ah, al
				stosw
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------------------------------

extern	void draw_nop(void);

// --------------------------------------------------------------------------


void (*txtbeffects[])(void) = {
						txt8_nor,					// m[}
						txt8_halfx2,				// ׂďc{p
						txt8_right4dot,				// EShbg
						txt8_right4half,			// ׂEShbg

						txt8_Yx2,					// c{p
						draw_nop,					// 肦Ȃ
						txt8_right4x2,				// EShbgc{p
						draw_nop,					// 肦Ȃ

						txt8_x2left,				// {p
						txt8_halfx4left,			// ׂĂS{p
						txt8_x2right,				// {pE
						txt8_halfx4right,			// ׂĂS{pE

						txt8_x4left,				// S{p
						draw_nop,					// 肦Ȃ
						txt8_x4right,				// S{pE
						draw_nop					// 肦Ȃ
};


void (*knjbeffects[])(void) = {
						knj8_nor,					// m[}
						knj8_halfx2,				// ׂďc{p
						knj8_right4dot,				// EShbg
						knj8_right4half,			// ׂEShbg

						knj8_Yx2,					// c{p
						draw_nop,					// 
						knj8_right4x2,				// EShbgc{p
						draw_nop,					//

						knj8_x2left,				// {p
						knj8_halfx4left,			// ׂĂS{p
						knj8_x2right,				// {pE
						knj8_halfx4right,			// ׂĂS{pE

						knj8_x4left,				// S{p
						draw_nop,					//
						knj8_x4right,				// S{pE
						draw_nop					//
};


void (*extbeffects[])(void) = {
						ext8_nor,					// m[}
						ext8_halfx2,				// ׂďc{p
						ext8_right4dot,				// EShbg
						ext8_right4half,			// ׂEShbg

						ext8_Yx2,					// c{p
						draw_nop,					// 
						ext8_right4x2,				// EShbgc{p
						draw_nop,					//

						ext8_x2left,				// {p
						ext8_halfx4left,			// ׂĂS{p
						ext8_x2right,				// {pE
						ext8_halfx4right,			// ׂĂS{pE

						ext8_x4left,				// S{p
						draw_nop,					//
						ext8_x4right,				// S{pE
						draw_nop					//
};

