#include	<windows.h>
#include	"common.h"
#include	"dsounds.h"
#include	"opm.h"
#include	"opmcore.h"

extern	OPM_CH	OPMCH[MAXCHANNEL];
extern	WORD	env_curve[];
extern	long	envtable[];
extern	short	sintable[];

extern	long	feedback2;
extern	long	feedback3;
extern	long	feedback4;

extern	long	outdl;
extern	long	outdc;
extern	long	outdr;

extern	PSG_CH	PSGCH[];
extern	PSG_T	psg;
extern	WORD	psgvol[];
static	BYTE	psgch_cnt;

extern	BYTE	psgenv_mod;
extern	BYTE	psgenv_vol;
extern	BYTE	psgenv_volcnt;
extern	WORD	psgenv_cnt;
extern	WORD	psgenv_max;

static	WORD	psgnoise_rand0;
static	WORD	psgnoise_rand1;
extern	WORD	psgnoise_cnt;
extern	WORD	psgnoise_freq;
extern	WORD	psgnoise_table[];

extern	WORD	psg_puchidec;
extern	WORD	psg_puchinoisecnt;

static	DWORD	pcmmakepos = 0;


void psgproc_puchi(void);
void psgproc_normal(void);


static	void (*psgproc)(void) = psgproc_normal;


#define	OP_OUT															\
			__asm {	add		eax, [edi].freq_cnt						}	\
			__asm {	shr		eax, (FREQ_BITS-SIN_BITS - 1)			}	\
			__asm {	and		eax, (SIN_ENT - 1) * 2					}	\
			__asm {	movsx	eax, word ptr sintable[eax]				}	\
			__asm {	imul	envtable[edx*4]							}	\
			__asm {	sar		eax, (ENVTBL_BIT+SINTBL_BIT-TL_BITS)	}


#define	calc_envlope(n)											\
			__asm {	mov		eax, [edi].freq_inc				}	\
			__asm {	add		[edi].freq_cnt, eax				}	\
			__asm {	mov		eax, [edi].env_cnt				}	\
			__asm {	add		eax, [edi].env_inc				}	\
			__asm {	cmp		eax, [edi].env_end				}	\
			__asm {	jae		calc_newenv##n##				}	\
envret##n##:													\
			__asm {	mov		[edi].env_cnt, eax				}	\
			__asm {	shr		eax, ENV_BITS					}	\
			__asm {	movzx	edx, word ptr [edi].totallevel	}	\
			__asm {	sub		dx, env_curve[eax*2]			}


#define	setenvlopmode(n)										\
			__asm {	mov		dl, [edi].env_mode				}	\
			__asm {	dec		dl								}	\
			__asm {	je		SETRR_##n##						}	\
			__asm {	dec		dl								}	\
			__asm {	je		SETD2_##n##						}	\
			__asm {	dec		dl								}	\
			__asm {	je		SETD1_##n##						}	\
			__asm {	dec		dl								}	\
			__asm {	jne		envret##n##						}	\
			__asm {	mov		[edi].env_mode, EM_DECAY1		}	\
			__asm {	mov		eax, [edi].decaylevel			}	\
			__asm {	mov		[edi].env_end, eax				}	\
			__asm {	mov		eax, [edi].env_inc_decay1		}	\
			__asm {	mov		[edi].env_inc, eax				}	\
			__asm {	mov		eax, EC_DECAY					}	\
			__asm {	jmp		envret##n##						}	\
SETD1_##n##:													\
			__asm {	mov		[edi].env_mode, EM_DECAY2		}	\
			__asm {	mov		[edi].env_end, EC_OFF			}	\
			__asm {	mov		eax, [edi].env_inc_decay2		}	\
			__asm {	mov		[edi].env_inc, eax				}	\
			__asm {	mov		eax, [edi].decaylevel			}	\
			__asm {	jmp		envret##n##						}	\
SETRR_##n##:													\
			__asm {	mov		[edi].env_mode, EM_OFF			}	\
SETD2_##n##:													\
			__asm {	mov		[edi].env_end, EC_OFF + 1		}	\
			__asm {	mov		[edi].env_inc, 0				}	\
			__asm {	mov		eax, EC_OFF						}	\
			__asm {	jmp		envret##n##						}




static LABEL void psgproc_normal(void) {

	__asm {
				cmp		psgenv_cnt, 0
				je		short psgenv_calcend
				dec		psgenv_cnt
				jne		short psgenv_calcend
				dec		psgenv_volcnt
				jns		short psg_env_cont2
				test	psgenv_mod, PSGENV_ONESHOT
				je		short psg_env_cont1
				mov		dl, 0
				test	psgenv_mod, PSGENV_LASTON
				je		short psg_envvolset
				mov		dl, 15
				jmp		short psg_envvolset
psg_env_cont1:	mov		psgenv_volcnt, 15
				test	psgenv_mod, PSGENV_ONECYCLE
				jne		short psg_env_cont2
				xor		psgenv_mod, PSGENV_INC
psg_env_cont2:	mov		dx, psgenv_max			; Counter Reset
				mov		psgenv_cnt, dx
				mov		dl, psgenv_volcnt
				xor		dl, psgenv_mod
				and		dl, 15
psg_envvolset:	mov		psgenv_vol, dl
psgenv_calcend:
				xor		eax, eax
				mov		ch, psg+7
				not		ch
				mov		esi, offset PSGCH
				xor		edi, edi
				mov		psgch_cnt, 3
psgoscloop:		mov		ebx, [esi].psg_volp
				mov		dl, [ebx]
				and		edx, 15
				je		short psgch_end
				movzx	ebx, word ptr psgvol[edx*2]
				test	ch, 8
				je		short nomixnoise
				add		edi, ebx
nomixnoise:		test	ch, 1
				je		short psgch_end
				mov		dx, [esi].psg_freq
				or		dx, dx
				je		psgch_end
				mov		cl, 4
psgsoundlp:		add		[esi].psg_sound_cnt, dx
				js		short psgsoundms
				add		eax, ebx
				jmp		short psgsoundslpe
psgsoundms:		sub		eax, ebx
psgsoundslpe:	dec		cl
				jne		short psgsoundlp
psgch_end:		add		esi, (type PSG_CH)
				shr		ch, 1
				dec		psgch_cnt
				jne		short psgoscloop

												// mCYEEEE
				or		edi, edi
				je		short psgnoiseallend
				mov		dx, psgnoise_freq
				sub		psgnoise_cnt, dx
				jc		short noiserandmake
				js		short psgnoisems
psgnoisepl:		add		eax, edi
				jmp		short psgnoisesend
noiserandmake:	mov		bx, psgnoise_rand0			// \
				ror		bx, 5
				add		bx, 60043
				sbb		psgnoise_rand1, 4953
				rol		psgnoise_rand1, 1
				adc		bx, psgnoise_rand1
				mov		psgnoise_rand0, bx
				and		ebx, 15*2
				mov		dx, psgnoise_table[ebx]
				mov		psgnoise_freq, dx
				cmp		psgnoise_cnt, 0
				jns		short psgnoisepl
psgnoisems:		sub		eax, edi
psgnoisesend:
psgnoiseallend:
				ret
	}
}

static LABEL void psgproc_puchi(void) {

	__asm {
				cmp		psgenv_cnt, 0
				je		short psgenv_calcend
				dec		psgenv_cnt
				jne		short psgenv_calcend
				dec		psgenv_volcnt
				jns		short psg_env_cont2
				test	psgenv_mod, PSGENV_ONESHOT
				je		short psg_env_cont1
				mov		dl, 0
				test	psgenv_mod, PSGENV_LASTON
				je		short psg_envvolset
				mov		dl, 15
				jmp		short psg_envvolset
psg_env_cont1:	mov		psgenv_volcnt, 15
				test	psgenv_mod, PSGENV_ONECYCLE
				jne		short psg_env_cont2
				xor		psgenv_mod, PSGENV_INC
psg_env_cont2:	mov		dx, psgenv_max			; Counter Reset
				mov		psgenv_cnt, dx
				mov		dl, psgenv_volcnt
				xor		dl, psgenv_mod
				and		dl, 15
psg_envvolset:	mov		psgenv_vol, dl
psgenv_calcend:
				xor		eax, eax
				mov		ch, psg+7
				not		ch
				mov		esi, offset PSGCH
				xor		edi, edi
				mov		psgch_cnt, 3
psgoscloop:		mov		ebx, [esi].psg_volp
				mov		dl, [ebx]
				and		edx, 15
				je		short psgch_end
				movzx	ebx, word ptr psgvol[edx*2]
				test	ch, 8
				je		short nomixnoise
				add		edi, ebx
nomixnoise:		test	ch, 1
				je		short psgch_end
				mov		dx, [esi].psg_freq
				or		dx, dx
				je		psgch_puchinoise
				mov		cl, 4
psgsoundlp:		add		[esi].psg_sound_cnt, dx
				js		short psgsoundms
				add		eax, ebx
				jmp		short psgsoundslpe
psgsoundms:		sub		eax, ebx
psgsoundslpe:	dec		cl
				jne		short psgsoundlp
psgch_end:		add		esi, (type PSG_CH)
				shr		ch, 1
				dec		psgch_cnt
				jne		short psgoscloop

												// mCYEEEE
				or		edi, edi
				je		short psgnoiseallend
				mov		dx, psgnoise_freq
				sub		psgnoise_cnt, dx
				jc		short noiserandmake
				js		short psgnoisems
psgnoisepl:		add		eax, edi
				jmp		short psgnoisesend
noiserandmake:	mov		bx, psgnoise_rand0			// \
				ror		bx, 5
				add		bx, 60043
				sbb		psgnoise_rand1, 4953
				rol		psgnoise_rand1, 1
				adc		bx, psgnoise_rand1
				mov		psgnoise_rand0, bx
				and		ebx, 15*2
				mov		dx, psgnoise_table[ebx]
				mov		psgnoise_freq, dx
				cmp		psgnoise_cnt, 0
				jns		short psgnoisepl
psgnoisems:		sub		eax, edi
psgnoisesend:
psgnoiseallend:	ret

psgch_puchinoise:
				cmp		[esi].psg_puchinoise, 0
				je		psgch_end
				dec		[esi].psg_puchinoise
				shl		ebx, 2
				mov		dx, psg_puchinoisecnt
				add		[esi].psg_sound_cnt, dx
				js		psgpuchims0
				add		eax, ebx
				jmp		psgch_end
psgpuchims0:	sub		eax, ebx
				jmp		psgch_end
	}
}


// make OSC DATA  stereo 16bit
void INX1F_makesample(DWORD samplecount) {

	__asm {
				cmp		samplecount, 0
				je		opmnoupdate

				mov		eax, pcmfreemax
				mov		ebx, pcmmakepos

				sub		eax, ebx
				jbe		opmnoupdate
				cmp		eax, samplecount
				jnc		nooflow
				mov		samplecount, eax
nooflow:
				push	esi
				push	edi
				lea		esi, pcmbuffer[ebx*4]

oscout_loop:	push	esi

				xor		eax, eax
				mov		outdl, eax
				mov		outdc, eax
				mov		outdr, eax
				mov		ch, MAXCHANNEL
				mov		edi, offset OPMCH

calc_channel_lp:xor		eax, eax
				mov		feedback2, eax
				mov		feedback3, eax
				mov		feedback4, eax
				mov		esi, edi
				calc_envlope(1)						// slot1 calculate
				jl		calc_slot3
				mov		cl, [esi].feedback
				or		cl, cl
				je		notcalc_feed
				mov		eax, [esi].op1fb			// with feedback
				mov		ebx, eax
				shr		eax, cl
				OP_OUT
				mov		[esi].op1fb, eax
				add		eax, ebx
				sar		eax, 1
				jmp		ch_algchk
notcalc_feed:	xor		eax, eax					// without feedback
				OP_OUT
ch_algchk:		cmp		[esi].algorhythm, 5
				jne		calcch_an5
				mov		feedback2, eax				// case ALG == 5
				mov		feedback3, eax
				mov		feedback4, eax
				jmp		calc_slot3
calcch_an5:		mov		ebx, [esi].connect1			// case ALG != 5
				add		[ebx], eax
calc_slot3:		add		edi, (type OPM_SLOT)*2		// slot3 calculate
				calc_envlope(3)
				jl		calc_slot2
				mov		eax, feedback2
				OP_OUT
				mov		ebx, [esi].connect2
				add		[ebx], eax
calc_slot2:		sub		edi, (type OPM_SLOT)		// slot2 calculate
				calc_envlope(2)
				jl		calc_slot4
				mov		eax, feedback3
				OP_OUT
				mov		ebx, [esi].connect3
				add		[ebx], eax
calc_slot4:		add		edi, (type OPM_SLOT)*2		// slot4 calculate
				calc_envlope(4)
				jl		calc_slot_end
				mov		eax, feedback4
				OP_OUT
				mov		ebx, [esi].connect4
				add		[ebx], eax

calc_slot_end:	add		edi, (type OPM_CH) - (type OPM_SLOT)*3
				dec		ch
				jne		calc_channel_lp

				call	psgproc

				pop		esi
				add		eax, outdc
				mov		edx, eax
				add		eax, outdl
				add		edx, outdr
				sar		eax, (OPM_OUTSB+1)
				sar		edx, (OPM_OUTSB+1)

				cmp		eax, 000008000h
				jge		short dd_leftmax
				cmp		eax, 0ffff8000h
				jle		short dd_leftmin
dd_leftch16:	cmp		edx, 000008000h
				jge		short dd_rightmax
				cmp		edx, 0ffff8000h
				jle		short dd_rightmin
dd_rightch16:
				mov		[esi], ax
				mov		[esi+2], dx
				inc		pcmmakepos
				add		esi, 4
				dec		samplecount
				jne		oscout_loop

				pop		edi
				pop		esi
opmnoupdate:
	}
	return;

		__asm {
dd_leftmax:		mov		ax, 7fffh
				jmp		dd_leftch16
dd_leftmin:		mov		ax, 8001h
				jmp		dd_leftch16
dd_rightmax:	mov		dx, 7fffh
				jmp		dd_rightch16
dd_rightmin:	mov		dx, 8001h
				jmp		dd_rightch16

calc_newenv1:	setenvlopmode(1)
calc_newenv3:	setenvlopmode(3)
calc_newenv2:	setenvlopmode(2)
calc_newenv4:	setenvlopmode(4)
	}
}

void INX1F_resetsamplepos(void) {

	pcmmakepos = 0;
}

void INX1F_PSGmode(BYTE withpuchinoise) {

	if (withpuchinoise) {
		psgproc = psgproc_puchi;
	}
	else {
		psgproc = psgproc_normal;
	}
}

