#include	<windows.h>
#include	<stdio.h>

#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_scpu.h"
#include	"x1_vram.h"
#include	"x1_cmt.h"
#include	"x1_8255.h"
#include	"draw.h"

#include	"dosio.h"
#include	"trace.h"

/***********************************************************************
	8255
***********************************************************************/

#if 1													// phantasie II, III
	s8255_TABLE		s8255 = {0, 0xff, 0xff, 0};
#else
	s8255_TABLE		s8255 = {0xff, 0xff, 0xff, 0};
#endif

void init_8255(void) {

	s8255.MODE = 0;
	s8255.PORT_A = 0;
	s8255.PORT_C |= 0x40;
	s8255.IO_MODE = 0;
}


X1_IOW x1_8255_w(WORD port, BYTE value) {

	BYTE	bak_c, bit;
	WORD	xl;

//	TRACEOUT(port, value);

	if (crtc.TXT_XL == 40) {
		s8255.PORT_C |= 0x40;
	}
	else {
		s8255.PORT_C &= ~0x40;
	}
	bak_c = s8255.PORT_C;

	switch(port & 0x0f) {
		case 0:
			if (!(s8255.MODE & 0x10)) {
				s8255.PORT_A = value;
			}
			return;
		case 1:
			if (!(s8255.MODE & 0x02)) {
				s8255.PORT_B = value;
			}
			return;
		case 2:
			if (!(s8255.MODE & 0x01)) {
				s8255.PORT_C &= 0xf0;
				s8255.PORT_C |= (value & 0x0f);
			}
			if (!(s8255.MODE & 0x08)) {
				s8255.PORT_C &= 0x0f;
				s8255.PORT_C |= (value & 0xf0);
			}
			break;
		case 3:
			if (value & 0x80) {
				s8255.MODE = value;
				return;
			}
			else {
				bit = (BYTE)(1 << ((value>>1) & 7));
				if (value & 0x01) {
					s8255.PORT_C |= bit;
				}
				else {
					s8255.PORT_C &= ~bit;
				}
			}
			break;
		default:
			return;
	}

//	cmt_write(s8255.PORT_C & 1);
	if ((bak_c & 0x20) && (!(s8255.PORT_C & 0x20))) {
		s8255.IO_MODE = 1;
	}
	xl = ((s8255.PORT_C & 0x40)?40:80);
	if (crtc.TXT_XL != xl) {
		crtc.TXT_XL = (BYTE)xl;
		crtc.GRP_XL = xl << 3;
		vrambank_patch();
		scrnallflash = 1;
	}
}

X1_IOR x1_8255_r(WORD port) {

	s8255.PORT_B = cmt_test(); // | cmt_read();	// THUNDER BALL

	if (v_cnt < crtc.CRT_YL) {
		s8255.PORT_B |= 0x80;					// 1:DISP
	}
	if (scpu.IBF) {
		scpu.IBF = 0;
		s8255.PORT_B |= 0x40;					// 1:SUB-CPU BUSY
	}
	if (scpu.OBF) {
		s8255.PORT_B |= 0x20;					// 1:SUB-CPU Data empty
	}
	if (!x1flg.ROM_SW) {
		s8255.PORT_B |= 0x10;					// 1:RAM
	}
	if (!(v_cnt < crtc.CRT_VS)) {
		s8255.PORT_B |= 0x04;					// V-SYNC
	}
	if (crtc.TXT_XL == 40) {
		s8255.PORT_C |= 0x40;
	}
	else {
		s8255.PORT_C &= ~0x40;
	}

	switch(port & 0x0f) {
		case 0:
			return(s8255.PORT_A);
		case 1:
			return(s8255.PORT_B);
		case 2:
			return(s8255.PORT_C);
		case 3:
			return(s8255.MODE);
	}
	return(-1);
}

