#include	<windows.h>
#include	"x1.h"
#include	"x1_8255.h"
#include	"x1_dma.h"
#include	"x1_fdc.h"

#include	"dosio.h"
#include	"trace.h"

/***********************************************************************
	DMA
***********************************************************************/

	DMA_TABLE	dma;


void init_dma(void) {

	ZeroMemory(&dma, sizeof(dma));
	dma.DMA_REDY = 8;
	dma.RR = 0x38;
}


void setdmareaddat(void) {

	dma.RR_CNT = dma.RR_OFF = 0;
	if (dma.RR_MSK & 0x01) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(RR);
	if (dma.RR_MSK & 0x02) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(BYT_N.b[0]);
	if (dma.RR_MSK & 0x04) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(BYT_N.b[1]);
	if (dma.RR_MSK & 0x08) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(CNT_A.b[0]);
	if (dma.RR_MSK & 0x10) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(CNT_A.b[1]);
	if (dma.RR_MSK & 0x20) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(CNT_B.b[0]);
	if (dma.RR_MSK & 0x40) dma.RR_TBL[dma.RR_CNT++] = DMAOFST(CNT_B.b[1]);
}

X1_IOW x1_dma_w(WORD port, BYTE value) {

	BYTE	wr;

	TRACEOUT(port, value);

	dma.DMA_ENBL = 0;

	if (!dma.WR_CNT) {
		wr = 6;
		dma.WR_CNT = dma.WR_OFF = 0;
		if (!(value & 0x80)) {
			if ((value & 3) != 0) {
				wr = 0;
			}
			else if ((value & 7) == 4) {
				wr = 1;
			}
			else if ((value & 7) == 0) {
				wr = 2;
			}
		}
		else {
			if ((value & 3) == 0) {
				wr = 3;
			}
			else if (((value & 3) == 1) && (value >> 5) != 7) {
				wr = 4;
			}
			else if (((value & 7) == 2) && (!(value & 0x40))) {
				wr = 5;
			}
			else if ((value & 3) == 3) {
				wr = 6;
			}
		}
		dma.WR[wr] = value;
		switch(wr) {
			case 0:
				dma.DMA_CMND = (BYTE)(value & 3);
				if (value & 0x08) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(ADR_A.b[0]);
				}
				if (value & 0x10) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(ADR_A.b[1]);
				}
				if (value & 0x20) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(BYT_L.b[0]);
				}
				if (value & 0x40) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(BYT_L.b[1]);
				}
				break;
			case 1:
			case 2:
				if (value & 0x40) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(nul);
				}
				break;
			case 3:
				if (value & 0x08) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(MASK_BYT);
				}
				if (value & 0x10) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(MACH_BYT);
				}
				dma.INT_ENBL = (BYTE)((value & 0x20)?1:0);
				dma.DMA_ENBL = (BYTE)((value & 0x40)?1:0);
				break;
			case 4:
				dma.DMA_MODE = (BYTE)((dma.WR[4] >> 5) & 3);
				if (value & 0x04) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(ADR_B.b[0]);
				}
				if (value & 0x08) {
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(ADR_B.b[1]);
				}
				if (value & 0x10){
					dma.WR_TBL[dma.WR_CNT++] = DMAOFST(INT_FLG);
				}
				break;
			case 6:
				switch(value) {
					case 0x83:				// DMAި
						dma.DMA_ENBL = 0;
						break;
					case 0x87:				// DMAȰ
						dma.DMA_ENBL = 1;
						break;
					case 0x8b:				// إƼײޥð޲
						dma.MACH_FLG = dma.ENDB_FLG = 0;
						break;
					case 0xa7:				// Ƽĥذޥݽ
						setdmareaddat();
						break;
					case 0xab:				// ĥȰ
						dma.INT_ENBL = 1;
						break;
					case 0xaf:				// ĥި
						dma.INT_ENBL = 0;
						break;
					case 0xb3:				// ި
						dma.DMA_REDY = (dma.WR[5] & 0x08);
						break;
					case 0xbb:				// ذޥϽ̫۰
						dma.WR_TBL[dma.WR_CNT++] = DMAOFST(RR_MSK);
						break;
					case 0xbf:				// ذޥð޲
						dma.RR_MSK = 1;
						setdmareaddat();
						break;
					case 0xc3:				// ؾ
#if 1										// ver0.25 ۰ޱײݽ
						dma.DMA_CMND = 0;
						dma.DMA_ENBL = 0;
						dma.INT_ENBL = 0;
#else
						init_dma();
#endif
						break;
					case 0xc7:				// ؾĥ߰Aݸ
					case 0xcb:				// ؾĥ߰Bݸ
						break;
					case 0xcf: // ۰
						dma.DMA_MODE = (BYTE)((dma.WR[4] >> 5) & 3);
						dma.CNT_A.w = dma.ADR_A.w;
						dma.CNT_B.w = dma.ADR_B.w;
						dma.BYT_N.w = 0;
						dma.ENDB_FLG = 0;
						dma.MACH_FLG = 0;			// 0619
						dma.DMA_ENBL = 0;
						break;
					case 0xd3:				// èƭ
						if (dma.DMA_STOP) {			// OrNOT READY
							dma.DMA_STOP = 0;
							// ŃCNĝ͂傢c
							switch(dma.WR[1] & 0x30) {
								case 0x00:
									dma.CNT_A.w--;
									break;
								case 0x10:
									dma.CNT_A.w++;
									break;
							}
							switch(dma.WR[2] & 0x30) {
								case 0x00:
									dma.CNT_B.w--;
									break;
								case 0x10:
									dma.CNT_B.w++;
									break;
							}
						}
						dma.BYT_N.w = 0;			// 0619
						dma.MACH_FLG = 0;			// 0619
						dma.ENDB_FLG = 0;
						dma.DMA_ENBL = 1;
						break;
				}
				break;
		}
	}
	else {
		*(((BYTE *)&dma) + dma.WR_TBL[dma.WR_OFF]) = value;
		if (dma.WR_TBL[dma.WR_OFF] == DMAOFST(INT_FLG)) {
			if (value & 0x08) {
				dma.WR_TBL[dma.WR_OFF + dma.WR_CNT] = DMAOFST(INT_PLS);
				dma.WR_CNT++;
			}
			if (value & 0x10) {
				dma.WR_TBL[dma.WR_OFF + dma.WR_CNT] = DMAOFST(INT_VCT);
				dma.WR_CNT++;
			}
		}
		else if (dma.WR_TBL[dma.WR_OFF] == DMAOFST(RR_MSK)) {
			setdmareaddat();
		}
		dma.WR_OFF++;
		dma.WR_CNT--;
	}
}

X1_IOR x1_dma_r(WORD port) {

	TRACEIN(port);

	dma.RR = 0xcc;
	if (dma.DMA_ENBL) {
		dma.RR |= 0x01;
	}
	if ((dma.DMA_MODE != 1) && ((dma.WR[5] ^ dma.DMA_REDY) & 8)) {
		dma.RR |= 0x02;
	}
	if (!dma.MACH_FLG) {
		dma.RR |= 0x10;
	}
	if (!dma.ENDB_FLG) {
		dma.RR |= 0x20;
	}
	if (!dma.RR_CNT) {
		return(dma.RR);
	}
	if (dma.RR_OFF >= dma.RR_CNT) {
		dma.RR_OFF = 0;
	}
	return(*(((BYTE *)&dma) + dma.RR_TBL[dma.RR_OFF++]));
}

