#include	<windows.h>
#include	"common.h"
#include	"x1.h"


LABEL BYTE __fastcall Z80_RDMEM(WORD adrs) {

	__asm {
				mov		eax, ecx
				and		eax, 0xffff
				or		ah, ah
				jns		mem_l_rb
				movzx	eax, mMAIN[eax]
				ret
mem_l_rb:		add		eax, RAM0r
				movzx	eax, byte ptr [eax]
				ret
	}
}


LABEL void __fastcall Z80_WRMEM(WORD adrs, BYTE value) {

	__asm {
				mov		eax, ecx
				and		eax, 0xffff
				or		ah, ah
				jns		mem_l_wb
				mov		mMAIN[eax], dl
				ret
mem_l_wb:		add		eax, RAM0w
				mov		[eax], dl
				ret
	}
}


LABEL WORD __fastcall Z80_RDMEM_W(WORD adrs) {

	__asm {
				mov		eax, ecx
				and		eax, 0xffff
				cmp		ax, 0xffff
				jo		mwr_7fff
				js		mwr_8000
				je		mwr_ffff
				add		eax, RAM0r
				movzx	eax, word ptr [eax]			// 0`7ffeh
				ret
mwr_7fff:		add		eax, RAM0r
				movzx	eax, byte ptr [eax]			// 7fffh
				mov		ah, mMAIN[0x8000]
				ret
mwr_8000:		movzx	eax, word ptr mMAIN[eax]	// 8000h ` fffeh
				ret
mwr_ffff:		mov		eax, RAM0r
				movzx	eax, byte ptr [eax]
				mov		ah, al
				mov		al, mMAIN[0xffff]			// ffffh
				ret
	}
}

LABEL void __fastcall Z80_WRMEM_W(WORD adrs, WORD value) {

	__asm {
				mov		eax, ecx
				and		eax, 0xffff
				cmp		ax, 0xffff
				jo		mww_7fff
				js		mww_8000
				je		mww_ffff
				add		eax, RAM0w
				mov		[eax], dx					// 0`7ffeh
				ret
mww_7fff:		mov		mMAIN[0x8000], dh			// 7fffh
				add		eax, RAM0w
				mov		[eax], dl
				ret
mww_8000:		mov		word ptr mMAIN[eax], dx		// 8000h ` fffeh
				ret
mww_ffff:		mov		mMAIN[0xffff], dl			// ffffh
				mov		eax, RAM0w
				mov		[eax], dh
				ret
	}
}



LABEL BYTE __fastcall fast_RDMEM(WORD adrs) {

	__asm {
				or		ch, ch
				jns		mem_l_rb
				movzx	eax, mMAIN[ecx]
				ret
mem_l_rb:		mov		eax, RAM0r
				movzx	eax, byte ptr [eax+ecx]
				ret
	}
}


LABEL void __fastcall fast_WRMEM(WORD adrs, BYTE value) {

	__asm {
				or		ch, ch
				jns		mem_l_wb
				mov		mMAIN[ecx], dl
				ret
mem_l_wb:		mov		eax, RAM0w
				mov		[eax+ecx], dl
				ret
	}
}


LABEL WORD __fastcall fast_RDMEM_W(WORD adrs) {

	__asm {
				cmp		cx, 0xffff
				jo		mwr_7fff
				js		mwr_8000
				je		mwr_ffff
				mov		eax, RAM0r
				movzx	ax, word ptr [eax+ecx]		// 0`7ffeh
				ret
mwr_7fff:		mov		eax, RAM0r
				movzx	eax, byte ptr [eax+ecx]		// 7fffh
				mov		ah, mMAIN[0x8000]
				ret
mwr_8000:		movzx	eax, word ptr mMAIN[ecx]	// 8000h ` fffeh
				ret
mwr_ffff:		mov		eax, RAM0r
				movzx	eax, byte ptr [eax]
				mov		ah, al
				mov		al, mMAIN[0xffff]			// ffffh
				ret
	}
}

LABEL void __fastcall fast_WRMEM_W(WORD adrs, WORD value) {

	__asm {
				cmp		cx, 0xffff
				jo		mww_7fff
				js		mww_8000
				je		mww_ffff
				mov		eax, RAM0w
				mov		[eax+ecx], dx				// 0`7ffeh
				ret
mww_7fff:		mov		mMAIN[0x8000], dh			// 7fffh
				mov		eax, RAM0w
				mov		[eax+ecx], dl
				ret
mww_8000:		mov		word ptr mMAIN[ecx], dx		// 8000h ` fffeh
				ret
mww_ffff:		mov		mMAIN[0xffff], dl			// ffffh
				mov		eax, RAM0w
				mov		[eax], dh
				ret
	}
}


