#include	<windows.h>
#include	<stdio.h>
#include	<string.h>
#include	"common.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_vram.h"

		PCG_TABLE	pcg;
		BYTE		*KFONT;
		BYTE		*PFONT;
		BYTE		NULLCODE[32];

/***********************************************************************
	PCG
***********************************************************************/

static void reset_pcgoff(void) {

	*(DWORD *)&pcg.vsync = 0;
	*(DWORD *)&pcg.roff0 = 0;
}

void init_pcg(void) {

static	BYTE	initpcg = 0;

	if (!initpcg) {
		initpcg++;
		ZeroMemory(&pcg, sizeof(PCG_TABLE));
		ZeroMemory(NULLCODE, 32);
	}
	else {
		reset_pcgoff();
	}
}


WORD pcg_offset(void) {

	if (TXT_RAM[TEXT_ATR + 0x07ff] & 0x20) {
		return(0x7ff);
	}
	if (TXT_RAM[TEXT_ATR + 0x03ff] & 0x20) {
		return(0x3ff);
	}
	if (TXT_RAM[TEXT_ATR + 0x05ff] & 0x20) {
		return(0x5ff);
	}
	if (TXT_RAM[TEXT_ATR + 0x01ff] & 0x20) {
		return(0x1ff);
	}
	return(0x7ff);
}


WORD knj_offset(void) {

	if (!(TXT_RAM[TEXT_ATR + 0x07ff] & 0x20)) {
		return(0x7ff);
	}
	if (!(TXT_RAM[TEXT_ATR + 0x03ff] & 0x20)) {
		return(0x3ff);
	}
	if (!(TXT_RAM[TEXT_ATR + 0x05ff] & 0x20)) {
		return(0x5ff);
	}
	if (!(TXT_RAM[TEXT_ATR + 0x01ff] & 0x20)) {
		return(0x1ff);
	}
	return(0x7ff);
}


LABEL BYTE * __fastcall getfontjis(WORD jis) {

	__asm {
				mov		ax, cx
				test	ax, 08080h
				jne		j2s_err
				xor		dl, dl
				add		ah, 21h
				test	ah, 1
				je		jis2sjis1a
				mov		dl, 5eh
jis2sjis1a:		sar		ah, 1
				add		al, dl
				xor		ah, 20h
				or		ah, 80h
				cmp		al, 60h
				jb		jis2sjis1b
				inc		al
jis2sjis1b:		add		al, 1fh

				sub		ax, 8140h
				jc		j2s_err
				mov		edx, offset KNJ_FNT + 01000h
				cmp		ax, (84c0h - 8140h)
				jc		kanjiptr
				sub		ax, (8890h - 8140h)
				jc		j2s_err
				mov		edx, offset KNJ_FNT + 08000h
				cmp		ax, (0a000h - 8890h)
				jc		kanjiptr
				sub		ax, (0e040h - 8890h)
				jc		j2s_err
				cmp		ax, (0eab0h - 0e040h)
				jae		j2s_err
				mov		edx, offset KNJ_FNT + 36e00h
kanjiptr:		and		eax, 0ffffh
				shl		eax, 5
				add		eax, edx
				ret
j2s_err:		mov		eax, offset NULLCODE
				ret
	}
}


static	BYTE	adr2jis_tbl[4] = {0x20, 0x60, 0x40, 0x00};

LABEL WORD __fastcall adr2jis_x1t(WORD adr) {

	__asm {
				push	cx
				mov		ax, cx
				and		ah, 1fh
				mov		cx, ax
				shl		cx, 3
				mov		cl, al
				and		cx, 71fh
				mov		al, ah
				mov		ah, 0
				cmp		al, 4
				jb		a2jx1t_2121
				cmp		al, 1ch
				jbe		a2jxt1_us
				or		ch, 50h
a2jx1t_2121:	or		ch, 20h
				or		ch, ah
				and		eax, 3
				or		cl, adr2jis_tbl[eax]
				mov		ax, cx
				pop		cx
				ret
a2jxt1_us:		shr		al, 1
				jnc		a2jxt1_usnc
				or		ch, 8
a2jxt1_usnc:	add		al, 7
				mov		dl, 3
				div		dl
				shl		al, 1
				inc		ah
				shl		ax, 3
				shl		ah, 2
				xchg	al, ah
				or		ax, cx
				pop		cx
				ret
		}
}


WORD nowsyncoffset(void) {

	WORD	ret;

	ret = (((v_cnt - crtc.CRT_YL) / crtc.fnty) + crtc.TXT_YL) * crtc.TXT_XL
															+ crtc.TXT_TOP;
	if (x1flg.HSYNC_CLK) {
		ret += (h_cnt * crtc.TXT_XL) / x1flg.HSYNC_CLK;
	}

	if (ret >= 0x0800) {
		ret = 0x07ff;		// I[o[t[
	}
	return(ret);			// ܂ɕ\悤ƂĂ TXT-RAMAhX
}


X1_IOW x1_pcg_w(WORD port, BYTE value) {

	BYTE	chr;
	WORD	off, l;

	if (crtc.SCRN_BITS & SCRN_PCGMODE) {
		off = pcg_offset();
		chr = TXT_RAM[TEXT_ANK + off];
		if (TXT_RAM[TEXT_KNJ + off] & 0x90) {
			chr &= 0xfe;
			l = port & 15;
		}
		else {
			l = (port >> 1) & 7;
		}
		switch(port & 0xff00) {
			case 0x1500:
				pcg.B[chr][l] = value;
				break;
			case 0x1600:
				pcg.R[chr][l] = value;
				break;
			case 0x1700:
				pcg.G[chr][l] = value;
				break;
		}
	}
	else {
		off = nowsyncoffset();						// 990622 puni
		chr = TXT_RAM[TEXT_ANK + off];
		if (pcg.vsync) {
			reset_pcgoff();
		}
		switch(port & 0xff00) {
			case 0x1500:
				pcg.B[chr][pcg.woff1++] = value;
				pcg.woff1 &= 7;
				break;
			case 0x1600:
				pcg.R[chr][pcg.woff2++] = value;
				pcg.woff2 &= 7;
				break;
			case 0x1700:
				pcg.G[chr][pcg.woff4++] = value;
				pcg.woff4 &= 7;
				break;
		}
	}
}


X1_IOR x1_pcg_r(WORD port) {

static	WORD	localknj = -1;
		WORD	off,l;
		BYTE	chr,knj,val;
		WORD	jis;

	val = 0xff;
	if (crtc.SCRN_BITS & SCRN_PCGMODE) {
		l = port & 0x0f;
		if ((port & 0xff00) == 0x1400) {
			off = knj_offset();
			chr = TXT_RAM[off + TEXT_ANK];
			knj = TXT_RAM[off + TEXT_KNJ];
			if (knj & 0x80) {
				jis = ((WORD)knj << 8) | chr;
				if (localknj != jis) {
					localknj = jis;
					PFONT = getfontjis(adr2jis_x1t(jis));
				}
				l <<= 1;
				if (knj & 0x40) {
					val = PFONT[l + 1];
				}
				else {
					val = PFONT[l];
				}
			}
			else if (crtc.SCRN_BITS & SCRN_CPUFONT) {
				val = KNJ_FNT[(chr << 4) + l];
			}
			else {
				val = ANK_FNT[chr][l >> 1];
			}
		}
		else {
			off = pcg_offset();
			chr = TXT_RAM[TEXT_ANK + off];
			if (TXT_RAM[TEXT_KNJ + off] & 0x90) {
				chr &= 0xfe;
			}
			else {
				l >>= 1;
			}
			switch(port & 0xff00) {
				case 0x1500:
					val = pcg.B[chr][l];
					break;
				case 0x1600:
					val = pcg.R[chr][l];
					break;
				case 0x1700:
					val = pcg.G[chr][l];
					break;
			}
		}
	}
	else {
		off = nowsyncoffset();					// 990622 puni
		chr = TXT_RAM[TEXT_ANK + off];
		if (pcg.vsync) {
			reset_pcgoff();
		}
		switch(port & 0xff00) {
			case 0x1400:
				val = ANK_FNT[chr][pcg.roff0++];
				pcg.roff0 &= 7;
				break;
			case 0x1500:
				val = pcg.B[chr][pcg.roff1++];
				pcg.roff1 &= 7;
				break;
			case 0x1600:
				val = pcg.R[chr][pcg.roff2++];
				pcg.roff2 &= 7;
				break;
			case 0x1700:
				val = pcg.G[chr][pcg.roff4++];
				pcg.roff4 &= 7;
				break;
		}
	}
	return(val);
}

/***********************************************************************
	KANJI
***********************************************************************/

WORD jis2adr_x1(WORD jis) {

	BYTE	jh, jl;
	WORD	ret;

	jh = (BYTE)(jis >> 8);
	jl = (BYTE)(jis & 0xff);
	if (jh > 0x28) {
		ret = 0x4000 + ((jh - 0x30) * 0x600);
	}
	else {
		ret = 0x0100 + ((jh - 0x21) * 0x600);
	}
	if (jl >= 0x20) {
		ret += ((jl-0x20)*0x10);
	}
	return(ret);
}

WORD adr2jis_x1(WORD adr) {

	BYTE	jis[2];

	if (adr < 0x4000) {
		jis[1] = (BYTE)(((adr - 0x0100) / 0x0600) + 0x21);
	}
	else {
		jis[1] = (BYTE)(((adr - 0x4000) / 0x0600) + 0x30);
	}
	if (jis[1] > 0x28) {
		adr -= (0x4000 + ((jis[1] - 0x30) * 0x600));
	}
	else {
		adr -= (0x0100 + ((jis[1] - 0x21) * 0x600));
	}
	jis[0] = (BYTE)((adr >> 4) + 0x20);
	return(*(WORD *)jis);
}


BYTE	KCODE[2] = {0, 0};
BYTE	K_CNT = 0;
BYTE	K_FLG = 0;

X1_IOW x1_knj_w(WORD port, BYTE value) {

	if (port == 0x0e80) {
		KCODE[0] = value;
	}
	else if (port == 0x0e81) {
		KCODE[1] = value;
	}
	else if (port == 0x0e82) {
		KFONT = getfontjis(adr2jis_x1((*(WORD *)KCODE) & 0xfff0));
	}
}

X1_IOR x1_knj_r(WORD port) {

	BYTE	ret;

	if (KCODE[1]) {
		if (port == 0x0e80) {
			ret = KFONT[K_CNT << 1];
			K_FLG |= 1;
		}
		else if (port == 0x0e81) {
			ret = KFONT[(K_CNT << 1) + 1];
			K_FLG |= 2;
		}
		if (K_FLG == 3) {
			K_FLG = 0;
			K_CNT = (BYTE)((K_CNT + 1) & 15);
		}
	}
	else {
		if (port == 0x0e80) {
			ret = (BYTE)(jis2adr_x1(KCODE[0] << 8) >> 8);
		}
		else {
			ret = 0;
		}
	}
	return(ret);
}

