#include	<windows.h>
#include	"x1.h"
#include	"x1_sio.h"
#include	"mouses.h"


// jl񋟂̃\[XłB肪Ƃ܂B

/***********************************************************************
	rhn
***********************************************************************/

#define	FIFO_BUFMAX		80

typedef struct {
	short	cnt, top, fno;
	BYTE	buf[FIFO_BUFMAX];
	BYTE	flg[FIFO_BUFMAX];
} FIFO;

typedef struct {
	short	num;
	BYTE	wr[8];
	BYTE	rr[4];
	BYTE	tx_int;
	BYTE	rx_int;
	FIFO	TxD;			// M
	FIFO	RxD;			// M
} SIO_REGS;

static	SIO_REGS	CH_A, CH_B;

/***********************************************************************
	
***********************************************************************/

// ؾ
void init_sio(void) {

	ZeroMemory(&CH_A, sizeof(CH_A));
	ZeroMemory(&CH_B, sizeof(CH_B));
}

/***********************************************************************
	FIFO
***********************************************************************/

// sw ... 荞 1= 0=Ȃ
static void fifo_w(FIFO *p, BYTE data, BYTE sw) {

	short off;

	off = p->top + p->cnt;
	if (off >= FIFO_BUFMAX) {
		off -= FIFO_BUFMAX;
	}
	p->cnt++;
	if (p->cnt >= FIFO_BUFMAX) {
		p->cnt = 0;
	}
	p->buf[off] = data;
	p->flg[off] = sw;
}

static BYTE fifo_r(FIFO *p) {

	BYTE	data;

	if (!p->cnt) {
		return(0);
	}
	p->cnt--;
	data = p->buf[p->top++];
	if (p->top >= FIFO_BUFMAX) {
		p->top = 0;
	}
	return(data);
}

// 荞݃`FbN
static short fifo_chk(FIFO *p) {

	short flg;

	if (p->top != p->fno) {
		return(0);
	}
	flg = p->flg[p->fno++];
	if (p->fno >= FIFO_BUFMAX) {
		p->fno = 0;
	}
	return(flg);
}


/***********************************************************************
	荞
***********************************************************************/

void x1_sio0(SIO_REGS *r) {

	if (!(r->wr[3] & 0x01) ||
		!(r->wr[1] & 0x18) ||
		!(r->RxD.cnt)) {
		return;
	}
	if (fifo_chk(&r->RxD)) {
		r->rx_int = 1;
	}
}

short x1_sio1(SIO_REGS *r) {

	BYTE	vct;

	vct = (byte)(r->wr[2] & 0xf1);

	if ((r->tx_int) && (!Z80_Able_interrupt())) {
		r->tx_int = 0;
		Z80_Cause_Interrupt(vct);
		return(1);
	}
	if ((r->rx_int) && (!Z80_Able_interrupt())) {
		r->rx_int = 0;
		Z80_Cause_Interrupt((byte)(vct | 0x04));
		return(1);
	}
	return(0);
}

void x1_sio(void) {

	x1_sio0(&CH_A);
	x1_sio0(&CH_B);
	if (x1_sio1(&CH_A)) return;
	if (x1_sio1(&CH_B)) return;
}

/***********************************************************************
	}EX̏Ԃrhn̂ehenɑ
***********************************************************************/
void mouse_read(void) {

	short	mx, my;
	BYTE	dat0, dat1, dat2;

	dat0 = mouse_posget(&mx, &my) & 3;

	if (mx > 127) {
		dat1 = 0x7f;
		dat0 |= 0x10;
	}
	else if (mx < -127) {
		dat1 = 0x80;
		dat0 |= 0x20;
	}
	else {
		dat1 = (char)mx;
	}
	if (my > 127) {
		dat2 = 0x7f;
		dat0 |= 0x40;
	}
	else if (my < -127) {
		dat2 = 0x80;
		dat0 |= 0x80;
	}
	else {
		dat2 = (char)my;
	}
	if ((CH_B.wr[1] & 0x18) == 0x08) {
		fifo_w(&CH_B.RxD, dat0, 1);		// ŏ̂PoCgM荞
		fifo_w(&CH_B.RxD, dat1, 0);
		fifo_w(&CH_B.RxD, dat2, 0);
	}
	else {
		fifo_w(&CH_B.RxD, dat0, 1);		// PoCgɊ荞
		fifo_w(&CH_B.RxD, dat1, 1);
		fifo_w(&CH_B.RxD, dat2, 1);
	}
}

/***********************************************************************
	wP猩h^n
***********************************************************************/

X1_IOW x1_sio_w(WORD port, BYTE value) {

	switch(port) {
		case 0x1f90:				// CH-A ް
			if (CH_A.wr[3] & 0x08) {
				fifo_w(&CH_A.TxD, value, 0);
			}
			break;
		case 0x1f91:				// CH-A ۰
			if (CH_A.num) {
				CH_A.wr[CH_A.num] = value;
				CH_A.num = 0;
			}
			else if (value & 0xf1) {
				CH_A.wr[CH_A.num] = value;
				CH_A.num = (value & 7);
			}
			break;
#if 0
		case 0x1f92:				// CH-B ް   (Mouse)
			if (CH_B.wr[3] & 0x08) {
				fifo_w(&CH_B.T_D, value, 0);
			}
			break;
#endif
		case 0x1f93:				// CH-B ۰ (Mouse)
			if (CH_B.num == 5) {
				// RTS(WR5:BIT1)OP֕ω
				// }EXRoCg̃f[^Ă
				if (!(CH_B.wr[5] & 2) && (value & 2)) {
					mouse_read();
				}
			}
			CH_B.wr[CH_B.num] = value;
			if (CH_B.num) {
				CH_B.num = 0;
			}
			else {
				CH_B.num = value & 7;
			}
			break;
	}
}


X1_IOR x1_sio_r(WORD port) {

	switch(port) {
		case 0x1f90:				// CH-A ް
			if (CH_A.RxD.cnt) {
				return(fifo_r(&CH_A.RxD));
			}
			break;
		case 0x1f91:				// CH-A ۰
			if (CH_A.num == 0) {
				BYTE ans = 0;
				if (CH_A.RxD.cnt != 0) {
					ans |= 1;
				}
				if (CH_A.TxD.cnt == 0) {
					ans |= 4;
				}
				return(ans);
			}
			break;
		case 0x1f92:				// CH-B ް   (Mouse)
			if (CH_B.RxD.cnt) {
				return(fifo_r(&CH_B.RxD));
			}
			break;
		case 0x1f93:				// CH-B ۰ (Mouse)
			if (CH_A.num == 0) {
				BYTE ans = 0;
				if (CH_B.RxD.cnt != 0) {
					ans |= 1;
				}
				if (CH_B.TxD.cnt == 0) {
					ans |= 4;
				}
				return(ans);
			}
			break;
	}
	return(0);
}
