#include	<windows.h>

#include	"xmil.h"
#include	"dinputs.h"
#include	"x1.h"
#include	"dsounds.h"
#include	"opm.h"

	BYTE	changehz = 0;
	BYTE	psg[0x10];
	BYTE	psgreg = 0;
	BYTE	opmreg = 0;

#define	key_4	0x4b
#define	key_6	0x4d
#define	key_8	0x48
#define	key_2	0x50
#define	key_sp	0x39
#define	key_et	0x1c
#define	key_x	0x2d
#define	key_z	0x2c
#define	key_up	0xc8
#define	key_rt	0xcd
#define	key_lt	0xcb
#define	key_dn	0xd0
#define	key_c	0x2e
#define	key_v	0x2f

const	BYTE	joybitdata[16] = {
					key_c,	key_c,		key_sp,	key_x,
					key_et,	key_z,		key_v,	key_v,
					key_rt,	key_6,		key_lt,	key_4,
					key_dn,	key_2,		key_up,	key_8};


void x1_psg_reset(void) {

	if (changehz) {
		changehz = 0;
		STREAM_TERM();
		STREAM_CREATE();
	}
	INX1F_reset();
	opmreg = 0;
	psgreg = 0;
}

void x1_psg_stop(void) { }
void x1_psg_cont(void) { }

X1_IOW x1_psg_reg(WORD port, BYTE value) {

	psgreg = value;
}

X1_IOW x1_psg_dat(WORD port, BYTE value) {

	if (psgreg < 0x0e) {
		psg[psgreg] = value;
		INX1F_PSGctrl(psgreg, value);
	}
}

BYTE joy_key(void) {

		BYTE	ret = 0xff;
		BYTE	bit;
		BYTE	*p = (BYTE *)joybitdata;
extern	BYTE	KEY_TBL[];

	for(bit=0x80; bit; bit>>=1, p+=2) {
		if (KEY_TBL[*p] || KEY_TBL[*(p+1)]) {
			ret ^= bit;
		}
	}
	return(ret);
}

X1_IOR x1_psg_sta(WORD port) {

static	BYTE	rapids = 0;

	if (psgreg < 0x0e) {
		return(psg[psgreg]);
	}
	if (psgreg < 0x10) {
		BYTE ret = 0xff;
		if (psgreg == (xmilcfg.KEY_MODE + 0x0d)) {
			ret &= joy_key();
		}
		if (psgreg == 0x0e) {
			ret &= joy_getflag();
		}
		if (xmilcfg.BTN_RAPID) {
			rapids ^= 0x60;
			ret |= rapids;
		}
		if (xmilcfg.BTN_MODE) {
			BYTE bit1 = (ret & 0x40) >> 1;
			BYTE bit2 = (ret & 0x20) << 1;
			ret = (ret & (~0x60)) | bit1 | bit2;
		}
		return(ret);
	}
	return(0xff);
}




void x1_opm_reset(void) { }
void x1_opm_stop(void) { }
void x1_opm_cont(void) { }

X1_IOW x1_opm_reg(WORD port, BYTE value) {

	opmreg = value;
}
X1_IOW x1_opm_dat(WORD port, BYTE value) {

	INX1F_OPMctrl(opmreg, value);
}

X1_IOR x1_opm_stat(WORD port) {

	if (x1flg.SOUND_SW) {
		return(0x00);								// [A[h΍
	}
	return(0xff);
}
