//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#include	<windows.h>

#include	"common.h"
#include	"x1_io.h"
#include	"x1_mem.h"
#include	"z80r.h"
#include	"z80r_mcr.h"


Z80RASM _cb_rlc(void) {

	__asm {
				rol		al, 1
				ret
	}
}

Z80RASM _cb_rrc(void) {

	__asm {
				ror		al, 1
				ret
	}
}

Z80RASM _cb_rl(void) {

	__asm {
				bt		R_Z80AF, 0
				rcl		al, 1
				ret
	}
}

Z80RASM _cb_rr(void) {

	__asm {
				bt		R_Z80AF, 0
				rcr		al, 1
				ret
	}
}

Z80RASM _cb_sla(void) {

	__asm {
				shl		al, 1
				ret
	}
}

Z80RASM _cb_sra(void) {

	__asm {
				sar		al, 1
				ret
	}
}

Z80RASM _cb_sll(void) {

	__asm {
				stc
				rcl		al, 1
				ret
	}
}

Z80RASM _cb_srl(void) {

	__asm {
				shr		al, 1
				ret
	}
}

static Z80ROPCODE rorsht_tbl[8] = {
		_cb_rlc,	_cb_rrc,	_cb_rl,		_cb_rr,
		_cb_sla,	_cb_sra,	_cb_sll,	_cb_srl};

static BYTE *cb_reg[8] = {
		&R_Z80B,	&R_Z80C,	&R_Z80D,	&R_Z80E,
		&R_Z80H,	&R_Z80L,	NULL,		&R_Z80A};


LABEL Z80RPUB _code_cb(void) {

	__asm {
				inc		R.R
				GET_PC_BYTE
				mov		bl, al
				and		eax, 7
				cmp		al, 6
				je		cb_memory_hl
				mov		edx, cb_reg[eax*4]
				add		Z80_ICount, 8

				cmp		bl, 40h				// cl = opcode!
				jc		cb_bitsht			// cl =  0~3f
				js		cb_set				// cl = c0~ff
				jge		cb_bit				// cl = 40~7f
											// cl = 80~bf
				shr		bl, 3								// 80~bf
				and		bx, 7
				btr		[edx], bx
				ret

cb_set:			shr		bl, 3								// c0~ff
				and		bx, 7
				bts		[edx], bx
				ret

cb_bit:			and		R_Z80F, C_FLAG						// 40~7f
				shr		bl, 3
				and		bx, 7
				bt		[edx], bx
				jnc		cb_bit_z
				cmp		bl, 7
				jne		cb_bit_nsz
				or		R_Z80F, (H_FLAG or S_FLAG)
				ret
cb_bit_nsz:		or		R_Z80F, H_FLAG
				ret
cb_bit_z:		or		R_Z80F, (H_FLAG or Z_FLAG)
				ret

cb_bitsht:		shr		bl, 1								// 00~3f
				and		ebx, 7*4
				mov		al, [edx]
				call	rorsht_tbl[ebx]
				mov		[edx], al
				mov		al, ZSPtable[eax]
				adc		al, 0
				mov		R_Z80F, al
				ret

cb_memory_hl:	mov		cx, R_Z80HL
				cmp		bl, 40h				// bl = opcode!
				jc		cbmem_bitsht		// bl =  0~3f
				js		cbmem_set			// bl = c0~ff
				jge		cbmem_bit			// bl = 40~7f
											// bl = 80~bf
				add		Z80_ICount, 15						// 80~bf
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				btr		ax, bx
				mov		dl, al
				jmp		fast_WRMEM

cbmem_set:		add		Z80_ICount, 15						// c0~ff
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				bts		ax, bx
				mov		dl, al
				jmp		fast_WRMEM

cbmem_bit:		add		Z80_ICount, 12						// 40~7f
				and		R_Z80F, C_FLAG
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				bt		ax, bx
				jnc		cbmem_bit_z
				cmp		bl, 7
				jne		cbmem_bit_nsz
				or		R_Z80F, (H_FLAG or S_FLAG)
				ret
cbmem_bit_nsz:	or		R_Z80F, H_FLAG
				ret
cbmem_bit_z:	or		R_Z80F, (H_FLAG or Z_FLAG)
				ret

cbmem_bitsht:	add		Z80_ICount, 15						// 00~3f
				shr		bl, 1
				and		ebx, 7*4
				call	fast_RDMEM
				call	rorsht_tbl[ebx]
				mov		dl, al
				mov		al, ZSPtable[eax]
				adc		al, 0
				mov		R_Z80F, al
				jmp		fast_WRMEM
	}
}


LABEL Z80RPUB _ixcb_proc(void) {

	__asm {
				GET_PC_WORD
				mov		bl, ah
				cbw
				add		ax, R_Z80IX
				mov		cx, ax
				add		Z80_ICount, 8

				cmp		bl, 40h				// bl = opcode!
				jc		cbmem_bitsht		// bl =  0~3f
				js		cbmem_set			// bl = c0~ff
				jge		cbmem_bit			// bl = 40~7f
											// bl = 80~bf
				add		Z80_ICount, 15						// 80~bf
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				btr		ax, bx
				mov		dl, al
				jmp		fast_WRMEM

cbmem_set:		add		Z80_ICount, 15						// c0~ff
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				bts		ax, bx
				mov		dl, al
				jmp		fast_WRMEM

cbmem_bit:		add		Z80_ICount, 12						// 40~7f
				and		R_Z80F, C_FLAG
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				bt		ax, bx
				jnc		cbmem_bit_z
				cmp		bl, 7
				jne		cbmem_bit_nsz
				or		R_Z80F, (H_FLAG or S_FLAG)
				ret
cbmem_bit_nsz:	or		R_Z80F, H_FLAG
				ret
cbmem_bit_z:	or		R_Z80F, (H_FLAG or Z_FLAG)
				ret

cbmem_bitsht:	add		Z80_ICount, 15						// 00~3f
				shr		bl, 1
				and		ebx, 7*4
				call	fast_RDMEM
				call	rorsht_tbl[ebx]
				mov		dl, al
				mov		al, ZSPtable[eax]
				adc		al, 0
				mov		R_Z80F, al
				jmp		fast_WRMEM
	}
}


LABEL Z80RPUB _iycb_proc(void) {

	__asm {
				GET_PC_WORD
				mov		bl, ah
				cbw
				add		ax, R_Z80IY
				mov		cx, ax
				add		Z80_ICount, 8

				cmp		bl, 40h				// bl = opcode!
				jc		cbmem_bitsht		// bl =  0~3f
				js		cbmem_set			// bl = c0~ff
				jge		cbmem_bit			// bl = 40~7f
											// bl = 80~bf
				add		Z80_ICount, 15						// 80~bf
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				btr		ax, bx
				mov		dl, al
				jmp		fast_WRMEM

cbmem_set:		add		Z80_ICount, 15						// c0~ff
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				bts		ax, bx
				mov		dl, al
				jmp		fast_WRMEM

cbmem_bit:		add		Z80_ICount, 12						// 40~7f
				and		R_Z80F, C_FLAG
				shr		bl, 3
				and		bx, 7
				call	fast_RDMEM
				bt		ax, bx
				jnc		cbmem_bit_z
				cmp		bl, 7
				jne		cbmem_bit_nsz
				or		R_Z80F, (H_FLAG or S_FLAG)
				ret
cbmem_bit_nsz:	or		R_Z80F, H_FLAG
				ret
cbmem_bit_z:	or		R_Z80F, (H_FLAG or Z_FLAG)
				ret

cbmem_bitsht:	add		Z80_ICount, 15						// 00~3f
				shr		bl, 1
				and		ebx, 7*4
				call	fast_RDMEM
				call	rorsht_tbl[ebx]
				mov		dl, al
				mov		al, ZSPtable[eax]
				adc		al, 0
				mov		R_Z80F, al
				jmp		fast_WRMEM
	}
}

