//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#include	<windows.h>

#include	"common.h"
#include	"x1_io.h"
#include	"x1_mem.h"
#include	"z80r.h"
#include	"z80r_mcr.h"

extern	Z80RPUB _ixcb_proc(void);

#define	R_Z80IXL	R.IX.B.l
#define	R_Z80IXH	R.IX.B.h

#define	GET_IX														\
			GET_PC_BYTE												\
			__asm {	cbw											}	\
			__asm {	add		ax, R_Z80IX							}

#define	GET_XIX														\
			GET_PC_BYTE												\
			__asm {	cbw											}	\
			__asm {	add		ax, R_Z80IX							}	\
			__asm {	mov		cx, ax								}	\
			__asm {	call	fast_RDMEM							}

#define	XIX2R(reg)													\
			GET_XIX													\
			__asm {	mov		reg, al								}	\
			__asm {	ret											}	\

#define	R2XIX(reg)													\
			GET_IX													\
			__asm {	mov		cx, ax								}	\
			__asm {	mov		dl, reg								}	\
			__asm {	jmp		fast_WRMEM							}


Z80RASM _and_ixl(void) { regAND(R_Z80IXL) }
Z80RASM _and_ixh(void) { regAND(R_Z80IXH) }
Z80RASM _or_ixl(void) { regOR(R_Z80IXL) }
Z80RASM _or_ixh(void) { regOR(R_Z80IXH) }
Z80RASM _xor_ixl(void) { regXOR(R_Z80IXL) }
Z80RASM _xor_ixh(void) { regXOR(R_Z80IXH) }
Z80RASM _cp_ixl(void) { regCP(R_Z80IXL) }
Z80RASM _cp_ixh(void) { regCP(R_Z80IXL) }

Z80RASM _inc_ixl(void) { MCR_INC(R_Z80IXL) }
Z80RASM _inc_ixh(void) { MCR_INC(R_Z80IXH) }
Z80RASM _dec_ixl(void) { MCR_DEC(R_Z80IXL) }
Z80RASM _dec_ixh(void) { MCR_DEC(R_Z80IXH) }

Z80RASM _add_a_ixl(void) { regADD(R_Z80IXL) }
Z80RASM _add_a_ixh(void) { regADD(R_Z80IXH) }
Z80RASM _adc_a_ixl(void) { regADC(R_Z80IXL) }
Z80RASM _adc_a_ixh(void) { regADC(R_Z80IXH) }
Z80RASM _sub_ixl(void) { regSUB(R_Z80IXL) }
Z80RASM _sub_ixh(void) { regSUB(R_Z80IXH) }
Z80RASM _sbc_a_ixl(void) { regSBC(R_Z80IXL) }
Z80RASM _sbc_a_ixh(void) { regSBC(R_Z80IXH) }

Z80RASM _ld_a_ixl(void) { MCR_LD(R_Z80A, R_Z80IXL) }
Z80RASM _ld_b_ixl(void) { MCR_LD(R_Z80B, R_Z80IXL) }
Z80RASM _ld_c_ixl(void) { MCR_LD(R_Z80C, R_Z80IXL) }
Z80RASM _ld_d_ixl(void) { MCR_LD(R_Z80D, R_Z80IXL) }
Z80RASM _ld_e_ixl(void) { MCR_LD(R_Z80E, R_Z80IXL) }
Z80RASM _ld_ixl_a(void) { MCR_LD(R_Z80IXL, R_Z80A) }
Z80RASM _ld_ixl_b(void) { MCR_LD(R_Z80IXL, R_Z80B) }
Z80RASM _ld_ixl_c(void) { MCR_LD(R_Z80IXL, R_Z80C) }
Z80RASM _ld_ixl_d(void) { MCR_LD(R_Z80IXL, R_Z80D) }
Z80RASM _ld_ixl_e(void) { MCR_LD(R_Z80IXL, R_Z80E) }
Z80RASM _ld_ixl_ixh(void) { MCR_LD(R_Z80IXL, R_Z80IXH) }
Z80RASM _ld_ixl_byte(void) { LDB_b(R_Z80IXL) }

Z80RASM _ld_a_ixh(void) { MCR_LD(R_Z80A, R_Z80IXH) }
Z80RASM _ld_b_ixh(void) { MCR_LD(R_Z80B, R_Z80IXH) }
Z80RASM _ld_c_ixh(void) { MCR_LD(R_Z80C, R_Z80IXH) }
Z80RASM _ld_d_ixh(void) { MCR_LD(R_Z80D, R_Z80IXH) }
Z80RASM _ld_e_ixh(void) { MCR_LD(R_Z80E, R_Z80IXH) }
Z80RASM _ld_ixh_a(void) { MCR_LD(R_Z80IXH, R_Z80A) }
Z80RASM _ld_ixh_b(void) { MCR_LD(R_Z80IXH, R_Z80B) }
Z80RASM _ld_ixh_c(void) { MCR_LD(R_Z80IXH, R_Z80C) }
Z80RASM _ld_ixh_d(void) { MCR_LD(R_Z80IXH, R_Z80D) }
Z80RASM _ld_ixh_e(void) { MCR_LD(R_Z80IXH, R_Z80E) }
Z80RASM _ld_ixh_ixl(void) { MCR_LD(R_Z80IXH, R_Z80IXL) }
Z80RASM _ld_ixh_byte(void) { LDB_b(R_Z80IXH) }

Z80RASM _and_xix(void)	{ GET_XIX	MCR_AND 		}
Z80RASM _or_xix(void)	{ GET_XIX	MCR_OR			}
Z80RASM _xor_xix(void)	{ GET_XIX	MCR_XOR			}
Z80RASM _cp_xix(void)	{ GET_XIX	MCR_CP			}

Z80RASM _inc_xix(void)	{ GET_IX	MCR_INC_MEM(ax)	}
Z80RASM _dec_xix(void)	{ GET_IX	MCR_DEC_MEM(ax)	}

Z80RASM	_add_a_xix(void)	{ GET_XIX	MCR_ADD			}
Z80RASM _adc_a_xix(void) 	{ GET_XIX	MCR_ADC			}
Z80RASM	_sub_xix(void)		{ GET_XIX	MCR_SUB			}
Z80RASM _sbc_a_xix(void)	{ GET_XIX	MCR_SBC			}

Z80RASM _add_ix_bc(void)	{ MCR_ADD_W(R_Z80IX, R_Z80BC) }
Z80RASM _add_ix_de(void)	{ MCR_ADD_W(R_Z80IX, R_Z80DE) }
Z80RASM _add_ix_ix(void)	{ MCR_ADDx2(R_Z80IX) }
Z80RASM _add_ix_sp(void)	{ MCR_ADD_W(R_Z80IX, R_Z80SP) }

Z80RASM _ld_a_xix(void) { XIX2R(R_Z80A) }
Z80RASM _ld_b_xix(void) { XIX2R(R_Z80B) }
Z80RASM _ld_c_xix(void) { XIX2R(R_Z80C) }
Z80RASM _ld_d_xix(void) { XIX2R(R_Z80D) }
Z80RASM _ld_e_xix(void) { XIX2R(R_Z80E) }
Z80RASM _ld_l_xix(void) { XIX2R(R_Z80L) }
Z80RASM _ld_h_xix(void) { XIX2R(R_Z80H) }
Z80RASM _ld_xix_a(void) { R2XIX(R_Z80A) }
Z80RASM _ld_xix_b(void) { R2XIX(R_Z80B) }
Z80RASM _ld_xix_c(void) { R2XIX(R_Z80C) }
Z80RASM _ld_xix_d(void) { R2XIX(R_Z80D) }
Z80RASM _ld_xix_e(void) { R2XIX(R_Z80E) }
Z80RASM _ld_xix_l(void) { R2XIX(R_Z80L) }
Z80RASM _ld_xix_h(void) { R2XIX(R_Z80H) }

Z80RASM _ld_xix_byte(void) {

	__asm {
				GET_IX
				push	ax
				GET_PC_BYTE
				mov		dl, al
				pop		cx
				jmp		fast_WRMEM
	}
}

Z80RASM _push_ix(void) { MCR_PUSH(R_Z80IX) }
Z80RASM _pop_ix(void) { MCR_POP(R_Z80IX) }
Z80RASM _inc_ix(void) { MCR_INC_W(R_Z80IX) }
Z80RASM _dec_ix(void) { MCR_DEC_W(R_Z80IX) }
Z80RASM _ex_xsp_ix(void) { MCR_EX_XSP(R_Z80IX) }
Z80RASM _ld_xword_ix(void) { LDx_W(R_Z80IX) }
Z80RASM _ld_ix_xword(void) { LDW_x(R_Z80IX) }
Z80RASM _ld_ix_word(void) { LDW_w(R_Z80IX) }
Z80RASM _ld_sp_ix(void) { MCR_LD_W(R_Z80SP, R_Z80IX) }
Z80RASM _jp_ix(void) { MCR_LD_W(R_Z80PC, R_Z80IX) }

Z80RASM _ld_nop(void) { __asm { ret } }

Z80RASM _no_op(void) { MCR_DEC_W(R_Z80PC) }


Z80ROPCODE opcode_dd[256] = {
		_no_op,			_no_op,			_no_op,			_no_op,			// 00
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_add_ix_bc,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 10
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_add_ix_de,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_ld_ix_word,	_ld_xword_ix,	_inc_ix,		// 20
		_inc_ixh,		_dec_ixh,		_ld_ixh_byte,	_no_op,
		_no_op,			_add_ix_ix,		_ld_ix_xword,	_dec_ix,
		_inc_ixl,		_dec_ixl,		_ld_ixl_byte,	_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 30
		_inc_xix,		_dec_xix,		_ld_xix_byte,	_no_op,
		_no_op,			_add_ix_sp,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 40
		_ld_b_ixh,		_ld_b_ixl,		_ld_b_xix,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_ld_c_ixh,		_ld_c_ixl,		_ld_c_xix,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 50
		_ld_d_ixh,		_ld_d_ixl,		_ld_d_xix,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_ld_e_ixh,		_ld_e_ixl,		_ld_e_xix,		_no_op,

		_ld_ixh_b,		_ld_ixh_c,		_ld_ixh_d,		_ld_ixh_e,		// 60
		_ld_nop,		_ld_ixh_ixl,	_ld_h_xix,		_ld_ixh_a,
		_ld_ixl_b,		_ld_ixl_c,		_ld_ixl_d,		_ld_ixl_e,
		_ld_ixl_ixh,	_ld_nop,		_ld_l_xix,		_ld_ixl_a,

		_ld_xix_b,		_ld_xix_c,		_ld_xix_d,		_ld_xix_e,		// 70
		_ld_xix_h,		_ld_xix_l,		_no_op,			_ld_xix_a,
		_no_op,			_no_op,			_no_op,			_no_op,
		_ld_a_ixh,		_ld_a_ixl,		_ld_a_xix,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 80
		_add_a_ixh,		_add_a_ixl,		_add_a_xix,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_adc_a_ixh,		_adc_a_ixl,		_adc_a_xix,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// 90
		_sub_ixh,		_sub_ixl,		_sub_xix,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_sbc_a_ixh,		_sbc_a_ixl,		_sbc_a_xix,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// a0
		_and_ixh,		_and_ixl,		_and_xix,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_xor_ixh,		_xor_ixl,		_xor_xix,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// b0
		_or_ixh,		_or_ixl,		_or_xix,		_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_cp_ixh,		_cp_ixl,		_cp_xix,		_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// c0
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_ixcb_proc,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// d0
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_pop_ix,		_no_op,			_ex_xsp_ix,		// e0
		_no_op,			_push_ix,		_no_op,			_no_op,
		_no_op,			_jp_ix,			_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op,

		_no_op,			_no_op,			_no_op,			_no_op,			// f0
		_no_op,			_no_op,			_no_op,			_no_op,
		_no_op,			_ld_sp_ix,		_no_op,			_no_op,
		_no_op,			_no_op,			_no_op,			_no_op};

